/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.ksp;

import com.google.devtools.ksp.MemoizedSequence;
import com.google.devtools.ksp.PsiUtilsKt;
import com.google.devtools.ksp.symbol.ClassKind;
import com.google.devtools.ksp.symbol.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.jvm.JvmModifier;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiDocumentManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u001a\u001a\u0010\u0011\u001a\u00020\u000f*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u001c\u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\u0006\b\u0000\u0010\u0018\u0018\u0001*\u00020\u0019H\u0086\b\u00a2\u0006\u0002\u0010\u001a\u001a\n\u0010\u001b\u001a\u00020\u001c*\u00020\u001d\u001a\f\u0010\u001e\u001a\u0004\u0018\u00010\u000f*\u00020\u0019\u001a\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00180 \"\u0004\b\u0000\u0010\u0018*\b\u0012\u0004\u0012\u0002H\u00180!\u001a\u0010\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020#\u001a\u0012\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u0004\u0018\u00010$\u001a\u0010\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020%\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"%\u0010\n\u001a\u0016\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006&"}, d2={"javaModifiers", "", "Lcom/google/devtools/ksp/symbol/Modifier;", "getJavaModifiers", "()Ljava/util/Set;", "jvmModifierMap", "", "Lorg/jetbrains/kotlin/com/intellij/lang/jvm/JvmModifier;", "getJvmModifierMap", "()Ljava/util/Map;", "modifierMap", "Lorg/jetbrains/kotlin/lexer/KtModifierKeywordToken;", "kotlin.jvm.PlatformType", "getModifierMap", "parseDocString", "", "raw", "findLocationString", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "file", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "offset", "", "findParentOfType", "T", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Ljava/lang/Object;", "getClassType", "Lcom/google/devtools/ksp/symbol/ClassKind;", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "getDocString", "memoized", "Lcom/google/devtools/ksp/MemoizedSequence;", "Lkotlin/sequences/Sequence;", "toKSModifiers", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiModifierListOwner;", "Lorg/jetbrains/kotlin/psi/KtModifierList;", "Lorg/jetbrains/kotlin/psi/KtModifierListOwner;", "common-util"})
@SourceDebugExtension(value={"SMAP\nPsiUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PsiUtils.kt\ncom/google/devtools/ksp/PsiUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,176:1\n766#2:177\n857#2,2:178\n1549#2:180\n1620#2,3:181\n766#2:184\n857#2,2:185\n1549#2:187\n1620#2,3:188\n179#3,2:191\n*S KotlinDebug\n*F\n+ 1 PsiUtils.kt\ncom/google/devtools/ksp/PsiUtilsKt\n*L\n106#1:177\n106#1:178,2\n107#1:180\n107#1:181,3\n120#1:184\n120#1:185,2\n121#1:187\n121#1:188,3\n149#1:191,2\n*E\n"})
public final class PsiUtilsKt {
    @NotNull
    private static final Map<JvmModifier, Modifier> jvmModifierMap;
    @NotNull
    private static final Set<Modifier> javaModifiers;
    @NotNull
    private static final Map<KtModifierKeywordToken, Modifier> modifierMap;

    @NotNull
    public static final Map<JvmModifier, Modifier> getJvmModifierMap() {
        return jvmModifierMap;
    }

    @NotNull
    public static final Set<Modifier> getJavaModifiers() {
        return javaModifiers;
    }

    @NotNull
    public static final Map<KtModifierKeywordToken, Modifier> getModifierMap() {
        return modifierMap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<Modifier> toKSModifiers(@Nullable KtModifierList $this$toKSModifiers) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        if ($this$toKSModifiers == null) {
            return SetsKt.emptySet();
        }
        Set modifiers2 = new LinkedHashSet();
        Iterable iterable = modifierMap.entrySet();
        Set set = modifiers2;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!$this$toKSModifiers.hasModifier((KtModifierKeywordToken)it.getKey())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Modifier)it.getValue());
        }
        set.addAll((List)destination$iv$iv);
        return modifiers2;
    }

    @NotNull
    public static final Set<Modifier> toKSModifiers(@NotNull KtModifierListOwner $this$toKSModifiers) {
        Intrinsics.checkNotNullParameter((Object)$this$toKSModifiers, (String)"<this>");
        KtModifierList modifierList = $this$toKSModifiers.getModifierList();
        return PsiUtilsKt.toKSModifiers(modifierList);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<Modifier> toKSModifiers(@NotNull PsiModifierListOwner $this$toKSModifiers) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toKSModifiers, (String)"<this>");
        Set modifiers2 = new LinkedHashSet();
        Iterable iterable = jvmModifierMap.entrySet();
        Set set = modifiers2;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!$this$toKSModifiers.hasModifier((JvmModifier)it.getKey())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Modifier)it.getValue());
        }
        set.addAll(CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
        PsiModifierList psiModifierList = $this$toKSModifiers.getModifierList();
        boolean bl = psiModifierList != null ? psiModifierList.hasExplicitModifier("default") : false;
        if (bl) {
            modifiers2.add(Modifier.JAVA_DEFAULT);
        }
        return modifiers2;
    }

    @NotNull
    public static final String findLocationString(@NotNull Project $this$findLocationString, @NotNull PsiFile file, int offset) {
        Intrinsics.checkNotNullParameter((Object)$this$findLocationString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)$this$findLocationString);
        Document document = psiDocumentManager.getDocument(file);
        if (document == null) {
            return "<unknown>";
        }
        Document document2 = document;
        int lineNumber = document2.getLineNumber(offset);
        int offsetInLine = offset - document2.getLineStartOffset(lineNumber);
        return file.getVirtualFile().getPath() + ": (" + (lineNumber + 1) + ", " + (offsetInLine + 1) + ')';
    }

    private static final String parseDocString(String raw) {
        String t1 = ((Object)StringsKt.trim((CharSequence)raw)).toString();
        if (!StringsKt.startsWith$default((String)t1, (String)"/**", (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)t1, (String)"*/", (boolean)false, (int)2, null)) {
            return null;
        }
        Object[] objectArray = new String[]{"\r\n", "\n", "\r"};
        Object object = StringsKt.findAnyOf$default((CharSequence)t1, (Collection)CollectionsKt.listOf((Object[])objectArray), (int)0, (boolean)false, (int)6, null);
        if (object == null || (object = (String)object.getSecond()) == null) {
            object = "";
        }
        Object lineSep = object;
        char[] cArray = new char[]{'/'};
        String string = StringsKt.trim((String)t1, (char[])cArray);
        cArray = new char[]{'*'};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.lines((CharSequence)StringsKt.trim((String)string, (char[])cArray)), (CharSequence)((CharSequence)lineSep), null, null, (int)0, null, (Function1)parseDocString.1.INSTANCE, (int)30, null);
    }

    @Nullable
    public static final String getDocString(@NotNull PsiElement $this$getDocString) {
        String string;
        Object v1;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$getDocString, (String)"<this>");
            PsiElement psiElement = $this$getDocString.getFirstChild();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"this.firstChild");
            Sequence $this$firstOrNull$iv = org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt.siblings$default((PsiElement)psiElement, (boolean)false, (boolean)false, (int)3, null);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof PsiComment)) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        PsiElement psiElement = v1;
        if (psiElement != null) {
            PsiElement it = psiElement;
            boolean bl = false;
            String string2 = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.text");
            string = PsiUtilsKt.parseDocString(string2);
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public static final ClassKind getClassType(@NotNull KtClassOrObject $this$getClassType) {
        ClassKind classKind2;
        Intrinsics.checkNotNullParameter((Object)$this$getClassType, (String)"<this>");
        KtClassOrObject ktClassOrObject = $this$getClassType;
        if (ktClassOrObject instanceof KtObjectDeclaration) {
            classKind2 = ClassKind.OBJECT;
        } else if (ktClassOrObject instanceof KtEnumEntry) {
            classKind2 = ClassKind.ENUM_ENTRY;
        } else if (ktClassOrObject instanceof KtClass) {
            classKind2 = ((KtClass)$this$getClassType).isEnum() ? ClassKind.ENUM_CLASS : (((KtClass)$this$getClassType).isInterface() ? ClassKind.INTERFACE : ($this$getClassType.isAnnotation() ? ClassKind.ANNOTATION_CLASS : ClassKind.CLASS));
        } else {
            throw new IllegalStateException("Unexpected psi type " + $this$getClassType.getClass() + ", please file a bug at https://github.com/google/ksp/issues/new");
        }
        return classKind2;
    }

    public static final /* synthetic */ <T> T findParentOfType(PsiElement $this$findParentOfType) {
        PsiElement parent2;
        Intrinsics.checkNotNullParameter((Object)$this$findParentOfType, (String)"<this>");
        boolean $i$f$findParentOfType = false;
        for (parent2 = $this$findParentOfType.getParent(); parent2 != null; parent2 = parent2.getParent()) {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (parent2 instanceof Object) break;
        }
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)parent2;
    }

    @NotNull
    public static final <T> MemoizedSequence<T> memoized(@NotNull Sequence<? extends T> $this$memoized) {
        Intrinsics.checkNotNullParameter($this$memoized, (String)"<this>");
        return new MemoizedSequence<T>($this$memoized);
    }

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)JvmModifier.PUBLIC, (Object)Modifier.PUBLIC), TuplesKt.to((Object)JvmModifier.PRIVATE, (Object)Modifier.PRIVATE), TuplesKt.to((Object)JvmModifier.ABSTRACT, (Object)Modifier.ABSTRACT), TuplesKt.to((Object)JvmModifier.FINAL, (Object)Modifier.FINAL), TuplesKt.to((Object)JvmModifier.PROTECTED, (Object)Modifier.PROTECTED), TuplesKt.to((Object)JvmModifier.STATIC, (Object)Modifier.JAVA_STATIC), TuplesKt.to((Object)JvmModifier.STRICTFP, (Object)Modifier.JAVA_STRICT), TuplesKt.to((Object)JvmModifier.NATIVE, (Object)Modifier.JAVA_NATIVE), TuplesKt.to((Object)JvmModifier.SYNCHRONIZED, (Object)Modifier.JAVA_SYNCHRONIZED), TuplesKt.to((Object)JvmModifier.TRANSIENT, (Object)Modifier.JAVA_TRANSIENT), TuplesKt.to((Object)JvmModifier.VOLATILE, (Object)Modifier.JAVA_VOLATILE)};
        jvmModifierMap = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new Modifier[]{Modifier.ABSTRACT, Modifier.FINAL, Modifier.JAVA_DEFAULT, Modifier.JAVA_NATIVE, Modifier.JAVA_STATIC, Modifier.JAVA_STRICT, Modifier.JAVA_SYNCHRONIZED, Modifier.JAVA_TRANSIENT, Modifier.JAVA_VOLATILE, Modifier.PRIVATE, Modifier.PROTECTED, Modifier.PUBLIC};
        javaModifiers = SetsKt.setOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to((Object)KtTokens.PUBLIC_KEYWORD, (Object)Modifier.PUBLIC), TuplesKt.to((Object)KtTokens.PRIVATE_KEYWORD, (Object)Modifier.PRIVATE), TuplesKt.to((Object)KtTokens.INTERNAL_KEYWORD, (Object)Modifier.INTERNAL), TuplesKt.to((Object)KtTokens.PROTECTED_KEYWORD, (Object)Modifier.PROTECTED), TuplesKt.to((Object)KtTokens.IN_KEYWORD, (Object)Modifier.IN), TuplesKt.to((Object)KtTokens.OUT_KEYWORD, (Object)Modifier.OUT), TuplesKt.to((Object)KtTokens.OVERRIDE_KEYWORD, (Object)Modifier.OVERRIDE), TuplesKt.to((Object)KtTokens.LATEINIT_KEYWORD, (Object)Modifier.LATEINIT), TuplesKt.to((Object)KtTokens.ENUM_KEYWORD, (Object)Modifier.ENUM), TuplesKt.to((Object)KtTokens.SEALED_KEYWORD, (Object)Modifier.SEALED), TuplesKt.to((Object)KtTokens.ANNOTATION_KEYWORD, (Object)Modifier.ANNOTATION), TuplesKt.to((Object)KtTokens.DATA_KEYWORD, (Object)Modifier.DATA), TuplesKt.to((Object)KtTokens.INNER_KEYWORD, (Object)Modifier.INNER), TuplesKt.to((Object)KtTokens.FUN_KEYWORD, (Object)Modifier.FUN), TuplesKt.to((Object)KtTokens.VALUE_KEYWORD, (Object)Modifier.VALUE), TuplesKt.to((Object)KtTokens.SUSPEND_KEYWORD, (Object)Modifier.SUSPEND), TuplesKt.to((Object)KtTokens.TAILREC_KEYWORD, (Object)Modifier.TAILREC), TuplesKt.to((Object)KtTokens.OPERATOR_KEYWORD, (Object)Modifier.OPERATOR), TuplesKt.to((Object)KtTokens.INFIX_KEYWORD, (Object)Modifier.INFIX), TuplesKt.to((Object)KtTokens.INLINE_KEYWORD, (Object)Modifier.INLINE), TuplesKt.to((Object)KtTokens.EXTERNAL_KEYWORD, (Object)Modifier.EXTERNAL), TuplesKt.to((Object)KtTokens.ABSTRACT_KEYWORD, (Object)Modifier.ABSTRACT), TuplesKt.to((Object)KtTokens.FINAL_KEYWORD, (Object)Modifier.FINAL), TuplesKt.to((Object)KtTokens.OPEN_KEYWORD, (Object)Modifier.OPEN), TuplesKt.to((Object)KtTokens.VARARG_KEYWORD, (Object)Modifier.VARARG), TuplesKt.to((Object)KtTokens.NOINLINE_KEYWORD, (Object)Modifier.NOINLINE), TuplesKt.to((Object)KtTokens.CROSSINLINE_KEYWORD, (Object)Modifier.CROSSINLINE), TuplesKt.to((Object)KtTokens.REIFIED_KEYWORD, (Object)Modifier.REIFIED), TuplesKt.to((Object)KtTokens.EXPECT_KEYWORD, (Object)Modifier.EXPECT), TuplesKt.to((Object)KtTokens.ACTUAL_KEYWORD, (Object)Modifier.ACTUAL), TuplesKt.to((Object)KtTokens.CONST_KEYWORD, (Object)Modifier.CONST)};
        modifierMap = MapsKt.mapOf((Pair[])objectArray);
    }
}

