/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.ksp.gradle.utils;

import com.android.build.api.AndroidPluginVersion;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.google.devtools.ksp.gradle.utils.KgpUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u001a\n\u0010\n\u001a\u00020\b*\u00020\t\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\u0001*\u00020\t\u001a\n\u0010\f\u001a\u00020\b*\u00020\t\u001a\n\u0010\r\u001a\u00020\b*\u00020\t\u001a\n\u0010\u000e\u001a\u00020\b*\u00020\t\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000f"}, d2={"MINIMUM_SUPPORTED_AGP_VERSION", "Lcom/android/build/api/AndroidPluginVersion;", "getMINIMUM_SUPPORTED_AGP_VERSION", "()Lcom/android/build/api/AndroidPluginVersion;", "checkMinimumAgpVersion", "", "pluginVersion", "canUseAddGeneratedSourceDirectoriesApi", "", "Lorg/gradle/api/Project;", "canUseInternalKspApis", "getAgpVersion", "isAgpBuiltInKotlinUsed", "minimumAndroidKotlinMultiplatformVersion", "useLegacyVariantApi", "gradle-plugin"})
public final class AgpUtilsKt {
    @NotNull
    private static final AndroidPluginVersion MINIMUM_SUPPORTED_AGP_VERSION = new AndroidPluginVersion(8, 3, 0);

    @Nullable
    public static final AndroidPluginVersion getAgpVersion(@NotNull Project $this$getAgpVersion) {
        AndroidComponentsExtension androidComponentsExtension;
        Intrinsics.checkNotNullParameter((Object)$this$getAgpVersion, (String)"<this>");
        try {
            androidComponentsExtension = (AndroidComponentsExtension)$this$getAgpVersion.getExtensions().findByType(AndroidComponentsExtension.class);
            androidComponentsExtension = androidComponentsExtension != null ? androidComponentsExtension.getPluginVersion() : null;
        }
        catch (NoClassDefFoundError e) {
            androidComponentsExtension = null;
        }
        catch (Exception e) {
            androidComponentsExtension = null;
        }
        return androidComponentsExtension;
    }

    public static final boolean isAgpBuiltInKotlinUsed(@NotNull Project $this$isAgpBuiltInKotlinUsed) {
        Intrinsics.checkNotNullParameter((Object)$this$isAgpBuiltInKotlinUsed, (String)"<this>");
        return KgpUtilsKt.isKotlinBaseApiPluginApplied($this$isAgpBuiltInKotlinUsed) && !KgpUtilsKt.isKotlinAndroidPluginApplied($this$isAgpBuiltInKotlinUsed);
    }

    public static final void checkMinimumAgpVersion(@NotNull AndroidPluginVersion pluginVersion) {
        Intrinsics.checkNotNullParameter((Object)pluginVersion, (String)"pluginVersion");
        if (pluginVersion.compareTo(MINIMUM_SUPPORTED_AGP_VERSION) < 0) {
            throw new RuntimeException("The minimum supported AGP version is " + MINIMUM_SUPPORTED_AGP_VERSION.getVersion() + ". Please upgrade the AGP version in your project.");
        }
    }

    public static final boolean useLegacyVariantApi(@NotNull Project $this$useLegacyVariantApi) {
        Intrinsics.checkNotNullParameter((Object)$this$useLegacyVariantApi, (String)"<this>");
        Project project = $this$useLegacyVariantApi.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AndroidPluginVersion androidPluginVersion = AgpUtilsKt.getAgpVersion(project);
        if (androidPluginVersion == null) {
            return true;
        }
        AndroidPluginVersion agpVersion = androidPluginVersion;
        if (Intrinsics.areEqual((Object)$this$useLegacyVariantApi.getProviders().gradleProperty("force.legacy.variant.api").getOrNull(), (Object)"true")) {
            return true;
        }
        return agpVersion.compareTo(new AndroidPluginVersion(8, 10, 0).alpha(3)) < 0;
    }

    public static final boolean canUseAddGeneratedSourceDirectoriesApi(@NotNull Project $this$canUseAddGeneratedSourceDirectoriesApi) {
        Intrinsics.checkNotNullParameter((Object)$this$canUseAddGeneratedSourceDirectoriesApi, (String)"<this>");
        Project project = $this$canUseAddGeneratedSourceDirectoriesApi.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AndroidPluginVersion androidPluginVersion = AgpUtilsKt.getAgpVersion(project);
        if (androidPluginVersion == null) {
            return false;
        }
        AndroidPluginVersion agpVersion = androidPluginVersion;
        return agpVersion.compareTo(new AndroidPluginVersion(8, 12, 0).alpha(6)) >= 0;
    }

    public static final boolean canUseInternalKspApis(@NotNull Project $this$canUseInternalKspApis) {
        Intrinsics.checkNotNullParameter((Object)$this$canUseInternalKspApis, (String)"<this>");
        Project project = $this$canUseInternalKspApis.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AndroidPluginVersion androidPluginVersion = AgpUtilsKt.getAgpVersion(project);
        if (androidPluginVersion == null) {
            return false;
        }
        AndroidPluginVersion agpVersion = androidPluginVersion;
        return agpVersion.compareTo(new AndroidPluginVersion(9, 0, 0).alpha(14)) >= 0;
    }

    public static final boolean minimumAndroidKotlinMultiplatformVersion(@NotNull Project $this$minimumAndroidKotlinMultiplatformVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$minimumAndroidKotlinMultiplatformVersion, (String)"<this>");
        Project project = $this$minimumAndroidKotlinMultiplatformVersion.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AndroidPluginVersion androidPluginVersion = AgpUtilsKt.getAgpVersion(project);
        if (androidPluginVersion == null) {
            return false;
        }
        AndroidPluginVersion agpVersion = androidPluginVersion;
        return agpVersion.compareTo(new AndroidPluginVersion(8, 2, 0)) >= 0;
    }

    @NotNull
    public static final AndroidPluginVersion getMINIMUM_SUPPORTED_AGP_VERSION() {
        return MINIMUM_SUPPORTED_AGP_VERSION;
    }
}

