/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.ksp;

import com.google.devtools.ksp.FileExternalizer;
import com.google.devtools.ksp.FileKeyDescriptor;
import com.google.devtools.ksp.PersistentMap;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.IncrementalCompilationContext;
import org.jetbrains.kotlin.incremental.IncrementalJvmCacheKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0016\u0010\n\u001a\u00020\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/google/devtools/ksp/FileToFilesMap;", "Lcom/google/devtools/ksp/PersistentMap;", "Ljava/io/File;", "storageFile", "icContext", "Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;", "(Ljava/io/File;Lorg/jetbrains/kotlin/incremental/IncrementalCompilationContext;)V", "dumpKey", "", "key", "dumpValue", "value", "", "compiler-plugin"})
public final class FileToFilesMap
extends PersistentMap<File, File> {
    public FileToFilesMap(@NotNull File storageFile, @NotNull IncrementalCompilationContext icContext) {
        Intrinsics.checkNotNullParameter((Object)storageFile, (String)"storageFile");
        Intrinsics.checkNotNullParameter((Object)icContext, (String)"icContext");
        super(storageFile, FileKeyDescriptor.INSTANCE, FileExternalizer.INSTANCE, icContext);
    }

    @NotNull
    public String dumpKey(@NotNull File key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = key.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    @NotNull
    public String dumpValue(@NotNull Collection<? extends File> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return IncrementalJvmCacheKt.dumpCollection(value);
    }
}

