/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.ksp.processing.impl;

import com.google.devtools.ksp.NoSourceFile;
import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.Dependencies;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSFile;
import com.google.devtools.ksp.symbol.KSName;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010&\u001a\u00020\u0003H\u0002J&\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u0003H\u0002J.\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012H\u0016J&\u0010,\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010'\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012H\u0016J.\u0010-\u001a\u00020$2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\f2\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012H\u0016J\u0006\u00100\u001a\u00020$J \u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u0003H\u0002J(\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012H\u0016J \u00105\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u0010'\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012H\u0016J\u0010\u00106\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u0012H\u0002J\u0018\u00107\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020\u00032\u0006\u00108\u001a\u00020\u0003H\u0002J\u001e\u00109\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00030\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\n \u001e*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030 0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006:"}, d2={"Lcom/google/devtools/ksp/processing/impl/CodeGeneratorImpl;", "Lcom/google/devtools/ksp/processing/CodeGenerator;", "classDir", "Ljava/io/File;", "javaDir", "Lkotlin/Function0;", "kotlinDir", "resourcesDir", "projectBase", "anyChangesWildcard", "Lcom/google/devtools/ksp/symbol/KSFile;", "allSources", "", "isIncremental", "", "(Ljava/io/File;Lkotlin/jvm/functions/Function0;Ljava/io/File;Ljava/io/File;Ljava/io/File;Lcom/google/devtools/ksp/symbol/KSFile;Ljava/util/List;Z)V", "fileMap", "", "", "fileOutputStreamMap", "Ljava/io/FileOutputStream;", "generatedFile", "", "getGeneratedFile", "()Ljava/util/Collection;", "outputs", "", "getOutputs", "()Ljava/util/Set;", "separator", "kotlin.jvm.PlatformType", "sourceToOutputs", "", "getSourceToOutputs", "()Ljava/util/Map;", "associate", "", "sources", "outputPath", "path", "baseDir", "packageName", "fileName", "extensionName", "associateByPath", "associateWithClasses", "classes", "Lcom/google/devtools/ksp/symbol/KSClassDeclaration;", "closeFiles", "createNewFile", "Ljava/io/OutputStream;", "dependencies", "Lcom/google/devtools/ksp/processing/Dependencies;", "createNewFileByPath", "extensionToDirectory", "isWithinBaseDir", "file", "pathOf", "common-util"})
@SourceDebugExtension(value={"SMAP\nCodeGeneratorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeGeneratorImpl.kt\ncom/google/devtools/ksp/processing/impl/CodeGeneratorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,172:1\n1855#2,2:173\n1549#2:175\n1620#2,3:176\n1855#2:179\n1856#2:187\n1620#2,3:188\n1549#2:191\n1620#2,3:192\n372#3,7:180\n*S KotlinDebug\n*F\n+ 1 CodeGeneratorImpl.kt\ncom/google/devtools/ksp/processing/impl/CodeGeneratorImpl\n*L\n49#1:173,2\n95#1:175\n95#1:176,3\n161#1:179\n161#1:187\n167#1:188,3\n170#1:191\n170#1:192,3\n162#1:180,7\n*E\n"})
public final class CodeGeneratorImpl
implements CodeGenerator {
    @NotNull
    private final File classDir;
    @NotNull
    private final Function0<File> javaDir;
    @NotNull
    private final File kotlinDir;
    @NotNull
    private final File resourcesDir;
    @NotNull
    private final File projectBase;
    @NotNull
    private final KSFile anyChangesWildcard;
    @NotNull
    private final List<KSFile> allSources;
    private final boolean isIncremental;
    @NotNull
    private final Map<String, File> fileMap;
    @NotNull
    private final Map<String, FileOutputStream> fileOutputStreamMap;
    private final String separator;
    @NotNull
    private final Map<File, Set<File>> sourceToOutputs;

    public CodeGeneratorImpl(@NotNull File classDir, @NotNull Function0<? extends File> javaDir, @NotNull File kotlinDir, @NotNull File resourcesDir, @NotNull File projectBase, @NotNull KSFile anyChangesWildcard, @NotNull List<? extends KSFile> allSources, boolean isIncremental) {
        Intrinsics.checkNotNullParameter((Object)classDir, (String)"classDir");
        Intrinsics.checkNotNullParameter(javaDir, (String)"javaDir");
        Intrinsics.checkNotNullParameter((Object)kotlinDir, (String)"kotlinDir");
        Intrinsics.checkNotNullParameter((Object)resourcesDir, (String)"resourcesDir");
        Intrinsics.checkNotNullParameter((Object)projectBase, (String)"projectBase");
        Intrinsics.checkNotNullParameter((Object)anyChangesWildcard, (String)"anyChangesWildcard");
        Intrinsics.checkNotNullParameter(allSources, (String)"allSources");
        this.classDir = classDir;
        this.javaDir = javaDir;
        this.kotlinDir = kotlinDir;
        this.resourcesDir = resourcesDir;
        this.projectBase = projectBase;
        this.anyChangesWildcard = anyChangesWildcard;
        this.allSources = allSources;
        this.isIncremental = isIncremental;
        this.fileMap = new LinkedHashMap();
        this.fileOutputStreamMap = new LinkedHashMap();
        this.separator = File.separator;
        this.sourceToOutputs = new LinkedHashMap();
    }

    @NotNull
    public final Map<File, Set<File>> getSourceToOutputs() {
        return this.sourceToOutputs;
    }

    public final void closeFiles() {
        Iterable $this$forEach$iv = this.fileOutputStreamMap.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            FileOutputStream fileOutputStream = this.fileOutputStreamMap.get(it);
            Intrinsics.checkNotNull((Object)fileOutputStream);
            fileOutputStream.close();
        }
        this.fileOutputStreamMap.clear();
    }

    @NotNull
    public final String pathOf(@NotNull String packageName2, @NotNull String fileName2, @NotNull String extensionName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)fileName2, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)extensionName, (String)"extensionName");
        if (!Intrinsics.areEqual((Object)packageName2, (Object)"")) {
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray = new String[]{"."};
            Iterable iterable = StringsKt.split$default((CharSequence)packageName2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String string2 = this.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"separator");
            string = stringBuilder.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null)).append(this.separator).toString();
        } else {
            string = "";
        }
        String packageDirs = string;
        String extension = !Intrinsics.areEqual((Object)extensionName, (Object)"") ? '.' + extensionName : "";
        return packageDirs + fileName2 + extension;
    }

    @NotNull
    public OutputStream createNewFile(@NotNull Dependencies dependencies, @NotNull String packageName2, @NotNull String fileName2, @NotNull String extensionName) {
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)fileName2, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)extensionName, (String)"extensionName");
        return this.createNewFile(dependencies, this.pathOf(packageName2, fileName2, extensionName), this.extensionToDirectory(extensionName));
    }

    @NotNull
    public OutputStream createNewFileByPath(@NotNull Dependencies dependencies, @NotNull String path, @NotNull String extensionName) {
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)extensionName, (String)"extensionName");
        String extension = !Intrinsics.areEqual((Object)extensionName, (Object)"") ? '.' + extensionName : "";
        return this.createNewFile(dependencies, path + extension, this.extensionToDirectory(extensionName));
    }

    public void associate(@NotNull List<? extends KSFile> sources, @NotNull String packageName2, @NotNull String fileName2, @NotNull String extensionName) {
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)fileName2, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)extensionName, (String)"extensionName");
        this.associate(sources, this.pathOf(packageName2, fileName2, extensionName), this.extensionToDirectory(extensionName));
    }

    public void associateByPath(@NotNull List<? extends KSFile> sources, @NotNull String path, @NotNull String extensionName) {
        Intrinsics.checkNotNullParameter(sources, (String)"sources");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)extensionName, (String)"extensionName");
        String extension = !Intrinsics.areEqual((Object)extensionName, (Object)"") ? '.' + extensionName : "";
        this.associate(sources, path + extension, this.extensionToDirectory(extensionName));
    }

    /*
     * WARNING - void declaration
     */
    public void associateWithClasses(@NotNull List<? extends KSClassDeclaration> classes, @NotNull String packageName2, @NotNull String fileName2, @NotNull String extensionName) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)fileName2, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)extensionName, (String)"extensionName");
        String path = this.pathOf(packageName2, fileName2, extensionName);
        Iterable $this$map$iv = classes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KSClassDeclaration kSClassDeclaration = (KSClassDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            KSFile kSFile = it.getContainingFile();
            if (kSFile == null) {
                KSName kSName = it.getQualifiedName();
                kSFile = new NoSourceFile(this.projectBase, String.valueOf(kSName != null ? kSName.asString() : null));
            }
            collection.add(kSFile);
        }
        List files = (List)destination$iv$iv;
        this.associate(files, path, this.extensionToDirectory(extensionName));
    }

    /*
     * Unable to fully structure code
     */
    private final File extensionToDirectory(String extensionName) {
        block7: {
            block6: {
                var2_2 = extensionName;
                switch (var2_2.hashCode()) {
                    case 3254818: {
                        if (var2_2.equals("java")) break;
                        ** break;
                    }
                    case 3433: {
                        if (!var2_2.equals("kt")) {
                            ** break;
                        }
                        break block6;
                    }
                    case 94742904: {
                        if (!var2_2.equals("class")) ** break;
                        v0 = this.classDir;
                        break block7;
                    }
                }
                v0 = (File)this.javaDir.invoke();
                break block7;
            }
            v0 = this.kotlinDir;
            break block7;
lbl19:
            // 4 sources

            v0 = this.resourcesDir;
        }
        return v0;
    }

    private final OutputStream createNewFile(Dependencies dependencies, String path, File baseDir) {
        File file = new File(baseDir, path);
        if (!this.isWithinBaseDir(baseDir, file)) {
            throw new IllegalStateException("requested path is outside the bounds of the required directory");
        }
        if (this.fileMap.containsKey(path)) {
            throw new FileAlreadyExistsException(file, null, null, 6, null);
        }
        File parentFile = file.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new IllegalStateException("failed to make parent directories.");
        }
        FilesKt.writeText$default((File)file, (String)"", null, (int)2, null);
        this.fileMap.put(path, file);
        List sources = dependencies.isAllSources() ? CollectionsKt.plus((Collection)this.allSources, (Object)this.anyChangesWildcard) : (dependencies.getAggregating() ? CollectionsKt.plus((Collection)dependencies.getOriginatingFiles(), (Object)this.anyChangesWildcard) : dependencies.getOriginatingFiles());
        this.associate(sources, file);
        File file2 = this.fileMap.get(path);
        Intrinsics.checkNotNull((Object)file2);
        this.fileOutputStreamMap.put(path, new FileOutputStream(file2));
        FileOutputStream fileOutputStream = this.fileOutputStreamMap.get(path);
        Intrinsics.checkNotNull((Object)fileOutputStream);
        return fileOutputStream;
    }

    private final boolean isWithinBaseDir(File baseDir, File file) {
        boolean bl;
        Path base = baseDir.toPath().normalize();
        try {
            Path relativePath = file.toPath().normalize();
            bl = relativePath.startsWith(base);
        }
        catch (IOException e) {
            bl = false;
        }
        return bl;
    }

    private final void associate(List<? extends KSFile> sources, String path, File baseDir) {
        File file = new File(baseDir, path);
        if (!this.isWithinBaseDir(baseDir, file)) {
            throw new IllegalStateException("requested path is outside the bounds of the required directory");
        }
        this.associate(sources, file);
    }

    /*
     * WARNING - void declaration
     */
    private final void associate(List<? extends KSFile> sources, File outputPath) {
        if (!this.isIncremental) {
            return;
        }
        File output = FilesKt.relativeTo((File)outputPath, (File)this.projectBase);
        Iterable $this$forEach$iv = sources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            void $this$getOrPut$iv;
            KSFile source = (KSFile)element$iv;
            boolean bl = false;
            Map<File, Set<File>> map = this.sourceToOutputs;
            File key$iv = FilesKt.relativeTo((File)new File(source.getFilePath()), (File)this.projectBase);
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                Set answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Set)object).add(output);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<File> getOutputs() {
        void var2_2;
        void $this$mapTo$iv;
        Iterable iterable = this.fileMap.values();
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            File file = (File)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(FilesKt.relativeTo((File)it, (File)this.projectBase));
        }
        return (Set)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<File> getGeneratedFile() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.fileOutputStreamMap.keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file = this.fileMap.get(it);
            Intrinsics.checkNotNull((Object)file);
            collection.add(file);
        }
        return (List)destination$iv$iv;
    }
}

