/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeObjCRefinementChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.MemberWithBaseScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00122\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0003\u0010\u0011\u0012B\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J-\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u00020\nR\u00020\fj\u0006\u0010\u000b\u001a\u00020\nj\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000f\u0082\u0001\u0002\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "mppKind", "Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;)V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "Regular", "ForExpectClass", "Companion", "Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker$Regular;", "checkers.native"})
public abstract class FirNativeObjCRefinementOverridesChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private FirNativeObjCRefinementOverridesChecker(MppCheckerKind mppKind) {
        super(mppKind);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        FirTypeScope baseScope = FirHelpersKt.unsubstitutedScope(context2, declaration2);
        FirContainingNamesAwareScopeKt.processAllFunctions(baseScope, (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)arg_0 -> FirNativeObjCRefinementOverridesChecker.check$lambda$0(context2, reporter, baseScope, declaration2, arg_0)));
        FirContainingNamesAwareScopeKt.processAllProperties(baseScope, arg_0 -> FirNativeObjCRefinementOverridesChecker.check$lambda$1(context2, reporter, baseScope, declaration2, arg_0));
    }

    private static final Unit check$lambda$0(CheckerContext $context, DiagnosticReporter $reporter, FirTypeScope $baseScope, FirClass $declaration, FirNamedFunctionSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (!ClassMembersKt.isIntersectionOverride(symbol)) {
            return Unit.INSTANCE;
        }
        Companion.check($context, $reporter, $baseScope, symbol, $declaration, CollectionsKt.emptyList(), CollectionsKt.emptyList());
        return Unit.INSTANCE;
    }

    private static final Unit check$lambda$1(CheckerContext $context, DiagnosticReporter $reporter, FirTypeScope $baseScope, FirClass $declaration, FirVariableSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        if (!ClassMembersKt.isIntersectionOverride(symbol)) {
            return Unit.INSTANCE;
        }
        Companion.check($context, $reporter, $baseScope, symbol, $declaration, CollectionsKt.emptyList(), CollectionsKt.emptyList());
        return Unit.INSTANCE;
    }

    public /* synthetic */ FirNativeObjCRefinementOverridesChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J[\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0014J,\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016*\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002JE\u0010\u001b\u001a\u00020\u0005*\u00020\b2\u0006\u0010\u001c\u001a\u00020\u000f2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0010\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u0011H\u0002R\u00020\u0006j\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u001f\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker$Companion;", "", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "baseScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "memberSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "declarationToReport", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "objCAnnotations", "", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "swiftAnnotations", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Ljava/util/List;Ljava/util/List;)V", "inheritsRefinedAnnotations", "Lkotlin/Pair;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "hasRefinedAnnotations", "reportIncompatibleOverride", "declaration", "annotations", "notRefinedSupers", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Ljava/util/List;Ljava/util/List;)V", "checkers.native"})
    @SourceDebugExtension(value={"SMAP\nFirNativeObjCRefinementOverridesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeObjCRefinementOverridesChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1617#2,9:145\n1869#2:154\n1870#2:156\n1626#2:157\n1#3:155\n*S KotlinDebug\n*F\n+ 1 FirNativeObjCRefinementOverridesChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker$Companion\n*L\n132#1:145,9\n132#1:154\n132#1:156\n132#1:157\n132#1:155\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirTypeScope baseScope, @NotNull FirCallableSymbol<?> memberSymbol, @NotNull FirDeclaration declarationToReport, @NotNull List<? extends FirAnnotation> objCAnnotations, @NotNull List<? extends FirAnnotation> swiftAnnotations) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)baseScope, (String)"baseScope");
            Intrinsics.checkNotNullParameter(memberSymbol, (String)"memberSymbol");
            Intrinsics.checkNotNullParameter((Object)declarationToReport, (String)"declarationToReport");
            Intrinsics.checkNotNullParameter(objCAnnotations, (String)"objCAnnotations");
            Intrinsics.checkNotNullParameter(swiftAnnotations, (String)"swiftAnnotations");
            List<MemberWithBaseScope<FirCallableSymbol<?>>> overriddenMemberSymbols = FirTypeScopeKt.getDirectOverriddenMembersWithBaseScopeSafe(baseScope, memberSymbol);
            if (overriddenMemberSymbols.isEmpty()) {
                return;
            }
            boolean isHiddenFromObjC = !((Collection)objCAnnotations).isEmpty();
            boolean isRefinedInSwift = !((Collection)swiftAnnotations).isEmpty();
            List supersNotHiddenFromObjC = new ArrayList();
            List supersNotRefinedInSwift = new ArrayList();
            for (MemberWithBaseScope<FirCallableSymbol<?>> memberWithBaseScope : overriddenMemberSymbols) {
                FirCallableSymbol<?> symbol = memberWithBaseScope.component1();
                FirTypeScope scope = memberWithBaseScope.component2();
                Pair<Boolean, Boolean> pair = this.inheritsRefinedAnnotations(symbol, context2.getSession(), scope);
                boolean superIsHiddenFromObjC = (Boolean)pair.component1();
                boolean superIsRefinedInSwift = (Boolean)pair.component2();
                if (superIsHiddenFromObjC) {
                    isHiddenFromObjC = true;
                } else {
                    supersNotHiddenFromObjC.add(symbol);
                }
                if (superIsRefinedInSwift) {
                    isRefinedInSwift = true;
                    continue;
                }
                supersNotRefinedInSwift.add(symbol);
            }
            if (isHiddenFromObjC && !((Collection)supersNotHiddenFromObjC).isEmpty()) {
                this.reportIncompatibleOverride(context2, reporter, declarationToReport, objCAnnotations, supersNotHiddenFromObjC);
            }
            if (isRefinedInSwift && !((Collection)supersNotRefinedInSwift).isEmpty()) {
                this.reportIncompatibleOverride(context2, reporter, declarationToReport, swiftAnnotations, supersNotRefinedInSwift);
            }
        }

        private final Pair<Boolean, Boolean> inheritsRefinedAnnotations(FirCallableSymbol<?> $this$inheritsRefinedAnnotations, FirSession session, FirTypeScope baseScope) {
            Pair<Boolean, Boolean> pair = this.hasRefinedAnnotations($this$inheritsRefinedAnnotations, session);
            boolean hasObjC = (Boolean)pair.component1();
            boolean hasSwift = (Boolean)pair.component2();
            if (hasObjC && hasSwift) {
                return TuplesKt.to((Object)true, (Object)true);
            }
            MemberWithBaseScope memberWithBaseScope = (MemberWithBaseScope)CollectionsKt.firstOrNull(FirTypeScopeKt.getDirectOverriddenMembersWithBaseScopeSafe(baseScope, $this$inheritsRefinedAnnotations));
            if (memberWithBaseScope == null) {
                return TuplesKt.to((Object)hasObjC, (Object)hasSwift);
            }
            MemberWithBaseScope memberWithBaseScope2 = memberWithBaseScope;
            Object overriddenMemberSymbol = memberWithBaseScope2.component1();
            FirTypeScope scope = memberWithBaseScope2.component2();
            Pair<Boolean, Boolean> pair2 = this.inheritsRefinedAnnotations((FirCallableSymbol<?>)overriddenMemberSymbol, session, scope);
            boolean inheritsObjC = (Boolean)pair2.component1();
            boolean inheritsSwift = (Boolean)pair2.component2();
            return TuplesKt.to((Object)(hasObjC || inheritsObjC ? 1 : 0), (Object)(hasSwift || inheritsSwift ? 1 : 0));
        }

        private final Pair<Boolean, Boolean> hasRefinedAnnotations(FirCallableSymbol<?> $this$hasRefinedAnnotations, FirSession session) {
            boolean hasObjC = false;
            boolean hasSwift = false;
            for (FirAnnotation annotation : $this$hasRefinedAnnotations.getResolvedAnnotationsWithClassIds()) {
                FirClassLikeSymbol<?> firClassLikeSymbol = FirAnnotationUtilsKt.toAnnotationClassLikeSymbol(annotation, session);
                List list = firClassLikeSymbol != null ? firClassLikeSymbol.getResolvedAnnotationsWithClassIds() : null;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                List metaAnnotations = list;
                for (FirAnnotation metaAnnotation : metaAnnotations) {
                    ClassId classId = FirAnnotationUtilsKt.toAnnotationClassId(metaAnnotation, session);
                    if (Intrinsics.areEqual((Object)classId, (Object)FirNativeObjCRefinementChecker.INSTANCE.getHidesFromObjCClassId())) {
                        hasObjC = true;
                        break;
                    }
                    if (!Intrinsics.areEqual((Object)classId, (Object)FirNativeObjCRefinementChecker.INSTANCE.getRefinesInSwiftClassId())) continue;
                    hasSwift = true;
                    break;
                }
                if (!hasObjC || !hasSwift) continue;
                return TuplesKt.to((Object)true, (Object)true);
            }
            return TuplesKt.to((Object)hasObjC, (Object)hasSwift);
        }

        /*
         * WARNING - void declaration
         */
        private final void reportIncompatibleOverride(CheckerContext context2, DiagnosticReporter $this$reportIncompatibleOverride, FirDeclaration declaration2, List<? extends FirAnnotation> annotations2, List<? extends FirCallableSymbol<?>> notRefinedSupers) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = notRefinedSupers;
            boolean bl2 = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirRegularClassSymbol it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl22 = false;
                FirCallableSymbol it = (FirCallableSymbol)element$iv$iv;
                boolean bl3 = false;
                ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.containingClassLookupTag(it);
                if ((coneClassLikeLookupTag != null ? ToSymbolUtilsKt.toRegularClassSymbol(coneClassLikeLookupTag, context2.getSession()) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List containingDeclarations = (List)destination$iv$iv;
            if (annotations2.isEmpty()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, $this$reportIncompatibleOverride, (AbstractKtSourceElement)declaration2.getSource(), FirNativeErrors.INSTANCE.getINCOMPATIBLE_OBJC_REFINEMENT_OVERRIDE(), declaration2.getSymbol(), (Object)containingDeclarations, null, 32, null);
            } else {
                for (FirAnnotation firAnnotation : annotations2) {
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, $this$reportIncompatibleOverride, (AbstractKtSourceElement)firAnnotation.getSource(), FirNativeErrors.INSTANCE.getINCOMPATIBLE_OBJC_REFINEMENT_OVERRIDE(), declaration2.getSymbol(), (Object)containingDeclarations, null, 32, null);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "checkers.native"})
    @SourceDebugExtension(value={"SMAP\nFirNativeObjCRefinementOverridesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeObjCRefinementOverridesChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker$ForExpectClass\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,144:1\n36#2:145\n*S KotlinDebug\n*F\n+ 1 FirNativeObjCRefinementOverridesChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker$ForExpectClass\n*L\n45#1:145\n*E\n"})
    public static final class ForExpectClass
    extends FirNativeObjCRefinementOverridesChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            FirMemberDeclaration $this$isExpect$iv = declaration2;
            boolean $i$f$isExpect = false;
            if (!$this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(context2, reporter, declaration2);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker$Regular;", "Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "checkers.native"})
    @SourceDebugExtension(value={"SMAP\nFirNativeObjCRefinementOverridesChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeObjCRefinementOverridesChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker$Regular\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,144:1\n36#2:145\n*S KotlinDebug\n*F\n+ 1 FirNativeObjCRefinementOverridesChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeObjCRefinementOverridesChecker$Regular\n*L\n37#1:145\n*E\n"})
    public static final class Regular
    extends FirNativeObjCRefinementOverridesChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
            FirMemberDeclaration $this$isExpect$iv = declaration2;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                return;
            }
            super.check(context2, reporter, declaration2);
        }
    }
}

