/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\u0019\u0010\u000e\u001a\u00020\u000fH\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010J\u0019\u0010\u0011\u001a\u00020\u000fH\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnsupportedArrayLiteralChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirArrayLiteral;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirArrayLiteralChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirArrayLiteral;)V", "isInsideAnnotationCall", "", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Z", "isInsideAnnotationConstructor", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirUnsupportedArrayLiteralChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirUnsupportedArrayLiteralChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnsupportedArrayLiteralChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt\n+ 4 CheckerContext.kt\norg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContextKt$findClosest$1\n*L\n1#1,48:1\n1761#2,3:49\n95#3,3:52\n100#3:56\n95#4:55\n*S KotlinDebug\n*F\n+ 1 FirUnsupportedArrayLiteralChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirUnsupportedArrayLiteralChecker\n*L\n35#1:49,3\n45#1:52,3\n45#1:56\n45#1:55\n*E\n"})
public final class FirUnsupportedArrayLiteralChecker
extends FirExpressionChecker<FirArrayLiteral> {
    @NotNull
    public static final FirUnsupportedArrayLiteralChecker INSTANCE = new FirUnsupportedArrayLiteralChecker();

    private FirUnsupportedArrayLiteralChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirArrayLiteral expression2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!this.isInsideAnnotationCall(context2) && !this.isInsideAnnotationConstructor(context2)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getUNSUPPORTED(), (Object)"Collection literals outside of annotations are unsupported.", null, 16, null);
        }
    }

    private final boolean isInsideAnnotationCall(CheckerContext context2) {
        boolean bl2;
        block5: {
            Iterable $this$any$iv = CollectionsKt.asReversed(context2.getCallsOrAssignments());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl3;
                    FirStatement it = (FirStatement)element$iv;
                    boolean bl4 = false;
                    FirStatement firStatement = it;
                    if (firStatement instanceof FirFunctionCall) {
                        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(FirTypeUtilsKt.getResolvedType((FirExpression)it), context2.getSession());
                        bl3 = (firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null) == ClassKind.ANNOTATION_CLASS;
                    } else {
                        bl3 = firStatement instanceof FirAnnotationCall;
                    }
                    if (!bl3) continue;
                    bl2 = true;
                    break block5;
                }
                bl2 = false;
            }
        }
        return bl2;
    }

    private final boolean isInsideAnnotationConstructor(CheckerContext context2) {
        Object object;
        FirBasedSymbol firBasedSymbol;
        block3: {
            CheckerContext $this$findClosest_u24default$iv = context2;
            boolean $i$f$findClosest = false;
            for (FirBasedSymbol it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                FirBasedSymbol firBasedSymbol2;
                FirBasedSymbol firBasedSymbol3 = it$iv;
                if (!(firBasedSymbol3 instanceof FirConstructorSymbol)) {
                    firBasedSymbol3 = null;
                }
                if ((firBasedSymbol = (FirBasedSymbol)((FirConstructorSymbol)firBasedSymbol3)) == null) continue;
                FirBasedSymbol firBasedSymbol4 = firBasedSymbol2 = firBasedSymbol;
                boolean bl2 = false;
                FirBasedSymbol it = firBasedSymbol4;
                firBasedSymbol = true ? firBasedSymbol2 : null;
                if (firBasedSymbol == null) {
                    continue;
                }
                break block3;
            }
            firBasedSymbol = null;
        }
        return ((object = (FirConstructorSymbol)firBasedSymbol) != null && (object = ((FirCallableSymbol)object).getResolvedReturnType()) != null && (object = ToSymbolUtilsKt.toRegularClassSymbol((ConeKotlinType)object, context2.getSession())) != null ? ((FirClassSymbol)object).getClassKind() : null) == ClassKind.ANNOTATION_CLASS;
    }
}

