/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.ItemPresentationProviders;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSyntheticClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiConstantEvaluationHelperImpl;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiFieldStub;
import com.intellij.psi.impl.java.stubs.PsiMemberStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stub.JavaStubImplUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.IncorrectOperationException;
import java.lang.ref.Reference;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFieldImpl
extends JavaStubPsiElement<PsiFieldStub>
implements PsiField,
PsiVariableEx,
Queryable {
    private static final Logger LOG = Logger.getInstance(PsiFieldImpl.class);
    private volatile Reference<PsiType> myCachedType;

    public PsiFieldImpl(PsiFieldStub stub2) {
        this(stub2, (IStubElementType)JavaStubElementTypes.FIELD);
    }

    protected PsiFieldImpl(PsiFieldStub stub2, IStubElementType type2) {
        super(stub2, type2);
    }

    public PsiFieldImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.dropCached();
    }

    private void dropCached() {
        this.myCachedType = null;
    }

    @Override
    protected Object clone() {
        PsiFieldImpl clone2 = (PsiFieldImpl)super.clone();
        clone2.dropCached();
        return clone2;
    }

    @Override
    public PsiClass getContainingClass() {
        PsiElement parent2 = this.getParent();
        return parent2 instanceof PsiClass ? (PsiClass)parent2 : (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)this, PsiSyntheticClass.class);
    }

    @Override
    public PsiElement getContext() {
        PsiClass cc = this.getContainingClass();
        return cc != null ? cc : super.getContext();
    }

    @Override
    @NotNull
    public CompositeElement getNode() {
        CompositeElement compositeElement = (CompositeElement)super.getNode();
        if (compositeElement == null) {
            PsiFieldImpl.$$$reportNull$$$0(0);
        }
        return compositeElement;
    }

    @Override
    @NotNull
    public PsiIdentifier getNameIdentifier() {
        PsiIdentifier psiIdentifier = (PsiIdentifier)this.getNode().findChildByRoleAsPsiElement(9);
        if (psiIdentifier == null) {
            PsiFieldImpl.$$$reportNull$$$0(1);
        }
        return psiIdentifier;
    }

    @Override
    @NotNull
    public String getName() {
        PsiFieldStub stub2 = (PsiFieldStub)this.getGreenStub();
        if (stub2 != null) {
            String string = stub2.getName();
            if (string == null) {
                PsiFieldImpl.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = this.getNameIdentifier().getText();
        if (string == null) {
            PsiFieldImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            PsiFieldImpl.$$$reportNull$$$0(4);
        }
        PsiImplUtil.setName(this.getNameIdentifier(), name2);
        return this;
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiFieldStub stub2 = (PsiFieldStub)this.getStub();
        if (stub2 != null) {
            PsiType type2 = SoftReference.dereference(this.myCachedType);
            if (type2 == null) {
                type2 = JavaSharedImplUtil.createTypeFromStub(this, stub2.getType());
                this.myCachedType = new java.lang.ref.SoftReference<PsiType>(type2);
            }
            PsiType psiType = type2;
            if (psiType == null) {
                PsiFieldImpl.$$$reportNull$$$0(5);
            }
            return psiType;
        }
        this.myCachedType = null;
        PsiTypeElement typeElement = this.getTypeElement();
        if (typeElement == null) {
            LOG.error("No type element found for field; children classes = " + StringUtil.join(this.getChildren(), e2 -> e2.getClass().getName(), ", "), new Attachment("tree.txt", DebugUtil.psiTreeToString(this, true)));
            PsiType psiType = PsiTypes.nullType();
            if (psiType == null) {
                PsiFieldImpl.$$$reportNull$$$0(6);
            }
            return psiType;
        }
        PsiType psiType = JavaSharedImplUtil.getType(typeElement, this.getNameIdentifier());
        if (psiType == null) {
            PsiFieldImpl.$$$reportNull$$$0(7);
        }
        return psiType;
    }

    @Override
    public PsiTypeElement getTypeElement() {
        PsiField firstField = this.findFirstFieldInDeclaration();
        if (firstField != this) {
            return firstField.getTypeElement();
        }
        return (PsiTypeElement)this.getNode().findChildByRoleAsPsiElement(10);
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        PsiModifierList selfModifierList = this.getSelfModifierList();
        if (selfModifierList != null) {
            PsiModifierList psiModifierList = selfModifierList;
            if (psiModifierList == null) {
                PsiFieldImpl.$$$reportNull$$$0(8);
            }
            return psiModifierList;
        }
        PsiField firstField = this.findFirstFieldInDeclaration();
        if (firstField == this) {
            if (!this.isValid()) {
                throw new PsiInvalidElementAccessException(this);
            }
            PsiField lastResort = this.findFirstFieldByTree();
            if (lastResort == this) {
                throw new IllegalStateException("Missing modifier list for sequence of fields: '" + this.getText() + "'");
            }
            firstField = lastResort;
        }
        PsiModifierList psiModifierList = firstField.getModifierList();
        if (psiModifierList == null) {
            PsiFieldImpl.$$$reportNull$$$0(9);
        }
        return psiModifierList;
    }

    @Nullable
    private PsiModifierList getSelfModifierList() {
        return this.getStubOrPsiChild(JavaStubElementTypes.MODIFIER_LIST);
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name2) {
        if (name2 == null) {
            PsiFieldImpl.$$$reportNull$$$0(10);
        }
        return this.getModifierList().hasModifierProperty(name2);
    }

    private PsiField findFirstFieldInDeclaration() {
        if (this.getSelfModifierList() != null) {
            return this;
        }
        PsiFieldStub stub2 = (PsiFieldStub)this.getGreenStub();
        if (stub2 != null) {
            List<StubElement> siblings2 = stub2.getParentStub().getChildrenStubs();
            int idx = siblings2.indexOf(stub2);
            assert (idx >= 0);
            for (int i2 = idx - 1; i2 >= 0 && siblings2.get(i2) instanceof PsiFieldStub; --i2) {
                PsiFieldStub prevField = (PsiFieldStub)siblings2.get(i2);
                PsiFieldImpl prevFieldPsi = (PsiFieldImpl)prevField.getPsi();
                if (prevFieldPsi.getSelfModifierList() == null) continue;
                return prevFieldPsi;
            }
        }
        return this.findFirstFieldByTree();
    }

    private PsiField findFirstFieldByTree() {
        CompositeElement treeElement = this.getNode();
        ASTNode modifierList2 = treeElement.findChildByRole(8);
        if (modifierList2 == null) {
            ASTNode prevField;
            for (prevField = treeElement.getTreePrev(); prevField != null && prevField.getElementType() != JavaElementType.FIELD; prevField = prevField.getTreePrev()) {
            }
            if (prevField == null) {
                return this;
            }
            return ((PsiFieldImpl)SourceTreeToPsiMap.treeElementToPsi(prevField)).findFirstFieldInDeclaration();
        }
        return this;
    }

    @Override
    public PsiExpression getInitializer() {
        return (PsiExpression)this.getNode().findChildByRoleAsPsiElement(21);
    }

    @Nullable
    public static PsiExpression getDetachedInitializer(@NotNull PsiVariable variable) {
        if (variable == null) {
            PsiFieldImpl.$$$reportNull$$$0(11);
        }
        return variable instanceof PsiFieldImpl ? ((PsiFieldImpl)variable).getDetachedInitializer() : variable.getInitializer();
    }

    @Nullable
    private PsiExpression getDetachedInitializer() {
        PsiExpression initializer;
        PsiFieldStub stub2 = (PsiFieldStub)this.getGreenStub();
        if (stub2 == null) {
            initializer = this.getInitializer();
        } else {
            String initializerText = stub2.getInitializerText();
            if (StringUtil.isEmpty(initializerText)) {
                return null;
            }
            if (";INITIALIZER_NOT_STORED;".equals(initializerText) || ";INITIALIZER_TOO_LONG;".equals(initializerText)) {
                initializer = this.getInitializer();
            } else {
                PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance(this.getProject()).getParserFacade();
                initializer = parserFacade.createExpressionFromText(initializerText, this);
                ((LightVirtualFile)initializer.getContainingFile().getViewProvider().getVirtualFile()).setWritable(false);
            }
        }
        return initializer;
    }

    @Override
    public boolean hasInitializer() {
        PsiFieldStub stub2 = (PsiFieldStub)this.getGreenStub();
        if (stub2 != null) {
            return stub2.getInitializerText() != null;
        }
        return this.getInitializer() != null;
    }

    @Override
    public Icon getElementIcon(int flags) {
        IconManager iconManager = IconManager.getInstance();
        RowIcon baseIcon = iconManager.createLayeredIcon(this, this.getBaseIcon(), ElementPresentationUtil.getFlags(this, false));
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    @Override
    @NotNull
    protected Icon getBaseIcon() {
        IconManager iconManager = IconManager.getInstance();
        Icon icon = iconManager.getPlatformIcon(PlatformIcons.Field);
        if (icon == null) {
            PsiFieldImpl.$$$reportNull$$$0(12);
        }
        return icon;
    }

    @Nullable
    private Object _computeConstantValue(@Nullable Set<PsiVariable> visitedVars) {
        PsiType type2 = this.getType();
        if (!(type2 instanceof PsiPrimitiveType) && !type2.equalsToText("java.lang.String")) {
            return null;
        }
        PsiExpression initializer = this.getDetachedInitializer();
        if (initializer == null) {
            return null;
        }
        if (!PsiAugmentProvider.canTrustFieldInitializer(this)) {
            return null;
        }
        return PsiConstantEvaluationHelperImpl.computeCastTo(initializer, type2, visitedVars);
    }

    @Override
    public Object computeConstantValue() {
        return this.computeConstantValue(new HashSet<PsiVariable>(2));
    }

    @Override
    public Object computeConstantValue(Set<PsiVariable> visitedVars) {
        if (!this.hasModifierProperty("final")) {
            return null;
        }
        return JavaResolveCache.getInstance(this.getProject()).computeConstantValueWithCaching(this, OurConstValueComputer.INSTANCE, visitedVars);
    }

    @Override
    public boolean isDeprecated() {
        return JavaStubImplUtil.isMemberDeprecated(this, (PsiMemberStub)this.getGreenStub());
    }

    @Override
    public PsiDocComment getDocComment() {
        ASTNode prevField;
        PsiFieldStub stub2 = (PsiFieldStub)this.getGreenStub();
        if (stub2 != null && !stub2.hasDocComment()) {
            return null;
        }
        CompositeElement treeElement = this.getNode();
        if (this.getTypeElement() != null) {
            PsiElement element2 = treeElement.findChildByRoleAsPsiElement(7);
            return element2 instanceof PsiDocComment ? (PsiDocComment)element2 : null;
        }
        for (prevField = treeElement.getTreePrev(); prevField != null && prevField.getElementType() != JavaElementType.FIELD; prevField = prevField.getTreePrev()) {
        }
        if (prevField == null) {
            return null;
        }
        return ((PsiField)SourceTreeToPsiMap.treeElementToPsi(prevField)).getDocComment();
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
        ASTNode nextField;
        ASTNode comma;
        CheckUtil.checkWritable(this);
        PsiTypeElement type2 = this.getTypeElement();
        PsiModifierList modifierList2 = this.getModifierList();
        ASTNode field = SourceTreeToPsiMap.psiElementToTree(type2.getParent());
        while ((comma = PsiImplUtil.skipWhitespaceAndComments(field.getTreeNext())) != null && comma.getElementType() == JavaTokenType.COMMA && (nextField = PsiImplUtil.skipWhitespaceAndComments(comma.getTreeNext())) != null && nextField.getElementType() == JavaElementType.FIELD) {
            LeafElement semicolon = Factory.createSingleLeafElement(JavaTokenType.SEMICOLON, ";", 0, 1, null, this.getManager());
            CodeEditUtil.addChild(field, semicolon, null);
            CodeEditUtil.removeChild(comma.getTreeParent(), comma);
            PsiElement typeClone = type2.copy();
            CodeEditUtil.addChild(nextField, SourceTreeToPsiMap.psiElementToTree(typeClone), nextField.getFirstChildNode());
            PsiElement modifierListClone = modifierList2.copy();
            CodeEditUtil.addChild(nextField, SourceTreeToPsiMap.psiElementToTree(modifierListClone), nextField.getFirstChildNode());
            field = nextField;
        }
        JavaSharedImplUtil.normalizeBrackets(this);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiFieldImpl.$$$reportNull$$$0(13);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitField(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            PsiFieldImpl.$$$reportNull$$$0(14);
        }
        if (state == null) {
            PsiFieldImpl.$$$reportNull$$$0(15);
        }
        if (place == null) {
            PsiFieldImpl.$$$reportNull$$$0(16);
        }
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, this);
        return true;
    }

    @Override
    public String toString() {
        return "PsiField:" + this.getName();
    }

    @Override
    public PsiElement getOriginalElement() {
        PsiField originalField;
        PsiClass containingClass = this.getContainingClass();
        if (containingClass != null && (originalField = ((PsiClass)containingClass.getOriginalElement()).findFieldByName(this.getName(), false)) != null) {
            return originalField;
        }
        return this;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public void setInitializer(PsiExpression initializer) throws IncorrectOperationException {
        JavaSharedImplUtil.setInitializer(this, initializer);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isFieldEquivalentTo(this, another);
    }

    @Override
    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope(this);
        if (searchScope == null) {
            PsiFieldImpl.$$$reportNull$$$0(17);
        }
        return searchScope;
    }

    @Override
    public void putInfo(@NotNull Map<? super String, ? super String> info) {
        if (info == null) {
            PsiFieldImpl.$$$reportNull$$$0(18);
        }
        info.put("fieldName", this.getName());
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/PsiFieldImpl";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIdentifier";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/PsiFieldImpl";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifierList";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseIcon";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasModifierProperty";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDetachedInitializer";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class OurConstValueComputer
    implements JavaResolveCache.ConstValueComputer {
        private static final OurConstValueComputer INSTANCE = new OurConstValueComputer();

        private OurConstValueComputer() {
        }

        @Override
        public Object execute(@NotNull PsiVariable variable, Set<PsiVariable> visitedVars) {
            if (variable == null) {
                OurConstValueComputer.$$$reportNull$$$0(0);
            }
            return ((PsiFieldImpl)variable)._computeConstantValue(visitedVars);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/psi/impl/source/PsiFieldImpl$OurConstValueComputer", "execute"));
        }
    }
}

