/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.IrSpecialAnnotationsProvider;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.backend.DelicateDeclarationStorageApi;
import org.jetbrains.kotlin.fir.backend.Fir2IrBuiltinSymbolsContainer;
import org.jetbrains.kotlin.fir.backend.Fir2IrCommonMemberStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrConfiguration;
import org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import org.jetbrains.kotlin.fir.backend.Fir2IrConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrDeclarationStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrExtensions;
import org.jetbrains.kotlin.fir.backend.Fir2IrImplicitCastInserter;
import org.jetbrains.kotlin.fir.backend.Fir2IrIrGeneratedDeclarationsRegistrar;
import org.jetbrains.kotlin.fir.backend.Fir2IrLocalClassStorage;
import org.jetbrains.kotlin.fir.backend.Fir2IrSymbolsMappingForLazyClasses;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverter;
import org.jetbrains.kotlin.fir.backend.Fir2IrTypeConverterKt;
import org.jetbrains.kotlin.fir.backend.Fir2IrVisibilityConverter;
import org.jetbrains.kotlin.fir.backend.FirProviderWithGeneratedFiles;
import org.jetbrains.kotlin.fir.backend.LeakedDeclarationCaches;
import org.jetbrains.kotlin.fir.backend.generators.AdapterGenerator;
import org.jetbrains.kotlin.fir.backend.generators.AnnotationGenerator;
import org.jetbrains.kotlin.fir.backend.generators.CallAndReferenceGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrCallableDeclarationsGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrCallableDeclarationsGeneratorKt;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrClassifiersGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrDataClassMembersGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrLazyDeclarationsGenerator;
import org.jetbrains.kotlin.fir.backend.generators.Fir2IrLazyFakeOverrideGenerator;
import org.jetbrains.kotlin.fir.backend.utils.ConversionTypeOrigin;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirReplSnippet;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousObjectExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.lazy.Fir2IrLazyClass;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirReplSnippetSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.ir.IrLock;
import org.jetbrains.kotlin.ir.IrProvider;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.symbols.IrBindableSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrClassSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrEnumEntrySymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrFieldSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrTypeAliasSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrTypeParameterSymbolImpl;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00de\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010&\u001a\u00020'2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020'0)H\u0007J\u0015\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020/H\u0000\u00a2\u0006\u0002\b0J'\u00101\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u000206H\u0000\u00a2\u0006\u0002\b7J\"\u00108\u001a\u00020\u00162\u0006\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u0002042\b\b\u0002\u00105\u001a\u000206H\u0002J!\u00109\u001a\u0004\u0018\u00010\u00162\u0006\u00102\u001a\u00020\u00152\b\b\u0002\u00105\u001a\u000206H\u0000\u00a2\u0006\u0002\b:J\u0016\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u00105\u001a\u000206J\u0010\u0010?\u001a\u00020<2\u0006\u0010@\u001a\u00020\u0015H\u0002J\"\u0010A\u001a\u00020\u00102\u0006\u0010B\u001a\u00020\u000b2\u0006\u0010C\u001a\u00020D2\n\b\u0002\u0010E\u001a\u0004\u0018\u00010FJ\b\u0010G\u001a\u00020\fH\u0002J\u001d\u0010H\u001a\u00020'2\u0006\u0010B\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020\u0010H\u0001\u00a2\u0006\u0002\bJJ\u000e\u0010K\u001a\u00020\u00102\u0006\u0010L\u001a\u00020%J\u0010\u0010M\u001a\u00020N2\u0006\u0010L\u001a\u00020%H\u0007J\u0010\u0010O\u001a\u00020N2\u0006\u0010L\u001a\u00020%H\u0002J\u0012\u0010K\u001a\u0004\u0018\u00010\u00102\u0006\u0010P\u001a\u00020\u000fH\u0002J\u0010\u0010Q\u001a\u0004\u0018\u00010\u00102\u0006\u0010R\u001a\u00020%J\u0012\u0010S\u001a\u0004\u0018\u00010\u00102\u0006\u0010R\u001a\u00020%H\u0002J\u0012\u0010T\u001a\u00020\f2\n\u0010U\u001a\u0006\u0012\u0002\b\u00030VJ\u0010\u0010T\u001a\u0004\u0018\u00010\f2\u0006\u0010P\u001a\u00020\u000fJ\u001c\u0010W\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010I\u001a\u00020\u00102\u0006\u0010R\u001a\u00020%J\u000e\u0010X\u001a\u00020\u00102\u0006\u0010Y\u001a\u00020\u000fJ\u0010\u0010Z\u001a\u00020\u00102\u0006\u0010R\u001a\u00020%H\u0002J\u0006\u0010[\u001a\u00020'J.\u0010\\\u001a\u00020\u00102\u0006\u0010]\u001a\u00020^2\b\b\u0002\u0010_\u001a\u00020`2\b\b\u0002\u0010a\u001a\u00020b2\n\b\u0002\u0010c\u001a\u0004\u0018\u00010DJ \u0010d\u001a\u00020\u00102\u0006\u0010]\u001a\u00020^2\u0006\u0010a\u001a\u00020b2\b\u0010c\u001a\u0004\u0018\u00010\u0010J\u0016\u0010e\u001a\u00020'2\u0006\u0010f\u001a\u00020\u00192\u0006\u0010g\u001a\u00020\u0010J\u000e\u0010h\u001a\u00020\u001a2\u0006\u0010f\u001a\u00020\u0019J\"\u0010i\u001a\u00020j2\u0006\u0010f\u001a\u00020\u00192\u0006\u0010c\u001a\u00020\u00102\n\b\u0002\u0010E\u001a\u0004\u0018\u00010FJ\u0016\u0010k\u001a\u00020l2\u0006\u0010m\u001a\u00020\u00122\u0006\u0010C\u001a\u00020DJ\u0017\u0010n\u001a\u0004\u0018\u00010l2\u0006\u0010o\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\bpJ\u000e\u0010q\u001a\u00020\u00132\u0006\u0010r\u001a\u00020sJ\u0010\u0010t\u001a\u0004\u0018\u00010\u00102\u0006\u0010u\u001a\u00020\u001cJ\u0016\u0010v\u001a\u00020\u00102\u0006\u0010u\u001a\u00020\u001c2\u0006\u0010w\u001a\u00020xJ\u0010\u0010y\u001a\u0004\u0018\u00010\u00102\u0006\u0010z\u001a\u00020\u001eJ\u0016\u0010{\u001a\u00020\u00102\u0006\u0010z\u001a\u00020\u001e2\u0006\u0010|\u001a\u00020}R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u00100\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00100\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001f\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u00100\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010~\u001a\u00020\u007fX\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0080\u0001\u0010\u0081\u0001R\u0016\u0010\u0082\u0001\u001a\u00030\u0083\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0084\u0001\u0010\u0085\u0001R\u0016\u0010\u0086\u0001\u001a\u00030\u0087\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0088\u0001\u0010\u0089\u0001R\u0016\u0010\u008a\u0001\u001a\u00030\u008b\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u008c\u0001\u0010\u008d\u0001R\u0016\u0010\u008e\u0001\u001a\u00030\u008f\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0090\u0001\u0010\u0091\u0001R\u0016\u0010\u0092\u0001\u001a\u00030\u0093\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0094\u0001\u0010\u0095\u0001R\u0015\u0010\u0096\u0001\u001a\u00020\u0000X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u0097\u0001\u0010\u0098\u0001R\u0016\u0010\u0099\u0001\u001a\u00030\u009a\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u009b\u0001\u0010\u009c\u0001R\u0016\u0010\u009d\u0001\u001a\u00030\u009e\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u009f\u0001\u0010\u00a0\u0001R\u0016\u0010\u00a1\u0001\u001a\u00030\u00a2\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00a3\u0001\u0010\u00a4\u0001R\u0016\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00a7\u0001\u0010\u00a8\u0001R\u0016\u0010\u00a9\u0001\u001a\u00030\u00aa\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00ab\u0001\u0010\u00ac\u0001R\u0016\u0010\u00ad\u0001\u001a\u00030\u00ae\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00af\u0001\u0010\u00b0\u0001R\u001f\u0010\u00b1\u0001\u001a\f\u0012\u0005\u0012\u00030\u00b3\u0001\u0018\u00010\u00b2\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00b4\u0001\u0010\u00b5\u0001R\u0016\u0010\u00b6\u0001\u001a\u00030\u00b7\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00b8\u0001\u0010\u00b9\u0001R\u0016\u0010\u00ba\u0001\u001a\u00030\u00bb\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00bc\u0001\u0010\u00bd\u0001R\u0016\u0010\u00be\u0001\u001a\u00030\u00bf\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00c0\u0001\u0010\u00c1\u0001R\u001c\u0010\u00c2\u0001\u001a\t\u0012\u0005\u0012\u00030\u00c3\u00010 X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00c4\u0001\u0010\u00c5\u0001R\u0016\u0010\u00c6\u0001\u001a\u00030\u00c7\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00c8\u0001\u0010\u00c9\u0001R\u0016\u0010\u00ca\u0001\u001a\u00030\u00cb\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00cc\u0001\u0010\u00cd\u0001R\u0016\u0010\u00ce\u0001\u001a\u00030\u00cf\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00d0\u0001\u0010\u00d1\u0001R\u0016\u0010\u00d2\u0001\u001a\u00030\u00d3\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00d4\u0001\u0010\u00d5\u0001R\u0016\u0010\u00d6\u0001\u001a\u00030\u00d7\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00d8\u0001\u0010\u00d9\u0001R\u0018\u0010\u00da\u0001\u001a\u0005\u0018\u00010\u00db\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00dc\u0001\u0010\u00dd\u0001R\u0016\u0010\u00de\u0001\u001a\u00030\u00df\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00e0\u0001\u0010\u00e1\u0001R\u0016\u0010\u00e2\u0001\u001a\u00030\u00e3\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00e4\u0001\u0010\u00e5\u0001R\u0016\u0010\u00e6\u0001\u001a\u00030\u00e7\u0001X\u0096\u0005\u00a2\u0006\b\u001a\u0006\b\u00e8\u0001\u0010\u00e9\u0001\u00a8\u0006\u00ea\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "c", "commonMemberStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrCommonMemberStorage;", "conversionScope", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "<init>", "(Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;Lorg/jetbrains/kotlin/fir/backend/Fir2IrCommonMemberStorage;Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;)V", "classCache", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "notFoundClassCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeLookupTag;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "typeAliasCache", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeAliasSymbol;", "typeParameterCache", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "typeParameterCacheForSetter", "enumEntryCache", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "Lorg/jetbrains/kotlin/ir/symbols/IrEnumEntrySymbol;", "codeFragmentCache", "Lorg/jetbrains/kotlin/fir/declarations/FirCodeFragment;", "earlierSnippetsCache", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirReplSnippetSymbol;", "fieldsForContextReceivers", "", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "localStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrLocalClassStorage;", "localClassesCreatedOnTheFly", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "forEachCachedDeclarationSymbol", "", "block", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "processMembersOfClassesOnTheFlyImmediately", "", "preCacheTypeParameters", "owner", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRefsOwner;", "preCacheTypeParameters$fir2ir", "getIrTypeParameter", "typeParameter", "index", "", "typeOrigin", "Lorg/jetbrains/kotlin/fir/backend/utils/ConversionTypeOrigin;", "getIrTypeParameter$fir2ir", "createAndCacheIrTypeParameter", "getCachedIrTypeParameter", "getCachedIrTypeParameter$fir2ir", "getIrTypeParameterSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "firTypeParameterSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "createIrTypeParameterForNonCachedDeclaration", "firTypeParameter", "createAndCacheIrClass", "regularClass", "parent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "predefinedOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "createClassSymbol", "cacheIrClass", "irClass", "cacheIrClass$fir2ir", "getIrClass", "firClass", "getFir2IrLazyClass", "Lorg/jetbrains/kotlin/fir/lazy/Fir2IrLazyClass;", "createFir2IrLazyClass", "lookupTag", "getCachedIrLocalClass", "klass", "getCachedIrClass", "getIrClassSymbol", "firClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "getFieldsWithContextReceiversForClass", "getIrClassForNotFoundClass", "classLikeLookupTag", "createAndCacheLocalIrClassOnTheFly", "processMembersOfClassesCreatedOnTheFly", "createAndCacheAnonymousObject", "anonymousObject", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "visibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "name", "Lorg/jetbrains/kotlin/name/Name;", "irParent", "getIrAnonymousObjectForEnumEntry", "putEnumEntryClassInScope", "enumEntry", "correspondingClass", "getIrEnumEntrySymbol", "createAndCacheIrEnumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "createAndCacheIrTypeAlias", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;", "typeAlias", "getCachedTypeAlias", "firTypeAlias", "getCachedTypeAlias$fir2ir", "getIrTypeAliasSymbol", "firTypeAliasSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeAliasSymbol;", "getCachedIrCodeFragment", "codeFragment", "createAndCacheCodeFragmentClass", "containingFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "getCachedEarlierSnippetClass", "snippetSymbol", "createAndCacheEarlierSnippetClass", "containingPackageFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "adapterGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/AdapterGenerator;", "getAdapterGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/AdapterGenerator;", "annotationGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "getAnnotationGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/AnnotationGenerator;", "annotationsFromPluginRegistrar", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrIrGeneratedDeclarationsRegistrar;", "getAnnotationsFromPluginRegistrar", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrIrGeneratedDeclarationsRegistrar;", "builtins", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltinSymbolsContainer;", "getBuiltins", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrBuiltinSymbolsContainer;", "callGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "getCallGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/CallAndReferenceGenerator;", "callablesGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrCallableDeclarationsGenerator;", "getCallablesGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrCallableDeclarationsGenerator;", "classifierStorage", "getClassifierStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage;", "classifiersGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrClassifiersGenerator;", "getClassifiersGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrClassifiersGenerator;", "configuration", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "getConfiguration", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrConfiguration;", "converter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "getConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrConverter;", "dataClassMembersGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrDataClassMembersGenerator;", "getDataClassMembersGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrDataClassMembersGenerator;", "declarationStorage", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "getDeclarationStorage", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrDeclarationStorage;", "extensions", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "getExtensions", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "filesBeingCompiled", "", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getFilesBeingCompiled", "()Ljava/util/Set;", "firProvider", "Lorg/jetbrains/kotlin/fir/backend/FirProviderWithGeneratedFiles;", "getFirProvider", "()Lorg/jetbrains/kotlin/fir/backend/FirProviderWithGeneratedFiles;", "implicitCastInserter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrImplicitCastInserter;", "getImplicitCastInserter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrImplicitCastInserter;", "irMangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "getIrMangler", "()Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "irProviders", "Lorg/jetbrains/kotlin/ir/IrProvider;", "getIrProviders", "()Ljava/util/List;", "lazyDeclarationsGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyDeclarationsGenerator;", "getLazyDeclarationsGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyDeclarationsGenerator;", "lazyFakeOverrideGenerator", "Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyFakeOverrideGenerator;", "getLazyFakeOverrideGenerator", "()Lorg/jetbrains/kotlin/fir/backend/generators/Fir2IrLazyFakeOverrideGenerator;", "lock", "Lorg/jetbrains/kotlin/ir/IrLock;", "getLock", "()Lorg/jetbrains/kotlin/ir/IrLock;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "specialAnnotationsProvider", "Lorg/jetbrains/kotlin/backend/common/IrSpecialAnnotationsProvider;", "getSpecialAnnotationsProvider", "()Lorg/jetbrains/kotlin/backend/common/IrSpecialAnnotationsProvider;", "symbolsMappingForLazyClasses", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrSymbolsMappingForLazyClasses;", "getSymbolsMappingForLazyClasses", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrSymbolsMappingForLazyClasses;", "typeConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "getTypeConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrTypeConverter;", "visibilityConverter", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "getVisibilityConverter", "()Lorg/jetbrains/kotlin/fir/backend/Fir2IrVisibilityConverter;", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFir2IrClassifierStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrClassifierStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 5 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 7 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 8 Fir2IrConversionScope.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope\n*L\n1#1,468:1\n1869#2,2:469\n1869#2,2:471\n1869#2,2:473\n1869#2:475\n1869#2,2:476\n1870#2:478\n1563#2:487\n1634#2,3:488\n1#3:479\n1#3:497\n23#4:480\n23#4:481\n23#4:482\n233#5:483\n382#6,3:484\n385#6,4:491\n72#7,2:495\n74#8,7:498\n*S KotlinDebug\n*F\n+ 1 Fir2IrClassifierStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrClassifierStorage\n*L\n74#1:469,2\n75#1:471,2\n76#1:473,2\n77#1:475\n78#1:476,2\n77#1:478\n270#1:487\n270#1:488,3\n290#1:497\n190#1:480\n208#1:481\n247#1:482\n247#1:483\n269#1:484,3\n269#1:491,4\n290#1:495,2\n315#1:498,7\n*E\n"})
public final class Fir2IrClassifierStorage
implements Fir2IrComponents {
    @NotNull
    private final Fir2IrComponents c;
    @NotNull
    private final Fir2IrConversionScope conversionScope;
    @NotNull
    private final Map<FirRegularClass, IrClassSymbol> classCache;
    @NotNull
    private final ConcurrentHashMap<ConeClassLikeLookupTag, IrClass> notFoundClassCache;
    @NotNull
    private final Map<FirTypeAlias, IrTypeAliasSymbol> typeAliasCache;
    @NotNull
    private final Map<FirTypeParameter, IrTypeParameter> typeParameterCache;
    @NotNull
    private final Map<FirTypeParameter, IrTypeParameter> typeParameterCacheForSetter;
    @NotNull
    private final Map<FirEnumEntry, IrEnumEntrySymbol> enumEntryCache;
    @NotNull
    private final Map<FirCodeFragment, IrClass> codeFragmentCache;
    @NotNull
    private final Map<FirReplSnippetSymbol, IrClass> earlierSnippetsCache;
    @NotNull
    private final Map<IrClass, List<IrField>> fieldsForContextReceivers;
    @NotNull
    private final Fir2IrLocalClassStorage localStorage;
    @NotNull
    private final Map<FirClass, IrClass> localClassesCreatedOnTheFly;
    private boolean processMembersOfClassesOnTheFlyImmediately;

    public Fir2IrClassifierStorage(@NotNull Fir2IrComponents c2, @NotNull Fir2IrCommonMemberStorage commonMemberStorage, @NotNull Fir2IrConversionScope conversionScope) {
        Intrinsics.checkNotNullParameter((Object)c2, (String)"c");
        Intrinsics.checkNotNullParameter((Object)commonMemberStorage, (String)"commonMemberStorage");
        Intrinsics.checkNotNullParameter((Object)conversionScope, (String)"conversionScope");
        this.c = c2;
        this.conversionScope = conversionScope;
        this.classCache = commonMemberStorage.getClassCache();
        this.notFoundClassCache = commonMemberStorage.getNotFoundClassCache();
        this.typeAliasCache = new LinkedHashMap();
        this.typeParameterCache = commonMemberStorage.getTypeParameterCache();
        this.typeParameterCacheForSetter = new LinkedHashMap();
        this.enumEntryCache = commonMemberStorage.getEnumEntryCache();
        this.codeFragmentCache = new LinkedHashMap();
        this.earlierSnippetsCache = new LinkedHashMap();
        this.fieldsForContextReceivers = new LinkedHashMap();
        this.localStorage = new Fir2IrLocalClassStorage(commonMemberStorage.getLocalClassCache());
        this.localClassesCreatedOnTheFly = new LinkedHashMap();
    }

    @DelicateDeclarationStorageApi
    public final void forEachCachedDeclarationSymbol(@NotNull Function1<? super IrSymbol, Unit> block) {
        IrBindableSymbol<ClassDescriptor, IrClass> it;
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Iterable $this$forEach$iv = this.classCache.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrClassSymbol)element$iv;
            boolean bl2 = false;
            block.invoke((Object)it);
        }
        $this$forEach$iv = this.typeAliasCache.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrTypeAliasSymbol)element$iv;
            boolean bl3 = false;
            block.invoke((Object)it);
        }
        $this$forEach$iv = this.enumEntryCache.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (IrEnumEntrySymbol)element$iv;
            boolean bl4 = false;
            block.invoke((Object)it);
        }
        $this$forEach$iv = this.fieldsForContextReceivers.values();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List fields = (List)element$iv;
            boolean bl5 = false;
            Iterable $this$forEach$iv2 = fields;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                IrField it2 = (IrField)element$iv2;
                boolean bl6 = false;
                block.invoke((Object)it2.getSymbol());
            }
        }
    }

    public final void preCacheTypeParameters$fir2ir(@NotNull FirTypeParameterRefsOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Iterator iterator2 = ((Iterable)owner.getTypeParameters()).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int index2 = n2++;
            FirTypeParameterRef typeParameter = (FirTypeParameterRef)iterator2.next();
            FirTypeParameter original = (FirTypeParameter)typeParameter.getSymbol().getFir();
            IrTypeParameter irTypeParameter = Fir2IrClassifierStorage.getCachedIrTypeParameter$fir2ir$default(this, original, null, 2, null);
            if (irTypeParameter == null) {
                irTypeParameter = Fir2IrClassifierStorage.createAndCacheIrTypeParameter$default(this, original, index2, null, 4, null);
            }
            if (!(owner instanceof FirProperty) || !((FirProperty)owner).isVar()) continue;
            ConversionTypeOrigin context2 = ConversionTypeOrigin.SETTER;
            IrTypeParameter irTypeParameter2 = this.getCachedIrTypeParameter$fir2ir(original, context2);
            if (irTypeParameter2 != null) continue;
            irTypeParameter2 = this.createAndCacheIrTypeParameter(original, index2, context2);
        }
    }

    @NotNull
    public final IrTypeParameter getIrTypeParameter$fir2ir(@NotNull FirTypeParameter typeParameter, int index2, @NotNull ConversionTypeOrigin typeOrigin) {
        Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
        Intrinsics.checkNotNullParameter((Object)((Object)typeOrigin), (String)"typeOrigin");
        IrTypeParameter irTypeParameter = this.getCachedIrTypeParameter$fir2ir(typeParameter, typeOrigin);
        if (irTypeParameter != null) {
            IrTypeParameter it = irTypeParameter;
            boolean bl2 = false;
            return it;
        }
        IrTypeParameter irTypeParameter2 = this.createAndCacheIrTypeParameter(typeParameter, index2, typeOrigin);
        this.getClassifiersGenerator().initializeTypeParameterBounds(typeParameter, irTypeParameter2);
        return irTypeParameter2;
    }

    public static /* synthetic */ IrTypeParameter getIrTypeParameter$fir2ir$default(Fir2IrClassifierStorage fir2IrClassifierStorage, FirTypeParameter firTypeParameter, int n2, ConversionTypeOrigin conversionTypeOrigin, int n3, Object object) {
        if ((n3 & 4) != 0) {
            conversionTypeOrigin = ConversionTypeOrigin.DEFAULT;
        }
        return fir2IrClassifierStorage.getIrTypeParameter$fir2ir(firTypeParameter, n2, conversionTypeOrigin);
    }

    private final IrTypeParameter createAndCacheIrTypeParameter(FirTypeParameter typeParameter, int index2, ConversionTypeOrigin typeOrigin) {
        IrTypeParameterSymbolImpl symbol = new IrTypeParameterSymbolImpl(null, null, 3, null);
        IrTypeParameter irTypeParameter = this.getClassifiersGenerator().createIrTypeParameterWithoutBounds(typeParameter, index2, symbol);
        if (typeOrigin.getForSetter()) {
            this.typeParameterCacheForSetter.put(typeParameter, irTypeParameter);
        } else {
            this.typeParameterCache.put(typeParameter, irTypeParameter);
        }
        return irTypeParameter;
    }

    static /* synthetic */ IrTypeParameter createAndCacheIrTypeParameter$default(Fir2IrClassifierStorage fir2IrClassifierStorage, FirTypeParameter firTypeParameter, int n2, ConversionTypeOrigin conversionTypeOrigin, int n3, Object object) {
        if ((n3 & 4) != 0) {
            conversionTypeOrigin = ConversionTypeOrigin.DEFAULT;
        }
        return fir2IrClassifierStorage.createAndCacheIrTypeParameter(firTypeParameter, n2, conversionTypeOrigin);
    }

    @Nullable
    public final IrTypeParameter getCachedIrTypeParameter$fir2ir(@NotNull FirTypeParameter typeParameter, @NotNull ConversionTypeOrigin typeOrigin) {
        Intrinsics.checkNotNullParameter((Object)typeParameter, (String)"typeParameter");
        Intrinsics.checkNotNullParameter((Object)((Object)typeOrigin), (String)"typeOrigin");
        return typeOrigin.getForSetter() ? this.typeParameterCacheForSetter.get(typeParameter) : this.typeParameterCache.get(typeParameter);
    }

    public static /* synthetic */ IrTypeParameter getCachedIrTypeParameter$fir2ir$default(Fir2IrClassifierStorage fir2IrClassifierStorage, FirTypeParameter firTypeParameter, ConversionTypeOrigin conversionTypeOrigin, int n2, Object object) {
        if ((n2 & 2) != 0) {
            conversionTypeOrigin = ConversionTypeOrigin.DEFAULT;
        }
        return fir2IrClassifierStorage.getCachedIrTypeParameter$fir2ir(firTypeParameter, conversionTypeOrigin);
    }

    @NotNull
    public final IrTypeParameterSymbol getIrTypeParameterSymbol(@NotNull FirTypeParameterSymbol firTypeParameterSymbol, @NotNull ConversionTypeOrigin typeOrigin) {
        Object cachedSymbol;
        Intrinsics.checkNotNullParameter((Object)firTypeParameterSymbol, (String)"firTypeParameterSymbol");
        Intrinsics.checkNotNullParameter((Object)((Object)typeOrigin), (String)"typeOrigin");
        FirTypeParameter firTypeParameter = (FirTypeParameter)firTypeParameterSymbol.getFir();
        Object object = this.getCachedIrTypeParameter$fir2ir(firTypeParameter, typeOrigin);
        if (object == null || (object = ((IrTypeParameter)object).getSymbol()) == null) {
            IrTypeParameter irTypeParameter = this.typeParameterCache.get(firTypeParameter);
            object = irTypeParameter != null ? irTypeParameter.getSymbol() : null;
        }
        if ((cachedSymbol = object) != null) {
            return cachedSymbol;
        }
        if (this.c.getConfiguration().getAllowNonCachedDeclarations()) {
            return this.createIrTypeParameterForNonCachedDeclaration(firTypeParameter);
        }
        throw new IllegalStateException(("Cannot find cached type parameter by FIR symbol: " + firTypeParameterSymbol.getName() + " of the owner: " + firTypeParameter.getContainingDeclarationSymbol()).toString());
    }

    private final IrTypeParameterSymbol createIrTypeParameterForNonCachedDeclaration(FirTypeParameter firTypeParameter) {
        IrTypeParameter irTypeParameter;
        int n2;
        FirBasedSymbol<?> firTypeParameterOwnerSymbol = firTypeParameter.getContainingDeclarationSymbol();
        Object obj = firTypeParameterOwnerSymbol.getFir();
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner");
        FirTypeParameterRefsOwner firTypeParameterOwner = (FirTypeParameterRefsOwner)obj;
        int it = n2 = firTypeParameterOwner.getTypeParameters().indexOf(firTypeParameter);
        boolean bl2 = false;
        if (!(it >= 0)) {
            throw new IllegalStateException("Check failed.");
        }
        int index2 = n2;
        boolean isSetter = firTypeParameterOwner instanceof FirPropertyAccessor && ((FirPropertyAccessor)firTypeParameterOwner).isSetter();
        ConversionTypeOrigin conversionTypeOrigin = isSetter ? ConversionTypeOrigin.SETTER : ConversionTypeOrigin.DEFAULT;
        IrTypeParameter it2 = irTypeParameter = this.createAndCacheIrTypeParameter(firTypeParameter, index2, conversionTypeOrigin);
        boolean bl3 = false;
        this.getClassifiersGenerator().initializeTypeParameterBounds(firTypeParameter, it2);
        return irTypeParameter.getSymbol();
    }

    @NotNull
    public final IrClass createAndCacheIrClass(@NotNull FirRegularClass regularClass, @NotNull IrDeclarationParent parent2, @Nullable IrDeclarationOrigin predefinedOrigin) {
        IrClass irClass;
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        IrClassSymbol symbol = this.createClassSymbol();
        IrClass it = irClass = this.getClassifiersGenerator().createIrClass(regularClass, parent2, symbol, predefinedOrigin);
        boolean bl2 = false;
        this.cacheIrClass$fir2ir(regularClass, it);
        return irClass;
    }

    public static /* synthetic */ IrClass createAndCacheIrClass$default(Fir2IrClassifierStorage fir2IrClassifierStorage, FirRegularClass firRegularClass, IrDeclarationParent irDeclarationParent, IrDeclarationOrigin irDeclarationOrigin, int n2, Object object) {
        if ((n2 & 4) != 0) {
            irDeclarationOrigin = null;
        }
        return fir2IrClassifierStorage.createAndCacheIrClass(firRegularClass, irDeclarationParent, irDeclarationOrigin);
    }

    private final IrClassSymbol createClassSymbol() {
        return new IrClassSymbolImpl(null, null, 3, null);
    }

    @LeakedDeclarationCaches
    public final void cacheIrClass$fir2ir(@NotNull FirRegularClass regularClass, @NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)regularClass, (String)"regularClass");
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        FirMemberDeclaration $this$visibility$iv = regularClass;
        boolean $i$f$getVisibility = false;
        if (Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) {
            this.localStorage.set(regularClass, irClass);
        } else {
            this.classCache.put(regularClass, irClass.getSymbol());
        }
    }

    @NotNull
    public final IrClass getIrClass(@NotNull FirClass firClass) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)firClass, (String)"firClass");
                IrClass irClass = this.getCachedIrClass(firClass);
                if (irClass != null) {
                    IrClass it = irClass;
                    boolean bl2 = false;
                    return it;
                }
                if (firClass instanceof FirAnonymousObject) break block4;
                if (!(firClass instanceof FirRegularClass)) break block5;
                FirMemberDeclaration $this$visibility$iv = firClass;
                boolean $i$f$getVisibility = false;
                if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) break block5;
            }
            return this.createAndCacheLocalIrClassOnTheFly(firClass);
        }
        return this.createFir2IrLazyClass(firClass);
    }

    @DelicateDeclarationStorageApi
    @NotNull
    public final Fir2IrLazyClass getFir2IrLazyClass(@NotNull FirClass firClass) {
        Fir2IrLazyClass fir2IrLazyClass;
        Intrinsics.checkNotNullParameter((Object)firClass, (String)"firClass");
        IrClass irClass = this.getCachedIrClass(firClass);
        if (irClass != null) {
            IrClass it = irClass;
            boolean bl2 = false;
            fir2IrLazyClass = (Fir2IrLazyClass)it;
        } else {
            fir2IrLazyClass = this.createFir2IrLazyClass(firClass);
        }
        return fir2IrLazyClass;
    }

    /*
     * Unable to fully structure code
     */
    private final Fir2IrLazyClass createFir2IrLazyClass(FirClass firClass) {
        block4: {
            if (!(firClass instanceof FirRegularClass)) {
                var3_2 = "Failed requirement.";
                throw new IllegalArgumentException(var3_2.toString());
            }
            symbol = this.createClassSymbol();
            classId = ((FirRegularClass)firClass).getSymbol().getClassId();
            v0 = ClassMembersKt.getContainingClassForLocalAttr((FirRegularClass)firClass);
            if (v0 != null) break block4;
            v1 = classId.getOuterClassId();
            if (v1 == null) ** GOTO lbl-1000
            it = v1;
            $i$a$-let-Fir2IrClassifierStorage$createFir2IrLazyClass$parentClassLookupTag$1 = false;
            v2 = FirSymbolProviderKt.getSymbolProvider(this.getSession()).getClassLikeSymbolByClassId(it);
            v1 = v2;
            if (v2 != null) {
                v0 = v1.toLookupTag();
            } else lbl-1000:
            // 2 sources

            {
                v0 = null;
            }
        }
        parentClassLookupTag = v0;
        v3 = this.getDeclarationStorage().findIrParent$fir2ir(classId.getPackageFqName(), parentClassLookupTag, ((FirRegularClass)firClass).getSymbol(), ((FirRegularClass)firClass).getOrigin());
        Intrinsics.checkNotNull((Object)v3);
        irParent = v3;
        this.classCache.put((FirRegularClass)firClass, symbol);
        if (!Fir2IrCallableDeclarationsGeneratorKt.isExternalParent(irParent)) {
            $i$a$-check-Fir2IrClassifierStorage$createFir2IrLazyClass$1 = false;
            var6_10 = "Source classes should be created separately before referencing";
            throw new IllegalStateException(var6_10.toString());
        }
        return this.getLazyDeclarationsGenerator().createIrLazyClass((FirRegularClass)firClass, irParent, symbol);
    }

    private final IrClass getIrClass(ConeClassLikeLookupTag lookupTag) {
        FirClassSymbol<?> firClassSymbol = ToSymbolUtilsKt.toClassSymbol(lookupTag, this.getSession());
        if (firClassSymbol == null) {
            return null;
        }
        FirClassSymbol<?> firClassSymbol2 = firClassSymbol;
        return this.getIrClass((FirClass)firClassSymbol2.getFir());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final IrClass getCachedIrLocalClass(@NotNull FirClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (!(klass instanceof FirAnonymousObject)) {
            if (!(klass instanceof FirRegularClass)) return null;
            FirMemberDeclaration $this$visibility$iv = klass;
            boolean $i$f$getVisibility = false;
            if (!Intrinsics.areEqual((Object)$this$visibility$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE)) return null;
        }
        boolean bl2 = true;
        boolean condition$iv = bl2;
        boolean $i$f$runIf = false;
        if (!condition$iv) return null;
        boolean bl3 = false;
        IrClass irClass = this.localStorage.get(klass);
        return irClass;
    }

    private final IrClass getCachedIrClass(FirClass klass) {
        IrClass irClass = this.getCachedIrLocalClass(klass);
        if (irClass == null) {
            IrClassSymbol irClassSymbol = this.classCache.get(klass);
            irClass = irClassSymbol != null ? (IrClass)irClassSymbol.getOwner() : null;
        }
        return irClass;
    }

    @NotNull
    public final IrClassSymbol getIrClassSymbol(@NotNull FirClassSymbol<?> firClassSymbol) {
        Intrinsics.checkNotNullParameter(firClassSymbol, (String)"firClassSymbol");
        return this.getIrClass((FirClass)firClassSymbol.getFir()).getSymbol();
    }

    @Nullable
    public final IrClassSymbol getIrClassSymbol(@NotNull ConeClassLikeLookupTag lookupTag) {
        Intrinsics.checkNotNullParameter((Object)lookupTag, (String)"lookupTag");
        IrClass irClass = this.getIrClass(lookupTag);
        return irClass != null ? irClass.getSymbol() : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<IrField> getFieldsWithContextReceiversForClass(@NotNull IrClass irClass, @NotNull FirClass klass) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (!(klass instanceof FirRegularClass) || ((FirRegularClass)klass).getContextParameters().isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Map<IrClass, List<IrField>> map = this.fieldsForContextReceivers;
        IrClass key$iv = irClass;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            void $this$mapTo$iv$iv;
            boolean bl2 = false;
            Iterable $this$map$iv = CollectionsKt.withIndex((Iterable)((FirRegularClass)klass).getContextParameters());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                IrField irField;
                IndexedValue indexedValue = (IndexedValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                int index2 = indexedValue.component1();
                FirValueParameter contextReceiver = (FirValueParameter)indexedValue.component2();
                IrDeclarationOrigin irDeclarationOrigin = IrDeclarationOrigin.Companion.getFIELD_FOR_CLASS_CONTEXT_RECEIVER();
                Name name2 = Name.identifier("contextReceiverField" + index2);
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
                DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PRIVATE;
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PRIVATE");
                IrField it = irField = IrFactoryImpl.INSTANCE.createField(-1, -1, irDeclarationOrigin, name2, descriptorVisibility, new IrFieldSymbolImpl(null, null, 3, null), Fir2IrTypeConverterKt.toIrType$default((Fir2IrComponents)this, contextReceiver.getReturnTypeRef(), null, 2, null), true, false, false);
                boolean bl4 = false;
                it.setParent(irClass);
                collection.add(irField);
            }
            List answer$iv = (List)destination$iv$iv;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrClass getIrClassForNotFoundClass(@NotNull ConeClassLikeLookupTag classLikeLookupTag) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)classLikeLookupTag, (String)"classLikeLookupTag");
        ConcurrentMap concurrentMap = this.notFoundClassCache;
        ConeClassLikeLookupTag key$iv = classLikeLookupTag;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl2 = false;
            IrClass default$iv = this.getClassifiersGenerator().createIrClassForNotFoundClass(classLikeLookupTag);
            boolean bl3 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (IrClass)object;
    }

    private final IrClass createAndCacheLocalIrClassOnTheFly(FirClass klass) {
        Fir2IrClassifiersGenerator.LocalIrClassInfo localIrClassInfo = this.getClassifiersGenerator().createLocalIrClassOnTheFly(klass, this.processMembersOfClassesOnTheFlyImmediately);
        IrClass irClass = localIrClassInfo.component1();
        FirClass firClassOrLocalParent = localIrClassInfo.component2();
        IrClass irClassOrLocalParent = localIrClassInfo.component3();
        if (!this.processMembersOfClassesOnTheFlyImmediately) {
            this.localClassesCreatedOnTheFly.put(firClassOrLocalParent, irClassOrLocalParent);
        }
        return irClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void processMembersOfClassesCreatedOnTheFly() {
        this.processMembersOfClassesOnTheFlyImmediately = true;
        for (Map.Entry<FirClass, IrClass> entry : this.localClassesCreatedOnTheFly.entrySet()) {
            void this_$iv;
            FirClass klass = entry.getKey();
            IrClass irClass = entry.getValue();
            Fir2IrConversionScope fir2IrConversionScope = this.conversionScope;
            FirClass containingFirClass$iv = klass;
            boolean $i$f$withContainingFirClass = false;
            ((Collection)this_$iv.getContainingFirClassStack()).add(containingFirClass$iv);
            try {
                boolean bl2 = false;
                this.getClassifiersGenerator().processClassHeader(klass, irClass);
                this.getConverter().processClassMembers$fir2ir(klass, irClass);
            }
            finally {
                this_$iv.getContainingFirClassStack().remove(this_$iv.getContainingFirClassStack().size() - 1);
            }
        }
        this.localClassesCreatedOnTheFly.clear();
    }

    @NotNull
    public final IrClass createAndCacheAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @NotNull Visibility visibility, @NotNull Name name2, @Nullable IrDeclarationParent irParent) {
        IrClass irClass;
        Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
        Intrinsics.checkNotNullParameter((Object)visibility, (String)"visibility");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        IrClass it = irClass = this.getClassifiersGenerator().createAnonymousObject(anonymousObject, visibility, name2, irParent);
        boolean bl2 = false;
        this.localStorage.set(anonymousObject, it);
        return irClass;
    }

    public static /* synthetic */ IrClass createAndCacheAnonymousObject$default(Fir2IrClassifierStorage fir2IrClassifierStorage, FirAnonymousObject firAnonymousObject, Visibility visibility, Name name2, IrDeclarationParent irDeclarationParent, int n2, Object object) {
        if ((n2 & 2) != 0) {
            visibility = Visibilities.Local.INSTANCE;
        }
        if ((n2 & 4) != 0) {
            name2 = SpecialNames.NO_NAME_PROVIDED;
        }
        if ((n2 & 8) != 0) {
            irDeclarationParent = null;
        }
        return fir2IrClassifierStorage.createAndCacheAnonymousObject(firAnonymousObject, visibility, name2, irDeclarationParent);
    }

    @NotNull
    public final IrClass getIrAnonymousObjectForEnumEntry(@NotNull FirAnonymousObject anonymousObject, @NotNull Name name2, @Nullable IrClass irParent) {
        Intrinsics.checkNotNullParameter((Object)anonymousObject, (String)"anonymousObject");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        IrClass irClass = this.localStorage.get(anonymousObject);
        if (irClass != null) {
            IrClass it = irClass;
            boolean bl2 = false;
            return it;
        }
        IrClass irAnonymousObject = this.createAndCacheAnonymousObject(anonymousObject, Visibilities.Private.INSTANCE, name2, irParent);
        this.getClassifiersGenerator().processClassHeader(anonymousObject, irAnonymousObject);
        return irAnonymousObject;
    }

    public final void putEnumEntryClassInScope(@NotNull FirEnumEntry enumEntry, @NotNull IrClass correspondingClass) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        Intrinsics.checkNotNullParameter((Object)correspondingClass, (String)"correspondingClass");
        FirExpression firExpression = enumEntry.getInitializer();
        Intrinsics.checkNotNull((Object)firExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirAnonymousObjectExpression");
        this.localStorage.set(((FirAnonymousObjectExpression)firExpression).getAnonymousObject(), correspondingClass);
    }

    @NotNull
    public final IrEnumEntrySymbol getIrEnumEntrySymbol(@NotNull FirEnumEntry enumEntry) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        IrEnumEntrySymbol irEnumEntrySymbol = this.enumEntryCache.get(enumEntry);
        if (irEnumEntrySymbol != null) {
            IrEnumEntrySymbol it = irEnumEntrySymbol;
            boolean bl2 = false;
            return it;
        }
        IrEnumEntrySymbolImpl symbol = new IrEnumEntrySymbolImpl(null, null, 3, null);
        this.enumEntryCache.put(enumEntry, symbol);
        IrDeclarationParent irDeclarationParent = this.getDeclarationStorage().findIrParent$fir2ir(enumEntry, null);
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        IrClass irParent = (IrClass)irDeclarationParent;
        if (Fir2IrCallableDeclarationsGeneratorKt.isExternalParent(irParent)) {
            FirLazyDeclarationResolverKt.lazyResolveToPhase(enumEntry, FirResolvePhase.ANNOTATION_ARGUMENTS);
            this.getClassifiersGenerator().createIrEnumEntry(enumEntry, irParent, symbol, irParent.getOrigin());
        }
        return symbol;
    }

    @NotNull
    public final IrEnumEntry createAndCacheIrEnumEntry(@NotNull FirEnumEntry enumEntry, @NotNull IrClass irParent, @Nullable IrDeclarationOrigin predefinedOrigin) {
        Intrinsics.checkNotNullParameter((Object)enumEntry, (String)"enumEntry");
        Intrinsics.checkNotNullParameter((Object)irParent, (String)"irParent");
        IrEnumEntrySymbol symbol = this.getIrEnumEntrySymbol(enumEntry);
        FirFile containingFile2 = this.getFirProvider().getFirCallableContainerFile(enumEntry.getSymbol());
        IrDeclarationOrigin irDeclarationOrigin = predefinedOrigin;
        if (irDeclarationOrigin == null) {
            irDeclarationOrigin = containingFile2 != null ? (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getDEFINED() : irParent.getOrigin();
        }
        IrDeclarationOrigin predefinedOrigin2 = irDeclarationOrigin;
        return this.getClassifiersGenerator().createIrEnumEntry(enumEntry, irParent, symbol, predefinedOrigin2);
    }

    public static /* synthetic */ IrEnumEntry createAndCacheIrEnumEntry$default(Fir2IrClassifierStorage fir2IrClassifierStorage, FirEnumEntry firEnumEntry, IrClass irClass, IrDeclarationOrigin irDeclarationOrigin, int n2, Object object) {
        if ((n2 & 4) != 0) {
            irDeclarationOrigin = null;
        }
        return fir2IrClassifierStorage.createAndCacheIrEnumEntry(firEnumEntry, irClass, irDeclarationOrigin);
    }

    @NotNull
    public final IrTypeAlias createAndCacheIrTypeAlias(@NotNull FirTypeAlias typeAlias, @NotNull IrDeclarationParent parent2) {
        IrTypeAlias irTypeAlias;
        Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        IrTypeAliasSymbolImpl symbol = new IrTypeAliasSymbolImpl(null, null, 3, null);
        IrTypeAlias it = irTypeAlias = this.getClassifiersGenerator().createIrTypeAlias(typeAlias, parent2, symbol);
        boolean bl2 = false;
        this.typeAliasCache.put(typeAlias, symbol);
        return irTypeAlias;
    }

    @Nullable
    public final IrTypeAlias getCachedTypeAlias$fir2ir(@NotNull FirTypeAlias firTypeAlias) {
        Intrinsics.checkNotNullParameter((Object)firTypeAlias, (String)"firTypeAlias");
        IrTypeAliasSymbol irTypeAliasSymbol = this.typeAliasCache.get(firTypeAlias);
        return irTypeAliasSymbol != null ? (IrTypeAlias)irTypeAliasSymbol.getOwner() : null;
    }

    @NotNull
    public final IrTypeAliasSymbol getIrTypeAliasSymbol(@NotNull FirTypeAliasSymbol firTypeAliasSymbol) {
        FirClassLikeSymbol<?> firClassLikeSymbol;
        ClassId parentId;
        Intrinsics.checkNotNullParameter((Object)firTypeAliasSymbol, (String)"firTypeAliasSymbol");
        FirTypeAlias firTypeAlias = (FirTypeAlias)firTypeAliasSymbol.getFir();
        IrTypeAlias irTypeAlias = this.getCachedTypeAlias$fir2ir(firTypeAlias);
        if (irTypeAlias != null) {
            IrTypeAlias it = irTypeAlias;
            boolean bl2 = false;
            return it.getSymbol();
        }
        ClassId typeAliasId = firTypeAliasSymbol.getClassId();
        ClassId classId = parentId = typeAliasId.getOuterClassId();
        if (classId != null) {
            ClassId it = classId;
            boolean bl3 = false;
            firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(this.getSession()).getClassLikeSymbolByClassId(it);
        } else {
            firClassLikeSymbol = null;
        }
        FirClassLikeSymbol<?> parentClass = firClassLikeSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol2 = parentClass;
        IrDeclarationParent irDeclarationParent = this.getDeclarationStorage().findIrParent$fir2ir(typeAliasId.getPackageFqName(), firClassLikeSymbol2 != null ? firClassLikeSymbol2.toLookupTag() : null, firTypeAliasSymbol, firTypeAlias.getOrigin());
        Intrinsics.checkNotNull((Object)irDeclarationParent);
        IrDeclarationParent irParent = irDeclarationParent;
        IrTypeAliasSymbolImpl symbol = new IrTypeAliasSymbolImpl(null, null, 3, null);
        this.typeAliasCache.put(firTypeAlias, symbol);
        this.getLazyDeclarationsGenerator().createIrLazyTypeAlias(firTypeAlias, irParent, symbol);
        return symbol;
    }

    @Nullable
    public final IrClass getCachedIrCodeFragment(@NotNull FirCodeFragment codeFragment) {
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        return this.codeFragmentCache.get(codeFragment);
    }

    @NotNull
    public final IrClass createAndCacheCodeFragmentClass(@NotNull FirCodeFragment codeFragment, @NotNull IrFile containingFile2) {
        IrClass irClass;
        Intrinsics.checkNotNullParameter((Object)codeFragment, (String)"codeFragment");
        Intrinsics.checkNotNullParameter((Object)containingFile2, (String)"containingFile");
        IrClassSymbol symbol = this.createClassSymbol();
        IrClass it = irClass = this.getClassifiersGenerator().createCodeFragmentClass(codeFragment, containingFile2, symbol);
        boolean bl2 = false;
        this.codeFragmentCache.put(codeFragment, it);
        return irClass;
    }

    @Nullable
    public final IrClass getCachedEarlierSnippetClass(@NotNull FirReplSnippetSymbol snippetSymbol) {
        Intrinsics.checkNotNullParameter((Object)snippetSymbol, (String)"snippetSymbol");
        return this.earlierSnippetsCache.get(snippetSymbol);
    }

    @NotNull
    public final IrClass createAndCacheEarlierSnippetClass(@NotNull FirReplSnippetSymbol snippetSymbol, @NotNull IrPackageFragment containingPackageFragment) {
        IrClass irClass;
        block0: {
            Intrinsics.checkNotNullParameter((Object)snippetSymbol, (String)"snippetSymbol");
            Intrinsics.checkNotNullParameter((Object)containingPackageFragment, (String)"containingPackageFragment");
            IrClassSymbol symbol = this.createClassSymbol();
            IrClass it = irClass = this.getClassifiersGenerator().createEarlierSnippetClass((FirReplSnippet)snippetSymbol.getFir(), containingPackageFragment, symbol);
            boolean bl2 = false;
            this.earlierSnippetsCache.put(snippetSymbol, it);
            Fir2IrLazyClass fir2IrLazyClass = it instanceof Fir2IrLazyClass ? (Fir2IrLazyClass)it : null;
            if (fir2IrLazyClass == null) break block0;
            Fir2IrLazyClass lazyClass = fir2IrLazyClass;
            boolean bl3 = false;
            this.classCache.put(lazyClass.getFir(), symbol);
        }
        return irClass;
    }

    @Override
    @NotNull
    public FirSession getSession() {
        return this.c.getSession();
    }

    @Override
    @NotNull
    public ScopeSession getScopeSession() {
        return this.c.getScopeSession();
    }

    @Override
    @NotNull
    public FirProviderWithGeneratedFiles getFirProvider() {
        return this.c.getFirProvider();
    }

    @Override
    @NotNull
    public Fir2IrConverter getConverter() {
        return this.c.getConverter();
    }

    @Override
    @NotNull
    public Fir2IrBuiltinSymbolsContainer getBuiltins() {
        return this.c.getBuiltins();
    }

    @Override
    @Nullable
    public IrSpecialAnnotationsProvider getSpecialAnnotationsProvider() {
        return this.c.getSpecialAnnotationsProvider();
    }

    @Override
    @NotNull
    public KotlinMangler.IrMangler getIrMangler() {
        return this.c.getIrMangler();
    }

    @Override
    @NotNull
    public List<IrProvider> getIrProviders() {
        return this.c.getIrProviders();
    }

    @Override
    @NotNull
    public IrLock getLock() {
        return this.c.getLock();
    }

    @Override
    @NotNull
    public Fir2IrClassifierStorage getClassifierStorage() {
        return this.c.getClassifierStorage();
    }

    @Override
    @NotNull
    public Fir2IrDeclarationStorage getDeclarationStorage() {
        return this.c.getDeclarationStorage();
    }

    @Override
    @NotNull
    public Fir2IrTypeConverter getTypeConverter() {
        return this.c.getTypeConverter();
    }

    @Override
    @NotNull
    public Fir2IrVisibilityConverter getVisibilityConverter() {
        return this.c.getVisibilityConverter();
    }

    @Override
    @NotNull
    public Fir2IrCallableDeclarationsGenerator getCallablesGenerator() {
        return this.c.getCallablesGenerator();
    }

    @Override
    @NotNull
    public Fir2IrClassifiersGenerator getClassifiersGenerator() {
        return this.c.getClassifiersGenerator();
    }

    @Override
    @NotNull
    public Fir2IrLazyDeclarationsGenerator getLazyDeclarationsGenerator() {
        return this.c.getLazyDeclarationsGenerator();
    }

    @Override
    @NotNull
    public Fir2IrDataClassMembersGenerator getDataClassMembersGenerator() {
        return this.c.getDataClassMembersGenerator();
    }

    @Override
    @NotNull
    public AnnotationGenerator getAnnotationGenerator() {
        return this.c.getAnnotationGenerator();
    }

    @Override
    @NotNull
    public CallAndReferenceGenerator getCallGenerator() {
        return this.c.getCallGenerator();
    }

    @Override
    @NotNull
    public Fir2IrLazyFakeOverrideGenerator getLazyFakeOverrideGenerator() {
        return this.c.getLazyFakeOverrideGenerator();
    }

    @Override
    @NotNull
    public Fir2IrSymbolsMappingForLazyClasses getSymbolsMappingForLazyClasses() {
        return this.c.getSymbolsMappingForLazyClasses();
    }

    @Override
    @NotNull
    public Fir2IrExtensions getExtensions() {
        return this.c.getExtensions();
    }

    @Override
    @NotNull
    public Fir2IrConfiguration getConfiguration() {
        return this.c.getConfiguration();
    }

    @Override
    @NotNull
    public Fir2IrIrGeneratedDeclarationsRegistrar getAnnotationsFromPluginRegistrar() {
        return this.c.getAnnotationsFromPluginRegistrar();
    }

    @Override
    @NotNull
    public AdapterGenerator getAdapterGenerator() {
        return this.c.getAdapterGenerator();
    }

    @Override
    @NotNull
    public Fir2IrImplicitCastInserter getImplicitCastInserter() {
        return this.c.getImplicitCastInserter();
    }

    @Override
    @Nullable
    public Set<FirFile> getFilesBeingCompiled() {
        return this.c.getFilesBeingCompiled();
    }
}

