/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.psi;

import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInDecompilerKt;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInFileType;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.KotlinMetadataStubBuilder;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartSource;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u001a\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/psi/KotlinBuiltInMetadataStubBuilder;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder;", "readFile", "Lkotlin/Function2;", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata;", "<init>", "(Lkotlin/jvm/functions/Function2;)V", "createCallableSource", "Lorg/jetbrains/kotlin/descriptors/SourceElement;", "file", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/KotlinMetadataStubBuilder$FileWithMetadata$Compatible;", "filename", "", "decompiler-to-psi"})
final class KotlinBuiltInMetadataStubBuilder
extends KotlinMetadataStubBuilder {
    public KotlinBuiltInMetadataStubBuilder(@NotNull Function2<? super VirtualFile, ? super byte[], ? extends KotlinMetadataStubBuilder.FileWithMetadata> readFile) {
        Intrinsics.checkNotNullParameter(readFile, (String)"readFile");
        super(KotlinBuiltInDecompilerKt.access$getStubVersionForStubBuilderAndDecompiler(), KotlinBuiltInFileType.INSTANCE, (Function0<? extends SerializerExtensionProtocol>)((Function0)KotlinBuiltInMetadataStubBuilder::_init_$lambda$0), readFile);
    }

    @Override
    @Nullable
    protected SourceElement createCallableSource(@NotNull KotlinMetadataStubBuilder.FileWithMetadata.Compatible file, @NotNull String filename) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        String withoutExtension = StringsKt.removeSuffix((String)filename, (CharSequence)".kotlin_builtins");
        String fileNameForFacade = Intrinsics.areEqual((Object)withoutExtension, (Object)"kotlin") ? "library" : withoutExtension;
        FqName facadeFqName = PackagePartClassUtils.getPackagePartFqName(file.getPackageFqName(), fileNameForFacade);
        JvmClassName jvmClassName = JvmClassName.byClassId(ClassId.Companion.topLevel(facadeFqName));
        Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byClassId(...)");
        ProtoBuf.Package package_ = file.getProto().getPackage();
        Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"getPackage(...)");
        return new JvmPackagePartSource(jvmClassName, null, null, package_, file.getNameResolver(), null, null, null, null, 480, null);
    }

    private static final SerializerExtensionProtocol _init_$lambda$0() {
        return BuiltInSerializerProtocol.INSTANCE;
    }
}

