/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.SlowOperationCanceledException;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.EDT;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SlowOperations {
    private static final Logger LOG = Logger.getInstance(SlowOperations.class);
    private static final String ERROR_EDT = "Slow operations are prohibited on EDT. See SlowOperations.assertSlowOperationsAreAllowed javadoc.";
    private static final String ERROR_RA = "Non-cancelable slow operations are prohibited inside read action. See SlowOperations.assertNonCancelableSlowOperationsAreAllowed javadoc.";
    public static final String ACTION_UPDATE = "action.update";
    public static final String ACTION_PERFORM = "action.perform";
    public static final String KNOWN_ISSUE = "known-issues";
    public static final String GENERIC = "generic";
    public static final String FORCE_ASSERT = "  force assert  ";
    public static final String FORCE_THROW = "  force throw  ";
    public static final String RESET = "  reset  ";
    public static final String IDEA_PLUGIN_SANDBOX_MODE = "idea.plugin.in.sandbox.mode";
    private static int ourAlwaysAllow = -1;
    @NotNull
    private static @NotNull FList<@NotNull String> ourStack = FList.emptyList();
    private static String ourTargetClass;
    private static final Set<String> ourReportedClasses;

    private SlowOperations() {
    }

    public static void assertSlowOperationsAreAllowed() {
        String error;
        String string = error = !EDT.isCurrentThreadEdt() || SlowOperations.isAlwaysAllowed() || SlowOperations.isSlowOperationAllowed() ? null : ERROR_EDT;
        if (error == null || SlowOperations.isAlreadyReported()) {
            return;
        }
        if (SlowOperations.isInSection(FORCE_THROW) && !Cancellation.isInNonCancelableSection()) {
            throw new SlowOperationCanceledException();
        }
        LOG.error(error);
    }

    public static void assertNonCancelableSlowOperationsAreAllowed() {
        String error;
        String string = SlowOperations.isAlwaysAllowed() ? null : (EDT.isCurrentThreadEdt() ? (SlowOperations.isSlowOperationAllowed() ? null : ERROR_EDT) : (error = ApplicationManager.getApplication().isReadAccessAllowed() ? ERROR_RA : null));
        if (error == null || SlowOperations.isAlreadyReported()) {
            return;
        }
        LOG.error(error);
    }

    private static boolean isSlowOperationAllowed() {
        boolean forceAssert = SlowOperations.isInSection(FORCE_ASSERT);
        if (!forceAssert && !Registry.is("ide.slow.operations.assertion", true)) {
            return true;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isWriteAccessAllowed() && !Registry.is("ide.slow.operations.assertion.write.action")) {
            return true;
        }
        if (ourStack.isEmpty() && !Registry.is("ide.slow.operations.assertion.other", false)) {
            return true;
        }
        for (String activity : ourStack) {
            if (RESET.equals(activity)) break;
            if (Registry.is("ide.slow.operations.assertion." + activity, true)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAlreadyReported() {
        if (ourTargetClass != null && !ourReportedClasses.add(ourTargetClass)) {
            return true;
        }
        Throwable throwable = new Throwable();
        return ThrowableInterner.intern(throwable) != throwable;
    }

    @ApiStatus.Internal
    public static boolean isInSection(@NotNull String sectionName) {
        if (sectionName == null) {
            SlowOperations.$$$reportNull$$$0(0);
        }
        EDT.assertIsEdt();
        for (String activity : ourStack) {
            if (RESET.equals(activity)) break;
            if (!sectionName.equals(activity)) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public static boolean isAlwaysAllowed() {
        if (ourAlwaysAllow == 1) {
            return true;
        }
        if (ourAlwaysAllow == 0) {
            return false;
        }
        if (!LoadingState.APP_STARTED.isOccurred()) {
            return true;
        }
        Application application = ApplicationManager.getApplication();
        boolean result2 = System.getenv("TEAMCITY_VERSION") != null || application.isUnitTestMode() || application.isCommandLine() || !application.isEAP() && !application.isInternal() && !SystemProperties.getBooleanProperty(IDEA_PLUGIN_SANDBOX_MODE, false);
        ourAlwaysAllow = result2 ? 1 : 0;
        return result2;
    }

    @Deprecated
    public static <T, E extends Throwable> T allowSlowOperations(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            SlowOperations.$$$reportNull$$$0(1);
        }
        try (AccessToken ignore = SlowOperations.startSection(GENERIC);){
            T t2 = computable.compute();
            return t2;
        }
    }

    @Deprecated
    public static <E extends Throwable> void allowSlowOperations(@NotNull ThrowableRunnable<E> runnable) throws E {
        if (runnable == null) {
            SlowOperations.$$$reportNull$$$0(2);
        }
        try (AccessToken ignore = SlowOperations.startSection(GENERIC);){
            runnable.run();
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static AccessToken knownIssue(@NotNull @NonNls String ytIssueId) {
        if (ytIssueId == null) {
            SlowOperations.$$$reportNull$$$0(3);
        }
        return SlowOperations.startSection(KNOWN_ISSUE);
    }

    @ApiStatus.Internal
    @NotNull
    public static AccessToken reportOnceIfViolatedFor(@NotNull Object target) {
        if (target == null) {
            SlowOperations.$$$reportNull$$$0(4);
        }
        if (!EDT.isCurrentThreadEdt()) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            if (accessToken == null) {
                SlowOperations.$$$reportNull$$$0(5);
            }
            return accessToken;
        }
        final String prev = ourTargetClass;
        ourTargetClass = target.getClass().getName();
        return new AccessToken(){

            @Override
            public void finish() {
                ourTargetClass = prev;
            }
        };
    }

    @Deprecated
    @NotNull
    public static AccessToken allowSlowOperations(@NotNull @NonNls String activityName) {
        if (activityName == null) {
            SlowOperations.$$$reportNull$$$0(6);
        }
        return SlowOperations.startSection(activityName);
    }

    @ApiStatus.Internal
    @NotNull
    public static AccessToken startSection(@NotNull @NonNls String sectionName) {
        if (sectionName == null) {
            SlowOperations.$$$reportNull$$$0(7);
        }
        if (!EDT.isCurrentThreadEdt()) {
            AccessToken accessToken = AccessToken.EMPTY_ACCESS_TOKEN;
            if (accessToken == null) {
                SlowOperations.$$$reportNull$$$0(8);
            }
            return accessToken;
        }
        final FList<String> prev = ourStack;
        ourStack = prev.prepend(sectionName);
        return new AccessToken(){

            @Override
            public void finish() {
                ourStack = prev;
            }
        };
    }

    @ApiStatus.Internal
    public static boolean isMyMessage(@Nullable String error) {
        return Strings.areSameInstance(ERROR_EDT, error) || Strings.areSameInstance(ERROR_RA, error);
    }

    static {
        ourReportedClasses = new HashSet<String>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sectionName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ytIssueId";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/SlowOperations";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activityName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/SlowOperations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "reportOnceIfViolatedFor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "startSection";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInSection";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "allowSlowOperations";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "knownIssue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reportOnceIfViolatedFor";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "startSection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

