/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.SpineRef;
import com.intellij.psi.impl.source.StubbedSpine;
import com.intellij.psi.impl.source.SubstrateRef;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInconsistencyReporter;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FileTrees {
    private static final Logger LOG = Logger.getInstance(FileTrees.class);
    private static final int firstNonFilePsiIndex = 1;
    private final PsiFileImpl myFile;
    private final Reference<StubTree> myStub;
    private final Supplier<? extends FileElement> myTreeElementPointer;
    private final Reference<StubBasedPsiElementBase<?>> @Nullable [] myRefToPsi;

    private FileTrees(@NotNull PsiFileImpl file, @Nullable Reference<StubTree> stub2, @Nullable Supplier<? extends FileElement> ast, Reference<StubBasedPsiElementBase<?>> @Nullable [] refToPsi) {
        if (file == null) {
            FileTrees.$$$reportNull$$$0(0);
        }
        this.myFile = file;
        this.myStub = stub2;
        this.myTreeElementPointer = ast;
        this.myRefToPsi = refToPsi;
    }

    @Nullable
    StubTree derefStub() {
        return SoftReference.dereference(this.myStub);
    }

    @Nullable
    FileElement derefTreeElement() {
        return SoftReference.deref(this.myTreeElementPointer);
    }

    FileTrees switchToStrongRefs() {
        if (this.myRefToPsi == null) {
            return this;
        }
        this.forEachCachedPsi(psi -> {
            ASTNode node = psi.getNode();
            LOG.assertTrue(node.getPsi() == psi);
            psi.setSubstrateRef(SubstrateRef.createAstStrongRef(node));
        });
        return new FileTrees(this.myFile, this.myStub, this.myTreeElementPointer, null);
    }

    private void forEachCachedPsi(Consumer<? super StubBasedPsiElementBase<?>> consumer2) {
        assert (this.myRefToPsi != null);
        for (Reference<StubBasedPsiElementBase<?>> t2 : this.myRefToPsi) {
            StubBasedPsiElementBase<?> psi;
            StubBasedPsiElementBase<?> stubBasedPsiElementBase = psi = t2 == null ? null : t2.get();
            if (psi == null) continue;
            consumer2.accept(psi);
        }
    }

    private boolean hasCachedPsi() {
        Reference<StubBasedPsiElementBase<?>>[] refToPsi = this.myRefToPsi;
        if (refToPsi != null) {
            for (Reference<StubBasedPsiElementBase<?>> t2 : refToPsi) {
                if (t2 == null || t2.get() == null) continue;
                return true;
            }
        }
        return false;
    }

    boolean useSpineRefs() {
        return this.myRefToPsi != null;
    }

    FileTrees switchToSpineRefs(@NotNull List<PsiElement> spine) {
        Reference<StubBasedPsiElementBase<?>>[] refToPsi;
        if (spine == null) {
            FileTrees.$$$reportNull$$$0(1);
        }
        if ((refToPsi = this.myRefToPsi) == null) {
            refToPsi = new Reference[spine.size()];
        }
        try {
            for (int i2 = 1; i2 < refToPsi.length; ++i2) {
                StubBasedPsiElementBase psi = (StubBasedPsiElementBase)Objects.requireNonNull(spine.get(i2));
                psi.setSubstrateRef(new SpineRef(this.myFile, i2));
                StubBasedPsiElementBase<?> existing = SoftReference.dereference(refToPsi[i2]);
                if (existing != null) {
                    assert (existing == psi) : "Duplicate PSI found";
                    continue;
                }
                refToPsi[i2] = new WeakReference<StubBasedPsiElementBase>(psi);
            }
            return new FileTrees(this.myFile, this.myStub, this.myTreeElementPointer, refToPsi);
        }
        catch (Throwable e2) {
            throw new RuntimeException("Exceptions aren't allowed here", e2);
        }
    }

    FileTrees clearStub(@NotNull String reason) {
        StubTree stubHolder;
        if (reason == null) {
            FileTrees.$$$reportNull$$$0(2);
        }
        if ((stubHolder = this.derefStub()) != null) {
            ((PsiFileStubImpl)stubHolder.getRoot()).clearPsi(reason);
        }
        if (this.myRefToPsi != null) {
            DebugUtil.performPsiModification("clearStub", () -> this.forEachCachedPsi(psi -> {
                DebugUtil.onInvalidated(psi);
                psi.setSubstrateRef(SubstrateRef.createInvalidRef(psi));
            }));
        }
        return new FileTrees(this.myFile, null, this.myTreeElementPointer, null);
    }

    FileTrees withAst(@NotNull Supplier<? extends FileElement> ast) throws StubTreeLoader.StubTreeAndIndexUnmatchCoarseException {
        if (ast == null) {
            FileTrees.$$$reportNull$$$0(3);
        }
        return new FileTrees(this.myFile, this.myStub, ast, this.myRefToPsi).reconcilePsi(this.derefStub(), ast.get(), true);
    }

    FileTrees withStub(@NotNull StubTree stub2, @Nullable FileElement ast) throws StubTreeLoader.StubTreeAndIndexUnmatchCoarseException {
        if (stub2 == null) {
            FileTrees.$$$reportNull$$$0(4);
        }
        assert (this.derefTreeElement() == ast);
        return new FileTrees(this.myFile, new java.lang.ref.SoftReference<StubTree>(stub2), this.myTreeElementPointer, this.myRefToPsi).reconcilePsi(stub2, ast, false);
    }

    static FileTrees noStub(@Nullable FileElement ast, @NotNull PsiFileImpl file) {
        if (file == null) {
            FileTrees.$$$reportNull$$$0(5);
        }
        return new FileTrees(file, null, ast == null ? null : () -> ast, null);
    }

    private FileTrees reconcilePsi(@Nullable StubTree stubTree, @Nullable FileElement astRoot, boolean takePsiFromStubs) throws StubTreeLoader.StubTreeAndIndexUnmatchCoarseException {
        List<CompositeElement> nodeList;
        assert (stubTree != null || astRoot != null);
        if (!(stubTree != null && astRoot != null || this.hasCachedPsi())) {
            return new FileTrees(this.myFile, this.myStub, this.myTreeElementPointer, null);
        }
        List stubList = stubTree == null ? null : stubTree.getPlainList();
        List<CompositeElement> list = nodeList = astRoot == null ? null : astRoot.getStubbedSpine().getSpineNodes();
        List<PsiElement> srcSpine = stubList == null || nodeList == null ? null : FileTrees.getAllSpinePsi(takePsiFromStubs ? stubTree.getSpine() : astRoot.getStubbedSpine());
        try {
            return DebugUtil.performPsiModification("reconcilePsi", () -> {
                if (this.myRefToPsi != null) {
                    assert (this.myRefToPsi.length == (stubList != null ? stubList.size() : nodeList.size())) : "Cached PSI count doesn't match actual one";
                    this.bindSubstratesToCachedPsi(stubList, nodeList);
                }
                if (stubList != null && nodeList != null) {
                    assert (stubList.size() == nodeList.size()) : "Stub count doesn't match stubbed node length";
                    FileTrees result2 = this.switchToSpineRefs(srcSpine);
                    FileTrees.bindStubsWithAst(srcSpine, stubList, nodeList, takePsiFromStubs);
                    return result2;
                }
                return this;
            });
        }
        catch (Throwable e2) {
            this.myFile.clearContent("stub-psi mismatch");
            this.myFile.rebuildStub();
            throw StubTreeLoader.getInstance().createCoarseExceptionStubTreeAndIndexDoNotMatch(stubTree, this.myFile, e2, StubInconsistencyReporter.StubTreeAndIndexDoNotMatchSource.FileTreesPsiReconciliation);
        }
    }

    static List<PsiElement> getAllSpinePsi(@NotNull StubbedSpine spine) {
        if (spine == null) {
            FileTrees.$$$reportNull$$$0(6);
        }
        return IntStream.range(0, spine.getStubCount()).mapToObj(spine::getStubPsi).collect(Collectors.toList());
    }

    private void bindSubstratesToCachedPsi(List<StubElement<?>> stubList, List<? extends CompositeElement> nodeList) {
        assert (this.myRefToPsi != null);
        for (int i2 = 1; i2 < this.myRefToPsi.length; ++i2) {
            StubBasedPsiElementBase<?> cachedPsi = SoftReference.dereference(this.myRefToPsi[i2]);
            if (cachedPsi == null) continue;
            if (stubList != null) {
                ((StubBase)stubList.get(i2)).setPsi(cachedPsi);
            }
            if (nodeList == null) continue;
            nodeList.get(i2).setPsi(cachedPsi);
        }
    }

    private static void bindStubsWithAst(@NotNull List<? extends PsiElement> srcSpine, List<? extends StubElement<?>> stubList, List<? extends CompositeElement> nodeList, boolean takePsiFromStubs) {
        if (srcSpine == null) {
            FileTrees.$$$reportNull$$$0(7);
        }
        for (int i2 = 1; i2 < stubList.size(); ++i2) {
            StubElement<?> stub2 = stubList.get(i2);
            CompositeElement node = nodeList.get(i2);
            assert (stub2.getStubType() == node.getElementType()) : "Stub type mismatch: " + stub2.getStubType() + "!=" + node.getElementType() + " in #" + node.getElementType().getLanguage();
            PsiElement psi = Objects.requireNonNull(srcSpine.get(i2));
            if (takePsiFromStubs) {
                node.setPsi(psi);
                continue;
            }
            ((StubBase)stub2).setPsi(psi);
        }
    }

    public String toString() {
        return "FileTrees{stub=" + (this.myStub == null ? "noRef" : this.derefStub()) + ", AST=" + (this.myTreeElementPointer == null ? "noRef" : this.derefTreeElement()) + ", useSpineRefs=" + this.useSpineRefs() + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ast";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcSpine";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/FileTrees";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "switchToSpineRefs";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "clearStub";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "withAst";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "withStub";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "noStub";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllSpinePsi";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "bindStubsWithAst";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

