/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.LinkedDeque;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class AbstractLinkedDeque<E>
extends AbstractCollection<E>
implements LinkedDeque<E> {
    @Nullable E first;
    @Nullable E last;

    AbstractLinkedDeque() {
    }

    void linkFirst(E e2) {
        E f2 = this.first;
        this.first = e2;
        if (f2 == null) {
            this.last = e2;
        } else {
            this.setPrevious(f2, e2);
            this.setNext(e2, f2);
        }
    }

    void linkLast(E e2) {
        E l2 = this.last;
        this.last = e2;
        if (l2 == null) {
            this.first = e2;
        } else {
            this.setNext(l2, e2);
            this.setPrevious(e2, l2);
        }
    }

    E unlinkFirst() {
        E f2 = this.first;
        E next = this.getNext(f2);
        this.setNext(f2, null);
        this.first = next;
        if (next == null) {
            this.last = null;
        } else {
            this.setPrevious(next, null);
        }
        return f2;
    }

    E unlinkLast() {
        E l2 = this.last;
        E prev = this.getPrevious(l2);
        this.setPrevious(l2, null);
        this.last = prev;
        if (prev == null) {
            this.first = null;
        } else {
            this.setNext(prev, null);
        }
        return l2;
    }

    void unlink(E e2) {
        E prev = this.getPrevious(e2);
        E next = this.getNext(e2);
        if (prev == null) {
            this.first = next;
        } else {
            this.setNext(prev, next);
            this.setPrevious(e2, null);
        }
        if (next == null) {
            this.last = prev;
        } else {
            this.setPrevious(next, prev);
            this.setNext(e2, null);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.first == null;
    }

    void checkNotEmpty() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public int size() {
        int size = 0;
        E e2 = this.first;
        while (e2 != null) {
            ++size;
            e2 = this.getNext(e2);
        }
        return size;
    }

    @Override
    public void clear() {
        E e2 = this.first;
        while (e2 != null) {
            E next = this.getNext(e2);
            this.setPrevious(e2, null);
            this.setNext(e2, null);
            e2 = next;
        }
        this.last = null;
        this.first = null;
    }

    @Override
    public abstract boolean contains(Object var1);

    @Override
    public boolean isFirst(E e2) {
        return e2 != null && e2 == this.first;
    }

    @Override
    public boolean isLast(E e2) {
        return e2 != null && e2 == this.last;
    }

    @Override
    public void moveToFront(E e2) {
        if (e2 != this.first) {
            this.unlink(e2);
            this.linkFirst(e2);
        }
    }

    @Override
    public void moveToBack(E e2) {
        if (e2 != this.last) {
            this.unlink(e2);
            this.linkLast(e2);
        }
    }

    @Override
    public @Nullable E peek() {
        return this.peekFirst();
    }

    @Override
    public @Nullable E peekFirst() {
        return this.first;
    }

    @Override
    public @Nullable E peekLast() {
        return this.last;
    }

    @Override
    public E getFirst() {
        this.checkNotEmpty();
        return this.peekFirst();
    }

    @Override
    public E getLast() {
        this.checkNotEmpty();
        return this.peekLast();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public boolean offer(E e2) {
        return this.offerLast(e2);
    }

    @Override
    public boolean offerFirst(E e2) {
        if (this.contains(e2)) {
            return false;
        }
        this.linkFirst(e2);
        return true;
    }

    @Override
    public boolean offerLast(E e2) {
        if (this.contains(e2)) {
            return false;
        }
        this.linkLast(e2);
        return true;
    }

    @Override
    public boolean add(E e2) {
        return this.offerLast(e2);
    }

    @Override
    public void addFirst(E e2) {
        if (!this.offerFirst(e2)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void addLast(E e2) {
        if (!this.offerLast(e2)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public @Nullable E poll() {
        return this.pollFirst();
    }

    @Override
    public @Nullable E pollFirst() {
        return this.isEmpty() ? null : (E)this.unlinkFirst();
    }

    @Override
    public @Nullable E pollLast() {
        return this.isEmpty() ? null : (E)this.unlinkLast();
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public E removeFirst() {
        this.checkNotEmpty();
        return this.pollFirst();
    }

    @Override
    public boolean removeFirstOccurrence(Object o2) {
        return this.remove(o2);
    }

    @Override
    public E removeLast() {
        this.checkNotEmpty();
        return this.pollLast();
    }

    @Override
    public boolean removeLastOccurrence(Object o2) {
        return this.remove(o2);
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        boolean modified = false;
        for (Object o2 : c2) {
            modified |= this.remove(o2);
        }
        return modified;
    }

    @Override
    public void push(E e2) {
        this.addFirst(e2);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public LinkedDeque.PeekingIterator<E> iterator() {
        return new AbstractLinkedIterator((Object)this.first){

            @Override
            @Nullable E computeNext() {
                return AbstractLinkedDeque.this.getNext(this.cursor);
            }
        };
    }

    @Override
    public LinkedDeque.PeekingIterator<E> descendingIterator() {
        return new AbstractLinkedIterator((Object)this.last){

            @Override
            @Nullable E computeNext() {
                return AbstractLinkedDeque.this.getPrevious(this.cursor);
            }
        };
    }

    abstract class AbstractLinkedIterator
    implements LinkedDeque.PeekingIterator<E> {
        @Nullable E previous;
        @Nullable E cursor;

        AbstractLinkedIterator(E start) {
            this.cursor = start;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != null;
        }

        @Override
        public @Nullable E peek() {
            return this.cursor;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.previous = this.cursor;
            this.cursor = this.computeNext();
            return this.previous;
        }

        abstract @Nullable E computeNext();

        @Override
        public void remove() {
            if (this.previous == null) {
                throw new IllegalStateException();
            }
            AbstractLinkedDeque.this.remove(this.previous);
            this.previous = null;
        }
    }
}

