/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations.comparators;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.comparators.FirCallableDeclarationComparator;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.types.FirTypeRefComparator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/comparators/FirMemberDeclarationComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lkotlin/Comparator;", "<init>", "()V", "compare", "", "a", "b", "TypeAndNameComparator", "tree"})
public final class FirMemberDeclarationComparator
implements Comparator<FirMemberDeclaration> {
    @NotNull
    public static final FirMemberDeclarationComparator INSTANCE = new FirMemberDeclarationComparator();

    private FirMemberDeclarationComparator() {
    }

    @Override
    public int compare(@NotNull FirMemberDeclaration a2, @NotNull FirMemberDeclaration b2) {
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
        if (a2 instanceof FirCallableDeclaration && b2 instanceof FirCallableDeclaration) {
            return FirCallableDeclarationComparator.INSTANCE.compare((FirCallableDeclaration)a2, (FirCallableDeclaration)b2);
        }
        int typeAndNameDiff = TypeAndNameComparator.INSTANCE.compare(a2, b2);
        if (typeAndNameDiff != 0) {
            return typeAndNameDiff;
        }
        FirMemberDeclaration firMemberDeclaration = a2;
        if (firMemberDeclaration instanceof FirClass) {
            if (!(b2 instanceof FirClass)) {
                boolean $i$a$-require-FirMemberDeclarationComparator$compare$32 = false;
                String $i$a$-require-FirMemberDeclarationComparator$compare$32 = "priority is inconsistent: " + UtilsKt.render(a2) + " v.s. " + UtilsKt.render(b2);
                throw new IllegalArgumentException($i$a$-require-FirMemberDeclarationComparator$compare$32.toString());
            }
            return FirDeclarationUtilKt.getClassId((FirClassLikeDeclaration)a2).getPackageFqName().asString().compareTo(FirDeclarationUtilKt.getClassId((FirClassLikeDeclaration)b2).getPackageFqName().asString());
        }
        if (firMemberDeclaration instanceof FirTypeAlias) {
            if (!(b2 instanceof FirTypeAlias)) {
                boolean bl2 = false;
                String string = "priority is inconsistent: " + UtilsKt.render(a2) + " v.s. " + UtilsKt.render(b2);
                throw new IllegalArgumentException(string.toString());
            }
            return FirTypeRefComparator.INSTANCE.compare(((FirTypeAlias)a2).getExpandedTypeRef(), ((FirTypeAlias)b2).getExpandedTypeRef());
        }
        throw new IllegalStateException(("Unsupported member declaration comparison: " + UtilsKt.render(a2) + " v.s. " + UtilsKt.render(b2)).toString());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/comparators/FirMemberDeclarationComparator$TypeAndNameComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lkotlin/Comparator;", "<init>", "()V", "priority", "", "getPriority", "(Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;)I", "compare", "a", "b", "tree"})
    public static final class TypeAndNameComparator
    implements Comparator<FirMemberDeclaration> {
        @NotNull
        public static final TypeAndNameComparator INSTANCE = new TypeAndNameComparator();

        private TypeAndNameComparator() {
        }

        private final int getPriority(FirMemberDeclaration $this$priority) {
            int n2;
            FirMemberDeclaration firMemberDeclaration = $this$priority;
            if (firMemberDeclaration instanceof FirEnumEntry) {
                n2 = 7;
            } else if (firMemberDeclaration instanceof FirConstructor) {
                n2 = 6;
            } else if (firMemberDeclaration instanceof FirProperty) {
                n2 = 5;
            } else if (firMemberDeclaration instanceof FirField) {
                n2 = 4;
            } else if (firMemberDeclaration instanceof FirFunction) {
                n2 = 3;
            } else if (firMemberDeclaration instanceof FirClass) {
                n2 = 2;
            } else if (firMemberDeclaration instanceof FirTypeAlias) {
                n2 = 1;
            } else if (firMemberDeclaration instanceof FirValueParameter) {
                n2 = 0;
            } else if (firMemberDeclaration instanceof FirBackingField) {
                n2 = 0;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return n2;
        }

        @Override
        public int compare(@NotNull FirMemberDeclaration a2, @NotNull FirMemberDeclaration b2) {
            Intrinsics.checkNotNullParameter((Object)a2, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
            int priorityDiff = this.getPriority(a2) - this.getPriority(b2);
            if (priorityDiff != 0) {
                return priorityDiff;
            }
            if (a2 instanceof FirEnumEntry) {
                if (!(b2 instanceof FirEnumEntry)) {
                    boolean bl2 = false;
                    String string = "priority is inconsistent: " + UtilsKt.render(a2) + " v.s. " + UtilsKt.render(b2);
                    throw new IllegalArgumentException(string.toString());
                }
                return 0;
            }
            return FirDeclarationUtilKt.getNameOrSpecialName(a2).compareTo(FirDeclarationUtilKt.getNameOrSpecialName(b2));
        }
    }
}

