/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.web.common.FirWebCommonErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.js.checkers.declaration.FirJsExternalChecker;
import org.jetbrains.kotlin.fir.analysis.web.common.checkers.declaration.FirWebCommonExternalChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyBackingField;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J-\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u00020\fR\u00020\u000ej\u0006\u0010\r\u001a\u00020\fj\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0012J-\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u00020\fR\u00020\u000ej\u0006\u0010\r\u001a\u00020\fj\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0016J)\u0010!\u001a\u00020\u000b*\u00020\u0011H\u0002R\u00020\fR\u00020\u000ej\u0006\u0010\r\u001a\u00020\fj\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0012R\u0018\u0010\u0018\u001a\u00020\u0005*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001d*\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExternalChecker;", "Lorg/jetbrains/kotlin/fir/analysis/web/common/checkers/declaration/FirWebCommonExternalChecker;", "<init>", "()V", "isNativeOrEffectivelyExternal", "", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "reportExternalEnum", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "additionalCheck", "isDefinedExternallyCallableId", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "hasExternalLikeAnnotations", "allowsReporting", "Lorg/jetbrains/kotlin/KtSourceElement;", "getAllowsReporting", "(Lorg/jetbrains/kotlin/KtSourceElement;)Z", "varargElementType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getVarargElementType", "(Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "checkEnumEntry", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsExternalChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsExternalChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExternalChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,131:1\n42#2:132\n*S KotlinDebug\n*F\n+ 1 FirJsExternalChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsExternalChecker\n*L\n42#1:132\n*E\n"})
public final class FirJsExternalChecker
extends FirWebCommonExternalChecker {
    @NotNull
    public static final FirJsExternalChecker INSTANCE = new FirJsExternalChecker();

    private FirJsExternalChecker() {
        super(true);
    }

    @Override
    public boolean isNativeOrEffectivelyExternal(@NotNull FirBasedSymbol<?> symbol, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return FirJsHelpersKt.isNativeObject(symbol, session);
    }

    @Override
    public void reportExternalEnum(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration2.getSource(), FirJsErrors.INSTANCE.getENUM_CLASS_IN_EXTERNAL_DECLARATION_WARNING(), null, 8, null);
    }

    @Override
    public void additionalCheck(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        if (declaration2 instanceof FirFunction) {
            FirMemberDeclaration $this$isInline$iv = (FirMemberDeclaration)declaration2;
            boolean $i$f$isInline = false;
            if ($this$isInline$iv.getStatus().isInline()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirFunction)declaration2).getSource(), FirWebCommonErrors.INSTANCE.getINLINE_EXTERNAL_DECLARATION(), null, 8, null);
            }
        }
        KtDiagnosticFactory0 valueClassInExternalDiagnostic = context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsAllowValueClassesInExternals) ? FirJsErrors.INSTANCE.getINLINE_CLASS_IN_EXTERNAL_DECLARATION_WARNING() : FirJsErrors.INSTANCE.getINLINE_CLASS_IN_EXTERNAL_DECLARATION();
        FirJsExternalChecker.additionalCheck$reportOnParametersAndReturnTypesIf(declaration2, context2, reporter, valueClassInExternalDiagnostic, (Function1<? super ConeKotlinType, Boolean>)((Function1)arg_0 -> FirJsExternalChecker.additionalCheck$lambda$1(context2, arg_0)));
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.JsEnableExtensionFunctionInExternals)) {
            FirJsExternalChecker.additionalCheck$reportOnParametersAndReturnTypesIf(declaration2, context2, reporter, FirJsErrors.INSTANCE.getEXTENSION_FUNCTION_IN_EXTERNAL_DECLARATION(), (Function1<? super ConeKotlinType, Boolean>)((Function1)additionalCheck.2.INSTANCE));
        }
        this.checkEnumEntry(context2, reporter, declaration2);
    }

    @Override
    public boolean isDefinedExternallyCallableId(@NotNull CallableId callableId) {
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        return Intrinsics.areEqual((Object)callableId, (Object)JsStandardClassIds.Callables.JsDefinedExternally);
    }

    @Override
    public boolean hasExternalLikeAnnotations(@NotNull FirDeclaration declaration2, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return FirAnnotationUtilsKt.hasAnnotation(declaration2, JsStandardClassIds.Annotations.JsNative, session);
    }

    private final boolean getAllowsReporting(KtSourceElement $this$allowsReporting) {
        return !($this$allowsReporting.getKind() instanceof KtFakeSourceElementKind) || Intrinsics.areEqual((Object)$this$allowsReporting.getKind(), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE);
    }

    private final ConeKotlinType getVarargElementType(FirValueParameter $this$varargElementType) {
        ConeKotlinType coneKotlinType;
        if (!$this$varargElementType.isVararg()) {
            coneKotlinType = null;
        } else {
            ConeTypeProjection coneTypeProjection = (ConeTypeProjection)ArraysKt.firstOrNull((Object[])FirTypeUtilsKt.getConeType($this$varargElementType.getReturnTypeRef()).getTypeArguments());
            coneKotlinType = coneTypeProjection != null ? ConeTypeProjectionKt.getType(coneTypeProjection) : null;
        }
        return coneKotlinType;
    }

    private final void checkEnumEntry(CheckerContext context2, DiagnosticReporter reporter, FirDeclaration $this$checkEnumEntry) {
        block1: {
            if (!($this$checkEnumEntry instanceof FirEnumEntry)) {
                return;
            }
            FirExpression firExpression = ((FirEnumEntry)$this$checkEnumEntry).getInitializer();
            if (firExpression == null) break block1;
            FirExpression it = firExpression;
            boolean bl2 = false;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)it.getSource(), FirJsErrors.INSTANCE.getEXTERNAL_ENUM_ENTRY_WITH_BODY(), null, 8, null);
        }
    }

    private static final void additionalCheck$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(Function1<? super ConeKotlinType, Boolean> $condition, CheckerContext $context, DiagnosticReporter $reporter, KtDiagnosticFactory0 $diagnosticFactory, ConeKotlinType type2, KtSourceElement elementToReport) {
        if (((Boolean)$condition.invoke((Object)type2)).booleanValue()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)$context, $reporter, (AbstractKtSourceElement)elementToReport, $diagnosticFactory, null, 8, null);
        }
    }

    private static final void additionalCheck$reportOnParametersAndReturnTypesIf(FirDeclaration $declaration, CheckerContext $context, DiagnosticReporter $reporter, KtDiagnosticFactory0 diagnosticFactory, Function1<? super ConeKotlinType, Boolean> condition) {
        if (!($declaration instanceof FirCallableDeclaration) || $declaration instanceof FirDefaultPropertyAccessor || $declaration instanceof FirDefaultPropertyBackingField) {
            return;
        }
        KtSourceElement ktSourceElement = ((FirCallableDeclaration)$declaration).getReturnTypeRef().getSource();
        boolean bl2 = ktSourceElement != null ? INSTANCE.getAllowsReporting(ktSourceElement) : false;
        if (bl2) {
            KtSourceElement ktSourceElement2 = ((FirCallableDeclaration)$declaration).getReturnTypeRef().getSource();
            if (ktSourceElement2 != null) {
                KtSourceElement it = ktSourceElement2;
                boolean bl3 = false;
                FirJsExternalChecker.additionalCheck$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(condition, $context, $reporter, diagnosticFactory, FirTypeUtilsKt.getConeType(((FirCallableDeclaration)$declaration).getReturnTypeRef()), it);
            }
        }
        if (!($declaration instanceof FirFunction)) {
            return;
        }
        for (FirValueParameter parameter2 : ((FirFunction)$declaration).getValueParameters()) {
            KtSourceElement ktParam;
            KtSourceElement ktSourceElement3 = ktParam = parameter2.getSource();
            boolean bl4 = ktSourceElement3 != null ? INSTANCE.getAllowsReporting(ktSourceElement3) : false;
            if (!bl4) continue;
            ConeKotlinType coneKotlinType = INSTANCE.getVarargElementType(parameter2);
            if (coneKotlinType == null) {
                coneKotlinType = FirTypeUtilsKt.getConeType(parameter2.getReturnTypeRef());
            }
            ConeKotlinType typeToCheck = coneKotlinType;
            FirJsExternalChecker.additionalCheck$reportOnParametersAndReturnTypesIf$checkTypeIsNotInlineClass(condition, $context, $reporter, diagnosticFactory, typeToCheck, ktParam);
        }
    }

    private static final boolean additionalCheck$lambda$1(CheckerContext $context, ConeKotlinType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return FirHelpersKt.isValueClass(it, $context.getSession());
    }
}

