/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirReceiverParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ'\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f*\u0006\u0012\u0002\b\u00030\u0010H\u0002R\u00020\bj\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirLateinitIntrinsicApplicabilityChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)V", "containingClassOrFile", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;)Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirLateinitIntrinsicApplicabilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirLateinitIntrinsicApplicabilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirLateinitIntrinsicApplicabilityChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n33#2:83\n28#2:87\n2746#3,3:84\n*S KotlinDebug\n*F\n+ 1 FirLateinitIntrinsicApplicabilityChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirLateinitIntrinsicApplicabilityChecker\n*L\n50#1:83\n67#1:87\n57#1:84,3\n*E\n"})
public final class FirLateinitIntrinsicApplicabilityChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirLateinitIntrinsicApplicabilityChecker INSTANCE = new FirLateinitIntrinsicApplicabilityChecker();

    private FirLateinitIntrinsicApplicabilityChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirQualifiedAccessExpression expression2) {
        boolean bl2;
        FirVariableSymbol calleeVariableSymbol;
        KtSourceElement source;
        block13: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            FirPropertySymbol firPropertySymbol = FirReferenceUtilsKt.toResolvedPropertySymbol$default(expression2.getCalleeReference(), false, 1, null);
            if (firPropertySymbol == null) {
                return;
            }
            FirPropertySymbol resolvedSymbol = firPropertySymbol;
            if (!Intrinsics.areEqual((Object)resolvedSymbol.getName().getIdentifierOrNullIfSpecial(), (Object)"isInitialized")) {
                return;
            }
            FirReceiverParameterSymbol firReceiverParameterSymbol = resolvedSymbol.getReceiverParameterSymbol();
            if (firReceiverParameterSymbol == null) {
                return;
            }
            FirReceiverParameterSymbol receiverParameter = firReceiverParameterSymbol;
            if (!FirAnnotationUtilsKt.hasAnnotation(receiverParameter, StandardClassIds.Annotations.INSTANCE.getAccessibleLateinitPropertyLiteral(), context2.getSession())) {
                return;
            }
            source = expression2.getCalleeReference().getSource();
            FirExpression extensionReceiver2 = expression2.getExtensionReceiver();
            if (!(extensionReceiver2 instanceof FirCallableReferenceAccess)) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getLATEINIT_INTRINSIC_CALL_ON_NON_LITERAL(), null, 8, null);
                return;
            }
            FirVariableSymbol firVariableSymbol = FirReferenceUtilsKt.toResolvedVariableSymbol$default(((FirCallableReferenceAccess)extensionReceiver2).getCalleeReference(), false, 1, null);
            if (firVariableSymbol == null) {
                return;
            }
            calleeVariableSymbol = firVariableSymbol;
            FirCallableSymbol $this$isLateInit$iv = calleeVariableSymbol;
            boolean $i$f$isLateInit = false;
            if (!$this$isLateInit$iv.getRawStatus().isLateInit()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getLATEINIT_INTRINSIC_CALL_ON_NON_LATEINIT(), null, 8, null);
                return;
            }
            FirBasedSymbol<?> containingSymbol = this.containingClassOrFile(context2, calleeVariableSymbol);
            Iterable $this$none$iv = context2.getContainingDeclarations();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    FirBasedSymbol it = (FirBasedSymbol)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it, containingSymbol)) continue;
                    bl2 = false;
                    break block13;
                }
                bl2 = true;
            }
        }
        if (bl2) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getLATEINIT_INTRINSIC_CALL_ON_NON_ACCESSIBLE_PROPERTY(), (Object)calleeVariableSymbol, null, 16, null);
            return;
        }
        FirBasedSymbol closestOwnFunction = (FirBasedSymbol)CollectionsKt.lastOrNull(context2.getContainingDeclarations());
        if (closestOwnFunction instanceof FirFunctionSymbol) {
            FirCallableSymbol $this$isInline$iv = (FirCallableSymbol)closestOwnFunction;
            boolean $i$f$isInline = false;
            if ($this$isInline$iv.getRawStatus().isInline()) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getLATEINIT_INTRINSIC_CALL_IN_INLINE_FUNCTION(), null, 8, null);
            }
        }
    }

    private final FirBasedSymbol<?> containingClassOrFile(CheckerContext context2, FirVariableSymbol<?> $this$containingClassOrFile) {
        FirBasedSymbol firBasedSymbol;
        FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)$this$containingClassOrFile);
        if (firClassLikeSymbol != null) {
            firBasedSymbol = firClassLikeSymbol;
        } else {
            FirFile firFile = FirProviderKt.getFirProvider(context2.getSession()).getFirCallableContainerFile((FirCallableSymbol)$this$containingClassOrFile);
            firBasedSymbol = firFile != null ? firFile.getSymbol() : null;
        }
        return firBasedSymbol;
    }
}

