/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ObjectUtilsRt;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.RefValueHashMapUtil;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Deprecated
@ApiStatus.ScheduledForRemoval
public class ConcurrentWeakKeySoftValueHashMap<K, V>
implements ConcurrentMap<K, V> {
    private final ConcurrentMap<KeyReference<K, V>, ValueReference<K, V>> myMap;
    final ReferenceQueue<K> myKeyQueue;
    final ReferenceQueue<V> myValueQueue;
    @NotNull
    final HashingStrategy<? super K> myHashingStrategy;
    private static final ThreadLocal<HardKey<?, ?>> HARD_KEY = ThreadLocal.withInitial(() -> new HardKey());

    protected ConcurrentWeakKeySoftValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this(initialCapacity, loadFactor, concurrencyLevel, HashingStrategy.canonical());
    }

    protected ConcurrentWeakKeySoftValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull HashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(0);
        }
        this.myKeyQueue = new ReferenceQueue();
        this.myValueQueue = new ReferenceQueue();
        this.myHashingStrategy = hashingStrategy;
        this.myMap = new ConcurrentHashMap<KeyReference<K, V>, ValueReference<K, V>>(initialCapacity, loadFactor, concurrencyLevel);
    }

    @NotNull
    KeyReference<K, V> createKeyReference(@NotNull K k2, @NotNull V v2) {
        if (k2 == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(1);
        }
        if (v2 == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(2);
        }
        ValueReference<K, V> valueReference = this.createValueReference(v2, this.myValueQueue);
        WeakKey keyReference = new WeakKey(k2, valueReference, this.myHashingStrategy, this.myKeyQueue);
        if (valueReference instanceof SoftValue) {
            ((SoftValue)valueReference).myKeyReference = keyReference;
        }
        ObjectUtilsRt.reachabilityFence(k2);
        WeakKey weakKey = keyReference;
        if (weakKey == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(3);
        }
        return weakKey;
    }

    @NotNull
    protected ValueReference<K, V> createValueReference(@NotNull V value2, @NotNull ReferenceQueue<? super V> queue) {
        if (value2 == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(4);
        }
        if (queue == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(5);
        }
        return new SoftValue(value2, queue);
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public void clear() {
        this.myMap.clear();
        this.processQueues();
    }

    @NotNull
    private HardKey<K, V> createHardKey(@NotNull Object o2) {
        if (o2 == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(6);
        }
        Object key = o2;
        HardKey<?, ?> hardKey = HARD_KEY.get();
        ((HardKey)hardKey).set(key, this.myHashingStrategy.hashCode(key));
        HardKey<?, ?> hardKey2 = hardKey;
        if (hardKey2 == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(7);
        }
        return hardKey2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(@NotNull Object key) {
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(8);
        }
        HardKey<K, V> hardKey = this.createHardKey(key);
        try {
            ValueReference valueReference = (ValueReference)this.myMap.get(hardKey);
            V v2 = valueReference == null ? null : (V)valueReference.get();
            return v2;
        }
        finally {
            ((HardKey)hardKey).clear();
        }
    }

    @Override
    public boolean containsKey(@NotNull Object key) {
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(9);
        }
        throw RefValueHashMapUtil.pointlessContainsKey();
    }

    @Override
    public boolean containsValue(@NotNull Object value2) {
        if (value2 == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(10);
        }
        throw RefValueHashMapUtil.pointlessContainsValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(@NotNull Object key) {
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(11);
        }
        HardKey<K, V> hardKey = this.createHardKey(key);
        try {
            ValueReference valueReference = (ValueReference)this.myMap.remove(hardKey);
            V v2 = valueReference == null ? null : (V)valueReference.get();
            return v2;
        }
        finally {
            ((HardKey)hardKey).clear();
            this.processQueues();
        }
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m4) {
        if (m4 == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(12);
        }
        for (Map.Entry<K, V> e2 : m4.entrySet()) {
            this.put(e2.getKey(), e2.getValue());
        }
    }

    @Override
    public V put(K key, V value2) {
        KeyReference<K, V> keyReference = this.createKeyReference(key, value2);
        ValueReference<K, V> valueReference = keyReference.getValueReference();
        ValueReference<K, V> prevValReference = this.myMap.put(keyReference, valueReference);
        this.processQueues();
        return prevValReference == null ? null : (V)prevValReference.get();
    }

    private boolean processQueues() {
        ValueReference valueReference;
        KeyReference keyReference;
        boolean removed = false;
        while ((keyReference = (KeyReference)((Object)this.myKeyQueue.poll())) != null) {
            valueReference = keyReference.getValueReference();
            removed |= this.myMap.remove(keyReference, valueReference);
        }
        while ((valueReference = (ValueReference)((Object)this.myValueQueue.poll())) != null) {
            keyReference = valueReference.getKeyReference();
            removed |= this.myMap.remove(keyReference, valueReference);
        }
        return removed;
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList<Object> values2 = new ArrayList<Object>();
        for (ValueReference valueReference : this.myMap.values()) {
            Object v2 = valueReference == null ? null : (Object)valueReference.get();
            if (v2 == null) continue;
            values2.add(v2);
        }
        ArrayList<Object> arrayList = values2;
        if (arrayList == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(@NotNull Object key, @NotNull Object value2) {
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(14);
        }
        if (value2 == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(15);
        }
        HardKey<K, V> hardKey = this.createHardKey(key);
        try {
            ValueReference valueReference = (ValueReference)this.myMap.get(hardKey);
            Object v2 = valueReference == null ? null : valueReference.get();
            boolean bl2 = value2.equals(v2) && this.myMap.remove(hardKey, valueReference);
            return bl2;
        }
        finally {
            ((HardKey)hardKey).clear();
            this.processQueues();
        }
    }

    @Override
    public V putIfAbsent(@NotNull K key, @NotNull V value2) {
        Object prev;
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(16);
        }
        if (value2 == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(17);
        }
        KeyReference<K, V> keyRef = this.createKeyReference(key, value2);
        ValueReference<K, V> newRef = keyRef.getValueReference();
        while (true) {
            ValueReference<K, V> oldRef;
            if ((oldRef = this.myMap.putIfAbsent(keyRef, newRef)) == null) {
                prev = null;
                break;
            }
            V oldVal = oldRef.get();
            if (oldVal == null) {
                if (this.myMap.replace(keyRef, oldRef, newRef)) {
                    prev = null;
                    break;
                }
            } else {
                prev = oldVal;
                break;
            }
            this.processQueues();
        }
        this.processQueues();
        return prev;
    }

    @Override
    public boolean replace(@NotNull K key, @NotNull V oldValue, @NotNull V newValue) {
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(18);
        }
        if (oldValue == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(19);
        }
        if (newValue == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(20);
        }
        KeyReference<K, V> oldKeyReference = this.createKeyReference(key, oldValue);
        ValueReference<K, V> oldValueReference = oldKeyReference.getValueReference();
        KeyReference<K, V> newKeyReference = this.createKeyReference(key, newValue);
        ValueReference<K, V> newValueReference = newKeyReference.getValueReference();
        boolean replaced = this.myMap.replace(oldKeyReference, oldValueReference, newValueReference);
        this.processQueues();
        return replaced;
    }

    @Override
    public V replace(@NotNull K key, @NotNull V value2) {
        ValueReference<K, V> valueReference;
        KeyReference<K, V> keyReference;
        ValueReference<K, V> result2;
        if (key == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(21);
        }
        if (value2 == null) {
            ConcurrentWeakKeySoftValueHashMap.$$$reportNull$$$0(22);
        }
        V prev = (result2 = this.myMap.replace(keyReference = this.createKeyReference(key, value2), valueReference = keyReference.getValueReference())) == null ? null : (V)result2.get();
        this.processQueues();
        return prev;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 13: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "k";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "v";
                break;
            }
            case 3: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap";
                break;
            }
            case 4: 
            case 10: 
            case 15: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldValue";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createKeyReference";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createHardKey";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createKeyReference";
                break;
            }
            case 3: 
            case 7: 
            case 13: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createValueReference";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createHardKey";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "containsValue";
                break;
            }
            case 11: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ValueReference<K, V>
    extends Supplier<V> {
        @NotNull
        public KeyReference<K, V> getKeyReference();

        @Override
        public V get();
    }

    static final class WeakKey<K, V>
    extends WeakReference<K>
    implements KeyReference<K, V> {
        private final int myHash;
        private final HashingStrategy<? super K> myStrategy;
        @NotNull
        private final ValueReference<K, V> myValueReference;

        WeakKey(@NotNull K k2, @NotNull ValueReference<K, V> valueReference, @NotNull HashingStrategy<? super K> strategy, @NotNull ReferenceQueue<? super K> queue) {
            if (k2 == null) {
                WeakKey.$$$reportNull$$$0(0);
            }
            if (valueReference == null) {
                WeakKey.$$$reportNull$$$0(1);
            }
            if (strategy == null) {
                WeakKey.$$$reportNull$$$0(2);
            }
            if (queue == null) {
                WeakKey.$$$reportNull$$$0(3);
            }
            super(k2, queue);
            this.myValueReference = valueReference;
            this.myHash = strategy.hashCode(k2);
            this.myStrategy = strategy;
        }

        @Override
        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof KeyReference)) {
                return false;
            }
            Object t2 = this.get();
            Object other = ((KeyReference)o2).get();
            if (t2 == null || other == null) {
                return false;
            }
            if (t2 == other) {
                return true;
            }
            return this.myHash == o2.hashCode() && this.myStrategy.equals(t2, other);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }

        @Override
        @NotNull
        public ValueReference<K, V> getValueReference() {
            ValueReference<K, V> valueReference = this.myValueReference;
            if (valueReference == null) {
                WeakKey.$$$reportNull$$$0(4);
            }
            return valueReference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 4: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "k";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueReference";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strategy";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queue";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$WeakKey";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$WeakKey";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueReference";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class SoftValue<K, V>
    extends SoftReference<V>
    implements ValueReference<K, V> {
        @NotNull
        volatile KeyReference<K, V> myKeyReference;

        private SoftValue(@NotNull V value2, @NotNull ReferenceQueue<? super V> queue) {
            if (value2 == null) {
                SoftValue.$$$reportNull$$$0(0);
            }
            if (queue == null) {
                SoftValue.$$$reportNull$$$0(1);
            }
            super(value2, queue);
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null) {
                return false;
            }
            Object v2 = this.get();
            Object thatV = ((ValueReference)o2).get();
            return v2 != null && v2.equals(thatV);
        }

        @Override
        @NotNull
        public KeyReference<K, V> getKeyReference() {
            KeyReference<K, V> keyReference = this.myKeyReference;
            if (keyReference == null) {
                SoftValue.$$$reportNull$$$0(2);
            }
            return keyReference;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queue";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$SoftValue";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$SoftValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKeyReference";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface KeyReference<K, V>
    extends Supplier<K> {
        @Override
        public K get();

        @NotNull
        public ValueReference<K, V> getValueReference();

        public boolean equals(Object var1);

        public int hashCode();
    }

    private static class HardKey<K, V>
    implements KeyReference<K, V> {
        private K myKey;
        private int myHash;

        private HardKey() {
        }

        private void set(@NotNull K key, int hash) {
            if (key == null) {
                HardKey.$$$reportNull$$$0(0);
            }
            this.myKey = key;
            this.myHash = hash;
        }

        private void clear() {
            this.myKey = null;
        }

        @Override
        public K get() {
            return this.myKey;
        }

        @Override
        public boolean equals(Object o2) {
            return o2.equals(this);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }

        @Override
        @NotNull
        public ValueReference<K, V> getValueReference() {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/containers/ConcurrentWeakKeySoftValueHashMap$HardKey", "set"));
        }
    }
}

