/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirCheckNotNullCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverValue;
import org.jetbrains.kotlin.fir.scopes.CallableCopyTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/ExpressionReceiverValue;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;", "receiverExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "<init>", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)V", "getReceiverExpression", "()Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "type", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "scope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "providers"})
@SourceDebugExtension(value={"SMAP\nFirReceivers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirReceivers.kt\norg/jetbrains/kotlin/fir/resolve/calls/ExpressionReceiverValue\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n*L\n1#1,319:1\n46#2:320\n*S KotlinDebug\n*F\n+ 1 FirReceivers.kt\norg/jetbrains/kotlin/fir/resolve/calls/ExpressionReceiverValue\n*L\n73#1:320\n*E\n"})
public final class ExpressionReceiverValue
implements ReceiverValue {
    @NotNull
    private final FirExpression receiverExpression;

    public ExpressionReceiverValue(@NotNull FirExpression receiverExpression) {
        Intrinsics.checkNotNullParameter((Object)receiverExpression, (String)"receiverExpression");
        this.receiverExpression = receiverExpression;
    }

    @Override
    @NotNull
    public FirExpression getReceiverExpression() {
        return this.receiverExpression;
    }

    @Override
    @NotNull
    public ConeKotlinType getType() {
        return FirTypeUtilsKt.getResolvedType(this.getReceiverExpression());
    }

    @Override
    @Nullable
    public FirTypeScope scope(@NotNull FirSession useSiteSession, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        FirExpression receiverExpr = this.getReceiverExpression();
        if (receiverExpr instanceof FirCheckNotNullCall) {
            FirCall $this$arguments$iv = (FirCall)((Object)receiverExpr);
            boolean $i$f$getArguments = false;
            receiverExpr = (FirExpression)CollectionsKt.firstOrNull($this$arguments$iv.getArgumentList().getArguments());
        }
        if (receiverExpr instanceof FirSmartCastExpression) {
            return ScopeUtilsKt.smartcastScope((FirSmartCastExpression)receiverExpr, useSiteSession, scopeSession, FirResolvePhase.STATUS);
        }
        return ScopeUtilsKt.scope(this.getType(), useSiteSession, scopeSession, CallableCopyTypeCalculator.DoNothing.INSTANCE, FirResolvePhase.STATUS);
    }
}

