/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import org.jdom.IllegalDataException;

public enum AttributeType {
    UNDECLARED,
    CDATA,
    ID,
    IDREF,
    IDREFS,
    ENTITY,
    ENTITIES,
    NMTOKEN,
    NMTOKENS,
    NOTATION,
    ENUMERATION;


    @Deprecated
    public static final AttributeType byIndex(int index2) {
        if (index2 < 0) {
            throw new IllegalDataException("No such AttributeType " + index2);
        }
        if (index2 >= AttributeType.values().length) {
            throw new IllegalDataException("No such AttributeType " + index2 + ", max is " + (AttributeType.values().length - 1));
        }
        return AttributeType.values()[index2];
    }

    public static final AttributeType getAttributeType(String typeName) {
        if (typeName == null) {
            return UNDECLARED;
        }
        try {
            return AttributeType.valueOf(typeName);
        }
        catch (IllegalArgumentException iae) {
            if (typeName.length() > 0 && typeName.trim().charAt(0) == '(') {
                return ENUMERATION;
            }
            return UNDECLARED;
        }
    }
}

