/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.protobuf;

import java.util.NoSuchElementException;
import org.jetbrains.kotlin.protobuf.ByteString;
import org.jetbrains.kotlin.protobuf.LiteralByteString;

class BoundedByteString
extends LiteralByteString {
    private final int bytesOffset;
    private final int bytesLength;

    BoundedByteString(byte[] bytes, int offset, int length) {
        super(bytes);
        if (offset < 0) {
            int n2 = offset;
            throw new IllegalArgumentException(new StringBuilder(29).append("Offset too small: ").append(n2).toString());
        }
        if (length < 0) {
            int n3 = offset;
            throw new IllegalArgumentException(new StringBuilder(29).append("Length too small: ").append(n3).toString());
        }
        if ((long)offset + (long)length > (long)bytes.length) {
            int n4 = offset;
            int n5 = length;
            throw new IllegalArgumentException(new StringBuilder(48).append("Offset+Length too large: ").append(n4).append("+").append(n5).toString());
        }
        this.bytesOffset = offset;
        this.bytesLength = length;
    }

    public byte byteAt(int index2) {
        if (index2 < 0) {
            int n2 = index2;
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(28).append("Index too small: ").append(n2).toString());
        }
        if (index2 >= this.size()) {
            int n3 = index2;
            int n4 = this.size();
            throw new ArrayIndexOutOfBoundsException(new StringBuilder(41).append("Index too large: ").append(n3).append(", ").append(n4).toString());
        }
        return this.bytes[this.bytesOffset + index2];
    }

    public int size() {
        return this.bytesLength;
    }

    protected int getOffsetIntoBytes() {
        return this.bytesOffset;
    }

    protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        System.arraycopy(this.bytes, this.getOffsetIntoBytes() + sourceOffset, target, targetOffset, numberToCopy);
    }

    public ByteString.ByteIterator iterator() {
        return new BoundedByteIterator();
    }

    private class BoundedByteIterator
    implements ByteString.ByteIterator {
        private int position;
        private final int limit;

        private BoundedByteIterator() {
            this.position = BoundedByteString.this.getOffsetIntoBytes();
            this.limit = this.position + BoundedByteString.this.size();
        }

        public boolean hasNext() {
            return this.position < this.limit;
        }

        public Byte next() {
            return this.nextByte();
        }

        public byte nextByte() {
            if (this.position >= this.limit) {
                throw new NoSuchElementException();
            }
            return BoundedByteString.this.bytes[this.position++];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

