/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\f\u001a\u00020\u0011H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000f2\u0006\u0010\f\u001a\u00020\u0011H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u0011H\u0002J\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u00112\f\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0013H\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u0011H\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u0011H\u0002J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u0011H\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectConsistencyChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "getConstructorProhibitedPropertyParameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "containingClass", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "getConstructorDelegationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;", "getClassSuperTypeReferencesWithInitializers", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "isProhibitedPrivateDeclaration", "", "isProhibitedEnumConstructor", "lastClass", "isProhibitedDeclarationWithBody", "isProhibitedEnumEntryWithBody", "isProhibitedEnumEntryWithInitializer", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExpectConsistencyChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExpectConsistencyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectConsistencyChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 SourceNavigator.kt\norg/jetbrains/kotlin/fir/analysis/checkers/SourceNavigator$Companion\n*L\n1#1,124:1\n48#2:125\n59#2:127\n53#2,4:128\n36#3:126\n23#3:139\n86#3:140\n774#4:132\n865#4,2:133\n774#4:136\n865#4,2:137\n80#5:135\n80#5:141\n80#5:142\n*S KotlinDebug\n*F\n+ 1 FirExpectConsistencyChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirExpectConsistencyChecker\n*L\n34#1:125\n77#1:127\n77#1:128,4\n40#1:126\n105#1:139\n113#1:140\n79#1:132\n79#1:133,2\n100#1:136\n100#1:137,2\n99#1:135\n117#1:141\n121#1:142\n*E\n"})
public final class FirExpectConsistencyChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirExpectConsistencyChecker INSTANCE = new FirExpectConsistencyChecker();

    private FirExpectConsistencyChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration2) {
        FirClassSymbol lastClass;
        KtSourceElement source;
        block19: {
            block18: {
                Object $this$isExpect$iv;
                Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                KtSourceElement ktSourceElement = declaration2.getSource();
                if (ktSourceElement == null) {
                    return;
                }
                source = ktSourceElement;
                if (source.getKind() instanceof KtFakeSourceElementKind) {
                    return;
                }
                Iterator<FirPureAbstractElement> iterator2 = CollectionsKt.lastOrNull(context2.getContainingDeclarations());
                FirClassSymbol firClassSymbol = lastClass = iterator2 instanceof FirClassSymbol ? (FirClassSymbol)((Object)iterator2) : null;
                if (declaration2 instanceof FirAnonymousInitializer) {
                    boolean bl2;
                    FirClassSymbol firClassSymbol2 = lastClass;
                    if (firClassSymbol2 != null) {
                        $this$isExpect$iv = firClassSymbol2;
                        boolean $i$f$isExpect = false;
                        bl2 = ((FirClassLikeSymbol)$this$isExpect$iv).getRawStatus().isExpect();
                    } else {
                        bl2 = false;
                    }
                    if (bl2) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECTED_DECLARATION_WITH_BODY(), null, 8, null);
                    }
                    return;
                }
                if (!(declaration2 instanceof FirMemberDeclaration)) break block18;
                $this$isExpect$iv = (FirMemberDeclaration)declaration2;
                boolean $i$f$isExpect = false;
                if (((FirMemberDeclaration)$this$isExpect$iv).getStatus().isExpect()) break block19;
            }
            return;
        }
        FirDelegatedConstructorCall firDelegatedConstructorCall = this.getConstructorDelegationCall((FirMemberDeclaration)declaration2);
        if (firDelegatedConstructorCall != null) {
            FirDelegatedConstructorCall delegatedConstructor = firDelegatedConstructorCall;
            boolean bl3 = false;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)delegatedConstructor.getSource(), FirErrors.INSTANCE.getEXPECTED_CLASS_CONSTRUCTOR_DELEGATION_CALL(), null, 8, null);
        }
        for (FirTypeRef superTypeRef : this.getClassSuperTypeReferencesWithInitializers((FirMemberDeclaration)declaration2)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)superTypeRef.getSource(), FirErrors.INSTANCE.getSUPERTYPE_INITIALIZED_IN_EXPECTED_CLASS(), null, 8, null);
        }
        for (FirValueParameter propertyParameter : this.getConstructorProhibitedPropertyParameters((FirMemberDeclaration)declaration2, lastClass)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)propertyParameter.getSource(), FirErrors.INSTANCE.getEXPECTED_CLASS_CONSTRUCTOR_PROPERTY_PARAMETER(), null, 8, null);
        }
        if (this.isProhibitedEnumConstructor((FirMemberDeclaration)declaration2, lastClass)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECTED_ENUM_CONSTRUCTOR(), null, 8, null);
        }
        if (this.isProhibitedEnumEntryWithBody((FirMemberDeclaration)declaration2)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECTED_ENUM_ENTRY_WITH_BODY(), null, 8, null);
        }
        if (this.isProhibitedEnumEntryWithInitializer((FirMemberDeclaration)declaration2)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getSUPERTYPE_INITIALIZED_IN_EXPECTED_CLASS(), null, 8, null);
        }
        if (this.isProhibitedPrivateDeclaration((FirMemberDeclaration)declaration2)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECTED_PRIVATE_DECLARATION(), null, 8, null);
        }
        if (this.isProhibitedDeclarationWithBody((FirMemberDeclaration)declaration2)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECTED_DECLARATION_WITH_BODY(), null, 8, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final List<FirValueParameter> getConstructorProhibitedPropertyParameters(FirMemberDeclaration declaration, FirClassSymbol<?> containingClass) {
        block4: {
            if (!(declaration instanceof FirPrimaryConstructor) || containingClass == null || containingClass.getClassKind() == ClassKind.ANNOTATION_CLASS) break block4;
            $this$isInlineOrValue$iv = containingClass;
            $i$f$isInlineOrValue = false;
            $this$isInline$iv$iv = $this$isInlineOrValue$iv;
            $i$f$isInline = false;
            if ($this$isInline$iv$iv.getRawStatus().isInline()) ** GOTO lbl-1000
            $this$isValue$iv$iv = $this$isInlineOrValue$iv;
            $i$f$isValue = false;
            if ($this$isValue$iv$iv.getRawStatus().isValue()) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            if (!v0) {
                $this$filter$iv = ((FirPrimaryConstructor)declaration).getValueParameters();
                $i$f$filter = false;
                $this$isValue$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (FirValueParameter)element$iv$iv;
                    $i$a$-filter-FirExpectConsistencyChecker$getConstructorProhibitedPropertyParameters$1 = false;
                    if (!(FirKeywordUtilsKt.getValOrVarKeyword(it.getSource()) != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        }
        return CollectionsKt.emptyList();
    }

    private final FirDelegatedConstructorCall getConstructorDelegationCall(FirMemberDeclaration declaration2) {
        if (declaration2 instanceof FirConstructor && !((FirConstructor)declaration2).isPrimary()) {
            KtSourceElement delegatedConstructorSource;
            FirDelegatedConstructorCall delegatedConstructor;
            FirDelegatedConstructorCall firDelegatedConstructorCall = delegatedConstructor = ((FirConstructor)declaration2).getDelegatedConstructor();
            KtSourceElement ktSourceElement = delegatedConstructorSource = firDelegatedConstructorCall != null ? firDelegatedConstructorCall.getSource() : null;
            if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) {
                return delegatedConstructor;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirTypeRef> getClassSuperTypeReferencesWithInitializers(FirMemberDeclaration declaration2) {
        void $this$filterTo$iv$iv;
        void this_$iv;
        if (!(declaration2 instanceof FirRegularClass)) {
            return CollectionsKt.emptyList();
        }
        SourceNavigator.Companion companion = SourceNavigator.Companion;
        FirElement $this$withNavigator$iv = declaration2;
        boolean $i$f$withNavigator = false;
        SourceNavigator $this$getClassSuperTypeReferencesWithInitializers_u24lambda_u243 = this_$iv.forSource($this$withNavigator$iv.getSource());
        boolean bl2 = false;
        Iterable $this$filter$iv = ((FirRegularClass)declaration2).getSuperTypeRefs();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirTypeRef it = (FirTypeRef)element$iv$iv;
            boolean bl3 = false;
            if (!$this$getClassSuperTypeReferencesWithInitializers_u24lambda_u243.isInConstructorCallee(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProhibitedPrivateDeclaration(FirMemberDeclaration declaration2) {
        if (declaration2 instanceof FirConstructor) return false;
        if (declaration2 instanceof FirPropertyAccessor) return false;
        FirMemberDeclaration $this$visibility$iv = declaration2;
        boolean $i$f$getVisibility = false;
        if (!Visibilities.INSTANCE.isPrivate($this$visibility$iv.getStatus().getVisibility())) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProhibitedEnumConstructor(FirMemberDeclaration declaration2, FirClassSymbol<?> lastClass) {
        if (!(declaration2 instanceof FirConstructor)) return false;
        FirClassSymbol<?> firClassSymbol = lastClass;
        if ((firClassSymbol != null ? firClassSymbol.getClassKind() : null) != ClassKind.ENUM_CLASS) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProhibitedDeclarationWithBody(FirMemberDeclaration declaration2) {
        if (!(declaration2 instanceof FirFunction)) return false;
        FirFunction $this$hasBody$iv = (FirFunction)declaration2;
        boolean $i$f$getHasBody = false;
        if ($this$hasBody$iv.getBody() == null) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProhibitedEnumEntryWithBody(FirMemberDeclaration declaration2) {
        void this_$iv;
        if (!(declaration2 instanceof FirEnumEntry)) return false;
        SourceNavigator.Companion companion = SourceNavigator.Companion;
        FirElement $this$withNavigator$iv = declaration2;
        boolean $i$f$withNavigator = false;
        SourceNavigator $this$isProhibitedEnumEntryWithBody_u24lambda_u244 = this_$iv.forSource($this$withNavigator$iv.getSource());
        boolean bl2 = false;
        if (!Intrinsics.areEqual((Object)$this$isProhibitedEnumEntryWithBody_u24lambda_u244.hasBody((FirEnumEntry)declaration2), (Object)true)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProhibitedEnumEntryWithInitializer(FirMemberDeclaration declaration2) {
        void this_$iv;
        if (!(declaration2 instanceof FirEnumEntry)) return false;
        SourceNavigator.Companion companion = SourceNavigator.Companion;
        FirElement $this$withNavigator$iv = declaration2;
        boolean $i$f$withNavigator = false;
        SourceNavigator $this$isProhibitedEnumEntryWithInitializer_u24lambda_u245 = this_$iv.forSource($this$withNavigator$iv.getSource());
        boolean bl2 = false;
        if (!Intrinsics.areEqual((Object)$this$isProhibitedEnumEntryWithInitializer_u24lambda_u245.hasInitializer((FirEnumEntry)declaration2), (Object)true)) return false;
        return true;
    }
}

