/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmIrSerializer;
import org.jetbrains.kotlin.backend.jvm.lower.JvmExpectDeclarationRemover;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.MetadataSource;

@PhaseDescription(name="SerializeIr", prerequisite={JvmExpectDeclarationRemover.class})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/SerializeIrPhase;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nSerializeIrPhase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerializeIrPhase.kt\norg/jetbrains/kotlin/backend/jvm/lower/SerializeIrPhase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n808#2,11:34\n*S KotlinDebug\n*F\n+ 1 SerializeIrPhase.kt\norg/jetbrains/kotlin/backend/jvm/lower/SerializeIrPhase\n*L\n27#1:34,11\n*E\n"})
public final class SerializeIrPhase
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;

    public SerializeIrPhase(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void lower(@NotNull IrFile irFile) {
        block3: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
            JvmIrSerializer jvmIrSerializer = this.context.getIrSerializer();
            if (jvmIrSerializer == null) break block3;
            JvmIrSerializer irSerializer = jvmIrSerializer;
            boolean bl2 = false;
            MetadataSource metadataSource = irFile.getMetadata();
            MetadataSource.File file = metadataSource instanceof MetadataSource.File ? (MetadataSource.File)metadataSource : null;
            if (file != null) {
                file.setSerializedIr(irSerializer.serializeIrFile(irFile));
            }
            Iterable $this$filterIsInstance$iv = irFile.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Object object = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrClass)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (IrClass irClass : (List)destination$iv$iv) {
                object = irClass.getMetadata();
                MetadataSource.Class clazz = object instanceof MetadataSource.Class ? (MetadataSource.Class)object : null;
                if (clazz == null) continue;
                clazz.setSerializedIr(irSerializer.serializeTopLevelIrClass(irClass));
            }
        }
    }
}

