/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import kotlinx.collections.immutable.PersistentSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.contracts.description.MarkedEventOccurrencesRange;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.cfa.FirPropertyInitializationAnalyzerKt;
import org.jetbrains.kotlin.fir.analysis.cfa.VariableInitializationCheckProcessorKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.VariableInitializationInfoData;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirImplicitInvokeCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenSubjectExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNodeKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNodeWithSubgraphs;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CapturedByValue;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionCallArgumentsExitNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.FunctionCallEnterNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.QualifiedAccessNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJr\u0010\u000e\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0018\u0010\u0018\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0019H\u0002J:\u0010\u001a\u001a\u00020\u0005*\u00020\u00072\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002JJ\u0010\u001d\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001e2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00122\u0018\u0010\u0018\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0019H\u0002JZ\u0010\u001f\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\u001b\u001a\u00020 2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0018\u0010\u0018\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0019H\u0002JR\u0010!\u001a\u00020\u0005*\u00020\u00072\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\"\u001a\u00020#2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00122\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J$\u0010$\u001a\u00020\t*\u0006\u0012\u0002\b\u00030\u00132\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J~\u0010%\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030&2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0018\u0010\u0018\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0019H\u0002J0\u0010'\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\u001b\u001a\u00020 2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH$J,\u0010)\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\n\u001a\u00020\u000bH$J,\u0010*\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020 2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH$J,\u0010+\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020 2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH$J\"\u0010,\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH$J\u0014\u0010-\u001a\u00020\t*\u00020#2\u0006\u0010\u0006\u001a\u00020\u0007H$\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/VariableInitializationCheckProcessor;", "", "<init>", "()V", "check", "", "data", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;", "isForInitialization", "", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "runCheck", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "properties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "scope", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "doNotReportUninitializedVariable", "doNotReportConstantUninitialized", "scopes", "", "processUnionNode", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "processVariableDeclaration", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "processVariableAssignment", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "processQualifiedAccess", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "isInitializedAt", "processSubGraphs", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNodeWithSubgraphs;", "reportCapturedInitialization", "symbol", "reportUninitializedVariable", "reportNonInlineMemberValInitialization", "reportValReassignment", "filterProperties", "hasMatchingReceiver", "checkers"})
@SourceDebugExtension(value={"SMAP\nVariableInitializationCheckProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariableInitializationCheckProcessor.kt\norg/jetbrains/kotlin/fir/analysis/cfa/VariableInitializationCheckProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,387:1\n1740#2,3:388\n1761#2,3:391\n32#3:394\n33#3:395\n30#3:396\n168#4,3:397\n54#5:400\n1#6:401\n*S KotlinDebug\n*F\n+ 1 VariableInitializationCheckProcessor.kt\norg/jetbrains/kotlin/fir/analysis/cfa/VariableInitializationCheckProcessor\n*L\n144#1:388,3\n178#1:391,3\n207#1:394\n209#1:395\n210#1:396\n220#1:397,3\n252#1:400\n*E\n"})
public abstract class VariableInitializationCheckProcessor {
    public final void check(@NotNull VariableInitializationInfoData data, boolean isForInitialization, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Set<FirVariableSymbol<?>> filtered = this.filterProperties(data, isForInitialization);
        if (filtered.isEmpty()) {
            return;
        }
        this.runCheck(data, data.getGraph(), filtered, context2, reporter, null, isForInitialization, false, true, new LinkedHashMap());
    }

    private final void runCheck(VariableInitializationInfoData $this$runCheck, ControlFlowGraph graph2, Set<? extends FirVariableSymbol<?>> properties, CheckerContext context2, DiagnosticReporter reporter, FirDeclaration scope, boolean isForInitialization, boolean doNotReportUninitializedVariable, boolean doNotReportConstantUninitialized, Map<FirVariableSymbol<?>, FirDeclaration> scopes) {
        for (CFGNode<?> node : graph2.getNodes()) {
            CFGNode<?> cFGNode;
            if (node.isUnion()) {
                this.processUnionNode($this$runCheck, node, properties, context2, reporter);
            }
            if ((cFGNode = node) instanceof VariableDeclarationNode) {
                this.processVariableDeclaration($this$runCheck, (VariableDeclarationNode)node, scope, properties, scopes);
                continue;
            }
            if (cFGNode instanceof VariableAssignmentNode) {
                this.processVariableAssignment($this$runCheck, (VariableAssignmentNode)node, properties, reporter, context2, scope, scopes);
                continue;
            }
            if (cFGNode instanceof QualifiedAccessNode) {
                this.processQualifiedAccess($this$runCheck, node, ((QualifiedAccessNode)node).getFir(), properties, doNotReportUninitializedVariable, doNotReportConstantUninitialized, reporter, context2);
                continue;
            }
            if (cFGNode instanceof FunctionCallEnterNode) {
                FirQualifiedAccessExpression receiver;
                FirFunctionCall call2 = ((FunctionCallEnterNode)node).getFir();
                if (!(call2 instanceof FirImplicitInvokeCall)) continue;
                CFGNode<?> cFGNode2 = CFGNodeKt.getFirstPreviousNode(node);
                FunctionCallArgumentsExitNode functionCallArgumentsExitNode = cFGNode2 instanceof FunctionCallArgumentsExitNode ? (FunctionCallArgumentsExitNode)cFGNode2 : null;
                CFGNode<?> receiverExitNode = functionCallArgumentsExitNode != null ? functionCallArgumentsExitNode.getExplicitReceiverExitNode() : null;
                FirExpression firExpression = ((FirImplicitInvokeCall)call2).getDispatchReceiver();
                if (firExpression == null) {
                    firExpression = ((FirImplicitInvokeCall)call2).getExplicitReceiver();
                }
                FirQualifiedAccessExpression firQualifiedAccessExpression = receiver = (cFGNode2 = firExpression) instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)((Object)cFGNode2) : null;
                if (receiverExitNode == null || receiver == null) continue;
                this.processQualifiedAccess($this$runCheck, receiverExitNode, receiver, properties, doNotReportUninitializedVariable, doNotReportConstantUninitialized, reporter, context2);
                continue;
            }
            if (!(cFGNode instanceof CFGNodeWithSubgraphs)) continue;
            this.processSubGraphs($this$runCheck, graph2, (CFGNodeWithSubgraphs)node, properties, context2, reporter, scope, isForInitialization, doNotReportUninitializedVariable, doNotReportConstantUninitialized, scopes);
        }
    }

    private final void processUnionNode(VariableInitializationInfoData $this$processUnionNode, CFGNode<?> node, Set<? extends FirVariableSymbol<?>> properties, CheckerContext context2, DiagnosticReporter reporter) {
        for (Map.Entry entry : ((Map)$this$processUnionNode.getValue(node)).entrySet()) {
            EdgeLabel path = (EdgeLabel)entry.getKey();
            PersistentMap data = (PersistentMap)entry.getValue();
            if (Intrinsics.areEqual((Object)path, (Object)CapturedByValue.INSTANCE)) continue;
            for (Map.Entry entry2 : ((Map)data).entrySet()) {
                boolean bl2;
                FirVariableSymbol symbol;
                block5: {
                    symbol = (FirVariableSymbol)entry2.getKey();
                    MarkedEventOccurrencesRange range = (MarkedEventOccurrencesRange)entry2.getValue();
                    if (!symbol.isVal() || !EventOccurrencesRangeKt.canBeRevisited(range) || !properties.contains(symbol)) continue;
                    Iterable $this$all$iv = CfgTraverserKt.getPreviousCfgNodes(node);
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            CFGNode it = (CFGNode)element$iv;
                            boolean bl3 = false;
                            Object object = (PersistentMap)$this$processUnionNode.getValue(it).get(path);
                            if (!(object != null && (object = (MarkedEventOccurrencesRange)object.get(symbol)) != null ? EventOccurrencesRangeKt.canBeRevisited(object) : false)) continue;
                            bl2 = false;
                            break block5;
                        }
                        bl2 = true;
                    }
                }
                if (!bl2) continue;
                VariableInitializationCheckProcessor.processUnionNode$reportErrorsOnInitializationsInInputs(node, $this$processUnionNode, this, reporter, context2, symbol, path, ExtensionsKt.persistentSetOf());
            }
        }
    }

    private final void processVariableDeclaration(VariableInitializationInfoData $this$processVariableDeclaration, VariableDeclarationNode node, FirDeclaration scope, Set<? extends FirVariableSymbol<?>> properties, Map<FirVariableSymbol<?>, FirDeclaration> scopes) {
        FirPropertySymbol symbol = node.getFir().getSymbol();
        if (scope != null && $this$processVariableDeclaration.getReceiver() == null && node.getFir().isVal() && properties.contains(symbol)) {
            scopes.put(symbol, scope);
        }
    }

    private final void processVariableAssignment(VariableInitializationInfoData $this$processVariableAssignment, VariableAssignmentNode node, Set<? extends FirVariableSymbol<?>> properties, DiagnosticReporter reporter, CheckerContext context2, FirDeclaration scope, Map<FirVariableSymbol<?>, FirDeclaration> scopes) {
        boolean bl2;
        Object symbol;
        block13: {
            block15: {
                block14: {
                    Object object = ReferenceUtilsKt.getCalleeReference(node.getFir());
                    if (object == null || (object = FirReferenceUtilsKt.toResolvedVariableSymbol$default((FirReference)object, false, 1, null)) == null) {
                        return;
                    }
                    symbol = object;
                    if (!((FirVariableSymbol)symbol).isVal()) break block14;
                    FirQualifiedAccessExpression firQualifiedAccessExpression = FirExpressionUtilKt.unwrapLValue(node.getFir());
                    if ((firQualifiedAccessExpression != null ? this.hasMatchingReceiver(firQualifiedAccessExpression, $this$processVariableAssignment) : false) && properties.contains(symbol)) break block15;
                }
                return;
            }
            PersistentMap<EdgeLabel, PersistentMap<FirVariableSymbol<?>, MarkedEventOccurrencesRange<CFGNode<?>>>> info = $this$processVariableAssignment.getValue(node);
            Iterable $this$any$iv = info.values();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PersistentMap it = (PersistentMap)element$iv;
                    boolean bl3 = false;
                    MarkedEventOccurrencesRange markedEventOccurrencesRange = (MarkedEventOccurrencesRange)it.get(symbol);
                    boolean bl4 = markedEventOccurrencesRange != null ? EventOccurrencesRangeKt.canBeRevisited(markedEventOccurrencesRange) : false;
                    if (!bl4) continue;
                    bl2 = true;
                    break block13;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            this.reportValReassignment(node, (FirVariableSymbol<?>)symbol, reporter, context2);
        } else if (!Intrinsics.areEqual((Object)scope, (Object)scopes.get(symbol))) {
            this.reportCapturedInitialization($this$processVariableAssignment, node, (FirVariableSymbol<?>)symbol, reporter, context2);
        } else if (!VariableInitializationCheckProcessorKt.access$isLocal((FirVariableSymbol)symbol) && !VariableInitializationCheckProcessorKt.access$isInline(node.getOwner(), FirHelpersKt.getContainingSymbol((FirCallableSymbol)symbol, context2.getSession()))) {
            this.reportNonInlineMemberValInitialization(node, (FirVariableSymbol<?>)symbol, reporter, context2);
        }
    }

    private final void processQualifiedAccess(VariableInitializationInfoData $this$processQualifiedAccess, CFGNode<?> node, FirQualifiedAccessExpression expression2, Set<? extends FirVariableSymbol<?>> properties, boolean doNotReportUninitializedVariable, boolean doNotReportConstantUninitialized, DiagnosticReporter reporter, CheckerContext context2) {
        if (doNotReportUninitializedVariable) {
            return;
        }
        if (expression2 instanceof FirWhenSubjectExpression) {
            return;
        }
        if (FirHelpersKt.hasDiagnosticKind(FirTypeUtilsKt.getResolvedType(expression2), DiagnosticKind.RecursionInImplicitTypes)) {
            return;
        }
        FirVariableSymbol firVariableSymbol = FirReferenceUtilsKt.toResolvedVariableSymbol$default(expression2.getCalleeReference(), false, 1, null);
        if (firVariableSymbol == null) {
            return;
        }
        FirVariableSymbol symbol = firVariableSymbol;
        if (doNotReportConstantUninitialized) {
            FirCallableSymbol $this$isConst$iv = symbol;
            boolean $i$f$isConst = false;
            if ($this$isConst$iv.getRawStatus().isConst()) {
                return;
            }
        }
        FirCallableSymbol $this$isLateInit$iv = symbol;
        boolean $i$f$isLateInit = false;
        if (!$this$isLateInit$iv.getRawStatus().isLateInit()) {
            FirCallableSymbol $this$isExternal$iv = symbol;
            boolean $i$f$isExternal = false;
            if (!$this$isExternal$iv.getRawStatus().isExternal() && this.hasMatchingReceiver(expression2, $this$processQualifiedAccess) && properties.contains(symbol) && !this.isInitializedAt(symbol, node, $this$processQualifiedAccess)) {
                this.reportUninitializedVariable(reporter, expression2, symbol, context2);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInitializedAt(FirVariableSymbol<?> $this$isInitializedAt, CFGNode<?> node, VariableInitializationInfoData data) {
        boolean bl2;
        Map $this$all$iv = data.getValue(node);
        boolean $i$f$all = false;
        if ($this$all$iv.isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.entrySet().iterator();
        do {
            Map.Entry element$iv;
            if (!iterator2.hasNext()) return true;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl3 = false;
            EdgeLabel key = (EdgeLabel)entry.getKey();
            PersistentMap value2 = (PersistentMap)entry.getValue();
            if (!Intrinsics.areEqual((Object)key, (Object)CapturedByValue.INSTANCE) || VariableInitializationCheckProcessorKt.isCapturedByValue($this$isInitializedAt)) {
                MarkedEventOccurrencesRange markedEventOccurrencesRange = (MarkedEventOccurrencesRange)value2.get($this$isInitializedAt);
                if (markedEventOccurrencesRange == null) return false;
                if (!EventOccurrencesRangeKt.isDefinitelyVisited(markedEventOccurrencesRange)) return false;
                boolean bl4 = true;
                if (!bl4) return false;
            }
            bl2 = true;
        } while (bl2);
        return false;
    }

    private final void processSubGraphs(VariableInitializationInfoData $this$processSubGraphs, ControlFlowGraph graph2, CFGNodeWithSubgraphs<?> node, Set<? extends FirVariableSymbol<?>> properties, CheckerContext context2, DiagnosticReporter reporter, FirDeclaration scope, boolean isForInitialization, boolean doNotReportUninitializedVariable, boolean doNotReportConstantUninitialized, Map<FirVariableSymbol<?>, FirDeclaration> scopes) {
        if ($this$processSubGraphs.getReceiver() != null && node == graph2.getExitNode()) {
            return;
        }
        for (ControlFlowGraph subGraph : node.getSubGraphs()) {
            FirDeclaration firDeclaration;
            boolean isSubGraphConstProperty;
            boolean doNotReportForSubGraph;
            block8: {
                block7: {
                    FirDeclaration firDeclaration2;
                    boolean bl2;
                    doNotReportForSubGraph = isForInitialization && VariableInitializationCheckProcessorKt.access$getDoNotReportUninitializedVariableForInitialization(subGraph.getKind());
                    FirDeclaration firDeclaration3 = subGraph.getDeclaration();
                    FirProperty firProperty = firDeclaration3 instanceof FirProperty ? (FirProperty)firDeclaration3 : null;
                    if (firProperty != null) {
                        FirMemberDeclaration $this$isConst$iv = firProperty;
                        boolean $i$f$isConst = false;
                        bl2 = $this$isConst$iv.getStatus().isConst();
                    } else {
                        bl2 = isSubGraphConstProperty = false;
                    }
                    if ((firDeclaration = subGraph.getDeclaration()) == null) break block7;
                    FirDeclaration it = firDeclaration2 = firDeclaration;
                    boolean bl3 = false;
                    firDeclaration = !FirPropertyInitializationAnalyzerKt.getEvaluatedInPlace(it) ? firDeclaration2 : null;
                    if (firDeclaration != null) break block8;
                }
                firDeclaration = scope;
            }
            FirDeclaration newScope = firDeclaration;
            this.runCheck($this$processSubGraphs, subGraph, properties, context2, reporter, newScope, isForInitialization, doNotReportUninitializedVariable || doNotReportForSubGraph, doNotReportConstantUninitialized && !isSubGraphConstProperty, scopes);
        }
    }

    protected abstract void reportCapturedInitialization(@NotNull VariableInitializationInfoData var1, @NotNull VariableAssignmentNode var2, @NotNull FirVariableSymbol<?> var3, @NotNull DiagnosticReporter var4, @NotNull CheckerContext var5);

    protected abstract void reportUninitializedVariable(@NotNull DiagnosticReporter var1, @NotNull FirQualifiedAccessExpression var2, @NotNull FirVariableSymbol<?> var3, @NotNull CheckerContext var4);

    protected abstract void reportNonInlineMemberValInitialization(@NotNull VariableAssignmentNode var1, @NotNull FirVariableSymbol<?> var2, @NotNull DiagnosticReporter var3, @NotNull CheckerContext var4);

    protected abstract void reportValReassignment(@NotNull VariableAssignmentNode var1, @NotNull FirVariableSymbol<?> var2, @NotNull DiagnosticReporter var3, @NotNull CheckerContext var4);

    @NotNull
    protected abstract Set<FirVariableSymbol<?>> filterProperties(@NotNull VariableInitializationInfoData var1, boolean var2);

    protected abstract boolean hasMatchingReceiver(@NotNull FirQualifiedAccessExpression var1, @NotNull VariableInitializationInfoData var2);

    private static final void processUnionNode$reportErrorsOnInitializationsInInputs(CFGNode<?> $this$processUnionNode_u24reportErrorsOnInitializationsInInputs, VariableInitializationInfoData $this_processUnionNode, VariableInitializationCheckProcessor this$0, DiagnosticReporter $reporter, CheckerContext $context, FirVariableSymbol<?> symbol, EdgeLabel path, PersistentSet<? extends CFGNode<?>> visited2) {
        PersistentSet<CFGNode<?>> newVisited = visited2.add($this$processUnionNode_u24reportErrorsOnInitializationsInInputs);
        if (!(newVisited != visited2)) {
            boolean $i$a$-require-VariableInitializationCheckProcessor$processUnionNode$reportErrorsOnInitializationsInInputs$22 = false;
            String $i$a$-require-VariableInitializationCheckProcessor$processUnionNode$reportErrorsOnInitializationsInInputs$22 = VariableInitializationCheckProcessorKt.buildRecursionErrorMessage($this$processUnionNode_u24reportErrorsOnInitializationsInInputs, symbol, $context);
            throw new IllegalArgumentException($i$a$-require-VariableInitializationCheckProcessor$processUnionNode$reportErrorsOnInitializationsInInputs$22.toString());
        }
        for (CFGNode<?> previousNode : CfgTraverserKt.getPreviousCfgNodes($this$processUnionNode_u24reportErrorsOnInitializationsInInputs)) {
            Object object;
            CFGNode assignmentNode;
            if ($this$processUnionNode_u24reportErrorsOnInitializationsInInputs.edgeFrom(previousNode).getKind().isBack() || (assignmentNode = (object = (PersistentMap)$this_processUnionNode.getValue(previousNode).get(path)) != null && (object = (MarkedEventOccurrencesRange)object.get(symbol)) != null ? (CFGNode)((MarkedEventOccurrencesRange)object).getLocation() : null) instanceof VariableDeclarationNode) continue;
            if (assignmentNode instanceof VariableAssignmentNode) {
                this$0.reportCapturedInitialization($this_processUnionNode, (VariableAssignmentNode)assignmentNode, symbol, $reporter, $context);
                continue;
            }
            CFGNode cFGNode = assignmentNode;
            if (cFGNode == null) continue;
            VariableInitializationCheckProcessor.processUnionNode$reportErrorsOnInitializationsInInputs(cFGNode, $this_processUnionNode, this$0, $reporter, $context, symbol, path, newVisited);
        }
    }
}

