/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.java;

import com.intellij.core.JavaPsiBundle;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.lang.JavaVersion;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum LanguageLevel {
    JDK_1_3(JavaPsiBundle.messagePointer("jdk.1.3.language.level.description", new Object[0]), 3),
    JDK_1_4(JavaPsiBundle.messagePointer("jdk.1.4.language.level.description", new Object[0]), 4),
    JDK_1_5(JavaPsiBundle.messagePointer("jdk.1.5.language.level.description", new Object[0]), 5),
    JDK_1_6(JavaPsiBundle.messagePointer("jdk.1.6.language.level.description", new Object[0]), 6),
    JDK_1_7(JavaPsiBundle.messagePointer("jdk.1.7.language.level.description", new Object[0]), 7),
    JDK_1_8(JavaPsiBundle.messagePointer("jdk.1.8.language.level.description", new Object[0]), 8),
    JDK_1_9(JavaPsiBundle.messagePointer("jdk.1.9.language.level.description", new Object[0]), 9),
    JDK_10(JavaPsiBundle.messagePointer("jdk.10.language.level.description", new Object[0]), 10),
    JDK_11(JavaPsiBundle.messagePointer("jdk.11.language.level.description", new Object[0]), 11),
    JDK_12(JavaPsiBundle.messagePointer("jdk.12.language.level.description", new Object[0]), 12),
    JDK_13(JavaPsiBundle.messagePointer("jdk.13.language.level.description", new Object[0]), 13),
    JDK_14(JavaPsiBundle.messagePointer("jdk.14.language.level.description", new Object[0]), 14),
    JDK_15(JavaPsiBundle.messagePointer("jdk.15.language.level.description", new Object[0]), 15),
    JDK_16(JavaPsiBundle.messagePointer("jdk.16.language.level.description", new Object[0]), 16),
    JDK_17(JavaPsiBundle.messagePointer("jdk.17.language.level.description", new Object[0]), 17),
    JDK_17_PREVIEW(17),
    JDK_18(JavaPsiBundle.messagePointer("jdk.18.language.level.description", new Object[0]), 18),
    JDK_18_PREVIEW(18),
    JDK_19(JavaPsiBundle.messagePointer("jdk.19.language.level.description", new Object[0]), 19),
    JDK_19_PREVIEW(19),
    JDK_20(JavaPsiBundle.messagePointer("jdk.20.language.level.description", new Object[0]), 20),
    JDK_20_PREVIEW(20),
    JDK_21(JavaPsiBundle.messagePointer("jdk.21.language.level.description", new Object[0]), 21),
    JDK_21_PREVIEW(JavaPsiBundle.messagePointer("jdk.21.preview.language.level.description", new Object[0]), 21),
    JDK_22(JavaPsiBundle.messagePointer("jdk.22.language.level.description", new Object[0]), 22),
    JDK_22_PREVIEW(JavaPsiBundle.messagePointer("jdk.22.preview.language.level.description", new Object[0]), 22),
    JDK_X(JavaPsiBundle.messagePointer("jdk.X.language.level.description", new Object[0]), 23);

    public static final LanguageLevel HIGHEST;
    private final Supplier<@Nls String> myPresentableText;
    private final JavaVersion myVersion;
    private final boolean myPreview;
    private final boolean myUnsupported;
    private static final Map<Integer, LanguageLevel> ourStandardVersions;
    public static final Key<LanguageLevel> FILE_LANGUAGE_LEVEL_KEY;

    private LanguageLevel(Supplier<String> presentableTextSupplier, int major) {
        this(presentableTextSupplier, major, false);
    }

    private LanguageLevel(int major) {
        this(JavaPsiBundle.messagePointer("jdk.unsupported.preview.language.level.description", major), major, true);
    }

    private LanguageLevel(Supplier<String> presentableTextSupplier, int major, boolean unsupported) {
        this.myPresentableText = presentableTextSupplier;
        this.myVersion = JavaVersion.compose(major);
        this.myUnsupported = unsupported;
        boolean bl2 = this.myPreview = this.name().endsWith("_PREVIEW") || this.name().endsWith("_X");
        if (this.myUnsupported && !this.myPreview) {
            throw new IllegalArgumentException("Only preview versions could be unsupported: " + this.name());
        }
    }

    public boolean isPreview() {
        return this.myPreview;
    }

    public boolean isUnsupported() {
        return this.myUnsupported;
    }

    @Nullable
    public LanguageLevel getPreviewLevel() {
        if (this.myPreview) {
            return this;
        }
        try {
            return LanguageLevel.valueOf(this.name() + "_PREVIEW");
        }
        catch (IllegalArgumentException e2) {
            return null;
        }
    }

    @NotNull
    public LanguageLevel getNonPreviewLevel() {
        if (!this.myPreview) {
            LanguageLevel languageLevel = this;
            if (languageLevel == null) {
                LanguageLevel.$$$reportNull$$$0(0);
            }
            return languageLevel;
        }
        LanguageLevel languageLevel = Objects.requireNonNull(ourStandardVersions.get(this.myVersion.feature));
        if (languageLevel == null) {
            LanguageLevel.$$$reportNull$$$0(1);
        }
        return languageLevel;
    }

    @NotNull
    @Nls
    public String getPresentableText() {
        String string = this.myPresentableText.get();
        if (string == null) {
            LanguageLevel.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAtLeast(@NotNull LanguageLevel level) {
        if (level == null) {
            LanguageLevel.$$$reportNull$$$0(3);
        }
        return this.compareTo(level) >= 0;
    }

    public boolean isLessThan(@NotNull LanguageLevel level) {
        if (level == null) {
            LanguageLevel.$$$reportNull$$$0(4);
        }
        return this.compareTo(level) < 0;
    }

    @NotNull
    public JavaVersion toJavaVersion() {
        JavaVersion javaVersion = this.myVersion;
        if (javaVersion == null) {
            LanguageLevel.$$$reportNull$$$0(5);
        }
        return javaVersion;
    }

    public int feature() {
        return this.myVersion.feature;
    }

    @NlsSafe
    public String getShortText() {
        if (this == JDK_X) {
            return "X";
        }
        return this.feature() + (this.isPreview() ? "-preview" : "");
    }

    @Nullable
    public static LanguageLevel parse(@Nullable String compilerComplianceOption) {
        JavaSdkVersion sdkVersion;
        if (compilerComplianceOption != null && (sdkVersion = JavaSdkVersion.fromVersionString(compilerComplianceOption)) != null) {
            return sdkVersion.getMaxLanguageLevel();
        }
        return null;
    }

    @Nullable
    public static LanguageLevel forFeature(int feature) {
        return ourStandardVersions.get(feature);
    }

    static {
        HIGHEST = JDK_22;
        ourStandardVersions = Stream.of(LanguageLevel.values()).filter(ver -> !ver.isPreview()).collect(Collectors.toMap(ver -> ver.myVersion.feature, Function.identity()));
        FILE_LANGUAGE_LEVEL_KEY = Key.create("FORCE_LANGUAGE_LEVEL");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 3: 
            case 4: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/pom/java/LanguageLevel";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonPreviewLevel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/pom/java/LanguageLevel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toJavaVersion";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeast";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isLessThan";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

