/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnNothingExhaustivenessChecker;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker;", "<init>", "()V", "isApplicable", "", "subjectType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "computeMissingCases", "", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "destination", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "resolve"})
final class WhenOnNothingExhaustivenessChecker
extends WhenExhaustivenessChecker {
    @NotNull
    public static final WhenOnNothingExhaustivenessChecker INSTANCE = new WhenOnNothingExhaustivenessChecker();

    private WhenOnNothingExhaustivenessChecker() {
        super(null);
    }

    @Override
    public boolean isApplicable(@NotNull ConeKotlinType subjectType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)subjectType, (String)"subjectType");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return ConeBuiltinTypeUtilsKt.isNullableNothing(subjectType) || ConeBuiltinTypeUtilsKt.isNothing(subjectType);
    }

    @Override
    public void computeMissingCases(@NotNull FirWhenExpression whenExpression, @NotNull ConeKotlinType subjectType, @NotNull FirSession session, @NotNull Collection<WhenMissingCase> destination) {
        Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
        Intrinsics.checkNotNullParameter((Object)subjectType, (String)"subjectType");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
    }
}

