/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.DefaultHeaderInfoBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.ForLoopBodyTransformer;
import org.jetbrains.kotlin.backend.common.lower.loops.ForLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderProcessor;
import org.jetbrains.kotlin.backend.common.lower.loops.LoopReplacement;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionsKt;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\b\u0002\u0018\u0000 32\u00020\u0001:\u0003123B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0016\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020 00H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "oldLoopToNewLoop", "", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "loopBodyTransformer", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopBodyTransformer;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;Ljava/util/Map;Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopBodyTransformer;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "getContainer", "()Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "getOldLoopToNewLoop", "()Ljava/util/Map;", "getLoopBodyTransformer", "()Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopBodyTransformer;", "headerInfoBuilder", "Lorg/jetbrains/kotlin/backend/common/lower/loops/DefaultHeaderInfoBuilder;", "headerProcessor", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderProcessor;", "getScopeOwnerSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "lowerHeader", "Lorg/jetbrains/kotlin/ir/IrStatement;", "variable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "loopHeader", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopHeader;", "lowerWhileLoop", "Lorg/jetbrains/kotlin/backend/common/lower/loops/LoopReplacement;", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "specializeIteratorIfPossible", "", "irForLoopBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "gatherLoopVariableInfo", "Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer$LoopVariableInfo;", "statements", "", "LoopVariableInfo", "FindInitializerCallVisitor", "Companion", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nForLoopsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForLoopsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,464:1\n1#2:465\n1761#3,3:466\n385#4,11:469\n*S KotlinDebug\n*F\n+ 1 ForLoopsLowering.kt\norg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer\n*L\n177#1:466,3\n321#1:469,11\n*E\n"})
final class RangeLoopTransformer
extends IrElementTransformerVoidWithContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final IrSymbolOwner container;
    @NotNull
    private final Map<IrLoop, IrLoop> oldLoopToNewLoop;
    @Nullable
    private final ForLoopBodyTransformer loopBodyTransformer;
    @NotNull
    private final DefaultHeaderInfoBuilder headerInfoBuilder;
    @NotNull
    private final HeaderProcessor headerProcessor;
    @NotNull
    private static final FqName STDLIB_ITERATOR_FUNCTION_FQ_NAME = new FqName("kotlin.collections.CollectionsKt.iterator");

    public RangeLoopTransformer(@NotNull CommonBackendContext context2, @NotNull IrSymbolOwner container, @NotNull Map<IrLoop, IrLoop> oldLoopToNewLoop, @Nullable ForLoopBodyTransformer loopBodyTransformer) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter(oldLoopToNewLoop, (String)"oldLoopToNewLoop");
        this.context = context2;
        this.container = container;
        this.oldLoopToNewLoop = oldLoopToNewLoop;
        this.loopBodyTransformer = loopBodyTransformer;
        this.headerInfoBuilder = new DefaultHeaderInfoBuilder(this.context, (Function0<? extends IrSymbol>)((Function0)new Function0<IrSymbol>((Object)this){

            public final IrSymbol invoke() {
                return ((RangeLoopTransformer)this.receiver).getScopeOwnerSymbol();
            }
        }));
        this.headerProcessor = new HeaderProcessor(this.context, this.headerInfoBuilder, (Function0<? extends IrSymbol>)((Function0)new Function0<IrSymbol>((Object)this){

            public final IrSymbol invoke() {
                return ((RangeLoopTransformer)this.receiver).getScopeOwnerSymbol();
            }
        }));
    }

    public /* synthetic */ RangeLoopTransformer(CommonBackendContext commonBackendContext, IrSymbolOwner irSymbolOwner, Map map, ForLoopBodyTransformer forLoopBodyTransformer, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            forLoopBodyTransformer = null;
        }
        this(commonBackendContext, irSymbolOwner, map, forLoopBodyTransformer);
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrSymbolOwner getContainer() {
        return this.container;
    }

    @NotNull
    public final Map<IrLoop, IrLoop> getOldLoopToNewLoop() {
        return this.oldLoopToNewLoop;
    }

    @Nullable
    public final ForLoopBodyTransformer getLoopBodyTransformer() {
        return this.loopBodyTransformer;
    }

    @NotNull
    public final IrSymbol getScopeOwnerSymbol() {
        Object object = this.getCurrentScope();
        if (object == null || (object = ((ScopeWithIr)object).getScope()) == null || (object = ((Scope)object).getScopeOwnerSymbol()) == null) {
            object = this.container.getSymbol();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2) {
        boolean bl2;
        ForLoopHeader loopHeader;
        IrWhileLoop oldLoop;
        IrVariable iteratorVariable;
        List<IrStatement> statements;
        block10: {
            boolean bl3;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            if (!Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)IrStatementOrigin.Companion.getFOR_LOOP())) {
                return super.visitBlock(expression2);
            }
            statements = expression2.getStatements();
            boolean bl4 = bl3 = statements.size() == 2;
            if (_Assertions.ENABLED && !bl3) {
                boolean $i$a$-assert-RangeLoopTransformer$visitBlock$42 = false;
                String $i$a$-assert-RangeLoopTransformer$visitBlock$42 = "Expected 2 statements in for-loop block, was:\n" + DumpIrTreeKt.dump$default(expression2, null, 1, null);
                throw new AssertionError((Object)$i$a$-assert-RangeLoopTransformer$visitBlock$42);
            }
            IrStatement irStatement = statements.get(0);
            Intrinsics.checkNotNull((Object)irStatement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrVariable");
            iteratorVariable = (IrVariable)irStatement;
            boolean $i$a$-assert-RangeLoopTransformer$visitBlock$42 = Intrinsics.areEqual((Object)iteratorVariable.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFOR_LOOP_ITERATOR());
            if (_Assertions.ENABLED && !$i$a$-assert-RangeLoopTransformer$visitBlock$42) {
                boolean $i$a$-assert-RangeLoopTransformer$visitBlock$52 = false;
                String $i$a$-assert-RangeLoopTransformer$visitBlock$52 = "Expected FOR_LOOP_ITERATOR origin for iterator variable, was:\n" + DumpIrTreeKt.dump$default(iteratorVariable, null, 1, null);
                throw new AssertionError((Object)$i$a$-assert-RangeLoopTransformer$visitBlock$52);
            }
            IrStatement irStatement2 = statements.get(1);
            Intrinsics.checkNotNull((Object)irStatement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrWhileLoop");
            oldLoop = (IrWhileLoop)irStatement2;
            boolean $i$a$-assert-RangeLoopTransformer$visitBlock$52 = Intrinsics.areEqual((Object)oldLoop.getOrigin(), (Object)IrStatementOrigin.Companion.getFOR_LOOP_INNER_WHILE());
            if (_Assertions.ENABLED && !$i$a$-assert-RangeLoopTransformer$visitBlock$52) {
                boolean $i$a$-assert-RangeLoopTransformer$visitBlock$62 = false;
                String $i$a$-assert-RangeLoopTransformer$visitBlock$62 = "Expected FOR_LOOP_INNER_WHILE origin for while loop, was:\n" + DumpIrTreeKt.dump$default(oldLoop, null, 1, null);
                throw new AssertionError((Object)$i$a$-assert-RangeLoopTransformer$visitBlock$62);
            }
            ForLoopHeader forLoopHeader = this.headerProcessor.extractHeader(iteratorVariable);
            if (forLoopHeader == null) {
                void $this$visitBlock_u24lambda_u243;
                IrBlock irBlock;
                IrBlock irBlock2 = irBlock = expression2;
                RangeLoopTransformer rangeLoopTransformer = this;
                boolean bl5 = false;
                this.specializeIteratorIfPossible((IrContainerExpression)$this$visitBlock_u24lambda_u243);
                return super.visitBlock(irBlock);
            }
            loopHeader = forLoopHeader;
            Iterable $this$any$iv = loopHeader.getLoopInitStatements();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrStatement it = (IrStatement)element$iv;
                    boolean bl6 = false;
                    IrAnnotationContainer irAnnotationContainer = it instanceof IrVariable ? (IrVariable)it : null;
                    boolean bl7 = irAnnotationContainer != null && (irAnnotationContainer = irAnnotationContainer.getType()) != null ? IrTypePredicatesKt.isNothing((IrType)irAnnotationContainer) : false;
                    if (!bl7) continue;
                    bl2 = true;
                    break block10;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            return super.visitBlock(expression2);
        }
        IrStatement loweredHeader = this.lowerHeader(iteratorVariable, loopHeader);
        LoopReplacement loopReplacement = this.lowerWhileLoop(oldLoop, loopHeader);
        if (loopReplacement == null) {
            return super.visitBlock(expression2);
        }
        LoopReplacement loopReplacement2 = loopReplacement;
        IrLoop newLoop = loopReplacement2.component1();
        IrExpression loopReplacementExpression = loopReplacement2.component2();
        this.oldLoopToNewLoop.put(oldLoop, newLoop);
        statements.set(0, loweredHeader);
        statements.set(1, loopReplacementExpression);
        return super.visitBlock(expression2);
    }

    private final IrStatement lowerHeader(IrVariable variable, ForLoopHeader loopHeader) {
        return new IrCompositeImpl(variable.getStartOffset(), variable.getEndOffset(), this.context.getIrBuiltIns().getUnitType(), null, loopHeader.getLoopInitStatements());
    }

    private final LoopReplacement lowerWhileLoop(IrWhileLoop loop, ForLoopHeader loopHeader) {
        IrExpression newBody;
        IrExpression irExpression;
        IrExpression irExpression2 = loop.getBody();
        Object object = irExpression2 instanceof IrContainerExpression ? (IrContainerExpression)irExpression2 : null;
        if (object == null || (object = object.getStatements()) == null) {
            return null;
        }
        Object loopBodyStatements = object;
        LoopVariableInfo loopVariableInfo = this.gatherLoopVariableInfo((List<IrStatement>)loopBodyStatements);
        IrVariable mainLoopVariable = loopVariableInfo.component1();
        int mainLoopVariableIndex = loopVariableInfo.component2();
        Map<Integer, IrVariable> loopVariableComponents = loopVariableInfo.component3();
        List<Integer> loopVariableComponentIndices = loopVariableInfo.component4();
        if (loopHeader.getConsumesLoopVariableComponents() && !Intrinsics.areEqual((Object)mainLoopVariable.getOrigin(), (Object)IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE())) {
            return null;
        }
        IrExpression irExpression3 = mainLoopVariable.getInitializer();
        Intrinsics.checkNotNull((Object)irExpression3);
        IrExpression initializer = irExpression3;
        DeclarationIrBuilder $this$lowerWhileLoop_u24lambda_u245 = LowerUtilsKt.createIrBuilder(this.context, this.getScopeOwnerSymbol(), initializer.getStartOffset(), initializer.getEndOffset());
        boolean bl2 = false;
        IrCompositeImpl replacement = new IrCompositeImpl(mainLoopVariable.getStartOffset(), mainLoopVariable.getEndOffset(), $this$lowerWhileLoop_u24lambda_u245.getContext().getIrBuiltIns().getUnitType(), IrStatementOrigin.Companion.getFOR_LOOP_NEXT(), loopHeader.initializeIteration(mainLoopVariable, loopVariableComponents, $this$lowerWhileLoop_u24lambda_u245, this.context));
        if (loopHeader.getConsumesLoopVariableComponents()) {
            Iterator iterator2 = CollectionsKt.asReversed(loopVariableComponentIndices).iterator();
            while (iterator2.hasNext()) {
                boolean bl3;
                int index2 = ((Number)iterator2.next()).intValue();
                boolean bl4 = bl3 = index2 > mainLoopVariableIndex;
                if (_Assertions.ENABLED && !bl3) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                loopBodyStatements.remove(index2);
            }
        }
        loopBodyStatements.set(mainLoopVariableIndex, replacement);
        IrExpression irExpression4 = loop.getBody();
        if (irExpression4 != null) {
            IrExpression it = irExpression4;
            boolean bl5 = false;
            irExpression = it instanceof IrContainerExpression && !IrExpressionsKt.isTransparentScope((IrContainerExpression)it) ? (IrExpression)new IrCompositeImpl(loop.getStartOffset(), loop.getEndOffset(), it.getType(), ((IrContainerExpression)it).getOrigin(), ((IrContainerExpression)it).getStatements()) : it;
        } else {
            irExpression = newBody = null;
        }
        if (newBody != null && this.loopBodyTransformer != null) {
            this.loopBodyTransformer.transform(this.context, newBody, mainLoopVariable, loopHeader, loopVariableComponents);
        }
        return loopHeader.buildLoop(LowerUtilsKt.createIrBuilder(this.context, this.getScopeOwnerSymbol(), loop.getStartOffset(), loop.getEndOffset()), loop, newBody);
    }

    private final void specializeIteratorIfPossible(IrContainerExpression irForLoopBlock) {
        block13: {
            IrVariable irVariable;
            IrStatement irStatement;
            IrStatement single$iv;
            Object receiverType;
            IrCall initializer;
            IrVariable iterator2;
            List<IrStatement> statements;
            block12: {
                statements = irForLoopBlock.getStatements();
                IrStatement irStatement2 = statements.get(0);
                Intrinsics.checkNotNull((Object)irStatement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrVariable");
                iterator2 = (IrVariable)irStatement2;
                IrExpression irExpression = iterator2.getInitializer();
                IrCall irCall = irExpression instanceof IrCall ? (IrCall)irExpression : null;
                if (irCall == null) {
                    return;
                }
                initializer = irCall;
                if (!AdditionalIrUtilsKt.hasEqualFqName(initializer.getSymbol().getOwner(), STDLIB_ITERATOR_FUNCTION_FQ_NAME)) {
                    return;
                }
                Object object = (IrExpression)initializer.getArguments().get(0);
                if (object == null || (object = ((IrExpression)object).getType()) == null) {
                    return;
                }
                receiverType = object;
                if (!IrTypeUtilsKt.isStrictSubtypeOfClass((IrType)receiverType, this.context.getIrBuiltIns().getIteratorClass())) {
                    return;
                }
                IrClass irClass = IrTypesKt.getClass((IrType)receiverType);
                if (irClass == null) {
                    return;
                }
                IrClass receiverClass = irClass;
                Sequence<IrSimpleFunction> $this$singleOrNull$iv = IrUtilsKt.getFunctions(receiverClass);
                boolean $i$f$singleOrNull = false;
                single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    IrSimpleFunction it = (IrSimpleFunction)element$iv;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)OperatorNameConventions.NEXT) && IrUtilsKt.hasShape$default(it, true, false, 0, 0, null, 30, null))) continue;
                    if (found$iv) {
                        irStatement = null;
                        break block12;
                    }
                    single$iv = (IrStatement)element$iv;
                    found$iv = true;
                }
                irStatement = !found$iv ? null : single$iv;
            }
            IrSimpleFunction irSimpleFunction = (IrSimpleFunction)irStatement;
            if (irSimpleFunction == null) {
                return;
            }
            IrSimpleFunction next = irSimpleFunction;
            IrVariable $this$specializeIteratorIfPossible_u24lambda_u248 = irVariable = iterator2;
            boolean bl3 = false;
            $this$specializeIteratorIfPossible_u24lambda_u248.setType((IrType)receiverType);
            $this$specializeIteratorIfPossible_u24lambda_u248.setInitializer((IrExpression)initializer.getArguments().get(0));
            IrStatement irStatement3 = statements.get(1);
            Intrinsics.checkNotNull((Object)irStatement3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrWhileLoop");
            IrWhileLoop loop = (IrWhileLoop)irStatement3;
            IrExpression irExpression = loop.getBody();
            Object object = irExpression instanceof IrBlock ? (IrBlock)irExpression : null;
            single$iv = object != null && (object = object.getStatements()) != null ? (IrStatement)CollectionsKt.firstOrNull((List)object) : null;
            IrVariable irVariable2 = single$iv instanceof IrVariable ? (IrVariable)single$iv : null;
            if (irVariable2 == null) {
                return;
            }
            IrVariable loopVariable = irVariable2;
            IrExpression irExpression2 = loop.getCondition();
            IrCall irCall = irExpression2 instanceof IrCall ? (IrCall)irExpression2 : null;
            if (irCall == null) {
                return;
            }
            IrCall loopCondition = irCall;
            IrExpression irExpression3 = loopCondition.getDispatchReceiver();
            if (irExpression3 != null) {
                irExpression3.setType((IrType)receiverType);
            }
            IrExpression nextCall = loopVariable.getInitializer();
            if (!(nextCall instanceof IrCall)) break block13;
            ((IrCall)nextCall).setSymbol(next.getSymbol());
            IrExpression irExpression4 = ((IrCall)nextCall).getDispatchReceiver();
            if (irExpression4 != null) {
                irExpression4.setType((IrType)receiverType);
            }
        }
    }

    private final LoopVariableInfo gatherLoopVariableInfo(List<IrStatement> statements) {
        boolean bl2;
        IrStatement mainLoopVariable = null;
        int mainLoopVariableIndex = -1;
        Map loopVariableComponents = new LinkedHashMap();
        List loopVariableComponentIndices = new ArrayList();
        Iterator iterator2 = ((Iterable)statements).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            IrStatementOrigin origin2;
            IrMemberAccessExpression initializer;
            IrMemberAccessExpression irMemberAccessExpression;
            int i2 = n2++;
            IrStatement stmt = (IrStatement)iterator2.next();
            if (!(stmt instanceof IrVariable)) continue;
            if (((IrVariable)stmt).getInitializer() != null) {
                IrExpression it;
                FindInitializerCallVisitor findInitializerCallVisitor;
                boolean bl3 = false;
                FindInitializerCallVisitor $this$gatherLoopVariableInfo_u24lambda_u2410_u24lambda_u249 = findInitializerCallVisitor = new FindInitializerCallVisitor((IrVariable)mainLoopVariable);
                boolean bl4 = false;
                IrVisitorsKt.acceptVoid((IrElement)it, $this$gatherLoopVariableInfo_u24lambda_u2410_u24lambda_u249);
                irMemberAccessExpression = findInitializerCallVisitor.getInitializerCall();
            } else {
                irMemberAccessExpression = null;
            }
            IrMemberAccessExpression irMemberAccessExpression2 = initializer = irMemberAccessExpression;
            IrStatementOrigin irStatementOrigin = origin2 = irMemberAccessExpression2 != null ? irMemberAccessExpression2.getOrigin() : null;
            if (Intrinsics.areEqual((Object)origin2, (Object)IrStatementOrigin.Companion.getFOR_LOOP_NEXT())) {
                mainLoopVariable = stmt;
                mainLoopVariableIndex = i2;
                continue;
            }
            if (!(origin2 instanceof IrStatementOrigin.COMPONENT_N)) continue;
            loopVariableComponents.put(((IrStatementOrigin.COMPONENT_N)origin2).getIndex(), stmt);
            loopVariableComponentIndices.add(i2);
        }
        if (mainLoopVariable == null) {
            boolean bl5 = false;
            String string = "No 'next' statement in for-loop";
            throw new IllegalStateException(string.toString());
        }
        boolean bl6 = bl2 = mainLoopVariableIndex >= 0;
        if (_Assertions.ENABLED && !bl2) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        return new LoopVariableInfo((IrVariable)mainLoopVariable, mainLoopVariableIndex, loopVariableComponents, loopVariableComponentIndices);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer$Companion;", "", "<init>", "()V", "STDLIB_ITERATOR_FUNCTION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getSTDLIB_ITERATOR_FUNCTION_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "ir.backend.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FqName getSTDLIB_ITERATOR_FUNCTION_FQ_NAME() {
            return STDLIB_ITERATOR_FUNCTION_FQ_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0007H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer$FindInitializerCallVisitor;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "mainLoopVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrVariable;)V", "initializerCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getInitializerCall", "()Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "setInitializerCall", "(Lorg/jetbrains/kotlin/ir/expressions/IrCall;)V", "visitElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitCall", "expression", "ir.backend.common"})
    private static final class FindInitializerCallVisitor
    extends IrVisitorVoid {
        @Nullable
        private final IrVariable mainLoopVariable;
        @Nullable
        private IrCall initializerCall;

        public FindInitializerCallVisitor(@Nullable IrVariable mainLoopVariable) {
            this.mainLoopVariable = mainLoopVariable;
        }

        @Nullable
        public final IrCall getInitializerCall() {
            return this.initializerCall;
        }

        public final void setInitializerCall(@Nullable IrCall irCall) {
            this.initializerCall = irCall;
        }

        @Override
        public void visitElement(@NotNull IrElement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            IrVisitorsKt.acceptChildrenVoid(element2, this);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void visitCall(@NotNull IrCall expression) {
            block7: {
                block8: {
                    block6: {
                        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                        var3_2 = expression.getOrigin();
                        if (!Intrinsics.areEqual((Object)var3_2, (Object)IrStatementOrigin.Companion.getFOR_LOOP_NEXT())) break block6;
                        v0 = expression;
                        break block7;
                    }
                    if (!(var3_2 instanceof IrStatementOrigin.COMPONENT_N)) break block8;
                    if (this.mainLoopVariable == null) ** GOTO lbl-1000
                    var4_3 = expression.getDispatchReceiver();
                    v1 = var4_3 instanceof IrGetValue != false ? (IrGetValue)var4_3 : null;
                    if (Intrinsics.areEqual((Object)(v1 != null ? v1.getSymbol() : null), (Object)this.mainLoopVariable.getSymbol())) {
                        v0 = expression;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = null;
                    }
                    break block7;
                }
                v0 = null;
            }
            candidateCall = v0;
            if (candidateCall == null) {
                super.visitCall(expression);
            } else if (this.initializerCall == null) {
                this.initializerCall = candidateCall;
            } else {
                v2 = new StringBuilder().append("Multiple initializer calls found. First: ");
                v3 = this.initializerCall;
                Intrinsics.checkNotNull((Object)v3);
                throw new IllegalStateException(v2.append(RenderIrElementKt.render$default(v3, null, 1, null)).append("\nSecond: ").append(RenderIrElementKt.render$default(candidateCall, null, 1, null)).toString());
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0003JC\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/RangeLoopTransformer$LoopVariableInfo;", "", "mainLoopVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "mainLoopVariableIndex", "", "loopVariableComponents", "", "loopVariableComponentIndices", "", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrVariable;ILjava/util/Map;Ljava/util/List;)V", "getMainLoopVariable", "()Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "getMainLoopVariableIndex", "()I", "getLoopVariableComponents", "()Ljava/util/Map;", "getLoopVariableComponentIndices", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "ir.backend.common"})
    private static final class LoopVariableInfo {
        @NotNull
        private final IrVariable mainLoopVariable;
        private final int mainLoopVariableIndex;
        @NotNull
        private final Map<Integer, IrVariable> loopVariableComponents;
        @NotNull
        private final List<Integer> loopVariableComponentIndices;

        public LoopVariableInfo(@NotNull IrVariable mainLoopVariable, int mainLoopVariableIndex, @NotNull Map<Integer, ? extends IrVariable> loopVariableComponents, @NotNull List<Integer> loopVariableComponentIndices) {
            Intrinsics.checkNotNullParameter((Object)mainLoopVariable, (String)"mainLoopVariable");
            Intrinsics.checkNotNullParameter(loopVariableComponents, (String)"loopVariableComponents");
            Intrinsics.checkNotNullParameter(loopVariableComponentIndices, (String)"loopVariableComponentIndices");
            this.mainLoopVariable = mainLoopVariable;
            this.mainLoopVariableIndex = mainLoopVariableIndex;
            this.loopVariableComponents = loopVariableComponents;
            this.loopVariableComponentIndices = loopVariableComponentIndices;
        }

        @NotNull
        public final IrVariable getMainLoopVariable() {
            return this.mainLoopVariable;
        }

        public final int getMainLoopVariableIndex() {
            return this.mainLoopVariableIndex;
        }

        @NotNull
        public final Map<Integer, IrVariable> getLoopVariableComponents() {
            return this.loopVariableComponents;
        }

        @NotNull
        public final List<Integer> getLoopVariableComponentIndices() {
            return this.loopVariableComponentIndices;
        }

        @NotNull
        public final IrVariable component1() {
            return this.mainLoopVariable;
        }

        public final int component2() {
            return this.mainLoopVariableIndex;
        }

        @NotNull
        public final Map<Integer, IrVariable> component3() {
            return this.loopVariableComponents;
        }

        @NotNull
        public final List<Integer> component4() {
            return this.loopVariableComponentIndices;
        }

        @NotNull
        public final LoopVariableInfo copy(@NotNull IrVariable mainLoopVariable, int mainLoopVariableIndex, @NotNull Map<Integer, ? extends IrVariable> loopVariableComponents, @NotNull List<Integer> loopVariableComponentIndices) {
            Intrinsics.checkNotNullParameter((Object)mainLoopVariable, (String)"mainLoopVariable");
            Intrinsics.checkNotNullParameter(loopVariableComponents, (String)"loopVariableComponents");
            Intrinsics.checkNotNullParameter(loopVariableComponentIndices, (String)"loopVariableComponentIndices");
            return new LoopVariableInfo(mainLoopVariable, mainLoopVariableIndex, loopVariableComponents, loopVariableComponentIndices);
        }

        public static /* synthetic */ LoopVariableInfo copy$default(LoopVariableInfo loopVariableInfo, IrVariable irVariable, int n2, Map map, List list, int n3, Object object) {
            if ((n3 & 1) != 0) {
                irVariable = loopVariableInfo.mainLoopVariable;
            }
            if ((n3 & 2) != 0) {
                n2 = loopVariableInfo.mainLoopVariableIndex;
            }
            if ((n3 & 4) != 0) {
                map = loopVariableInfo.loopVariableComponents;
            }
            if ((n3 & 8) != 0) {
                list = loopVariableInfo.loopVariableComponentIndices;
            }
            return loopVariableInfo.copy(irVariable, n2, map, list);
        }

        @NotNull
        public String toString() {
            return "LoopVariableInfo(mainLoopVariable=" + this.mainLoopVariable + ", mainLoopVariableIndex=" + this.mainLoopVariableIndex + ", loopVariableComponents=" + this.loopVariableComponents + ", loopVariableComponentIndices=" + this.loopVariableComponentIndices + ')';
        }

        public int hashCode() {
            int result2 = this.mainLoopVariable.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.mainLoopVariableIndex);
            result2 = result2 * 31 + ((Object)this.loopVariableComponents).hashCode();
            result2 = result2 * 31 + ((Object)this.loopVariableComponentIndices).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoopVariableInfo)) {
                return false;
            }
            LoopVariableInfo loopVariableInfo = (LoopVariableInfo)other;
            if (!Intrinsics.areEqual((Object)this.mainLoopVariable, (Object)loopVariableInfo.mainLoopVariable)) {
                return false;
            }
            if (this.mainLoopVariableIndex != loopVariableInfo.mainLoopVariableIndex) {
                return false;
            }
            if (!Intrinsics.areEqual(this.loopVariableComponents, loopVariableInfo.loopVariableComponents)) {
                return false;
            }
            return Intrinsics.areEqual(this.loopVariableComponentIndices, loopVariableInfo.loopVariableComponentIndices);
        }
    }
}

