/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThrottledLogger {
    @NotNull
    private final Logger logger;
    private final long ignoreRepeatedMessagesInMs;
    private final AtomicLong lastLoggedAtMsHolder;

    public ThrottledLogger(@NotNull Logger logger2, long ignoreRepeatedMessagesInMs) {
        if (logger2 == null) {
            ThrottledLogger.$$$reportNull$$$0(0);
        }
        this.lastLoggedAtMsHolder = new AtomicLong(0L);
        this.logger = Objects.requireNonNull(logger2, "logger");
        if (ignoreRepeatedMessagesInMs < 0L) {
            throw new IllegalArgumentException("ignoreRepeatedMessagesInMs(=" + ignoreRepeatedMessagesInMs + ") must be >=0");
        }
        this.ignoreRepeatedMessagesInMs = ignoreRepeatedMessagesInMs;
    }

    @NotNull
    public Logger wrappedLogger() {
        Logger logger2 = this.logger;
        if (logger2 == null) {
            ThrottledLogger.$$$reportNull$$$0(1);
        }
        return logger2;
    }

    public void debug(String message) {
        this.debug(message, null);
    }

    public void debug(String message, @Nullable Throwable t2) {
        long nowMs = System.currentTimeMillis();
        long lastLoggedAt = this.lastLoggedAtMsHolder.get();
        if (lastLoggedAt + this.ignoreRepeatedMessagesInMs < nowMs) {
            this.logger.debug(message, t2);
            this.forwardLastLogged(nowMs, lastLoggedAt);
        }
    }

    public void debug(@NotNull Supplier<String> messageSupplier) {
        if (messageSupplier == null) {
            ThrottledLogger.$$$reportNull$$$0(2);
        }
        long nowMs = System.currentTimeMillis();
        long lastLoggedAt = this.lastLoggedAtMsHolder.get();
        if (lastLoggedAt + this.ignoreRepeatedMessagesInMs < nowMs) {
            this.logger.debug(messageSupplier.get());
            this.forwardLastLogged(nowMs, lastLoggedAt);
        }
    }

    public void info(String message) {
        this.info(message, null);
    }

    public void info(String message, @Nullable Throwable t2) {
        long nowMs = System.currentTimeMillis();
        long lastLoggedAt = this.lastLoggedAtMsHolder.get();
        if (lastLoggedAt + this.ignoreRepeatedMessagesInMs < nowMs) {
            this.logger.info(message, t2);
            this.forwardLastLogged(nowMs, lastLoggedAt);
        }
    }

    public void info(@NotNull Supplier<String> messageSupplier) {
        if (messageSupplier == null) {
            ThrottledLogger.$$$reportNull$$$0(3);
        }
        long nowMs = System.currentTimeMillis();
        long lastLoggedAt = this.lastLoggedAtMsHolder.get();
        if (lastLoggedAt + this.ignoreRepeatedMessagesInMs < nowMs) {
            this.logger.info(messageSupplier.get());
            this.forwardLastLogged(nowMs, lastLoggedAt);
        }
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(String message, @Nullable Throwable t2) {
        long nowMs = System.currentTimeMillis();
        long lastLoggedAt = this.lastLoggedAtMsHolder.get();
        if (lastLoggedAt + this.ignoreRepeatedMessagesInMs < nowMs) {
            this.logger.warn(message, t2);
            this.forwardLastLogged(nowMs, lastLoggedAt);
        }
    }

    public void warn(@NotNull Supplier<String> messageSupplier) {
        if (messageSupplier == null) {
            ThrottledLogger.$$$reportNull$$$0(4);
        }
        long nowMs = System.currentTimeMillis();
        long lastLoggedAt = this.lastLoggedAtMsHolder.get();
        if (lastLoggedAt + this.ignoreRepeatedMessagesInMs < nowMs) {
            this.logger.warn(messageSupplier.get());
            this.forwardLastLogged(nowMs, lastLoggedAt);
        }
    }

    public void error(String message) {
        this.error(message, null);
    }

    public void error(String message, @Nullable Throwable t2) {
        long nowMs = System.currentTimeMillis();
        long lastLoggedAt = this.lastLoggedAtMsHolder.get();
        if (lastLoggedAt + this.ignoreRepeatedMessagesInMs < nowMs) {
            this.logger.error(message, t2);
            this.forwardLastLogged(nowMs, lastLoggedAt);
        }
    }

    public void error(@NotNull Supplier<String> messageSupplier) {
        if (messageSupplier == null) {
            ThrottledLogger.$$$reportNull$$$0(5);
        }
        long nowMs = System.currentTimeMillis();
        long lastLoggedAt = this.lastLoggedAtMsHolder.get();
        if (lastLoggedAt + this.ignoreRepeatedMessagesInMs < nowMs) {
            this.logger.error(messageSupplier.get());
            this.forwardLastLogged(nowMs, lastLoggedAt);
        }
    }

    private void forwardLastLogged(long nowMs, long lastLoggedAt) {
        while (!this.lastLoggedAtMsHolder.compareAndSet(lastLoggedAt, nowMs) && (lastLoggedAt = this.lastLoggedAtMsHolder.get()) < nowMs) {
        }
    }

    public String toString() {
        return "ThrottledLogger[ignoreRepeatedMessagesInMs: " + this.ignoreRepeatedMessagesInMs + ", lastLoggedAtMs:" + this.lastLoggedAtMsHolder.get() + ", wrapped logger:" + this.logger + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/diagnostic/ThrottledLogger";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageSupplier";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/diagnostic/ThrottledLogger";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "wrappedLogger";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "debug";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "info";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "warn";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "error";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

