/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.intrinsics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.IrInterpreterEnvironment;
import org.jetbrains.kotlin.ir.interpreter.SimpleInstruction;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.intrinsics.IntrinsicBase;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrTypesKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/EnumValues;", "Lorg/jetbrains/kotlin/ir/interpreter/intrinsics/IntrinsicBase;", "<init>", "()V", "getListOfAcceptableFunctions", "", "", "getEnumClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "environment", "Lorg/jetbrains/kotlin/ir/interpreter/IrInterpreterEnvironment;", "unwind", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "evaluate", "", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nIntrinsicImplementations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntrinsicImplementations.kt\norg/jetbrains/kotlin/ir/interpreter/intrinsics/EnumValues\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,370:1\n808#2,11:371\n1563#2:382\n1634#2,3:383\n808#2,11:386\n1563#2:397\n1634#2,3:398\n37#3:401\n36#3,3:402\n*S KotlinDebug\n*F\n+ 1 IntrinsicImplementations.kt\norg/jetbrains/kotlin/ir/interpreter/intrinsics/EnumValues\n*L\n102#1:371,11\n104#1:382\n104#1:383,3\n110#1:386,11\n110#1:397\n110#1:398,3\n111#1:401\n111#1:402,3\n*E\n"})
public final class EnumValues
extends IntrinsicBase {
    @NotNull
    public static final EnumValues INSTANCE = new EnumValues();

    private EnumValues() {
        super(null);
    }

    @Override
    @NotNull
    public List<String> getListOfAcceptableFunctions() {
        return CollectionsKt.listOf((Object)"kotlin.enumValues");
    }

    private final IrClass getEnumClass(IrFunction irFunction, IrInterpreterEnvironment environment) {
        IrClass irClass;
        if (Intrinsics.areEqual((Object)UtilsKt.getFqName(irFunction), (Object)"kotlin.enumValues")) {
            State state = environment.getCallStack$ir_interpreter().loadState(((IrTypeParameter)CollectionsKt.first(irFunction.getTypeParameters())).getSymbol());
            Intrinsics.checkNotNull((Object)state, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState");
            KTypeState kType = (KTypeState)state;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(kType.getIrType());
            Intrinsics.checkNotNull((Object)irClassSymbol);
            irClass = (IrClass)irClassSymbol.getOwner();
        } else {
            IrDeclarationParent irDeclarationParent = irFunction.getParent();
            Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
            irClass = (IrClass)irDeclarationParent;
        }
        return irClass;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Instruction> unwind(@NotNull IrFunction irFunction, @NotNull IrInterpreterEnvironment environment) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        IrClass enumClass = this.getEnumClass(irFunction, environment);
        Iterable $this$filterIsInstance$iv = enumClass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrEnumEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List enumEntries = (List)destination$iv$iv;
        $this$filterIsInstance$iv = CollectionsKt.reversed((Iterable)enumEntries);
        Collection collection = super.unwind(irFunction, environment);
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrEnumEntry irEnumEntry = (IrEnumEntry)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl2 = false;
            collection2.add(new SimpleInstruction((IrElement)it));
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void evaluate(@NotNull IrFunction irFunction, @NotNull IrInterpreterEnvironment environment) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        IrClass enumClass = this.getEnumClass(irFunction, environment);
        Iterable $this$filterIsInstance$iv = enumClass.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrEnumEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrEnumEntry irEnumEntry = (IrEnumEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(environment.getMapOfEnums$ir_interpreter().get(it.getSymbol()));
        }
        List enumEntries = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = enumEntries;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        environment.getCallStack$ir_interpreter().pushState(environment.convertToState$ir_interpreter(thisCollection$iv.toArray(new Complex[0]), irFunction.getReturnType()));
    }
}

