/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class InvalidVirtualFileAccessException
extends RuntimeException {
    public InvalidVirtualFileAccessException(@NotNull VirtualFile file) {
        if (file == null) {
            InvalidVirtualFileAccessException.$$$reportNull$$$0(0);
        }
        super(InvalidVirtualFileAccessException.composeMessage(file));
    }

    public InvalidVirtualFileAccessException(@NotNull String message) {
        if (message == null) {
            InvalidVirtualFileAccessException.$$$reportNull$$$0(1);
        }
        super(message);
    }

    @NonNls
    private static String composeMessage(@NotNull VirtualFile file) {
        if (file == null) {
            InvalidVirtualFileAccessException.$$$reportNull$$$0(2);
        }
        String url = file.getUrl();
        @NonNls String message = "Accessing invalid virtual file: " + url;
        try {
            VirtualFile found = VirtualFileManager.getInstance().findFileByUrl(url);
            message = message + "; original:" + InvalidVirtualFileAccessException.hashCode(file) + "; found:" + InvalidVirtualFileAccessException.hashCode(found);
            if (file.isInLocalFileSystem()) {
                boolean physicalExists = new File(file.getPath()).exists();
                message = message + "; File.exists()=" + physicalExists;
            } else {
                message = message + "; file system=" + file.getFileSystem();
            }
        }
        catch (Throwable t2) {
            message = message + "; lookup failed: " + t2.getMessage();
        }
        return message;
    }

    private static String hashCode(Object o2) {
        return o2 == null ? "-" : String.valueOf(o2.hashCode());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vfs/InvalidVirtualFileAccessException";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "composeMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

