/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSealedClassConstructorCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirSealedClassConstructorCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSealedClassConstructorCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSealedClassConstructorCallChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,35:1\n40#2:36\n*S KotlinDebug\n*F\n+ 1 FirSealedClassConstructorCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirSealedClassConstructorCallChecker\n*L\n30#1:36\n*E\n"})
public final class FirSealedClassConstructorCallChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirSealedClassConstructorCallChecker INSTANCE = new FirSealedClassConstructorCallChecker();

    private FirSealedClassConstructorCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirRegularClassSymbol firRegularClassSymbol;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirConstructorSymbol firConstructorSymbol = FirReferenceUtilsKt.toResolvedConstructorSymbol(expression2.getCalleeReference(), true);
        if (firConstructorSymbol == null) {
            return;
        }
        FirConstructorSymbol constructorSymbol = firConstructorSymbol;
        ConeClassLikeLookupTag coneClassLikeLookupTag = ConeTypeUtilsKt.getClassLikeLookupTagIfAny(TypeExpansionUtilsKt.fullyExpandedType$default(constructorSymbol.getResolvedReturnTypeRef().getConeType(), context2.getSession(), null, 2, null));
        if (coneClassLikeLookupTag == null || (firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(coneClassLikeLookupTag, context2.getSession())) == null) {
            return;
        }
        FirRegularClassSymbol typeSymbol = firRegularClassSymbol;
        FirClassLikeSymbol $this$modality$iv = typeSymbol;
        boolean $i$f$getModality = false;
        if ($this$modality$iv.getResolvedStatus().getModality() == Modality.SEALED) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirErrors.INSTANCE.getSEALED_CLASS_CONSTRUCTOR_CALL(), (DiagnosticContext)context2, null, 8, null);
        }
    }
}

