/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.EnumEntryInitializationCheckProcessor;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.EnumEntryInitializationInfoData;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousObjectExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.references.FirControlFlowGraphReference;
import org.jetbrains.kotlin.fir.resolve.dfa.FirControlFlowGraphReferenceImplKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J&\u0010\u0013\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumEntryInitializationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkClass", "klass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "enumEntrySymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirEnumEntrySymbol;", "checkEnumEntries", "enumEntries", "", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirEnumEntryInitializationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirEnumEntryInitializationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumEntryInitializationChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n70#2:120\n37#3:121\n1634#4,3:122\n1634#4,3:125\n*S KotlinDebug\n*F\n+ 1 FirEnumEntryInitializationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirEnumEntryInitializationChecker\n*L\n36#1:120\n36#1:121\n40#1:122,3\n57#1:125,3\n*E\n"})
public final class FirEnumEntryInitializationChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirEnumEntryInitializationChecker INSTANCE = new FirEnumEntryInitializationChecker();

    private FirEnumEntryInitializationChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirRegularClass declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirClass $this$isEnumClass$iv = declaration2;
        boolean $i$f$isEnumClass = false;
        Object $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
        boolean $i$f$isEnumClass22 = false;
        if (!($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS)) {
            return;
        }
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProperUninitializedEnumEntryAccessAnalysis)) {
            return;
        }
        List<FirEnumEntry> enumEntries = DeclarationUtilsKt.collectEnumEntries(declaration2, context2.getSession());
        if (enumEntries.isEmpty()) {
            return;
        }
        $this$isEnumClass$iv$iv = enumEntries;
        Collection $i$f$isEnumClass22 = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            FirEnumEntry firEnumEntry = (FirEnumEntry)item$iv;
            void var13_15 = destination$iv;
            boolean bl2 = false;
            var13_15.add(it.getSymbol());
        }
        Set enumEntrySymbols = (Set)destination$iv;
        this.checkClass(declaration2, enumEntrySymbols, context2, reporter);
        this.checkEnumEntries(enumEntries, context2, reporter);
    }

    private final void checkClass(FirClass klass, Set<FirEnumEntrySymbol> enumEntrySymbols, CheckerContext context2, DiagnosticReporter reporter) {
        Object object = klass.getControlFlowGraphReference();
        if (object == null || (object = FirControlFlowGraphReferenceImplKt.getControlFlowGraph((FirControlFlowGraphReference)object)) == null) {
            return;
        }
        Object graph2 = object;
        EnumEntryInitializationInfoData data = new EnumEntryInitializationInfoData(enumEntrySymbols, (FirBasedSymbol)klass.getSymbol(), (ControlFlowGraph)graph2);
        EnumEntryInitializationCheckProcessor.INSTANCE.check(data, true, context2, reporter);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkEnumEntries(List<? extends FirEnumEntry> enumEntries, CheckerContext context2, DiagnosticReporter reporter) {
        void $this$mapTo$iv;
        Iterable iterable = enumEntries;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            FirEnumEntry firEnumEntry = (FirEnumEntry)item$iv;
            Collection collection2 = collection;
            boolean bl2 = false;
            collection2.add(it.getSymbol());
        }
        Set enumEntrySymbols = (Set)collection;
        for (FirEnumEntry firEnumEntry : enumEntries) {
            FirExpression firExpression = firEnumEntry.getInitializer();
            FirPureAbstractElement firPureAbstractElement = firExpression instanceof FirAnonymousObjectExpression ? (FirAnonymousObjectExpression)firExpression : null;
            if (firPureAbstractElement == null || (firPureAbstractElement = firPureAbstractElement.getAnonymousObject()) == null) continue;
            FirPureAbstractElement entryObject = firPureAbstractElement;
            this.checkClass((FirClass)entryObject, enumEntrySymbols, context2, reporter);
            enumEntrySymbols.remove(firEnumEntry.getSymbol());
        }
    }
}

