/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.storage.ProtoMapValue;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/ProtoMapValueExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "Lorg/jetbrains/kotlin/incremental/storage/ProtoMapValue;", "<init>", "()V", "save", "", "output", "Ljava/io/DataOutput;", "value", "read", "input", "Ljava/io/DataInput;", "kotlin-build-common"})
public final class ProtoMapValueExternalizer
implements DataExternalizer<ProtoMapValue> {
    @NotNull
    public static final ProtoMapValueExternalizer INSTANCE = new ProtoMapValueExternalizer();

    private ProtoMapValueExternalizer() {
    }

    @Override
    public void save(@NotNull DataOutput output, @NotNull ProtoMapValue value2) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        output.writeBoolean(value2.isPackageFacade());
        output.writeInt(value2.getBytes().length);
        output.write(value2.getBytes());
        output.writeInt(value2.getStrings().length);
        for (String string2 : value2.getStrings()) {
            output.writeUTF(string2);
        }
    }

    @Override
    @NotNull
    public ProtoMapValue read(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        boolean isPackageFacade = input.readBoolean();
        int bytesLength = input.readInt();
        byte[] bytes = new byte[bytesLength];
        input.readFully(bytes, 0, bytesLength);
        int stringsLength = input.readInt();
        int n2 = 0;
        String[] stringArray = new String[stringsLength];
        while (n2 < stringsLength) {
            int n3 = n2++;
            Intrinsics.checkNotNullExpressionValue((Object)input.readUTF(), (String)"readUTF(...)");
        }
        String[] strings2 = stringArray;
        return new ProtoMapValue(isPackageFacade, bytes, strings2);
    }
}

