/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.checkers.expression;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.checkers.CheckerUtilsKt;
import org.jetbrains.kotlin.backend.common.checkers.context.CheckerContext;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrExpressionChecker;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrDeclarationReferenceBoundChecker;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrExpressionChecker;", "Lorg/jetbrains/kotlin/ir/expressions/IrDeclarationReference;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrDeclarationReferenceChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;", "ir.backend.common"})
public final class IrDeclarationReferenceBoundChecker
implements IrExpressionChecker<IrDeclarationReference> {
    @NotNull
    public static final IrDeclarationReferenceBoundChecker INSTANCE = new IrDeclarationReferenceBoundChecker();

    private IrDeclarationReferenceBoundChecker() {
    }

    @Override
    public void check(@NotNull IrDeclarationReference expression2, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (expression2 instanceof IrFieldAccessExpression) {
            IrType receiverType;
            IrExpression irExpression = ((IrFieldAccessExpression)expression2).getReceiver();
            IrType irType = receiverType = irExpression != null ? irExpression.getType() : null;
            if (receiverType instanceof IrDynamicType) {
                return;
            }
        }
        CheckerUtilsKt.ensureBound(expression2.getSymbol(), expression2, context2);
    }
}

