/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.diagnostics;

import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.FilteringIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticsElementsCache;
import org.jetbrains.kotlin.resolve.diagnostics.KotlinSuppressCache;
import org.jetbrains.kotlin.resolve.diagnostics.SimpleDiagnostics;

public class DiagnosticsWithSuppression
implements Diagnostics {
    private final KotlinSuppressCache suppressCache;
    private final Collection<Diagnostic> diagnostics;
    private final DiagnosticsElementsCache elementsCache;

    public DiagnosticsWithSuppression(@NotNull KotlinSuppressCache suppressCache, @NotNull Collection<Diagnostic> diagnostics) {
        if (suppressCache == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(0);
        }
        if (diagnostics == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(1);
        }
        this.diagnostics = diagnostics;
        this.suppressCache = suppressCache;
        this.elementsCache = new DiagnosticsElementsCache(this, suppressCache.getFilter());
    }

    @Override
    @NotNull
    public Diagnostics noSuppression() {
        return new SimpleDiagnostics((Collection<? extends Diagnostic>)this.diagnostics);
    }

    @Override
    @NotNull
    public Iterator<Diagnostic> iterator() {
        return new FilteringIterator(this.diagnostics.iterator(), arg_0 -> this.suppressCache.getFilter().invoke(arg_0));
    }

    @Override
    @NotNull
    public Collection<Diagnostic> all() {
        List list = CollectionsKt.filter(this.diagnostics, this.suppressCache.getFilter());
        if (list == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<Diagnostic> forElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(3);
        }
        Collection<Diagnostic> collection = this.elementsCache.getDiagnostics(psiElement);
        if (collection == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    public boolean isEmpty() {
        return this.all().isEmpty();
    }

    @Override
    @NotNull
    public ModificationTracker getModificationTracker() {
        throw new IllegalStateException("Trying to obtain modification tracker for readonly DiagnosticsWithSuppression.");
    }

    @Override
    public void setCallback(@NotNull DiagnosticSink.DiagnosticsCallback callback) {
        if (callback == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(5);
        }
    }

    @Override
    public boolean setCallbackIfNotSet(@NotNull DiagnosticSink.DiagnosticsCallback callback) {
        if (callback == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(6);
        }
        return false;
    }

    @Override
    public void resetCallback() {
    }

    @NotNull
    public Collection<Diagnostic> getDiagnostics() {
        Collection<Diagnostic> collection = this.diagnostics;
        if (collection == null) {
            DiagnosticsWithSuppression.$$$reportNull$$$0(7);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string2;
        switch (n2) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suppressCache";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostics";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/resolve/diagnostics/DiagnosticsWithSuppression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "all";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "forElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiagnostics";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCallback";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setCallbackIfNotSet";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

