/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirConflictsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirDeclarationCollector;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirConflictsDeclarationCheckerKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.PlatformConflictDeclarationsDiagnosticDispatcher;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRefsOwner;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameterKind;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeSessionKey;
import org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirPackageMemberScopeKt;
import org.jetbrains.kotlin.fir.scopes.impl.TypeAliasConstructorsSubstitutingScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\b\u001a\u00020\u0010H\u0002JB\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2 \u0010\u0012\u001a\u001c\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u0002H\u0002J*\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u001c2\u0010\u0010\u001d\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00140\u001e2\u0006\u0010\t\u001a\u00020\nH\u0002R\u001c\u0010\u0017\u001a\u00020\u0018*\u0006\u0012\u0002\b\u00030\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "getDestructuredParameters", "", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "reportConflicts", "declarationConflictingSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/utils/SmartSet;", "container", "isPrimaryConstructor", "", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Z", "checkFile", "file", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "inspector", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirDeclarationCollector;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirConflictsDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirConflictsDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsDeclarationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 ScopeSession.kt\norg/jetbrains/kotlin/fir/resolve/ScopeSession\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,188:1\n865#2,2:189\n774#2:191\n865#2,2:192\n1634#2,3:194\n1625#2:197\n1869#2:198\n1870#2:201\n1626#2:202\n1740#2,3:204\n1#3:199\n1#3:200\n216#4:203\n217#4:207\n18#5:208\n19#5:212\n20#5,2:217\n384#6,3:209\n387#6,4:213\n*S KotlinDebug\n*F\n+ 1 FirConflictsDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConflictsDeclarationChecker\n*L\n95#1:189,2\n101#1:191\n101#1:192,2\n102#1:194,3\n104#1:197\n104#1:198\n104#1:201\n104#1:202\n136#1:204,3\n104#1:200\n121#1:203\n121#1:207\n158#1:208\n158#1:212\n158#1:217,2\n158#1:209,3\n158#1:213,4\n*E\n"})
public final class FirConflictsDeclarationChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirConflictsDeclarationChecker INSTANCE = new FirConflictsDeclarationChecker();

    private FirConflictsDeclarationChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirDeclaration firDeclaration = declaration2;
        if (firDeclaration instanceof FirFile) {
            FirDeclarationCollector inspector = new FirDeclarationCollector(context2);
            this.checkFile((FirFile)declaration2, inspector, context2);
            this.reportConflicts(reporter, context2, (Map)inspector.getDeclarationConflictingSymbols(), declaration2);
        } else if (firDeclaration instanceof FirClass) {
            KtSourceElement ktSourceElement = ((FirClass)declaration2).getSource();
            if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind)) {
                FirConflictsHelpersKt.checkForLocalRedeclarations(((FirClass)declaration2).getTypeParameters(), context2, reporter);
            }
            FirDeclarationCollector inspector = new FirDeclarationCollector(context2);
            FirConflictsHelpersKt.collectClassMembers(inspector, ((FirClass)declaration2).getSymbol());
            this.reportConflicts(reporter, context2, (Map)inspector.getDeclarationConflictingSymbols(), declaration2);
        } else {
            KtSourceElement ktSourceElement = declaration2.getSource();
            if (!((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) && declaration2 instanceof FirTypeParameterRefsOwner) {
                if (declaration2 instanceof FirFunction || declaration2 instanceof FirProperty) {
                    List<FirVariable> destructuredParameters = this.getDestructuredParameters((FirCallableDeclaration)declaration2);
                    FirConflictsHelpersKt.checkForLocalRedeclarations(destructuredParameters, context2, reporter);
                }
                FirConflictsHelpersKt.checkForLocalRedeclarations(((FirTypeParameterRefsOwner)((Object)declaration2)).getTypeParameters(), context2, reporter);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<FirVariable> getDestructuredParameters(FirCallableDeclaration declaration2) {
        List list;
        block10: {
            Object element$iv;
            List $this$getDestructuredParameters_u24lambda_u247 = list = CollectionsKt.createListBuilder();
            boolean bl2 = false;
            Iterable $this$filterTo$iv = declaration2.getContextParameters();
            boolean $i$f$filterTo2 = false;
            List<FirValueParameter> list2 = $this$filterTo$iv.iterator();
            while (list2.hasNext()) {
                element$iv = list2.next();
                FirValueParameter it = (FirValueParameter)element$iv;
                boolean bl3 = false;
                if (!(it.getValueParameterKind() == FirValueParameterKind.ContextParameter)) continue;
                ((Collection)$this$getDestructuredParameters_u24lambda_u247).add(element$iv);
            }
            if (declaration2 instanceof FirFunction) {
                void destination$iv;
                void $this$mapTo$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                $this$getDestructuredParameters_u24lambda_u247.addAll((Collection)((FirFunction)declaration2).getValueParameters());
                Iterable $i$f$filterTo2 = ((FirFunction)declaration2).getValueParameters();
                boolean $i$f$filter22 = false;
                element$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    FirValueParameter it = (FirValueParameter)element$iv$iv;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)SpecialNames.DESTRUCT)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                Collection $i$f$filter22 = new LinkedHashSet();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    FirValueParameter firValueParameter = (FirValueParameter)item$iv;
                    void var15_30 = destination$iv;
                    boolean bl5 = false;
                    var15_30.add(it.getSymbol());
                }
                Set destructuredParametersBoxes = (Set)destination$iv;
                Object object = ((FirFunction)declaration2).getBody();
                if (object != null && (object = ((FirBlock)object).getStatements()) != null) {
                    Iterable $this$mapNotNullTo$iv = (Iterable)object;
                    boolean $i$f$mapNotNullTo = false;
                    Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv$iv.iterator();
                    while (iterator2.hasNext()) {
                        FirVariable firVariable;
                        Object element$iv$iv;
                        Object element$iv2 = element$iv$iv = iterator2.next();
                        boolean bl6 = false;
                        FirStatement it = (FirStatement)element$iv2;
                        boolean bl7 = false;
                        FirVariable firVariable2 = it instanceof FirVariable ? (FirVariable)it : null;
                        if (firVariable2 != null) {
                            FirVariable firVariable3;
                            FirVariable it2 = firVariable3 = firVariable2;
                            boolean bl8 = false;
                            firVariable = CollectionsKt.contains((Iterable)destructuredParametersBoxes, (Object)FirDeclarationUtilKt.getDestructuredParameter(it2)) ? firVariable3 : null;
                        } else {
                            firVariable = null;
                        }
                        if (firVariable == null) continue;
                        FirVariable it$iv = firVariable;
                        boolean bl9 = false;
                        ((Collection)$this$getDestructuredParameters_u24lambda_u247).add(it$iv);
                    }
                    List cfr_ignored_1 = (List)((Collection)$this$getDestructuredParameters_u24lambda_u247);
                }
            }
            if (!(declaration2 instanceof FirProperty)) break block10;
            Object object = ((FirProperty)declaration2).getSetter();
            if (object != null) {
                List<FirValueParameter> it = list2 = object;
                boolean bl10 = false;
                KtSourceElement ktSourceElement = ((FirPropertyAccessor)((Object)it)).getSource();
                object = !Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DefaultAccessor.INSTANCE) ? list2 : null;
                if (object != null && (object = ((FirPropertyAccessor)object).getValueParameters()) != null) {
                    List<FirValueParameter> it3 = object;
                    boolean bl11 = false;
                    $this$getDestructuredParameters_u24lambda_u247.addAll((Collection)it3);
                }
            }
        }
        return CollectionsKt.build((List)list);
    }

    private final void reportConflicts(DiagnosticReporter reporter, CheckerContext context2, Map<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> declarationConflictingSymbols, FirDeclaration container) {
        Map<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> $this$forEach$iv = declarationConflictingSymbols;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            PlatformConflictDeclarationsDiagnosticDispatcher dispatcher;
            KtDiagnosticFactory1<Collection<FirBasedSymbol<?>>> factory2;
            boolean bl2;
            KtSourceElement source;
            KtSourceElement ktSourceElement;
            Map.Entry<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> element$iv;
            Map.Entry<FirBasedSymbol<?>, SmartSet<FirBasedSymbol<?>>> entry = element$iv = iterator2.next();
            boolean bl3 = false;
            FirBasedSymbol<?> conflictingDeclaration = entry.getKey();
            SmartSet<FirBasedSymbol<?>> symbols = entry.getValue();
            FirBasedSymbol firBasedSymbol = conflictingDeclaration instanceof FirConstructorSymbol ? (FirConstructorSymbol)conflictingDeclaration : null;
            KtSourceElement typeAliasForConstructorSource = firBasedSymbol != null && (firBasedSymbol = TypeAliasConstructorsSubstitutingScopeKt.getTypeAliasForConstructor((FirFunctionSymbol)firBasedSymbol)) != null ? firBasedSymbol.getSource() : null;
            FirDeclarationOrigin origin2 = conflictingDeclaration.getOrigin();
            if (!(conflictingDeclaration instanceof FirCallableSymbol)) {
                ktSourceElement = conflictingDeclaration.getSource();
            } else if (Intrinsics.areEqual((Object)origin2, (Object)FirDeclarationOrigin.Source.INSTANCE)) {
                ktSourceElement = ((FirCallableSymbol)conflictingDeclaration).getSource();
            } else {
                if (Intrinsics.areEqual((Object)origin2, (Object)FirDeclarationOrigin.Library.INSTANCE)) continue;
                ktSourceElement = source = Intrinsics.areEqual((Object)origin2, (Object)FirDeclarationOrigin.Synthetic.TypeAliasConstructor.INSTANCE) ? typeAliasForConstructorSource : container.getSource();
            }
            if (symbols.isEmpty()) continue;
            if (INSTANCE.isPrimaryConstructor(conflictingDeclaration)) {
                boolean bl4;
                block13: {
                    Iterable $this$all$iv = (Iterable)((Object)symbols);
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl4 = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            FirBasedSymbol it = (FirBasedSymbol)element$iv2;
                            boolean bl5 = false;
                            if (INSTANCE.isPrimaryConstructor(it)) continue;
                            bl4 = false;
                            break block13;
                        }
                        bl4 = true;
                    }
                }
                if (bl4) continue;
            }
            if ((FirBasedSymbol)CollectionsKt.singleOrNull((Iterable)((Iterable)((Object)symbols))) != null) {
                FirBasedSymbol it;
                boolean bl6 = false;
                bl2 = FirConflictsHelpersKt.isExpectAndNonExpect(conflictingDeclaration, it);
            } else {
                bl2 = false;
            }
            if (bl2) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getEXPECT_AND_ACTUAL_IN_THE_SAME_MODULE(), conflictingDeclaration, (DiagnosticContext)context2, null, 16, null);
                continue;
            }
            PlatformConflictDeclarationsDiagnosticDispatcher platformConflictDeclarationsDiagnosticDispatcher = FirConflictsDeclarationCheckerKt.getConflictDeclarationsDiagnosticDispatcher(context2.getSession());
            if (platformConflictDeclarationsDiagnosticDispatcher == null) {
                platformConflictDeclarationsDiagnosticDispatcher = PlatformConflictDeclarationsDiagnosticDispatcher.DEFAULT.INSTANCE;
            }
            if ((factory2 = (dispatcher = platformConflictDeclarationsDiagnosticDispatcher).getDiagnostic(conflictingDeclaration, symbols, context2)) == null) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, factory2, symbols, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final boolean isPrimaryConstructor(FirBasedSymbol<?> $this$isPrimaryConstructor) {
        return $this$isPrimaryConstructor instanceof FirConstructorSymbol && ((FirConstructorSymbol)$this$isPrimaryConstructor).isPrimary() || Intrinsics.areEqual((Object)$this$isPrimaryConstructor.getOrigin(), (Object)FirDeclarationOrigin.Synthetic.TypeAliasConstructor.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkFile(FirFile file2, FirDeclarationCollector<FirBasedSymbol<?>> inspector, CheckerContext context2) {
        Object object;
        Object object2;
        void id$iv;
        void this_$iv;
        ScopeSession scopeSession = context2.getSessionHolder().getScopeSession();
        Pair pair = TuplesKt.to((Object)UtilsKt.getPackageFqName(file2), (Object)context2.getSession());
        ScopeSessionKey<Pair<FqName, FirSession>, FirPackageMemberScope> key$iv = FirPackageMemberScopeKt.getPACKAGE_MEMBER();
        boolean $i$f$getOrBuild = false;
        Map $this$getOrPut$iv$iv = this_$iv.scopes();
        boolean $i$f$getOrPut = false;
        Object value$iv$iv = $this$getOrPut$iv$iv.get(id$iv);
        if (value$iv$iv == null) {
            boolean bl2 = false;
            HashMap answer$iv$iv = new HashMap();
            $this$getOrPut$iv$iv.put(id$iv, answer$iv$iv);
            object2 = answer$iv$iv;
        } else {
            object2 = value$iv$iv;
        }
        $this$getOrPut$iv$iv = (Map)object2;
        $i$f$getOrPut = false;
        value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
        if (value$iv$iv == null) {
            boolean bl3 = false;
            boolean bl4 = false;
            FirPackageMemberScope answer$iv$iv = new FirPackageMemberScope(UtilsKt.getPackageFqName(file2), context2.getSessionHolder().getSession(), null, null, 12, null);
            $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
            object = answer$iv$iv;
        } else {
            object = value$iv$iv;
        }
        FirPackageMemberScope packageMemberScope = (FirPackageMemberScope)object;
        FirConflictsHelpersKt.collectTopLevel(inspector, file2, packageMemberScope);
    }
}

