/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.standalone.base.declarations;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.compiled.ClsStubBuilder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.impl.base.symbols.pointers.SmartPointerIncompatiblePsiFile;
import org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinDeclarationProvider;
import org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinDeclarationProviderFactory;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.standalone.base.declarations.KotlinFakeClsStubsCache;
import org.jetbrains.kotlin.analysis.api.standalone.base.declarations.KotlinStandaloneDeclarationIndex;
import org.jetbrains.kotlin.analysis.api.standalone.base.declarations.KotlinStandaloneDeclarationProvider;
import org.jetbrains.kotlin.analysis.api.standalone.base.declarations.KotlinStandaloneDeclarationProviderKt;
import org.jetbrains.kotlin.analysis.api.standalone.base.declarations.StringEnumerator;
import org.jetbrains.kotlin.analysis.decompiler.konan.K2KotlinNativeMetadataDecompiler;
import org.jetbrains.kotlin.analysis.decompiler.konan.KlibMetaFileType;
import org.jetbrains.kotlin.analysis.decompiler.psi.BuiltinsVirtualFileProvider;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInDecompiler;
import org.jetbrains.kotlin.analysis.decompiler.psi.KotlinBuiltInFileType;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.ClsKotlinBinaryClassCache;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.KotlinClsStubBuilder;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.stubs.KotlinClassOrObjectStub;
import org.jetbrains.kotlin.psi.stubs.KotlinFileStub;
import org.jetbrains.kotlin.psi.stubs.elements.KtStubElementTypes;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinClassStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFunctionStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinObjectStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPlaceHolderStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPropertyStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeAliasStubImpl;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002WXBQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0005H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001c\u001a\u00020\tH\u0002J \u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0006H\u0002J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010*\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020!2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010/\u001a\u00020!2\u0006\u0010,\u001a\u00020-H\u0002J\u0016\u00100\u001a\b\u0012\u0004\u0012\u0002010\b2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020!2\u0006\u00105\u001a\u000206H\u0002J\u0010\u00107\u001a\u00020!2\u0006\u00108\u001a\u000209H\u0002J\u0014\u0010:\u001a\u00020!2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030;H\u0002J\u0010\u0010<\u001a\u00020!2\u0006\u0010=\u001a\u00020\u001aH\u0002J\u0010\u0010>\u001a\u00020!2\u0006\u0010=\u001a\u00020\u001aH\u0002J$\u0010?\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001a0@2\u0006\u0010A\u001a\u00020\t2\u0006\u0010B\u001a\u00020CH\u0002J\"\u0010D\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\"\u001a\u00020\t2\u0006\u0010B\u001a\u00020C2\u0006\u0010E\u001a\u00020\fH\u0002J$\u0010F\u001a\u00020!2\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001a0@2\u0006\u0010H\u001a\u00020\fH\u0002J\u001a\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020L2\b\u0010M\u001a\u0004\u0018\u00010NH\u0016J\f\u0010O\u001a\b\u0012\u0004\u0012\u00020\u00060\bJ\f\u0010P\u001a\b\u0012\u0004\u0012\u00020(0\bJ\u0014\u0010Q\u001a\b\u0012\u0004\u0012\u00020(0R2\u0006\u0010S\u001a\u00020TJ\u0014\u0010U\u001a\b\u0012\u0004\u0012\u00020-0R2\u0006\u0010V\u001a\u00020TR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationProviderFactory;", "Lorg/jetbrains/kotlin/analysis/api/platform/declarations/KotlinDeclarationProviderFactory;", "project", "Lcom/intellij/openapi/project/Project;", "sourceKtFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "binaryRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "sharedBinaryRoots", "skipBuiltins", "", "shouldBuildStubsForBinaryLibraries", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Ljava/util/List;Ljava/util/List;ZZ)V", "index", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationIndex;", "psiManager", "Lcom/intellij/psi/PsiManager;", "Lorg/jetbrains/annotations/NotNull;", "builtInDecompiler", "Lorg/jetbrains/kotlin/analysis/decompiler/psi/KotlinBuiltInDecompiler;", "createdFakeKtFiles", "", "loadBuiltIns", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinFileStubImpl;", "createFileStub", "virtualFile", "registerStub", "stub", "isSharedStub", "addToFacadeFileMap", "", "file", "addToScriptMap", "script", "Lorg/jetbrains/kotlin/psi/KtScript;", "indexClassOrObject", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "addToClassMap", "indexSupertypeNames", "indexTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "addToTypeAliasMap", "indexTypeAliasDefinition", "findInheritableSimpleNames", "", "typeElement", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "addToFunctionMap", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "addToPropertyMap", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "indexStub", "Lcom/intellij/psi/stubs/StubElement;", "processMultifileClassStub", "ktFileStub", "processStub", "collectStubsFromBinaryRoot", "", "binaryRoot", "binaryClassCache", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/file/ClsKotlinBinaryClassCache;", "buildStubByVirtualFile", "preserveBuiltins", "processCollectedBinaryStubs", "stubs", "isSharedStubs", "createDeclarationProvider", "Lorg/jetbrains/kotlin/analysis/api/platform/declarations/KotlinDeclarationProvider;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "contextualModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "getAdditionalCreatedKtFiles", "getAllKtClasses", "getDirectInheritorCandidates", "", "baseClassName", "Lorg/jetbrains/kotlin/name/Name;", "getInheritableTypeAliases", "aliasedName", "KtClassFileViewProvider", "KtDeclarationRecorder", "analysis-api-standalone-base"})
@SourceDebugExtension(value={"SMAP\nKotlinStandaloneDeclarationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStandaloneDeclarationProvider.kt\norg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationProviderFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,633:1\n1869#2,2:634\n1563#2:637\n1634#2,3:638\n1869#2,2:641\n1869#2,2:643\n1617#2,9:646\n1869#2:655\n1870#2:657\n1626#2:658\n1869#2,2:659\n1869#2,2:661\n1869#2,2:663\n1869#2,2:665\n808#2,11:667\n1869#2,2:678\n1869#2,2:680\n1#3:636\n1#3:656\n51#4:645\n216#5,2:682\n*S KotlinDebug\n*F\n+ 1 KotlinStandaloneDeclarationProvider.kt\norg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationProviderFactory\n*L\n371#1:634,2\n391#1:637\n391#1:638,3\n392#1:641,2\n412#1:643,2\n178#1:646,9\n178#1:655\n178#1:657\n178#1:658\n292#1:659,2\n315#1:661,2\n424#1:663,2\n429#1:665,2\n436#1:667,11\n436#1:678,2\n458#1:680,2\n178#1:656\n177#1:645\n501#1:682,2\n*E\n"})
public final class KotlinStandaloneDeclarationProviderFactory
implements KotlinDeclarationProviderFactory {
    @NotNull
    private final Project project;
    @NotNull
    private final KotlinStandaloneDeclarationIndex index;
    @NotNull
    private final PsiManager psiManager;
    @NotNull
    private final KotlinBuiltInDecompiler builtInDecompiler;
    @NotNull
    private final List<KtFile> createdFakeKtFiles;

    /*
     * WARNING - void declaration
     */
    public KotlinStandaloneDeclarationProviderFactory(@NotNull Project project, @NotNull Collection<? extends KtFile> sourceKtFiles, @NotNull List<? extends VirtualFile> binaryRoots, @NotNull List<? extends VirtualFile> sharedBinaryRoots, boolean skipBuiltins, boolean shouldBuildStubsForBinaryLibraries) {
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(sourceKtFiles, (String)"sourceKtFiles");
        Intrinsics.checkNotNullParameter(binaryRoots, (String)"binaryRoots");
        Intrinsics.checkNotNullParameter(sharedBinaryRoots, (String)"sharedBinaryRoots");
        this.project = project;
        this.index = new KotlinStandaloneDeclarationIndex();
        PsiManager psiManager = PsiManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        this.psiManager = psiManager;
        this.builtInDecompiler = new KotlinBuiltInDecompiler();
        this.createdFakeKtFiles = new ArrayList();
        KtDeclarationRecorder recorder = new KtDeclarationRecorder();
        if (!skipBuiltins) {
            $this$forEach$iv = this.loadBuiltIns();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                KotlinFileStubImpl it = (KotlinFileStubImpl)element$iv;
                boolean bl2 = false;
                this.processStub(it);
            }
        }
        if (shouldBuildStubsForBinaryLibraries) {
            Iterator<? extends KtFile> $this$forEach$iv2;
            Iterator $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Object element$iv;
            ClsKotlinBinaryClassCache binaryClassCache = ClsKotlinBinaryClassCache.Companion.getInstance();
            for (VirtualFile virtualFile : sharedBinaryRoots) {
                element$iv = KotlinFakeClsStubsCache.Companion.processAdditionalRoot(virtualFile, (Function1<? super VirtualFile, ? extends Map<VirtualFile, KotlinFileStubImpl>>)((Function1)arg_0 -> KotlinStandaloneDeclarationProviderFactory._init_$lambda$24(this, binaryClassCache, arg_0)));
                if (element$iv == null) continue;
                Object it = element$iv;
                boolean bl3 = false;
                this.processCollectedBinaryStubs((Map<VirtualFile, KotlinFileStubImpl>)it, true);
            }
            Iterable $i$f$forEach2 = binaryRoots;
            boolean bl2 = false;
            element$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator bl3 = $this$mapTo$iv$iv.iterator();
            while (bl3.hasNext()) {
                void it;
                Object item$iv$iv = bl3.next();
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(this.collectStubsFromBinaryRoot((VirtualFile)it, binaryClassCache));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean bl4 = false;
            $this$mapTo$iv$iv = $this$forEach$iv2.iterator();
            while ($this$mapTo$iv$iv.hasNext()) {
                Object element$iv2 = $this$mapTo$iv$iv.next();
                Map it = (Map)element$iv2;
                boolean bl5 = false;
                this.processCollectedBinaryStubs(it, false);
            }
            for (KtFile ktFile : sourceKtFiles) {
                if (!ktFile.isCompiled()) continue;
                VirtualFile virtualFile = ktFile.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                KotlinFileStubImpl stub2 = this.buildStubByVirtualFile(virtualFile, binaryClassCache, skipBuiltins);
                if (stub2 == null) continue;
                stub2.setPsi((PsiFile)ktFile);
                this.processMultifileClassStub(stub2);
                ktFile.accept(recorder);
            }
        }
        $this$forEach$iv = sourceKtFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtFile file3 = (KtFile)element$iv;
            boolean bl6 = false;
            if (shouldBuildStubsForBinaryLibraries && file3.isCompiled()) continue;
            file3.accept(recorder);
        }
    }

    public /* synthetic */ KotlinStandaloneDeclarationProviderFactory(Project project, Collection collection, List list, List list2, boolean bl2, boolean bl3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            list = kotlin.collections.CollectionsKt.emptyList();
        }
        if ((n2 & 8) != 0) {
            list2 = kotlin.collections.CollectionsKt.emptyList();
        }
        if ((n2 & 0x10) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x20) != 0) {
            bl3 = false;
        }
        this(project, collection, list, list2, bl2, bl3);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KotlinFileStubImpl> loadBuiltIns() {
        void $this$mapNotNullTo$iv$iv;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        ComponentManager $this$serviceOrNull$iv = application;
        boolean $i$f$serviceOrNull = false;
        KotlinFakeClsStubsCache cacheService = $this$serviceOrNull$iv.getService(KotlinFakeClsStubsCache.class);
        Iterable $this$mapNotNull$iv = BuiltinsVirtualFileProvider.Companion.getInstance().getBuiltinVirtualFiles();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KotlinFileStubImpl kotlinFileStubImpl;
            KotlinFileStubImpl stub2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl2 = false;
            VirtualFile virtualFile = (VirtualFile)element$iv$iv;
            boolean bl3 = false;
            KotlinFileStubImpl kotlinFileStubImpl2 = stub2 = cacheService != null ? cacheService.processBuiltinsFile(virtualFile, (Function1<? super VirtualFile, KotlinFileStubImpl>)((Function1)new Function1<VirtualFile, KotlinFileStubImpl>((Object)this){

                public final KotlinFileStubImpl invoke(VirtualFile p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return KotlinStandaloneDeclarationProviderFactory.access$createFileStub((KotlinStandaloneDeclarationProviderFactory)this.receiver, p0);
                }
            })) : this.createFileStub(virtualFile);
            if (stub2 != null) {
                KotlinFileStubImpl it;
                boolean bl4 = false;
                kotlinFileStubImpl = this.registerStub(it, virtualFile, cacheService != null);
            } else {
                kotlinFileStubImpl = null;
            }
            if (kotlinFileStubImpl == null) continue;
            KotlinFileStubImpl it$iv$iv = kotlinFileStubImpl;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final KotlinFileStubImpl createFileStub(VirtualFile virtualFile) {
        FileContent fileContent = FileContentImpl.createByFile(virtualFile, this.project);
        Intrinsics.checkNotNullExpressionValue((Object)fileContent, (String)"createByFile(...)");
        FileContent fileContent2 = fileContent;
        PsiFileStub<?> psiFileStub = this.builtInDecompiler.getStubBuilder().buildFileStub(fileContent2);
        return psiFileStub instanceof KotlinFileStubImpl ? (KotlinFileStubImpl)psiFileStub : null;
    }

    private final KotlinFileStubImpl registerStub(KotlinFileStubImpl stub2, VirtualFile virtualFile, boolean isSharedStub) {
        KotlinFileStubImpl kotlinFileStubImpl;
        if (isSharedStub) {
            if (stub2.getPsi() != null) {
                throw new IllegalStateException("Shared stub cannot have psi as it leads to a project leak".toString());
            }
            StubElement stubElement = KotlinStandaloneDeclarationProviderKt.access$cloneStubRecursively(stub2, null, new UnsyncByteArrayOutputStream(), new StringEnumerator());
            Intrinsics.checkNotNull((Object)stubElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl");
            kotlinFileStubImpl = (KotlinFileStubImpl)stubElement;
        } else {
            kotlinFileStubImpl = stub2;
        }
        KotlinFileStubImpl resultStub = kotlinFileStubImpl;
        KtClassFileViewProvider fileViewProvider = new KtClassFileViewProvider(this.psiManager, virtualFile);
        SmartPointerIncompatiblePsiFile fakeFile2 = new SmartPointerIncompatiblePsiFile(fileViewProvider, resultStub){
            final /* synthetic */ KotlinFileStubImpl $resultStub;
            {
                this.$resultStub = $resultStub;
                super((FileViewProvider)$fileViewProvider, true);
            }

            public KotlinFileStub getStub() {
                return this.$resultStub;
            }

            protected KotlinFileStub getGreenStub() {
                return this.$resultStub;
            }

            public boolean isPhysical() {
                return false;
            }
        };
        resultStub.setPsi((PsiFile)((Object)fakeFile2));
        this.createdFakeKtFiles.add((KtFile)((Object)fakeFile2));
        return resultStub;
    }

    private final void addToFacadeFileMap(KtFile file2) {
        if (!file2.hasTopLevelCallables()) {
            return;
        }
        this.index.getFacadeFileMap$analysis_api_standalone_base().computeIfAbsent(file2.getPackageFqName(), arg_0 -> KotlinStandaloneDeclarationProviderFactory.addToFacadeFileMap$lambda$3(KotlinStandaloneDeclarationProviderFactory::addToFacadeFileMap$lambda$2, arg_0)).add(file2);
    }

    private final void addToScriptMap(KtScript script) {
        this.index.getScriptMap$analysis_api_standalone_base().computeIfAbsent(script.getFqName(), arg_0 -> KotlinStandaloneDeclarationProviderFactory.addToScriptMap$lambda$5(KotlinStandaloneDeclarationProviderFactory::addToScriptMap$lambda$4, arg_0)).add(script);
    }

    private final void indexClassOrObject(KtClassOrObject classOrObject) {
        this.addToClassMap(classOrObject);
        this.indexSupertypeNames(classOrObject);
    }

    private final void addToClassMap(KtClassOrObject classOrObject) {
        block0: {
            ClassId classId = classOrObject.getClassId();
            if (classId == null) break block0;
            ClassId classId2 = classId;
            boolean bl2 = false;
            this.index.getClassMap$analysis_api_standalone_base().computeIfAbsent(classId2.getPackageFqName(), arg_0 -> KotlinStandaloneDeclarationProviderFactory.addToClassMap$lambda$8$lambda$7(KotlinStandaloneDeclarationProviderFactory::addToClassMap$lambda$8$lambda$6, arg_0)).add(classOrObject);
        }
    }

    private final void indexSupertypeNames(KtClassOrObject classOrObject) {
        Iterable $this$forEach$iv = KtPsiUtilKt.getSuperNames(classOrObject);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String superName = (String)element$iv;
            boolean bl2 = false;
            this.index.getClassesBySupertypeName$analysis_api_standalone_base().computeIfAbsent(Name.identifier(superName), arg_0 -> KotlinStandaloneDeclarationProviderFactory.indexSupertypeNames$lambda$11$lambda$10(KotlinStandaloneDeclarationProviderFactory::indexSupertypeNames$lambda$11$lambda$9, arg_0)).add(classOrObject);
        }
    }

    private final void indexTypeAlias(KtTypeAlias typeAlias) {
        this.addToTypeAliasMap(typeAlias);
        this.indexTypeAliasDefinition(typeAlias);
    }

    private final void addToTypeAliasMap(KtTypeAlias typeAlias) {
        block0: {
            ClassId classId = typeAlias.getClassId();
            if (classId == null) break block0;
            ClassId classId2 = classId;
            boolean bl2 = false;
            this.index.getTypeAliasMap$analysis_api_standalone_base().computeIfAbsent(classId2.getPackageFqName(), arg_0 -> KotlinStandaloneDeclarationProviderFactory.addToTypeAliasMap$lambda$14$lambda$13(KotlinStandaloneDeclarationProviderFactory::addToTypeAliasMap$lambda$14$lambda$12, arg_0)).add(typeAlias);
        }
    }

    private final void indexTypeAliasDefinition(KtTypeAlias typeAlias) {
        KtElement ktElement = typeAlias.getTypeReference();
        if (ktElement == null || (ktElement = ktElement.getTypeElement()) == null) {
            return;
        }
        KtElement typeElement = ktElement;
        Iterable $this$forEach$iv = this.findInheritableSimpleNames((KtTypeElement)typeElement);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String expandedName = (String)element$iv;
            boolean bl2 = false;
            this.index.getInheritableTypeAliasesByAliasedName$analysis_api_standalone_base().computeIfAbsent(Name.identifier(expandedName), arg_0 -> KotlinStandaloneDeclarationProviderFactory.indexTypeAliasDefinition$lambda$17$lambda$16(KotlinStandaloneDeclarationProviderFactory::indexTypeAliasDefinition$lambda$17$lambda$15, arg_0)).add(typeAlias);
        }
    }

    private final List<String> findInheritableSimpleNames(KtTypeElement typeElement) {
        Object object;
        block5: {
            block6: {
                block7: {
                    KtTypeElement ktTypeElement;
                    block4: {
                        List list;
                        ktTypeElement = typeElement;
                        if (!(ktTypeElement instanceof KtUserType)) break block4;
                        String string2 = ((KtUserType)typeElement).getReferencedName();
                        if (string2 == null) {
                            return kotlin.collections.CollectionsKt.emptyList();
                        }
                        String referenceName = string2;
                        List $this$findInheritableSimpleNames_u24lambda_u2418 = list = kotlin.collections.CollectionsKt.createListBuilder();
                        boolean bl2 = false;
                        $this$findInheritableSimpleNames_u24lambda_u2418.add(referenceName);
                        KtFile ktFile = ((KtUserType)typeElement).getContainingKtFile();
                        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"getContainingKtFile(...)");
                        KtFile ktFile2 = ktFile;
                        if (!ktFile2.isCompiled()) {
                            Collection collection = $this$findInheritableSimpleNames_u24lambda_u2418;
                            KtFile ktFile3 = ((KtUserType)typeElement).getContainingKtFile();
                            Intrinsics.checkNotNullExpressionValue((Object)ktFile3, (String)"getContainingKtFile(...)");
                            CollectionsKt.addIfNotNull(collection, KtPsiUtilKt.getImportedSimpleNameByImportAlias(ktFile3, referenceName));
                        }
                        object = kotlin.collections.CollectionsKt.build((List)list);
                        break block5;
                    }
                    if (!(ktTypeElement instanceof KtNullableType)) break block6;
                    object = ((KtNullableType)typeElement).getInnerType();
                    if (object == null) break block7;
                    List p0 = object;
                    boolean bl3 = false;
                    List list = this.findInheritableSimpleNames((KtTypeElement)((Object)p0));
                    object = list;
                    if (list != null) break block5;
                }
                object = kotlin.collections.CollectionsKt.emptyList();
                break block5;
            }
            object = kotlin.collections.CollectionsKt.emptyList();
        }
        return object;
    }

    private final void addToFunctionMap(KtNamedFunction function2) {
        if (!function2.isTopLevel()) {
            return;
        }
        PsiElement psiElement = function2.getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        FqName packageFqName = ((KtFile)psiElement).getPackageFqName();
        this.index.getTopLevelFunctionMap$analysis_api_standalone_base().computeIfAbsent(packageFqName, arg_0 -> KotlinStandaloneDeclarationProviderFactory.addToFunctionMap$lambda$20(KotlinStandaloneDeclarationProviderFactory::addToFunctionMap$lambda$19, arg_0)).add(function2);
    }

    private final void addToPropertyMap(KtProperty property2) {
        if (!property2.isTopLevel()) {
            return;
        }
        PsiElement psiElement = property2.getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        FqName packageFqName = ((KtFile)psiElement).getPackageFqName();
        this.index.getTopLevelPropertyMap$analysis_api_standalone_base().computeIfAbsent(packageFqName, arg_0 -> KotlinStandaloneDeclarationProviderFactory.addToPropertyMap$lambda$22(KotlinStandaloneDeclarationProviderFactory::addToPropertyMap$lambda$21, arg_0)).add(property2);
    }

    /*
     * WARNING - void declaration
     */
    private final void indexStub(StubElement<?> stub2) {
        block5: {
            void $this$filterIsInstanceTo$iv$iv;
            StubElement<?> stubElement;
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block4: {
                                stubElement = stub2;
                                if (!(stubElement instanceof KotlinClassStubImpl)) break block4;
                                Object t2 = ((KotlinClassStubImpl)stub2).getPsi();
                                Intrinsics.checkNotNullExpressionValue(t2, (String)"getPsi(...)");
                                this.indexClassOrObject((KtClassOrObject)t2);
                                List<StubElement> list = ((KotlinClassStubImpl)stub2).getChildrenStubs();
                                Intrinsics.checkNotNullExpressionValue(list, (String)"getChildrenStubs(...)");
                                Iterable $this$forEach$iv = list;
                                boolean $i$f$forEach = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    StubElement p0 = (StubElement)element$iv;
                                    boolean bl2 = false;
                                    this.indexStub(p0);
                                }
                                break block5;
                            }
                            if (!(stubElement instanceof KotlinObjectStubImpl)) break block6;
                            Object t3 = ((KotlinObjectStubImpl)stub2).getPsi();
                            Intrinsics.checkNotNullExpressionValue(t3, (String)"getPsi(...)");
                            this.indexClassOrObject((KtClassOrObject)t3);
                            List<StubElement> list = ((KotlinObjectStubImpl)stub2).getChildrenStubs();
                            Intrinsics.checkNotNullExpressionValue(list, (String)"getChildrenStubs(...)");
                            Iterable $this$forEach$iv = list;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                StubElement p0 = (StubElement)element$iv;
                                boolean bl3 = false;
                                this.indexStub(p0);
                            }
                            break block5;
                        }
                        if (!(stubElement instanceof KotlinTypeAliasStubImpl)) break block7;
                        Object t4 = ((KotlinTypeAliasStubImpl)stub2).getPsi();
                        Intrinsics.checkNotNullExpressionValue(t4, (String)"getPsi(...)");
                        this.indexTypeAlias((KtTypeAlias)t4);
                        break block5;
                    }
                    if (!(stubElement instanceof KotlinFunctionStubImpl)) break block8;
                    Object t5 = ((KotlinFunctionStubImpl)stub2).getPsi();
                    Intrinsics.checkNotNullExpressionValue(t5, (String)"getPsi(...)");
                    this.addToFunctionMap((KtNamedFunction)t5);
                    break block5;
                }
                if (!(stubElement instanceof KotlinPropertyStubImpl)) break block9;
                Object t6 = ((KotlinPropertyStubImpl)stub2).getPsi();
                Intrinsics.checkNotNullExpressionValue(t6, (String)"getPsi(...)");
                this.addToPropertyMap((KtProperty)t6);
                break block5;
            }
            if (!(stubElement instanceof KotlinPlaceHolderStubImpl) || !Intrinsics.areEqual((Object)((KotlinPlaceHolderStubImpl)stub2).getStubType(), KtStubElementTypes.CLASS_BODY)) break block5;
            List<StubElement> list = ((KotlinPlaceHolderStubImpl)stub2).getChildrenStubs();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getChildrenStubs(...)");
            Iterable $this$filterIsInstance$iv = list;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KotlinClassOrObjectStub)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StubElement p0 = (StubElement)element$iv;
                boolean bl4 = false;
                this.indexStub(p0);
            }
        }
    }

    private final void processMultifileClassStub(KotlinFileStubImpl ktFileStub) {
        PsiElement psiElement = ktFileStub.getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
        KtFile ktFile = (KtFile)psiElement;
        List<String> list = ktFileStub.getFacadePartSimpleNames();
        if (list == null) {
            return;
        }
        List<String> partNames = list;
        FqName packageFqName = ktFileStub.getPackageFqName();
        for (String partName : partNames) {
            Name name2 = Name.identifier(partName);
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            FqName multiFileClassPartFqName = packageFqName.child(name2);
            this.index.getMultiFileClassPartMap$analysis_api_standalone_base().computeIfAbsent(multiFileClassPartFqName, arg_0 -> KotlinStandaloneDeclarationProviderFactory.processMultifileClassStub$lambda$33(KotlinStandaloneDeclarationProviderFactory::processMultifileClassStub$lambda$32, arg_0)).add(ktFile);
        }
    }

    private final void processStub(KotlinFileStubImpl ktFileStub) {
        PsiElement psiElement = ktFileStub.getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
        this.addToFacadeFileMap((KtFile)psiElement);
        this.processMultifileClassStub(ktFileStub);
        List<StubElement> list = ktFileStub.getChildrenStubs();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getChildrenStubs(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StubElement p0 = (StubElement)element$iv;
            boolean bl2 = false;
            this.indexStub(p0);
        }
    }

    private final Map<VirtualFile, KotlinFileStubImpl> collectStubsFromBinaryRoot(VirtualFile binaryRoot, ClsKotlinBinaryClassCache binaryClassCache) {
        Map map;
        Map $this$collectStubsFromBinaryRoot_u24lambda_u2435 = map = MapsKt.createMapBuilder();
        boolean bl2 = false;
        VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{};
        VfsUtilCore.visitChildrenRecursively(binaryRoot, new VirtualFileVisitor<Void>(this, binaryClassCache, (Map<VirtualFile, KotlinFileStubImpl>)$this$collectStubsFromBinaryRoot_u24lambda_u2435, optionArray){
            final /* synthetic */ KotlinStandaloneDeclarationProviderFactory this$0;
            final /* synthetic */ ClsKotlinBinaryClassCache $binaryClassCache;
            final /* synthetic */ Map<VirtualFile, KotlinFileStubImpl> $this_buildMap;
            {
                this.this$0 = $receiver;
                this.$binaryClassCache = $binaryClassCache;
                this.$this_buildMap = $receiver2;
                super($super_call_param$1);
            }

            public boolean visitFile(VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                if (!file2.isDirectory()) {
                    KotlinFileStubImpl kotlinFileStubImpl = KotlinStandaloneDeclarationProviderFactory.access$buildStubByVirtualFile(this.this$0, file2, this.$binaryClassCache, false);
                    if (kotlinFileStubImpl == null) {
                        return true;
                    }
                    KotlinFileStubImpl stub2 = kotlinFileStubImpl;
                    this.$this_buildMap.put(file2, stub2);
                }
                return true;
            }
        });
        return MapsKt.build((Map)map);
    }

    private final KotlinFileStubImpl buildStubByVirtualFile(VirtualFile file2, ClsKotlinBinaryClassCache binaryClassCache, boolean preserveBuiltins) {
        ClsStubBuilder clsStubBuilder;
        FileContent fileContent = FileContentImpl.createByFile(file2);
        Intrinsics.checkNotNullExpressionValue((Object)fileContent, (String)"createByFile(...)");
        FileContent fileContent2 = fileContent;
        FileType fileType = fileContent2.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        FileType fileType2 = fileType;
        Object object = fileType2;
        if (Intrinsics.areEqual((Object)object, (Object)JavaClassFileType.INSTANCE) && binaryClassCache.isKotlinJvmCompiledFile(file2, fileContent2.getContent())) {
            clsStubBuilder = new KotlinClsStubBuilder();
        } else if (Intrinsics.areEqual((Object)object, (Object)KotlinBuiltInFileType.INSTANCE) && (preserveBuiltins || !Intrinsics.areEqual((Object)file2.getExtension(), (Object)"kotlin_builtins"))) {
            clsStubBuilder = this.builtInDecompiler.getStubBuilder();
        } else if (Intrinsics.areEqual((Object)object, (Object)KlibMetaFileType.INSTANCE)) {
            clsStubBuilder = new K2KotlinNativeMetadataDecompiler().getStubBuilder();
        } else {
            return null;
        }
        ClsStubBuilder stubBuilder = clsStubBuilder;
        object = stubBuilder.buildFileStub(fileContent2);
        return object instanceof KotlinFileStubImpl ? (KotlinFileStubImpl)object : null;
    }

    private final void processCollectedBinaryStubs(Map<VirtualFile, KotlinFileStubImpl> stubs, boolean isSharedStubs) {
        Map<VirtualFile, KotlinFileStubImpl> $this$forEach$iv = stubs;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<VirtualFile, KotlinFileStubImpl>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<VirtualFile, KotlinFileStubImpl> element$iv;
            Map.Entry<VirtualFile, KotlinFileStubImpl> entry = element$iv = iterator2.next();
            boolean bl2 = false;
            KotlinFileStubImpl stub2 = this.registerStub(entry.getValue(), entry.getKey(), isSharedStubs);
            this.processStub(stub2);
        }
    }

    @Override
    @NotNull
    public KotlinDeclarationProvider createDeclarationProvider(@NotNull GlobalSearchScope scope, @Nullable KaModule contextualModule) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return new KotlinStandaloneDeclarationProvider(this.index, scope);
    }

    @NotNull
    public final List<KtFile> getAdditionalCreatedKtFiles() {
        return this.createdFakeKtFiles;
    }

    @NotNull
    public final List<KtClassOrObject> getAllKtClasses() {
        return (List)AddToStdlibKt.flattenTo((Iterable)this.index.getClassMap$analysis_api_standalone_base().values(), (Collection)new ArrayList());
    }

    @NotNull
    public final Set<KtClassOrObject> getDirectInheritorCandidates(@NotNull Name baseClassName) {
        Intrinsics.checkNotNullParameter((Object)baseClassName, (String)"baseClassName");
        Set set = this.index.getClassesBySupertypeName$analysis_api_standalone_base().get(baseClassName);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    @NotNull
    public final Set<KtTypeAlias> getInheritableTypeAliases(@NotNull Name aliasedName) {
        Intrinsics.checkNotNullParameter((Object)aliasedName, (String)"aliasedName");
        Set set = this.index.getInheritableTypeAliasesByAliasedName$analysis_api_standalone_base().get(aliasedName);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private static final Set addToFacadeFileMap$lambda$2(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set addToFacadeFileMap$lambda$3(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set addToScriptMap$lambda$4(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set addToScriptMap$lambda$5(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set addToClassMap$lambda$8$lambda$6(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set addToClassMap$lambda$8$lambda$7(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set indexSupertypeNames$lambda$11$lambda$9(Name it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set indexSupertypeNames$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set addToTypeAliasMap$lambda$14$lambda$12(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set addToTypeAliasMap$lambda$14$lambda$13(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set indexTypeAliasDefinition$lambda$17$lambda$15(Name it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set indexTypeAliasDefinition$lambda$17$lambda$16(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set addToFunctionMap$lambda$19(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set addToFunctionMap$lambda$20(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Set addToPropertyMap$lambda$21(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set addToPropertyMap$lambda$22(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    private static final Map _init_$lambda$24(KotlinStandaloneDeclarationProviderFactory this$0, ClsKotlinBinaryClassCache $binaryClassCache, VirtualFile additionalRoot) {
        Intrinsics.checkNotNullParameter((Object)additionalRoot, (String)"additionalRoot");
        return this$0.collectStubsFromBinaryRoot(additionalRoot, $binaryClassCache);
    }

    private static final Set processMultifileClassStub$lambda$32(FqName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashSet();
    }

    private static final Set processMultifileClassStub$lambda$33(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ KotlinFileStubImpl access$createFileStub(KotlinStandaloneDeclarationProviderFactory $this, VirtualFile virtualFile) {
        return $this.createFileStub(virtualFile);
    }

    public static final /* synthetic */ KotlinFileStubImpl access$buildStubByVirtualFile(KotlinStandaloneDeclarationProviderFactory $this, VirtualFile file2, ClsKotlinBinaryClassCache binaryClassCache, boolean preserveBuiltins) {
        return $this.buildStubByVirtualFile(file2, binaryClassCache, preserveBuiltins);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationProviderFactory$KtClassFileViewProvider;", "Lcom/intellij/psi/SingleRootFileViewProvider;", "psiManager", "Lcom/intellij/psi/PsiManager;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/psi/PsiManager;Lcom/intellij/openapi/vfs/VirtualFile;)V", "analysis-api-standalone-base"})
    private static final class KtClassFileViewProvider
    extends SingleRootFileViewProvider {
        public KtClassFileViewProvider(@NotNull PsiManager psiManager, @NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)psiManager, (String)"psiManager");
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            super(psiManager, virtualFile, true, KotlinLanguage.INSTANCE);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u0019H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationProviderFactory$KtDeclarationRecorder;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationProviderFactory;)V", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitElement", "element", "Lcom/intellij/psi/PsiElement;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitClassOrObject", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitTypeAlias", "typeAlias", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "analysis-api-standalone-base"})
    @SourceDebugExtension(value={"SMAP\nKotlinStandaloneDeclarationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinStandaloneDeclarationProvider.kt\norg/jetbrains/kotlin/analysis/api/standalone/base/declarations/KotlinStandaloneDeclarationProviderFactory$KtDeclarationRecorder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,633:1\n1#2:634\n*E\n"})
    private final class KtDeclarationRecorder
    extends KtVisitorVoid {
        @Override
        public void visitBinaryExpression(@NotNull KtBinaryExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            PsiUtilsKt.visitBinaryExpressionUsingStack(this, expression2);
        }

        @Override
        public void visitElement(@NotNull PsiElement element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            element2.acceptChildren(this);
        }

        @Override
        public void visitKtFile(@NotNull KtFile file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            KotlinStandaloneDeclarationProviderFactory.this.addToFacadeFileMap(file2);
            KtScript ktScript = file2.getScript();
            if (ktScript != null) {
                KtScript ktScript2 = ktScript;
                KotlinStandaloneDeclarationProviderFactory kotlinStandaloneDeclarationProviderFactory = KotlinStandaloneDeclarationProviderFactory.this;
                KtScript it = ktScript2;
                boolean bl2 = false;
                kotlinStandaloneDeclarationProviderFactory.addToScriptMap(it);
            }
            super.visitKtFile(file2);
        }

        @Override
        public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
            Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
            KotlinStandaloneDeclarationProviderFactory.this.indexClassOrObject(classOrObject);
            super.visitClassOrObject(classOrObject);
        }

        @Override
        public void visitTypeAlias(@NotNull KtTypeAlias typeAlias) {
            Intrinsics.checkNotNullParameter((Object)typeAlias, (String)"typeAlias");
            KotlinStandaloneDeclarationProviderFactory.this.indexTypeAlias(typeAlias);
            super.visitTypeAlias(typeAlias);
        }

        @Override
        public void visitNamedFunction(@NotNull KtNamedFunction function2) {
            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
            KotlinStandaloneDeclarationProviderFactory.this.addToFunctionMap(function2);
            super.visitNamedFunction(function2);
        }

        @Override
        public void visitProperty(@NotNull KtProperty property2) {
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            KotlinStandaloneDeclarationProviderFactory.this.addToPropertyMap(property2);
            super.visitProperty(property2);
        }
    }
}

