/*
 * Decompiled with CFR 0.152.
 */
package one.util.streamex;

import java.util.BitSet;
import java.util.HashMap;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.function.LongFunction;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import java.util.stream.Collector;
import one.util.streamex.Internals;
import one.util.streamex.MergingCollector;

public interface LongCollector<A, R>
extends MergingCollector<Long, A, R> {
    public ObjLongConsumer<A> longAccumulator();

    @Override
    default public BiConsumer<A, Long> accumulator() {
        return this.longAccumulator()::accept;
    }

    default public <RR> LongCollector<A, RR> andThen(Function<R, RR> finisher) {
        return LongCollector.of(this.supplier(), this.longAccumulator(), this.merger(), this.finisher().andThen(finisher));
    }

    public static <R> LongCollector<R, R> of(Supplier<R> supplier, ObjLongConsumer<R> longAccumulator, BiConsumer<R, R> merger) {
        return new Internals.LongCollectorImpl(supplier, longAccumulator, merger, Function.identity(), Internals.ID_CHARACTERISTICS);
    }

    public static <A, R> LongCollector<?, R> of(Collector<Long, A, R> collector) {
        if (collector instanceof LongCollector) {
            return (LongCollector)collector;
        }
        return LongCollector.mappingToObj(Long::valueOf, collector);
    }

    public static <A, R> LongCollector<A, R> of(Supplier<A> supplier, ObjLongConsumer<A> longAccumulator, BiConsumer<A, A> merger, Function<A, R> finisher) {
        return new Internals.LongCollectorImpl<A, R>(supplier, longAccumulator, merger, finisher, Internals.NO_CHARACTERISTICS);
    }

    public static LongCollector<?, String> joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return Internals.PartialCollector.joining(delimiter, prefix, suffix, true).asLong(Internals.joinAccumulatorLong(delimiter));
    }

    public static LongCollector<?, String> joining(CharSequence delimiter) {
        return Internals.PartialCollector.joining(delimiter, null, null, false).asLong(Internals.joinAccumulatorLong(delimiter));
    }

    public static LongCollector<?, Long> counting() {
        return Internals.PartialCollector.longSum().asLong((box, i2) -> {
            box[0] = box[0] + 1L;
        });
    }

    public static LongCollector<?, Integer> countingInt() {
        return Internals.PartialCollector.intSum().asLong((box, i2) -> {
            box[0] = box[0] + 1;
        });
    }

    public static LongCollector<?, Long> summing() {
        return Internals.PartialCollector.longSum().asLong((box, i2) -> {
            box[0] = box[0] + i2;
        });
    }

    public static LongCollector<?, OptionalDouble> averaging() {
        return LongCollector.of(Internals.AverageLong::new, Internals.AverageLong::accept, Internals.AverageLong::combine, Internals.AverageLong::result);
    }

    public static LongCollector<?, OptionalLong> min() {
        return LongCollector.reducing(Long::min);
    }

    public static LongCollector<?, OptionalLong> max() {
        return LongCollector.reducing(Long::max);
    }

    public static <A, R> LongCollector<?, R> mapping(LongUnaryOperator mapper, LongCollector<A, R> downstream) {
        ObjLongConsumer downstreamAccumulator = downstream.longAccumulator();
        return new Internals.LongCollectorImpl(downstream.supplier(), (r2, t2) -> downstreamAccumulator.accept(r2, mapper.applyAsLong(t2)), downstream.merger(), downstream.finisher(), downstream.characteristics());
    }

    public static <U, A, R> LongCollector<?, R> mappingToObj(LongFunction<U> mapper, Collector<U, A, R> downstream) {
        BiConsumer accumulator = downstream.accumulator();
        if (downstream instanceof MergingCollector) {
            return new Internals.LongCollectorImpl<Object, R>(downstream.supplier(), (acc, i2) -> accumulator.accept(acc, mapper.apply(i2)), ((MergingCollector)downstream).merger(), downstream.finisher(), downstream.characteristics());
        }
        return Internals.Box.partialCollector(downstream).asLong((box, i2) -> accumulator.accept(box.a, mapper.apply(i2)));
    }

    public static LongCollector<?, OptionalLong> reducing(LongBinaryOperator op) {
        return LongCollector.of(Internals.PrimitiveBox::new, (A box, long l2) -> {
            if (!box.b) {
                box.b = true;
                box.l = l2;
            } else {
                box.l = op.applyAsLong(box.l, l2);
            }
        }, (A box1, A box2) -> {
            if (box2.b) {
                if (!box1.b) {
                    box1.from((Internals.PrimitiveBox)box2);
                } else {
                    box1.l = op.applyAsLong(box1.l, box2.l);
                }
            }
        }, Internals.PrimitiveBox::asLong);
    }

    public static LongCollector<?, Long> reducing(long identity, LongBinaryOperator op) {
        return LongCollector.of(() -> new long[]{identity}, (A box, long i2) -> {
            box[0] = op.applyAsLong(box[0], i2);
        }, (A box1, A box2) -> {
            box1[0] = op.applyAsLong(box1[0], box2[0]);
        }, Internals.UNBOX_LONG);
    }

    public static LongCollector<?, LongSummaryStatistics> summarizing() {
        return LongCollector.of(LongSummaryStatistics::new, LongSummaryStatistics::accept, LongSummaryStatistics::combine);
    }

    public static LongCollector<?, Map<Boolean, long[]>> partitioningBy(LongPredicate predicate) {
        return LongCollector.partitioningBy(predicate, LongCollector.toArray());
    }

    public static <A, D> LongCollector<?, Map<Boolean, D>> partitioningBy(LongPredicate predicate, LongCollector<A, D> downstream) {
        ObjLongConsumer downstreamAccumulator = downstream.longAccumulator();
        ObjLongConsumer<Internals.BooleanMap> accumulator = (result2, t2) -> downstreamAccumulator.accept(predicate.test(t2) ? result2.trueValue : result2.falseValue, t2);
        return Internals.BooleanMap.partialCollector(downstream).asLong(accumulator);
    }

    public static <K> LongCollector<?, Map<K, long[]>> groupingBy(LongFunction<? extends K> classifier) {
        return LongCollector.groupingBy(classifier, LongCollector.toArray());
    }

    public static <K, D, A> LongCollector<?, Map<K, D>> groupingBy(LongFunction<? extends K> classifier, LongCollector<A, D> downstream) {
        return LongCollector.groupingBy(classifier, HashMap::new, downstream);
    }

    public static <K, D, A, M extends Map<K, D>> LongCollector<?, M> groupingBy(LongFunction<? extends K> classifier, Supplier<M> mapFactory, LongCollector<A, D> downstream) {
        Supplier downstreamSupplier = downstream.supplier();
        Function<Object, Object> supplier = k2 -> downstreamSupplier.get();
        ObjLongConsumer downstreamAccumulator = downstream.longAccumulator();
        ObjLongConsumer<Map> accumulator = (m4, t2) -> {
            Object key = Objects.requireNonNull(classifier.apply(t2));
            Object container = m4.computeIfAbsent(key, supplier);
            downstreamAccumulator.accept(container, t2);
        };
        return Internals.PartialCollector.grouping(mapFactory, downstream).asLong(accumulator);
    }

    public static LongCollector<?, long[]> toArray() {
        return LongCollector.of(Internals.LongBuffer::new, Internals.LongBuffer::add, Internals.LongBuffer::addAll, Internals.LongBuffer::toArray);
    }

    public static LongCollector<?, boolean[]> toBooleanArray(LongPredicate predicate) {
        return Internals.PartialCollector.booleanArray().asLong((box, t2) -> {
            if (predicate.test(t2)) {
                ((BitSet)box.a).set(box.b);
            }
            box.b = StrictMath.addExact(box.b, 1);
        });
    }
}

