/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import com.intellij.codeInsight.folding.impl.ClosureFolding;
import com.intellij.codeInsight.folding.impl.CommentFoldingUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaFoldingBuilderBase
extends CustomFoldingBuilder
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(JavaFoldingBuilderBase.class);

    private static String getCodeBlockPlaceholder(PsiElement codeBlock) {
        return codeBlock instanceof PsiCodeBlock && ((PsiCodeBlock)codeBlock).isEmpty() ? "{}" : "{...}";
    }

    private static boolean areOnAdjacentLines(@NotNull PsiElement e1, @NotNull PsiElement e2, @NotNull Document document) {
        if (e1 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(0);
        }
        if (e2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(1);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(2);
        }
        return document.getLineNumber(e1.getTextRange().getEndOffset()) + 1 == document.getLineNumber(e2.getTextRange().getStartOffset());
    }

    private static boolean isSimplePropertyAccessor(@NotNull PsiMethod method) {
        PsiExpression expr;
        if (method == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(3);
        }
        if (DumbService.isDumb(method.getProject())) {
            return false;
        }
        PsiCodeBlock body2 = method.getBody();
        if (body2 == null || body2.getLBrace() == null || body2.getRBrace() == null) {
            return false;
        }
        PsiStatement[] statements = body2.getStatements();
        if (statements.length == 0) {
            return false;
        }
        PsiStatement statement = statements[0];
        if (PropertyUtilBase.isSimplePropertyGetter(method)) {
            if (statement instanceof PsiReturnStatement) {
                return ((PsiReturnStatement)statement).getReturnValue() instanceof PsiReferenceExpression;
            }
            return false;
        }
        if (statements.length > 1 && !(statements[1] instanceof PsiReturnStatement)) {
            return false;
        }
        if (statement instanceof PsiExpressionStatement && (expr = ((PsiExpressionStatement)statement).getExpression()) instanceof PsiAssignmentExpression) {
            PsiExpression lhs = ((PsiAssignmentExpression)expr).getLExpression();
            PsiExpression rhs = ((PsiAssignmentExpression)expr).getRExpression();
            return lhs instanceof PsiReferenceExpression && rhs instanceof PsiReferenceExpression && !((PsiReferenceExpression)rhs).isQualified() && PropertyUtilBase.isSimplePropertySetter(method);
        }
        return false;
    }

    @Nullable
    private static TextRange importListRange(@NotNull PsiImportList list) {
        PsiImportStatementBase[] statements;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(4);
        }
        if ((statements = list.getAllImportStatements()).length == 0) {
            return null;
        }
        PsiElement importKeyword = statements[0].getFirstChild();
        if (importKeyword == null) {
            return null;
        }
        int startOffset = importKeyword.getTextRange().getEndOffset() + 1;
        int endOffset = statements[statements.length - 1].getTextRange().getEndOffset();
        return JavaFoldingBuilderBase.hasErrorElementsNearby(list.getContainingFile(), startOffset, endOffset) ? null : new TextRange(startOffset, endOffset);
    }

    @Nullable
    private static TextRange lambdaRange(@NotNull PsiLambdaExpression lambdaExpression) {
        PsiElement body2;
        if (lambdaExpression == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(5);
        }
        return (body2 = lambdaExpression.getBody()) instanceof PsiCodeBlock ? body2.getTextRange() : null;
    }

    @Nullable
    private static TextRange methodRange(@NotNull PsiMethod element2) {
        PsiCodeBlock body2;
        if (element2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(6);
        }
        return (body2 = element2.getBody()) == null ? null : body2.getTextRange();
    }

    @Nullable
    private static TextRange classRange(@NotNull PsiClass aClass) {
        PsiElement lBrace;
        if (aClass == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(7);
        }
        if ((lBrace = aClass.getLBrace()) == null) {
            return null;
        }
        PsiElement rBrace = aClass.getRBrace();
        if (rBrace == null) {
            return null;
        }
        return new TextRange(lBrace.getTextOffset(), rBrace.getTextOffset() + 1);
    }

    @Nullable
    private static TextRange moduleRange(@NotNull PsiJavaModule element2) {
        if (element2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(8);
        }
        PsiElement left = SyntaxTraverser.psiTraverser().children(element2).find(e2 -> PsiUtil.isJavaToken(e2, JavaTokenType.LBRACE));
        PsiElement right = SyntaxTraverser.psiTraverser().children(element2).find(e2 -> PsiUtil.isJavaToken(e2, JavaTokenType.RBRACE));
        return left != null && right != null ? new TextRange(left.getTextOffset(), right.getTextOffset() + 1) : null;
    }

    @NotNull
    private static TextRange annotationRange(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(9);
        }
        PsiElement element2 = annotation;
        int startOffset = element2.getTextRange().getStartOffset();
        PsiAnnotation last = element2;
        while (element2 instanceof PsiAnnotation) {
            last = element2;
            element2 = PsiTreeUtil.skipWhitespacesAndCommentsForward(element2);
        }
        return new TextRange(startOffset, last.getTextRange().getEndOffset());
    }

    public static boolean hasErrorElementsNearby(@NotNull PsiFile file2, int startOffset, int endOffset) {
        if (file2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(10);
        }
        endOffset = CharArrayUtil.shiftForward(file2.getViewProvider().getContents(), endOffset, " \t\n");
        for (PsiElement element2 : CollectHighlightsUtil.getElementsInRange(file2, startOffset, endOffset)) {
            if (!(element2 instanceof PsiErrorElement)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static TextRange fileHeaderRange(@NotNull PsiJavaFile file2) {
        PsiElement first;
        if (file2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(11);
        }
        if ((first = file2.getFirstChild()) instanceof PsiWhiteSpace) {
            first = first.getNextSibling();
        }
        PsiElement element2 = first;
        while (!(!(element2 instanceof PsiComment) || element2 instanceof PsiDocComment && PsiTreeUtil.skipWhitespacesForward(element2) instanceof PsiPackageStatement && "package-info.java".equals(file2.getName()) || !((element2 = element2.getNextSibling()) instanceof PsiWhiteSpace))) {
            element2 = element2.getNextSibling();
        }
        if (element2 == null) {
            return null;
        }
        PsiElement prevSibling = element2.getPrevSibling();
        if (prevSibling instanceof PsiWhiteSpace) {
            element2 = prevSibling;
        }
        if (element2.equals(first)) {
            return null;
        }
        return new UnfairTextRange(first.getTextOffset(), element2.getTextOffset());
    }

    private static void addAnnotationsToFold(@NotNull List<? super FoldingDescriptor> list, @Nullable PsiModifierList modifierList2, @NotNull Document document) {
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(12);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(13);
        }
        if (modifierList2 == null) {
            return;
        }
        PsiElement[] children2 = modifierList2.getChildren();
        for (int i2 = 0; i2 < children2.length; ++i2) {
            PsiElement nextChild;
            int j2;
            PsiElement child = children2[i2];
            if (!(child instanceof PsiAnnotation)) continue;
            PsiAnnotation annotation = (PsiAnnotation)child;
            JavaFoldingBuilderBase.addToFold(list, annotation, document, false, "@{...}", JavaFoldingBuilderBase.annotationRange(annotation), JavaCodeFoldingSettings.getInstance().isCollapseAnnotations());
            for (j2 = i2 + 1; j2 < children2.length && !((nextChild = children2[j2]) instanceof PsiModifier); ++j2) {
            }
            i2 = j2;
        }
    }

    private static void addCommentsToFold(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiElement element2, @NotNull Document document, @NotNull Set<? super PsiElement> processedComments) {
        PsiComment[] comments;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(14);
        }
        if (element2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(15);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(16);
        }
        if (processedComments == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(17);
        }
        if ((comments = (PsiComment[])PsiTreeUtil.getChildrenOfType((PsiElement)element2, PsiComment.class)) == null) {
            return;
        }
        for (PsiComment comment : comments) {
            JavaFoldingBuilderBase.addCommentToFold(list, comment, document, processedComments);
        }
    }

    private static void addCommentToFold(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiComment comment, @NotNull Document document, @NotNull Set<? super PsiElement> processedComments) {
        FoldingDescriptor commentDescriptor;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(18);
        }
        if (comment == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(19);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(20);
        }
        if (processedComments == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(21);
        }
        if ((commentDescriptor = CommentFoldingUtil.getCommentDescriptor(comment, document, processedComments, element2 -> JavaFoldingBuilderBase.isCustomRegionElement(element2), JavaFoldingBuilderBase.isCollapseCommentByDefault(comment))) != null) {
            list.add(commentDescriptor);
        }
    }

    private static void addMethodGenericParametersFolding(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiMethodCallExpression expression2, @NotNull Document document, boolean quick) {
        PsiReferenceExpression methodExpression;
        PsiReferenceParameterList parameterList2;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(22);
        }
        if (expression2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(23);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(24);
        }
        if ((parameterList2 = (methodExpression = expression2.getMethodExpression()).getParameterList()) == null || parameterList2.getTextLength() <= 5) {
            return;
        }
        PsiMethodCallExpression element2 = expression2;
        while (true) {
            if (!quick && !JavaFoldingBuilderBase.resolvesCorrectly(element2.getMethodExpression())) {
                return;
            }
            PsiElement parent2 = element2.getParent();
            if (!(parent2 instanceof PsiExpressionList) || !(parent2.getParent() instanceof PsiMethodCallExpression)) break;
            element2 = (PsiMethodCallExpression)parent2.getParent();
        }
        JavaFoldingBuilderBase.addTypeParametersFolding(list, document, parameterList2, 3, quick);
    }

    private static void addLocalVariableTypeFolding(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiVariable expression2, boolean quick) {
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(25);
        }
        if (expression2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(26);
        }
        if (quick) {
            return;
        }
        PsiTypeElement typeElement = expression2.getTypeElement();
        if (typeElement == null) {
            return;
        }
        if (!typeElement.isInferredType()) {
            return;
        }
        PsiType type2 = expression2.getType();
        if (type2 instanceof PsiCapturedWildcardType || type2.equals(PsiTypes.nullType())) {
            return;
        }
        String presentableText = type2.getPresentableText();
        if (presentableText.length() > 25) {
            return;
        }
        list.add(new FoldingDescriptor(typeElement.getNode(), typeElement.getTextRange(), null, presentableText, true, Collections.emptySet()));
    }

    private static boolean resolvesCorrectly(@NotNull PsiReferenceExpression expression2) {
        if (expression2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(27);
        }
        for (JavaResolveResult result2 : expression2.multiResolve(true)) {
            if (result2.isValidResult()) continue;
            return false;
        }
        return true;
    }

    private static void addGenericParametersFolding(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiNewExpression expression2, @NotNull Document document, boolean quick) {
        PsiReferenceParameterList parameterList2;
        PsiAnonymousClass anonymousClass;
        PsiElement parent2;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(28);
        }
        if (expression2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(29);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(30);
        }
        if (!((parent2 = expression2.getParent()) instanceof PsiVariable)) {
            return;
        }
        PsiType declType = ((PsiVariable)parent2).getType();
        if (!(declType instanceof PsiClassReferenceType)) {
            return;
        }
        Object[] parameters2 = ((PsiClassType)declType).getParameters();
        if (parameters2.length == 0) {
            return;
        }
        PsiJavaCodeReferenceElement classReference = expression2.getClassReference();
        if (classReference == null && (anonymousClass = expression2.getAnonymousClass()) != null) {
            classReference = anonymousClass.getBaseClassReference();
            if (quick || ClosureFolding.seemsLikeLambda(anonymousClass.getSuperClass(), anonymousClass)) {
                return;
            }
        }
        if (classReference != null && (parameterList2 = classReference.getParameterList()) != null) {
            PsiJavaCodeReferenceElement declReference;
            PsiReferenceParameterList declList;
            if (quick ? (declList = (declReference = ((PsiClassReferenceType)declType).getReference()).getParameterList()) == null || !parameterList2.getText().equals(declList.getText()) : !Arrays.equals(parameterList2.getTypeArguments(), parameters2)) {
                return;
            }
            JavaFoldingBuilderBase.addTypeParametersFolding(list, document, parameterList2, 5, quick);
        }
    }

    private static void addTypeParametersFolding(@NotNull List<? super FoldingDescriptor> list, @NotNull Document document, @NotNull PsiReferenceParameterList parameterList2, int ifLongerThan, boolean quick) {
        String text;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(31);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(32);
        }
        if (parameterList2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(33);
        }
        if (!quick) {
            for (PsiType type2 : parameterList2.getTypeArguments()) {
                if (!type2.isValid()) {
                    return;
                }
                if (!(type2 instanceof PsiClassType) && !(type2 instanceof PsiArrayType) || PsiUtil.resolveClassInType(type2) != null) continue;
                return;
            }
        }
        if ((text = parameterList2.getText()).startsWith("<") && text.endsWith(">") && text.length() > ifLongerThan) {
            TextRange range = parameterList2.getTextRange();
            JavaFoldingBuilderBase.addFoldRegion(list, parameterList2, document, true, range, "<~>", JavaCodeFoldingSettings.getInstance().isCollapseConstructorGenericParameters());
        }
    }

    protected abstract boolean shouldShowExplicitLambdaType(@NotNull PsiAnonymousClass var1, @NotNull PsiNewExpression var2);

    private static void addToFold(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiElement elementToFold, @NotNull Document document, boolean allowOneLiners, @NotNull String placeholder, @Nullable TextRange range, boolean isCollapsedByDefault) {
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(34);
        }
        if (elementToFold == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(35);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(36);
        }
        if (placeholder == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(37);
        }
        if (range != null) {
            PsiUtilCore.ensureValid(elementToFold);
            JavaFoldingBuilderBase.addFoldRegion(list, elementToFold, document, allowOneLiners, range, placeholder, isCollapsedByDefault);
        }
    }

    private static void addFoldRegion(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiElement elementToFold, @NotNull Document document, boolean allowOneLiners, @NotNull TextRange range, @NotNull String placeholder, boolean isCollapsedByDefault) {
        int endLine;
        int startLine;
        TextRange fileRange;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(38);
        }
        if (elementToFold == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(39);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(40);
        }
        if (range == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(41);
        }
        if (placeholder == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(42);
        }
        if (range.equals(fileRange = elementToFold.getContainingFile().getTextRange())) {
            return;
        }
        LOG.assertTrue(range.getStartOffset() >= 0 && range.getEndOffset() <= fileRange.getEndOffset());
        if (!allowOneLiners ? (startLine = document.getLineNumber(range.getStartOffset())) >= (endLine = document.getLineNumber(range.getEndOffset() - 1)) || range.getLength() <= 1 : range.getLength() <= placeholder.length()) {
            return;
        }
        list.add(new FoldingDescriptor(elementToFold.getNode(), range, null, placeholder, isCollapsedByDefault, Collections.emptySet()));
    }

    @Override
    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        PsiClass[] classes;
        if (descriptors == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(43);
        }
        if (root == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(44);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(45);
        }
        if (!(root instanceof PsiJavaFile)) {
            return;
        }
        PsiJavaFile file2 = (PsiJavaFile)root;
        HashSet processedComments = new HashSet();
        JavaFoldingBuilderBase.addFoldsForImports(descriptors, file2);
        PsiJavaModule module2 = file2.getModuleDeclaration();
        if (module2 != null) {
            JavaFoldingBuilderBase.addFoldsForModule(descriptors, module2, document, processedComments);
        }
        for (PsiClass aClass : classes = file2.getClasses()) {
            ProgressManager.checkCanceled();
            ProgressIndicatorProvider.checkCanceled();
            this.addFoldsForClass(descriptors, aClass, document, processedComments, quick);
        }
        JavaFoldingBuilderBase.addFoldsForFileHeader(descriptors, file2, document);
        JavaFoldingBuilderBase.addCommentsToFold(descriptors, root, document, processedComments);
    }

    private static void addFoldsForImports(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiJavaFile file2) {
        TextRange rangeToFold;
        PsiImportStatementBase[] statements;
        PsiImportList importList;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(46);
        }
        if (file2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(47);
        }
        if ((importList = file2.getImportList()) != null && (statements = importList.getAllImportStatements()).length > 1 && (rangeToFold = JavaFoldingBuilderBase.importListRange(importList)) != null && rangeToFold.getLength() > 1) {
            FoldingDescriptor descriptor2 = new FoldingDescriptor(importList.getNode(), rangeToFold, null, "...", JavaCodeFoldingSettings.getInstance().isCollapseImports(), Collections.emptySet());
            descriptor2.setCanBeRemovedWhenCollapsed(true);
            list.add(descriptor2);
        }
    }

    private static void addFoldsForFileHeader(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiJavaFile file2, @NotNull Document document) {
        TextRange range;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(48);
        }
        if (file2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(49);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(50);
        }
        if ((range = JavaFoldingBuilderBase.fileHeaderRange(file2)) != null && range.getLength() > 1 && document.getLineNumber(range.getEndOffset()) > document.getLineNumber(range.getStartOffset())) {
            ASTNode node;
            PsiElement anchorElementToUse = file2;
            PsiElement candidate = file2.getFirstChild();
            if (candidate != null && candidate.getTextRange().equals(range) && (node = candidate.getNode()) != null && node.getElementType() == JavaDocElementType.DOC_COMMENT) {
                anchorElementToUse = candidate;
            }
            list.add(new FoldingDescriptor(anchorElementToUse.getNode(), range, null, "/.../", JavaCodeFoldingSettings.getInstance().isCollapseFileHeader(), Collections.emptySet()));
        }
    }

    private static void addFoldsForModule(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiJavaModule module2, @NotNull Document document, @NotNull Set<? super PsiElement> processedComments) {
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(51);
        }
        if (module2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(52);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(53);
        }
        if (processedComments == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(54);
        }
        JavaFoldingBuilderBase.addToFold(list, module2, document, true, JavaFoldingBuilderBase.getCodeBlockPlaceholder(null), JavaFoldingBuilderBase.moduleRange(module2), false);
        JavaFoldingBuilderBase.addCommentsToFold(list, module2, document, processedComments);
        JavaFoldingBuilderBase.addAnnotationsToFold(list, module2.getModifierList(), document);
    }

    private void addFoldsForClass(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiClass aClass, @NotNull Document document, @NotNull Set<? super PsiElement> processedComments, boolean quick) {
        PsiElement parent2;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(55);
        }
        if (aClass == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(56);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(57);
        }
        if (processedComments == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(58);
        }
        if (!((parent2 = aClass.getParent()) instanceof PsiJavaFile) || ((PsiJavaFile)parent2).getClasses().length > 1) {
            JavaFoldingBuilderBase.addToFold(list, aClass, document, true, JavaFoldingBuilderBase.getCodeBlockPlaceholder(null), JavaFoldingBuilderBase.classRange(aClass), !(parent2 instanceof PsiFile) && JavaCodeFoldingSettings.getInstance().isCollapseInnerClasses());
        }
        JavaFoldingBuilderBase.addAnnotationsToFold(list, aClass.getModifierList(), document);
        for (PsiElement child = aClass.getFirstChild(); child != null; child = child.getNextSibling()) {
            ProgressIndicatorProvider.checkCanceled();
            if (child instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)child;
                this.addFoldsForMethod(list, method, document, quick, processedComments);
                continue;
            }
            if (child instanceof PsiField) {
                PsiField field = (PsiField)child;
                JavaFoldingBuilderBase.addCommentsToFold(list, field, document, processedComments);
                JavaFoldingBuilderBase.addAnnotationsToFold(list, field.getModifierList(), document);
                PsiExpression initializer = field.getInitializer();
                if (initializer != null) {
                    this.addCodeBlockFolds(list, initializer, processedComments, document, quick);
                    continue;
                }
                if (!(field instanceof PsiEnumConstant)) continue;
                this.addCodeBlockFolds(list, field, processedComments, document, quick);
                continue;
            }
            if (child instanceof PsiClassInitializer) {
                PsiClassInitializer initializer = (PsiClassInitializer)child;
                JavaFoldingBuilderBase.addToFold(list, child, document, true, JavaFoldingBuilderBase.getCodeBlockPlaceholder(initializer.getBody()), initializer.getBody().getTextRange(), JavaCodeFoldingSettings.getInstance().isCollapseMethods());
                this.addCodeBlockFolds(list, child, processedComments, document, quick);
                continue;
            }
            if (child instanceof PsiClass) {
                this.addFoldsForClass(list, (PsiClass)child, document, processedComments, quick);
                continue;
            }
            if (child instanceof PsiComment) {
                JavaFoldingBuilderBase.addCommentToFold(list, (PsiComment)child, document, processedComments);
                continue;
            }
            if (!(child instanceof PsiRecordHeader)) continue;
            JavaFoldingBuilderBase.addToFold(list, child, document, false, "(...)", child.getTextRange(), false);
        }
    }

    private void addFoldsForMethod(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiMethod method, @NotNull Document document, boolean quick, @NotNull Set<? super PsiElement> processedComments) {
        boolean oneLiner;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(59);
        }
        if (method == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(60);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(61);
        }
        if (processedComments == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(62);
        }
        if (!(oneLiner = this.addOneLineMethodFolding(list, method))) {
            JavaFoldingBuilderBase.addToFold(list, method, document, true, JavaFoldingBuilderBase.getCodeBlockPlaceholder(method.getBody()), JavaFoldingBuilderBase.methodRange(method), JavaFoldingBuilderBase.isCollapseMethodByDefault(method));
        }
        JavaFoldingBuilderBase.addAnnotationsToFold(list, method.getModifierList(), document);
        JavaFoldingBuilderBase.addCommentsToFold(list, method, document, processedComments);
        for (PsiParameter parameter2 : method.getParameterList().getParameters()) {
            JavaFoldingBuilderBase.addAnnotationsToFold(list, parameter2.getModifierList(), document);
        }
        PsiCodeBlock body2 = method.getBody();
        if (body2 != null) {
            this.addCodeBlockFolds(list, body2, processedComments, document, quick);
        }
    }

    private boolean addOneLineMethodFolding(@NotNull List<? super FoldingDescriptor> list, @NotNull PsiMethod method) {
        boolean collapseOneLineMethods;
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(63);
        }
        if (method == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(64);
        }
        if (!(collapseOneLineMethods = JavaCodeFoldingSettings.getInstance().isCollapseOneLineMethods())) {
            return false;
        }
        Document document = method.getContainingFile().getViewProvider().getDocument();
        PsiCodeBlock body2 = method.getBody();
        PsiIdentifier nameIdentifier = method.getNameIdentifier();
        if (body2 == null || document == null || nameIdentifier == null) {
            return false;
        }
        TextRange parameterListTextRange = method.getParameterList().getTextRange();
        if (parameterListTextRange == null || document.getLineNumber(nameIdentifier.getTextRange().getStartOffset()) != document.getLineNumber(parameterListTextRange.getEndOffset())) {
            return false;
        }
        PsiJavaToken lBrace = body2.getLBrace();
        PsiJavaToken rBrace = body2.getRBrace();
        PsiStatement[] statements = body2.getStatements();
        if (lBrace == null || rBrace == null || statements.length != 1) {
            return false;
        }
        PsiStatement statement = statements[0];
        if (statement.textContains('\n')) {
            return false;
        }
        if (!JavaFoldingBuilderBase.areOnAdjacentLines(lBrace, statement, document) || !JavaFoldingBuilderBase.areOnAdjacentLines(statement, rBrace, document)) {
            return false;
        }
        int leftStart = parameterListTextRange.getEndOffset();
        int bodyStart = body2.getTextRange().getStartOffset();
        if (bodyStart > leftStart && !StringUtil.isEmptyOrSpaces(document.getCharsSequence().subSequence(leftStart + 1, bodyStart))) {
            return false;
        }
        int leftEnd = statement.getTextRange().getStartOffset();
        int rightStart = statement.getTextRange().getEndOffset();
        int rightEnd = body2.getTextRange().getEndOffset();
        if (leftEnd <= leftStart + 1 || rightEnd <= rightStart + 1) {
            return false;
        }
        String leftText = " { ";
        String rightText = " }";
        if (!this.fitsRightMargin(method, document, leftStart, rightEnd, rightStart - leftEnd + leftText.length() + rightText.length())) {
            return false;
        }
        FoldingGroup group = FoldingGroup.newGroup("one-liner");
        list.add(new FoldingDescriptor(lBrace.getNode(), new TextRange(leftStart, leftEnd), group, leftText, true, Collections.emptySet()));
        list.add(new FoldingDescriptor(rBrace.getNode(), new TextRange(rightStart, rightEnd), group, rightText, true, Collections.emptySet()));
        return true;
    }

    @Override
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(65);
        }
        if (range == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(66);
        }
        return null;
    }

    @Override
    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(67);
        }
        LOG.error("Unknown element:" + node);
        return false;
    }

    private static boolean isCollapseCommentByDefault(@NotNull PsiComment comment) {
        if (comment == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(68);
        }
        JavaCodeFoldingSettings settings = JavaCodeFoldingSettings.getInstance();
        PsiElement parent2 = comment.getParent();
        if (parent2 instanceof PsiJavaFile) {
            if (((PsiJavaFile)parent2).getName().equals("package-info.java")) {
                return false;
            }
            PsiElement firstChild = parent2.getFirstChild();
            if (firstChild instanceof PsiWhiteSpace) {
                firstChild = firstChild.getNextSibling();
            }
            if (comment.equals(firstChild)) {
                return settings.isCollapseFileHeader();
            }
        }
        if (comment instanceof PsiDocComment) {
            return settings.isCollapseJavadocs();
        }
        IElementType commentType = comment.getTokenType();
        if (commentType == JavaTokenType.END_OF_LINE_COMMENT) {
            return settings.isCollapseEndOfLineComments();
        }
        if (commentType == JavaTokenType.C_STYLE_COMMENT) {
            return settings.isCollapseMultilineComments();
        }
        return false;
    }

    private static boolean isCollapseMethodByDefault(@NotNull PsiMethod element2) {
        JavaCodeFoldingSettings settings;
        if (element2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(69);
        }
        if (!(settings = JavaCodeFoldingSettings.getInstance()).isCollapseAccessors() && !settings.isCollapseMethods()) {
            return false;
        }
        if (JavaFoldingBuilderBase.isSimplePropertyAccessor(element2)) {
            return settings.isCollapseAccessors();
        }
        return settings.isCollapseMethods();
    }

    private void addCodeBlockFolds(final @NotNull List<? super FoldingDescriptor> list, @NotNull PsiElement scope, final @NotNull Set<? super PsiElement> processedComments, final @NotNull Document document, final boolean quick) {
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(70);
        }
        if (scope == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(71);
        }
        if (processedComments == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(72);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(73);
        }
        final boolean dumb = DumbService.isDumb(scope.getProject());
        scope.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitClass(@NotNull PsiClass aClass) {
                if (aClass == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (dumb || !JavaFoldingBuilderBase.this.addClosureFolding(aClass, document, list, processedComments, quick)) {
                    JavaFoldingBuilderBase.addToFold(list, aClass, document, true, JavaFoldingBuilderBase.getCodeBlockPlaceholder(null), JavaFoldingBuilderBase.classRange(aClass), JavaCodeFoldingSettings.getInstance().isCollapseInnerClasses());
                    JavaFoldingBuilderBase.this.addFoldsForClass(list, aClass, document, processedComments, quick);
                }
            }

            @Override
            public void visitVariable(@NotNull PsiVariable variable) {
                if (variable == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!dumb && JavaCodeFoldingSettings.getInstance().isReplaceVarWithInferredType()) {
                    JavaFoldingBuilderBase.addLocalVariableTypeFolding(list, variable, quick);
                }
                super.visitVariable(variable);
            }

            @Override
            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
                if (expression2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!dumb) {
                    JavaFoldingBuilderBase.addMethodGenericParametersFolding(list, expression2, document, quick);
                }
                super.visitMethodCallExpression(expression2);
            }

            @Override
            public void visitNewExpression(@NotNull PsiNewExpression expression2) {
                if (expression2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (!dumb) {
                    JavaFoldingBuilderBase.addGenericParametersFolding(list, expression2, document, quick);
                }
                super.visitNewExpression(expression2);
            }

            @Override
            public void visitLambdaExpression(@NotNull PsiLambdaExpression expression2) {
                PsiElement body2;
                if (expression2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                if ((body2 = expression2.getBody()) instanceof PsiCodeBlock) {
                    JavaFoldingBuilderBase.addToFold(list, expression2, document, true, JavaFoldingBuilderBase.getCodeBlockPlaceholder(expression2.getBody()), JavaFoldingBuilderBase.lambdaRange(expression2), JavaCodeFoldingSettings.getInstance().isCollapseAnonymousClasses());
                }
                super.visitLambdaExpression(expression2);
            }

            @Override
            public void visitCodeBlock(@NotNull PsiCodeBlock block) {
                if (block == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (Registry.is("java.folding.icons.for.control.flow", true) && block.getStatementCount() > 0) {
                    JavaFoldingBuilderBase.addToFold(list, block, document, false, JavaFoldingBuilderBase.getCodeBlockPlaceholder(block), block.getTextRange(), false);
                }
                super.visitCodeBlock(block);
            }

            @Override
            public void visitComment(@NotNull PsiComment comment) {
                if (comment == null) {
                    1.$$$reportNull$$$0(6);
                }
                JavaFoldingBuilderBase.addCommentToFold(list, comment, document, processedComments);
                super.visitComment(comment);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aClass";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "variable";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "block";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "comment";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitVariable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitNewExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitLambdaExpression";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCodeBlock";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitComment";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private boolean addClosureFolding(@NotNull PsiClass aClass, @NotNull Document document, @NotNull List<? super FoldingDescriptor> list, @NotNull Set<? super PsiElement> processedComments, boolean quick) {
        if (aClass == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(74);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(75);
        }
        if (list == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(76);
        }
        if (processedComments == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(77);
        }
        if (!JavaCodeFoldingSettings.getInstance().isCollapseLambdas()) {
            return false;
        }
        if (aClass instanceof PsiAnonymousClass) {
            List<FoldingDescriptor> descriptors;
            PsiAnonymousClass anonymousClass = (PsiAnonymousClass)aClass;
            ClosureFolding closureFolding = ClosureFolding.prepare(anonymousClass, quick, this);
            List<FoldingDescriptor> list2 = descriptors = closureFolding == null ? null : closureFolding.process(document);
            if (descriptors != null) {
                list.addAll(descriptors);
                this.addCodeBlockFolds(list, closureFolding.methodBody, processedComments, document, quick);
                return true;
            }
        }
        return false;
    }

    @NotNull
    protected String rightArrow() {
        return "->";
    }

    boolean fitsRightMargin(@NotNull PsiElement element2, @NotNull Document document, int foldingStart, int foldingEnd, int collapsedLength) {
        if (element2 == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(78);
        }
        if (document == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(79);
        }
        int beforeLength = foldingStart - document.getLineStartOffset(document.getLineNumber(foldingStart));
        int afterLength = document.getLineEndOffset(document.getLineNumber(foldingEnd)) - foldingEnd;
        return this.isBelowRightMargin(element2.getContainingFile(), beforeLength + collapsedLength + afterLength);
    }

    protected abstract boolean isBelowRightMargin(@NotNull PsiFile var1, int var2);

    @Override
    protected boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        if (node == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(80);
        }
        return node.getElementType() == JavaTokenType.END_OF_LINE_COMMENT;
    }

    @Override
    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        IElementType nodeType;
        if (node == null) {
            JavaFoldingBuilderBase.$$$reportNull$$$0(81);
        }
        if ((nodeType = node.getElementType()) == JavaElementType.CLASS) {
            ASTNode parent2 = node.getTreeParent();
            return parent2 == null || parent2.getElementType() != JavaElementType.CLASS;
        }
        return nodeType == JavaElementType.CODE_BLOCK;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e2";
                break;
            }
            case 2: 
            case 13: 
            case 16: 
            case 20: 
            case 24: 
            case 30: 
            case 32: 
            case 36: 
            case 40: 
            case 45: 
            case 50: 
            case 53: 
            case 57: 
            case 61: 
            case 73: 
            case 75: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 60: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 12: 
            case 14: 
            case 18: 
            case 22: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 38: 
            case 46: 
            case 48: 
            case 51: 
            case 55: 
            case 59: 
            case 63: 
            case 70: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaExpression";
                break;
            }
            case 6: 
            case 8: 
            case 15: 
            case 69: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 56: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 10: 
            case 11: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 17: 
            case 21: 
            case 54: 
            case 58: 
            case 62: 
            case 72: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedComments";
                break;
            }
            case 19: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 23: 
            case 26: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToFold";
                break;
            }
            case 37: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeholder";
                break;
            }
            case 41: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 65: 
            case 67: 
            case 80: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/folding/impl/JavaFoldingBuilderBase";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "areOnAdjacentLines";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSimplePropertyAccessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "importListRange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambdaRange";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "methodRange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "classRange";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "moduleRange";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "annotationRange";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "hasErrorElementsNearby";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "fileHeaderRange";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "addAnnotationsToFold";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "addCommentsToFold";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "addCommentToFold";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "addMethodGenericParametersFolding";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "addLocalVariableTypeFolding";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "resolvesCorrectly";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "addGenericParametersFolding";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "addTypeParametersFolding";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "addToFold";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[2] = "addFoldRegion";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "buildLanguageFoldRegions";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[2] = "addFoldsForImports";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[2] = "addFoldsForFileHeader";
                break;
            }
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[2] = "addFoldsForModule";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[2] = "addFoldsForClass";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[2] = "addFoldsForMethod";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[2] = "addOneLineMethodFolding";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagePlaceholderText";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[2] = "isCollapseCommentByDefault";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[2] = "isCollapseMethodByDefault";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[2] = "addCodeBlockFolds";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[2] = "addClosureFolding";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[2] = "fitsRightMargin";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomFoldingCandidate";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomFoldingRoot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

