/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.loops;

import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.loops.ComparableRangeInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.FloatingPointRangeHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ForLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.HeaderInfoBuilder;
import org.jetbrains.kotlin.backend.common.lower.loops.IndexedGetHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.IndexedGetLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.IterableHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.IterableLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.ProgressionLoopHeader;
import org.jetbrains.kotlin.backend.common.lower.loops.WithIndexHeaderInfo;
import org.jetbrains.kotlin.backend.common.lower.loops.WithIndexLoopHeader;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrParameterKind;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderProcessor;", "", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "headerInfoBuilder", "Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoBuilder;", "scopeOwnerSymbol", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Lorg/jetbrains/kotlin/backend/common/lower/loops/HeaderInfoBuilder;Lkotlin/jvm/functions/Function0;)V", "symbols", "Lorg/jetbrains/kotlin/backend/common/ir/Symbols;", "extractHeader", "Lorg/jetbrains/kotlin/backend/common/lower/loops/ForLoopHeader;", "variable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nHeaderProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeaderProcessor.kt\norg/jetbrains/kotlin/backend/common/lower/loops/HeaderProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n461#2,6:129\n*S KotlinDebug\n*F\n+ 1 HeaderProcessor.kt\norg/jetbrains/kotlin/backend/common/lower/loops/HeaderProcessor\n*L\n109#1:129,6\n*E\n"})
public final class HeaderProcessor {
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final HeaderInfoBuilder headerInfoBuilder;
    @NotNull
    private final Function0<IrSymbol> scopeOwnerSymbol;
    @NotNull
    private final Symbols symbols;

    public HeaderProcessor(@NotNull CommonBackendContext context2, @NotNull HeaderInfoBuilder headerInfoBuilder2, @NotNull Function0<? extends IrSymbol> scopeOwnerSymbol) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)headerInfoBuilder2, (String)"headerInfoBuilder");
        Intrinsics.checkNotNullParameter(scopeOwnerSymbol, (String)"scopeOwnerSymbol");
        this.context = context2;
        this.headerInfoBuilder = headerInfoBuilder2;
        this.scopeOwnerSymbol = scopeOwnerSymbol;
        this.symbols = this.context.getIr().getSymbols();
    }

    @Nullable
    public final ForLoopHeader extractHeader(@NotNull IrVariable variable) {
        ForLoopHeader forLoopHeader;
        IrElement iterable;
        Object object;
        IrElement irElement;
        IrCall iteratorCall;
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        boolean bl2 = Intrinsics.areEqual((Object)variable.getOrigin(), (Object)IrDeclarationOrigin.Companion.getFOR_LOOP_ITERATOR());
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (!IrTypeUtilsKt.isSubtypeOfClass(variable.getType(), this.symbols.getIterator())) {
            return null;
        }
        IrExpression irExpression = variable.getInitializer();
        IrCall irCall = iteratorCall = irExpression instanceof IrCall ? (IrCall)irExpression : null;
        if (irCall != null) {
            Object element$iv;
            block15: {
                IrCall $this$extractHeader_u24lambda_u241 = irCall;
                boolean bl3 = false;
                List $this$last$iv = CollectionsKt.zip((Iterable)$this$extractHeader_u24lambda_u241.getArguments(), (Iterable)((IrSimpleFunction)$this$extractHeader_u24lambda_u241.getSymbol().getOwner()).getParameters());
                boolean $i$f$last = false;
                ListIterator iterator$iv = $this$last$iv.listIterator($this$last$iv.size());
                while (iterator$iv.hasPrevious()) {
                    element$iv = iterator$iv.previous();
                    Pair pair = (Pair)element$iv;
                    boolean bl4 = false;
                    IrValueParameter parameter2 = (IrValueParameter)pair.component2();
                    if (!(parameter2.getKind() == IrParameterKind.ExtensionReceiver || parameter2.getKind() == IrParameterKind.DispatchReceiver)) continue;
                    break block15;
                }
                throw new NoSuchElementException("List contains no element matching the predicate.");
            }
            irElement = (IrExpression)((Pair)element$iv).getFirst();
        } else {
            irElement = null;
        }
        if ((object = (iterable = irElement)) == null || (object = (HeaderInfo)object.accept(this.headerInfoBuilder, iteratorCall)) == null) {
            return null;
        }
        Object headerInfo = object;
        DeclarationIrBuilder builder2 = LowerUtilsKt.createIrBuilder(this.context, (IrSymbol)this.scopeOwnerSymbol.invoke(), variable.getStartOffset(), variable.getEndOffset());
        Object object2 = headerInfo;
        if (object2 instanceof IndexedGetHeaderInfo) {
            forLoopHeader = new IndexedGetLoopHeader((IndexedGetHeaderInfo)headerInfo, builder2, this.context);
        } else if (object2 instanceof ProgressionHeaderInfo) {
            forLoopHeader = new ProgressionLoopHeader((ProgressionHeaderInfo)headerInfo, builder2, this.context);
        } else if (object2 instanceof WithIndexHeaderInfo) {
            forLoopHeader = new WithIndexLoopHeader((WithIndexHeaderInfo)headerInfo, builder2, this.context);
        } else if (object2 instanceof IterableHeaderInfo) {
            forLoopHeader = new IterableLoopHeader((IterableHeaderInfo)headerInfo);
        } else {
            if (object2 instanceof FloatingPointRangeHeaderInfo || object2 instanceof ComparableRangeInfo) {
                throw new IllegalStateException(("Unexpected " + Reflection.getOrCreateKotlinClass(headerInfo.getClass()).getSimpleName() + " for loops").toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return forLoopHeader;
    }
}

