/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Function;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StringArray
extends Memory
implements Function.PostCallRead {
    private String encoding;
    private List<NativeString> natives = new ArrayList<NativeString>();
    private Object[] original;

    public StringArray(String[] strings2) {
        this(strings2, false);
    }

    public StringArray(String[] strings2, boolean wide) {
        this((Object[])strings2, wide ? "--WIDE-STRING--" : Native.getDefaultStringEncoding());
    }

    public StringArray(String[] strings2, String encoding) {
        this((Object[])strings2, encoding);
    }

    public StringArray(WString[] strings2) {
        this(strings2, "--WIDE-STRING--");
    }

    private StringArray(Object[] strings2, String encoding) {
        super((strings2.length + 1) * Native.POINTER_SIZE);
        this.original = strings2;
        this.encoding = encoding;
        for (int i2 = 0; i2 < strings2.length; ++i2) {
            Pointer p = null;
            if (strings2[i2] != null) {
                NativeString ns = new NativeString(strings2[i2].toString(), encoding);
                this.natives.add(ns);
                p = ns.getPointer();
            }
            this.setPointer(Native.POINTER_SIZE * i2, p);
        }
        this.setPointer(Native.POINTER_SIZE * strings2.length, null);
    }

    @Override
    public void read() {
        boolean returnWide = this.original instanceof WString[];
        boolean wide = "--WIDE-STRING--".equals(this.encoding);
        for (int si = 0; si < this.original.length; ++si) {
            Pointer p = this.getPointer(si * Native.POINTER_SIZE);
            CharSequence s2 = null;
            if (p != null) {
                String string2 = s2 = wide ? p.getWideString(0L) : p.getString(0L, this.encoding);
                if (returnWide) {
                    s2 = new WString((String)s2);
                }
            }
            this.original[si] = s2;
        }
    }

    @Override
    public String toString() {
        boolean wide = "--WIDE-STRING--".equals(this.encoding);
        String s2 = wide ? "const wchar_t*[]" : "const char*[]";
        s2 = s2 + Arrays.asList(this.original);
        return s2;
    }
}

