/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.javadoc;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.javadoc.PsiInlineDocTagImpl;
import com.intellij.psi.impl.source.javadoc.SnippetDocTagManipulator;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.JavaDocElementType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiSnippetDocTag;
import com.intellij.psi.javadoc.PsiSnippetDocTagBody;
import com.intellij.psi.javadoc.PsiSnippetDocTagValue;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public class PsiSnippetDocTagImpl
extends CompositePsiElement
implements PsiSnippetDocTag,
PsiLanguageInjectionHost {
    public PsiSnippetDocTagImpl() {
        super(JavaDocElementType.DOC_SNIPPET_TAG);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getNameElement().getText().substring(1);
        if (string == null) {
            PsiSnippetDocTagImpl.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public PsiDocComment getContainingComment() {
        ASTNode scope = this.getTreeParent();
        while (scope.getElementType() != JavaDocElementType.DOC_COMMENT) {
            scope = scope.getTreeParent();
        }
        return (PsiDocComment)SourceTreeToPsiMap.treeElementToPsi(scope);
    }

    @Override
    public PsiElement getNameElement() {
        return this.findPsiChildByType(JavaDocTokenType.DOC_TAG_NAME);
    }

    @Override
    public PsiElement @NotNull [] getDataElements() {
        PsiElement[] psiElementArray = this.getChildrenAsPsiElements(PsiInlineDocTagImpl.VALUE_BIT_SET, PsiElement.ARRAY_FACTORY);
        if (psiElementArray == null) {
            PsiSnippetDocTagImpl.$$$reportNull$$$0(1);
        }
        return psiElementArray;
    }

    @Override
    public PsiElement setName(@NotNull String name2) throws IncorrectOperationException {
        if (name2 == null) {
            PsiSnippetDocTagImpl.$$$reportNull$$$0(2);
        }
        throw new IncorrectOperationException();
    }

    @Override
    @Nullable
    public PsiSnippetDocTagValue getValueElement() {
        return (PsiSnippetDocTagValue)this.findPsiChildByType(JavaDocElementType.DOC_SNIPPET_TAG_VALUE);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiSnippetDocTagImpl.$$$reportNull$$$0(3);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitSnippetTag(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiSnippetDocTag";
    }

    @Override
    public boolean isValidHost() {
        return true;
    }

    @Contract(pure=true)
    @NotNull
    public @NotNull List<@NotNull TextRange> getContentRanges() {
        TextRange snippetBodyRange;
        PsiSnippetDocTagValue valueElement = this.getValueElement();
        if (valueElement == null) {
            List<TextRange> list = Collections.emptyList();
            if (list == null) {
                PsiSnippetDocTagImpl.$$$reportNull$$$0(4);
            }
            return list;
        }
        PsiSnippetDocTagBody body = valueElement.getBody();
        if (body == null) {
            List<TextRange> list = Collections.emptyList();
            if (list == null) {
                PsiSnippetDocTagImpl.$$$reportNull$$$0(5);
            }
            return list;
        }
        ASTNode colon = PsiSnippetDocTagImpl.getColonElement(body);
        if (colon == null) {
            List<TextRange> list = Collections.emptyList();
            if (list == null) {
                PsiSnippetDocTagImpl.$$$reportNull$$$0(6);
            }
            return list;
        }
        int startOffset = colon.getTextRange().getEndOffset();
        TextRange range = TextRange.create(startOffset, (snippetBodyRange = body.getTextRange()).getEndOffset());
        TextRange snippetBodyTextRangeRelativeToSnippetTag = range.shiftLeft(this.getStartOffset());
        String[] lines = snippetBodyTextRangeRelativeToSnippetTag.substring(this.getText()).split("\n");
        if (lines.length == 0) {
            List<TextRange> list = Collections.singletonList(snippetBodyTextRangeRelativeToSnippetTag);
            if (list == null) {
                PsiSnippetDocTagImpl.$$$reportNull$$$0(7);
            }
            return list;
        }
        return PsiSnippetDocTagImpl.getRanges(snippetBodyTextRangeRelativeToSnippetTag, lines);
    }

    @Contract(pure=true)
    @NotNull
    private static @NotNull List<@NotNull TextRange> getRanges(@NotNull TextRange snippetBodyTextRangeRelativeToSnippet, String @NotNull [] lines) {
        if (snippetBodyTextRangeRelativeToSnippet == null) {
            PsiSnippetDocTagImpl.$$$reportNull$$$0(8);
        }
        if (lines == null) {
            PsiSnippetDocTagImpl.$$$reportNull$$$0(9);
        }
        int firstLine = PsiSnippetDocTagImpl.getFirstNonEmptyLine(lines);
        int lastLine = PsiSnippetDocTagImpl.getLastNonEmptyLine(lines);
        int totalMinIndent = PsiSnippetDocTagImpl.getIndent(lines, firstLine, lastLine);
        int startOffset = PsiSnippetDocTagImpl.getStartOffsetOfFirstNonEmptyLine(snippetBodyTextRangeRelativeToSnippet, lines, firstLine);
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        for (int i2 = firstLine; i2 < Math.min(lastLine, lines.length); ++i2) {
            String line = lines[i2];
            int size = line.length() + 1;
            int indentSize = PsiSnippetDocTagImpl.getIndentSize(line, totalMinIndent);
            ranges.add(TextRange.create(0, size - indentSize).shiftRight(startOffset + indentSize));
            startOffset += size;
        }
        String line = lines[lastLine];
        int indentSize = PsiSnippetDocTagImpl.getIndentSize(line, totalMinIndent);
        int endOffset = snippetBodyTextRangeRelativeToSnippet.getEndOffset();
        int lastLineStartOffset = Math.min(endOffset, startOffset + indentSize);
        int lastLineEndOffset = startOffset + line.length();
        ranges.add(TextRange.create(lastLineStartOffset, Math.min(endOffset, lastLineEndOffset)));
        ArrayList<TextRange> arrayList = ranges;
        if (arrayList == null) {
            PsiSnippetDocTagImpl.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @Contract(pure=true)
    private static @Range(from=0L, to=0x7FFFFFFFL) int getIndentSize(@NotNull String line, int indent) {
        int ownLineIndent;
        String maxPossibleIndent;
        int lastAsteriskInIndent;
        if (line == null) {
            PsiSnippetDocTagImpl.$$$reportNull$$$0(11);
        }
        return (lastAsteriskInIndent = (maxPossibleIndent = line.substring(0, ownLineIndent = CharArrayUtil.shiftForward(line, 0, " *"))).lastIndexOf(42, ownLineIndent)) >= indent ? lastAsteriskInIndent + 1 : indent;
    }

    @Contract(pure=true)
    private static @Range(from=0L, to=0x7FFFFFFFL) int getStartOffsetOfFirstNonEmptyLine(@NotNull TextRange snippetBodyTextRangeRelativeToSnippet, String @NotNull [] lines, int firstLine) {
        if (snippetBodyTextRangeRelativeToSnippet == null) {
            PsiSnippetDocTagImpl.$$$reportNull$$$0(12);
        }
        if (lines == null) {
            PsiSnippetDocTagImpl.$$$reportNull$$$0(13);
        }
        int start = snippetBodyTextRangeRelativeToSnippet.getStartOffset();
        for (int i2 = 0; i2 < Math.min(firstLine, lines.length); ++i2) {
            start += lines[i2].length() + 1;
        }
        return start;
    }

    @Contract(pure=true)
    private static @Range(from=0L, to=0x7FFFFFFFL) int getIndent(String @NotNull [] lines, int firstLine, int lastLine) {
        if (lines == null) {
            PsiSnippetDocTagImpl.$$$reportNull$$$0(14);
        }
        int minIndent = Integer.MAX_VALUE;
        for (int i2 = firstLine; i2 <= lastLine && i2 < lines.length; ++i2) {
            String line = lines[i2];
            int indentLength = PsiSnippetDocTagImpl.isEmptyOrSpacesWithLeadingAsterisksOnly(line) ? line.length() : PsiSnippetDocTagImpl.calculateIndent(line);
            if (minIndent <= indentLength) continue;
            minIndent = indentLength;
        }
        if (minIndent == Integer.MAX_VALUE) {
            minIndent = 0;
        }
        return minIndent;
    }

    @Contract(pure=true)
    private static @Range(from=0L, to=0x7FFFFFFFL) int getLastNonEmptyLine(String @NotNull [] lines) {
        int lastLine;
        if (lines == null) {
            PsiSnippetDocTagImpl.$$$reportNull$$$0(15);
        }
        for (lastLine = lines.length - 1; lastLine > 0 && PsiSnippetDocTagImpl.isEmptyOrSpacesWithLeadingAsterisksOnly(lines[lastLine]); --lastLine) {
        }
        return lastLine;
    }

    @Contract(pure=true)
    private static @Range(from=0L, to=0x7FFFFFFFL) int getFirstNonEmptyLine(String @NotNull [] lines) {
        int firstLine;
        if (lines == null) {
            PsiSnippetDocTagImpl.$$$reportNull$$$0(16);
        }
        for (firstLine = 0; firstLine < lines.length && PsiSnippetDocTagImpl.isEmptyOrSpacesWithLeadingAsterisksOnly(lines[firstLine]); ++firstLine) {
        }
        return firstLine;
    }

    @Contract(pure=true)
    private static boolean isEmptyOrSpacesWithLeadingAsterisksOnly(@NotNull String lines) {
        if (lines == null) {
            PsiSnippetDocTagImpl.$$$reportNull$$$0(17);
        }
        if (lines.isEmpty()) {
            return true;
        }
        return lines.matches("^\\s*\\**\\s*$");
    }

    @Contract(pure=true)
    private static @Range(from=0L, to=0x7FFFFFFFL) int calculateIndent(@NotNull String content) {
        if (content == null) {
            PsiSnippetDocTagImpl.$$$reportNull$$$0(18);
        }
        if (content.isEmpty()) {
            return 0;
        }
        String noIndent = content.replaceAll("^\\s*\\*\\s*", "");
        return content.length() - noIndent.length();
    }

    @Contract(pure=true)
    @Nullable
    private static ASTNode getColonElement(@NotNull PsiSnippetDocTagBody snippetBodyBody) {
        ASTNode[] colonElements;
        if (snippetBodyBody == null) {
            PsiSnippetDocTagImpl.$$$reportNull$$$0(19);
        }
        return (colonElements = snippetBodyBody.getNode().getChildren(TokenSet.create(JavaDocTokenType.DOC_TAG_VALUE_COLON))).length == 1 ? colonElements[0] : null;
    }

    @Override
    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            PsiSnippetDocTagImpl.$$$reportNull$$$0(20);
        }
        return new SnippetDocTagManipulator().handleContentChange(this, text);
    }

    @Override
    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        return new LiteralTextEscaper<PsiSnippetDocTagImpl>(this){
            private int[] myOffsets;

            @Override
            public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
                if (rangeInsideHost == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outChars == null) {
                    1.$$$reportNull$$$0(1);
                }
                List<TextRange> ranges = ((PsiSnippetDocTagImpl)this.myHost).getContentRanges();
                String content = rangeInsideHost.substring(((PsiSnippetDocTagImpl)this.myHost).getText());
                this.myOffsets = new int[content.length() + 1];
                Arrays.fill(this.myOffsets, -1);
                int i2 = 0;
                boolean decoded = false;
                for (TextRange range : ranges) {
                    if (!rangeInsideHost.contains(range)) continue;
                    for (int j2 = 0; j2 < range.getLength(); ++j2) {
                        this.myOffsets[i2++] = range.getStartOffset() + j2;
                    }
                    decoded = true;
                    outChars.append(range.substring(((PsiSnippetDocTagImpl)this.myHost).getText()));
                }
                this.myOffsets[i2] = rangeInsideHost.getEndOffset();
                return decoded;
            }

            @Override
            public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
                if (rangeInsideHost == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (offsetInDecoded >= this.myOffsets.length) {
                    return -1;
                }
                return this.myOffsets[offsetInDecoded];
            }

            @Override
            public boolean isOneLine() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rangeInsideHost";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outChars";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/source/javadoc/PsiSnippetDocTagImpl$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "decode";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getOffsetInHost";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/javadoc/PsiSnippetDocTagImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snippetBodyTextRangeRelativeToSnippet";
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snippetBodyBody";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataElements";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/javadoc/PsiSnippetDocTagImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRanges";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRanges";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRanges";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getIndentSize";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getStartOffsetOfFirstNonEmptyLine";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getIndent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLastNonEmptyLine";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFirstNonEmptyLine";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyOrSpacesWithLeadingAsterisksOnly";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "calculateIndent";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getColonElement";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

