/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProjectCoreUtil {
    private static volatile Project theOnlyProject;

    public static boolean isProjectOrWorkspaceFile(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectCoreUtil.$$$reportNull$$$0(0);
        }
        return ProjectCoreUtil.isProjectOrWorkspaceFile(file, FileTypeRegistry.getInstance().getFileTypeByFileName(file.getNameSequence()));
    }

    public static boolean isProjectOrWorkspaceFile(@NotNull VirtualFile file, @Nullable FileType fileType) {
        if (file == null) {
            ProjectCoreUtil.$$$reportNull$$$0(1);
        }
        return fileType instanceof InternalFileType || VfsUtilCore.findContainingDirectory(file, ".idea") != null;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @ApiStatus.Internal
    @Nullable
    public static Project theOnlyOpenProject() {
        return theOnlyProject;
    }

    @ApiStatus.Internal
    public static void updateInternalTheOnlyProjectFieldTemporarily(Project project) {
        theOnlyProject = project;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/project/ProjectCoreUtil", "isProjectOrWorkspaceFile"));
    }
}

