/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0012\u001a\r\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeSpecificAtomicChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirCallableDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkType", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "CONCURRENT_PACKAGE", "Lorg/jetbrains/kotlin/name/FqName;", "CONCURRENT_NAME_SET", "", "Lorg/jetbrains/kotlin/name/Name;", "Lkotlin/jvm/internal/EnhancedNullability;", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeSpecificAtomicChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeSpecificAtomicChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeSpecificAtomicChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n21#2:74\n1869#3,2:75\n1869#3,2:78\n1634#3,3:80\n1#4:77\n*S KotlinDebug\n*F\n+ 1 FirNativeSpecificAtomicChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeSpecificAtomicChecker\n*L\n33#1:74\n37#1:75,2\n45#1:78,2\n71#1:80,3\n*E\n"})
public final class FirNativeSpecificAtomicChecker
extends FirDeclarationChecker<FirCallableDeclaration> {
    @NotNull
    public static final FirNativeSpecificAtomicChecker INSTANCE;
    @NotNull
    private static final FqName CONCURRENT_PACKAGE;
    @NotNull
    private static final Set<Name> CONCURRENT_NAME_SET;

    private FirNativeSpecificAtomicChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull FirCallableDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirMemberDeclaration $this$visibility$iv = declaration2;
        boolean $i$f$getVisibility = false;
        if (!$this$visibility$iv.getStatus().getVisibility().isPublicAPI() || declaration2 instanceof FirValueParameter || declaration2 instanceof FirAnonymousFunction) {
            return;
        }
        FirPureAbstractElement firPureAbstractElement = declaration2.getReceiverParameter();
        if (firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null) {
            FirPureAbstractElement it = firPureAbstractElement;
            boolean bl2 = false;
            INSTANCE.checkType((FirTypeRef)it, context2, reporter);
        }
        Iterable $this$forEach$iv = declaration2.getContextParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirValueParameter it = (FirValueParameter)element$iv;
            boolean bl3 = false;
            INSTANCE.checkType(it.getReturnTypeRef(), context2, reporter);
        }
        FirTypeRef it = $i$f$forEach = declaration2.getReturnTypeRef();
        boolean bl4 = false;
        KtSourceElement ktSourceElement = it.getSource();
        FirTypeRef firTypeRef = (ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtRealSourceElementKind ? $i$f$forEach : null;
        if (firTypeRef != null) {
            it = firTypeRef;
            boolean bl5 = false;
            INSTANCE.checkType(it, context2, reporter);
        }
        if (!(declaration2 instanceof FirFunction) || declaration2 instanceof FirPropertyAccessor) {
            return;
        }
        $this$forEach$iv = ((FirFunction)declaration2).getValueParameters();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirValueParameter it2 = (FirValueParameter)element$iv;
            boolean bl6 = false;
            INSTANCE.checkType(it2.getReturnTypeRef(), context2, reporter);
        }
    }

    private final void checkType(FirTypeRef typeRef, CheckerContext context2, DiagnosticReporter reporter) {
        ClassId classId = FirHelpersKt.fullyExpandedClassId(FirTypeUtilsKt.getConeType(typeRef), context2.getSession());
        if (classId == null) {
            return;
        }
        ClassId classId2 = classId;
        if (!Intrinsics.areEqual((Object)classId2.getPackageFqName(), (Object)CONCURRENT_PACKAGE)) {
            return;
        }
        if (classId2.getParentClassId() != null) {
            return;
        }
        Name name2 = classId2.getShortClassName();
        if (!CONCURRENT_NAME_SET.contains(name2)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeRef.getSource(), FirNativeErrors.INSTANCE.getNATIVE_SPECIFIC_ATOMIC(), (Object)name2, (DiagnosticContext)context2, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        void $this$mapTo$iv;
        INSTANCE = new FirNativeSpecificAtomicChecker();
        CONCURRENT_PACKAGE = new FqName("kotlin.concurrent");
        Object object = new String[]{"AtomicIntArray", "AtomicLongArray", "AtomicArray", "AtomicInt", "AtomicLong", "AtomicReference"};
        object = CollectionsKt.listOf((Object[])object);
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            String string = (String)item$iv;
            Collection collection = destination$iv;
            boolean bl2 = false;
            collection.add(Name.identifier((String)it));
        }
        CONCURRENT_NAME_SET = CollectionsKt.toSet((Iterable)((Iterable)var1_1));
    }
}

