/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedReifiedParameterReference;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeTypeParameterInQualifiedAccess;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u0010*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeParameterInQualifiedAccessChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirQualifiedAccessExpressionChecker;", "<init>", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkExpressionItself", "checkExplicitReceiver", "coneTypeParameterInQualifiedAccess", "Lorg/jetbrains/kotlin/fir/resolve/diagnostics/ConeTypeParameterInQualifiedAccess;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getConeTypeParameterInQualifiedAccess", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/fir/resolve/diagnostics/ConeTypeParameterInQualifiedAccess;", "checkers"})
public final class FirTypeParameterInQualifiedAccessChecker
extends FirExpressionChecker<FirQualifiedAccessExpression> {
    @NotNull
    public static final FirTypeParameterInQualifiedAccessChecker INSTANCE = new FirTypeParameterInQualifiedAccessChecker();

    private FirTypeParameterInQualifiedAccessChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirQualifiedAccessExpression expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        this.checkExplicitReceiver(expression2, context2, reporter);
        this.checkExpressionItself(expression2, context2, reporter);
    }

    private final void checkExpressionItself(FirQualifiedAccessExpression expression2, CheckerContext context2, DiagnosticReporter reporter) {
        FirGetClassCall firGetClassCall = (FirGetClassCall)CollectionsKt.lastOrNull(context2.getGetClassCalls());
        if (Intrinsics.areEqual((Object)(firGetClassCall != null ? firGetClassCall.getArgument() : null), (Object)expression2)) {
            return;
        }
        FirStatement secondLast = (FirStatement)CollectionsKt.getOrNull(context2.getCallsOrAssignments(), (int)(context2.getCallsOrAssignments().size() - 2));
        if (secondLast instanceof FirQualifiedAccessExpression && Intrinsics.areEqual((Object)((FirQualifiedAccessExpression)secondLast).getExplicitReceiver(), (Object)expression2)) {
            return;
        }
        ConeTypeParameterInQualifiedAccess coneTypeParameterInQualifiedAccess = this.getConeTypeParameterInQualifiedAccess(FirTypeUtilsKt.getResolvedType(expression2));
        if (coneTypeParameterInQualifiedAccess == null) {
            return;
        }
        ConeTypeParameterInQualifiedAccess diagnostic = coneTypeParameterInQualifiedAccess;
        KtSourceElement ktSourceElement = expression2.getCalleeReference().getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getTYPE_PARAMETER_IS_NOT_AN_EXPRESSION(), (Object)diagnostic.getSymbol(), (DiagnosticContext)context2, null, 16, null);
    }

    private final void checkExplicitReceiver(FirQualifiedAccessExpression expression2, CheckerContext context2, DiagnosticReporter reporter) {
        FirExpression explicitReceiver = expression2.getExplicitReceiver();
        Object object = explicitReceiver instanceof FirResolvedReifiedParameterReference ? (FirResolvedReifiedParameterReference)explicitReceiver : null;
        if (object == null || (object = ((FirResolvedReifiedParameterReference)object).getSymbol()) == null) {
            Object object2 = explicitReceiver;
            if (object2 != null && (object2 = FirTypeUtilsKt.getResolvedType((FirExpression)object2)) != null && (object2 = this.getConeTypeParameterInQualifiedAccess((ConeKotlinType)object2)) != null) {
                object = ((ConeTypeParameterInQualifiedAccess)object2).getSymbol();
            } else {
                return;
            }
        }
        Object typeParameterSymbol = object;
        if (expression2 instanceof FirCallableReferenceAccess) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)((FirCallableReferenceAccess)expression2).getSource(), FirErrors.INSTANCE.getCALLABLE_REFERENCE_LHS_NOT_A_CLASS(), (DiagnosticContext)context2, null, 8, null);
        } else {
            FirExpression firExpression = explicitReceiver;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)(firExpression != null ? firExpression.getSource() : null), FirErrors.INSTANCE.getTYPE_PARAMETER_ON_LHS_OF_DOT(), typeParameterSymbol, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final ConeTypeParameterInQualifiedAccess getConeTypeParameterInQualifiedAccess(ConeKotlinType $this$coneTypeParameterInQualifiedAccess) {
        ConeErrorType coneErrorType = $this$coneTypeParameterInQualifiedAccess instanceof ConeErrorType ? (ConeErrorType)$this$coneTypeParameterInQualifiedAccess : null;
        ConeDiagnostic coneDiagnostic = coneErrorType != null ? coneErrorType.getDiagnostic() : null;
        return coneDiagnostic instanceof ConeTypeParameterInQualifiedAccess ? (ConeTypeParameterInQualifiedAccess)coneDiagnostic : null;
    }
}

