/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.PathUtilRt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathUtil {
    private PathUtil() {
    }

    @Nullable
    @NlsSafe
    public static String getLocalPath(@Nullable VirtualFile file) {
        if (file == null || !file.isValid()) {
            return null;
        }
        if (file.getFileSystem().getProtocol().equals("jar") && file.getParent() != null) {
            return null;
        }
        return PathUtil.getLocalPath(file.getPath());
    }

    @NotNull
    @NlsSafe
    public static String getLocalPath(@NotNull String path) {
        if (path == null) {
            PathUtil.$$$reportNull$$$0(0);
        }
        String string = FileUtilRt.toSystemDependentName(Strings.trimEnd(path, "!/"));
        if (string == null) {
            PathUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getJarPathForClass(@NotNull Class<?> aClass) {
        if (aClass == null) {
            PathUtil.$$$reportNull$$$0(2);
        }
        String pathForClass = PathManager.getJarPathForClass(aClass);
        assert (pathForClass != null) : aClass;
        String string = pathForClass;
        if (string == null) {
            PathUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String toPresentableUrl(@NotNull String url) {
        if (url == null) {
            PathUtil.$$$reportNull$$$0(4);
        }
        return PathUtil.getLocalPath(VirtualFileManager.extractPath(url));
    }

    @Deprecated
    public static String getCanonicalPath(@NonNls String path) {
        return FileUtil.toCanonicalPath(path);
    }

    @NotNull
    @NlsSafe
    public static String getFileName(@NotNull String path) {
        if (path == null) {
            PathUtil.$$$reportNull$$$0(5);
        }
        String string = PathUtilRt.getFileName(path);
        if (string == null) {
            PathUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    @NlsSafe
    public static String getFileExtension(@NotNull String name2) {
        if (name2 == null) {
            PathUtil.$$$reportNull$$$0(7);
        }
        return PathUtilRt.getFileExtension(name2);
    }

    @NotNull
    @NlsSafe
    public static String getParentPath(@NotNull String path) {
        if (path == null) {
            PathUtil.$$$reportNull$$$0(8);
        }
        String string = PathUtilRt.getParentPath(path);
        if (string == null) {
            PathUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String suggestFileName(@NotNull String text) {
        if (text == null) {
            PathUtil.$$$reportNull$$$0(10);
        }
        String string = PathUtilRt.suggestFileName(text);
        if (string == null) {
            PathUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public static String suggestFileName(@NotNull String text, boolean allowDots, boolean allowSpaces) {
        if (text == null) {
            PathUtil.$$$reportNull$$$0(12);
        }
        String string = PathUtilRt.suggestFileName(text, allowDots, allowSpaces);
        if (string == null) {
            PathUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    public static boolean isValidFileName(@NotNull String fileName2) {
        if (fileName2 == null) {
            PathUtil.$$$reportNull$$$0(14);
        }
        return PathUtilRt.isValidFileName(fileName2, true);
    }

    public static boolean isValidFileName(@NotNull String fileName2, boolean strict) {
        if (fileName2 == null) {
            PathUtil.$$$reportNull$$$0(15);
        }
        return PathUtilRt.isValidFileName(fileName2, strict);
    }

    @Contract(value="null -> null; !null -> !null")
    public static String toSystemIndependentName(@Nullable String path) {
        return path == null ? null : FileUtilRt.toSystemIndependentName(path);
    }

    @Contract(value="null -> null; !null -> !null")
    @NlsSafe
    public static String toSystemDependentName(@Nullable String path) {
        return path == null ? null : FileUtilRt.toSystemDependentName(path);
    }

    @NotNull
    public static String driveLetterToLowerCase(@NotNull String path) {
        if (path == null) {
            PathUtil.$$$reportNull$$$0(16);
        }
        if (SystemInfoRt.isWindows && OSAgnosticPathUtil.isAbsoluteDosPath(path) && Character.isUpperCase(path.charAt(0))) {
            String string = Character.toLowerCase(path.charAt(0)) + path.substring(1);
            if (string == null) {
                PathUtil.$$$reportNull$$$0(17);
            }
            return string;
        }
        String string = path;
        if (string == null) {
            PathUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    public static String makeFileName(@NotNull String name2, @Nullable String extension) {
        if (name2 == null) {
            PathUtil.$$$reportNull$$$0(19);
        }
        String string = extension == null || extension.isEmpty() ? name2 : name2 + '.' + extension;
        if (string == null) {
            PathUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 20: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/PathUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/PathUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarPathForClass";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentPath";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestFileName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "driveLetterToLowerCase";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "makeFileName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocalPath";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 20: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getJarPathForClass";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toPresentableUrl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFileExtension";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getParentPath";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "suggestFileName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isValidFileName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "driveLetterToLowerCase";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "makeFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

