/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference.constraints;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.core.JavaPsiBundle;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class CheckedExceptionCompatibilityConstraint
extends InputOutputConstraintFormula {
    private final PsiExpression myExpression;

    public CheckedExceptionCompatibilityConstraint(PsiExpression expression2, PsiType t2) {
        super(t2);
        this.myExpression = expression2;
    }

    @Override
    public boolean reduce(InferenceSession session, List<? super ConstraintFormula> constraints) {
        block18: {
            PsiExpression body;
            PsiType type3;
            if (!PsiPolyExpressionUtil.isPolyExpression(this.myExpression)) {
                return true;
            }
            PsiType myT = this.getCurrentType();
            if (this.myExpression instanceof PsiParenthesizedExpression) {
                constraints.add(new CheckedExceptionCompatibilityConstraint(((PsiParenthesizedExpression)this.myExpression).getExpression(), myT));
                return true;
            }
            if (this.myExpression instanceof PsiConditionalExpression) {
                PsiExpression elseExpression;
                PsiExpression thenExpression = ((PsiConditionalExpression)this.myExpression).getThenExpression();
                if (thenExpression != null) {
                    constraints.add(new CheckedExceptionCompatibilityConstraint(thenExpression, myT));
                }
                if ((elseExpression = ((PsiConditionalExpression)this.myExpression).getElseExpression()) != null) {
                    constraints.add(new CheckedExceptionCompatibilityConstraint(elseExpression, myT));
                }
                return true;
            }
            if (!(this.myExpression instanceof PsiLambdaExpression) && !(this.myExpression instanceof PsiMethodReferenceExpression)) break block18;
            if (!LambdaUtil.isFunctionalType(myT)) {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.not.a.functional.interface", session.getPresentableText(myT)));
                return false;
            }
            PsiType groundTargetType = this.myExpression instanceof PsiLambdaExpression ? FunctionalInterfaceParameterizationUtil.getGroundTargetType(myT, (PsiLambdaExpression)this.myExpression, false) : FunctionalInterfaceParameterizationUtil.getGroundTargetType(myT);
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(groundTargetType);
            if (interfaceMethod == null) {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.no.valid.function.type.found", session.getPresentableText(myT)));
                return false;
            }
            PsiSubstitutor substitutor2 = LambdaUtil.getSubstitutor(interfaceMethod, PsiUtil.resolveGenericsClassInType(groundTargetType));
            if (this.myExpression instanceof PsiLambdaExpression && !((PsiLambdaExpression)this.myExpression).hasFormalParameterTypes() || this.myExpression instanceof PsiMethodReferenceExpression && !((PsiMethodReferenceExpression)this.myExpression).isExact()) {
                for (PsiParameter parameter2 : interfaceMethod.getParameterList().getParameters()) {
                    PsiType type4 = substitutor2.substitute(parameter2.getType());
                    if (session.isProperType(type4)) continue;
                    session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.parameter.type.is.not.yet.inferred", session.getPresentableText(type4)));
                    return false;
                }
            }
            PsiType returnType2 = interfaceMethod.getReturnType();
            if (!(!(this.myExpression instanceof PsiLambdaExpression) && ((PsiMethodReferenceExpression)this.myExpression).isExact() || session.isProperType(type3 = substitutor2.substitute(returnType2)))) {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.return.type.is.not.yet.inferred", session.getPresentableText(type3)));
                return false;
            }
            List<PsiType> expectedThrownTypes = ContainerUtil.map(interfaceMethod.getThrowsList().getReferencedTypes(), type2 -> session.substituteWithInferenceVariables(substitutor2.substitute((PsiType)type2)));
            ArrayList<PsiType> expectedNonProperThrownTypes = new ArrayList<PsiType>();
            for (PsiType type4 : expectedThrownTypes) {
                if (session.isProperType(type4)) continue;
                expectedNonProperThrownTypes.add(type4);
            }
            ArrayList<PsiClassType> thrownTypes = new ArrayList<PsiClassType>();
            PsiElement psiElement = body = this.myExpression instanceof PsiLambdaExpression ? ((PsiLambdaExpression)this.myExpression).getBody() : this.myExpression;
            if (body != null) {
                List<PsiClassType> exceptions = ExceptionUtil.getUnhandledExceptions(new PsiElement[]{body});
                thrownTypes.addAll(ContainerUtil.filter(exceptions, type2 -> !ExceptionUtil.isUncheckedException(type2)));
            }
            if (expectedNonProperThrownTypes.isEmpty()) {
                for (PsiType psiType : thrownTypes) {
                    if (CheckedExceptionCompatibilityConstraint.isAddressed(expectedThrownTypes, psiType)) continue;
                    session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.unhandled.exception", session.getPresentableText(psiType)));
                    return false;
                }
            } else {
                ArrayList<PsiType> expectedProperTypes = new ArrayList<PsiType>(expectedThrownTypes);
                expectedProperTypes.removeAll(expectedNonProperThrownTypes);
                for (PsiType psiType : thrownTypes) {
                    if (CheckedExceptionCompatibilityConstraint.isAddressed(expectedProperTypes, psiType)) continue;
                    for (PsiType expectedNonProperThrownType : expectedNonProperThrownTypes) {
                        constraints.add(new StrictSubtypingConstraint(expectedNonProperThrownType, psiType));
                    }
                }
                for (PsiType psiType : expectedNonProperThrownTypes) {
                    InferenceVariable variable = session.getInferenceVariable(psiType);
                    if (variable == null) continue;
                    variable.setThrownBound();
                }
            }
        }
        return true;
    }

    private static boolean isAddressed(List<PsiType> expectedThrownTypes, PsiType thrownType) {
        for (PsiType expectedThrownType : expectedThrownTypes) {
            if (!TypeConversionUtil.isAssignable(expectedThrownType, thrownType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PsiExpression getExpression() {
        return this.myExpression;
    }

    @Override
    protected InputOutputConstraintFormula createSelfConstraint(PsiType type2, PsiExpression expression2) {
        return new CheckedExceptionCompatibilityConstraint(expression2, type2);
    }

    @Override
    protected void collectReturnTypeVariables(InferenceSession session, PsiExpression psiExpression, PsiType returnType2, Set<? super InferenceVariable> result2) {
        session.collectDependencies(returnType2, result2);
    }
}

