/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.declarations.FirReplSnippet;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.NameUtils;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a8\u0006\u0007"}, d2={"scriptClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "script", "Lorg/jetbrains/kotlin/fir/declarations/FirScript;", "snippetClassId", "snippet", "Lorg/jetbrains/kotlin/fir/declarations/FirReplSnippet;", "fir-serialization"})
public final class FirElementSerializerKt {
    @NotNull
    public static final ClassId scriptClassId(@NotNull FirScript script) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        FqName fqName = FqNamesUtilKt.parentOrNull(script.getSymbol().getFqName());
        if (fqName == null) {
            fqName = FqName.ROOT;
        }
        return new ClassId(fqName, NameUtils.getScriptTargetClassName(script.getName()));
    }

    @NotNull
    public static final ClassId snippetClassId(@NotNull FirReplSnippet snippet) {
        Intrinsics.checkNotNullParameter((Object)snippet, (String)"snippet");
        return new ClassId(FqName.ROOT, NameUtils.getSnippetTargetClassName(snippet.getName()));
    }
}

