/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extra;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.extra.FirUnusedExpressionCheckerKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirReplSnippet;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCatch;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLoop;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirContractCallBlock;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0002\r\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirUnusedExpressionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "UsageState", "UsageVisitor", "checkers"})
public final class FirUnusedExpressionChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirUnusedExpressionChecker INSTANCE = new FirUnusedExpressionChecker();

    private FirUnusedExpressionChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirDeclaration declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        block3: {
            FirDeclaration firDeclaration;
            UsageVisitor visitor2;
            block6: {
                block5: {
                    block4: {
                        block2: {
                            Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
                            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
                            visitor2 = new UsageVisitor(context2, reporter);
                            firDeclaration = declaration2;
                            if (!(firDeclaration instanceof FirReplSnippet)) break block2;
                            ((FirReplSnippet)declaration2).getBody().acceptChildren(visitor2, UsageState.Used);
                            break block3;
                        }
                        if (!(firDeclaration instanceof FirCodeFragment)) break block4;
                        ((FirCodeFragment)declaration2).getBlock().acceptChildren(visitor2, UsageState.Used);
                        break block3;
                    }
                    if (!(firDeclaration instanceof FirAnonymousInitializer)) break block5;
                    FirBlock firBlock = ((FirAnonymousInitializer)declaration2).getBody();
                    if (firBlock == null) break block3;
                    firBlock.acceptChildren(visitor2, UsageState.Unused);
                    break block3;
                }
                if (!(firDeclaration instanceof FirFunction)) break block6;
                boolean lastStatementUsed = declaration2 instanceof FirAnonymousFunction && ((FirAnonymousFunction)declaration2).isLambda();
                FirBlock firBlock = ((FirFunction)declaration2).getBody();
                if (firBlock == null) break block3;
                firBlock.accept(visitor2, lastStatementUsed ? UsageState.Used : UsageState.Unused);
                break block3;
            }
            if (!(firDeclaration instanceof FirVariable)) break block3;
            FirExpression firExpression = ((FirVariable)declaration2).getInitializer();
            if (firExpression != null) {
                firExpression.accept(visitor2, UsageState.Used);
            }
            FirExpression firExpression2 = ((FirVariable)declaration2).getDelegate();
            if (firExpression2 != null) {
                firExpression2.accept(visitor2, UsageState.Used);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirUnusedExpressionChecker$UsageState;", "", "<init>", "(Ljava/lang/String;I)V", "Used", "Unused", "checkers"})
    private static final class UsageState
    extends Enum<UsageState> {
        public static final /* enum */ UsageState Used = new UsageState();
        public static final /* enum */ UsageState Unused = new UsageState();
        private static final /* synthetic */ UsageState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static UsageState[] values() {
            return (UsageState[])$VALUES.clone();
        }

        public static UsageState valueOf(String value2) {
            return Enum.valueOf(UsageState.class, value2);
        }

        @NotNull
        public static EnumEntries<UsageState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = usageStateArray = new UsageState[]{UsageState.Used, UsageState.Unused};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirUnusedExpressionChecker$UsageVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/FirUnusedExpressionChecker$UsageState;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "visitElement", "element", "Lorg/jetbrains/kotlin/fir/FirElement;", "data", "visitAnnotation", "annotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "visitWhenExpression", "whenExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "visitTryExpression", "tryExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirTryExpression;", "visitBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "visitLoop", "loop", "Lorg/jetbrains/kotlin/fir/expressions/FirLoop;", "checkers"})
    private static final class UsageVisitor
    extends FirDefaultVisitor<Unit, UsageState> {
        @NotNull
        private final CheckerContext context;
        @NotNull
        private final DiagnosticReporter reporter;

        public UsageVisitor(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            this.context = context2;
            this.reporter = reporter;
        }

        @Override
        public void visitElement(@NotNull FirElement element2, @NotNull UsageState data) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
            if (element2 instanceof FirDeclaration) {
                return;
            }
            KtSourceElement source = element2.getSource();
            if (data == UsageState.Unused && element2 instanceof FirExpression && source != null && !FirUnusedExpressionCheckerKt.access$hasSideEffect((FirExpression)element2)) {
                KtDiagnosticFactory0 factory2 = element2 instanceof FirAnonymousFunctionExpression && ((FirAnonymousFunctionExpression)element2).getAnonymousFunction().isLambda() ? FirErrors.INSTANCE.getUNUSED_LAMBDA_EXPRESSION() : FirErrors.INSTANCE.getUNUSED_EXPRESSION();
                KtDiagnosticReportHelpersKt.reportOn$default(this.reporter, (AbstractKtSourceElement)source, factory2, (DiagnosticContext)this.context, null, 8, null);
                return;
            }
            element2.acceptChildren(this, UsageState.Used);
        }

        @Override
        public void visitAnnotation(@NotNull FirAnnotation annotation, @NotNull UsageState data) {
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
        }

        @Override
        public void visitWhenExpression(@NotNull FirWhenExpression whenExpression, @NotNull UsageState data) {
            Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
            Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
            FirVariable variable = whenExpression.getSubjectVariable();
            if (variable == null) {
                FirPureAbstractElement firPureAbstractElement = whenExpression.getSubjectVariable();
                if (firPureAbstractElement != null && (firPureAbstractElement = ((FirVariable)firPureAbstractElement).getInitializer()) != null) {
                    ((FirExpression)firPureAbstractElement).accept(this, UsageState.Used);
                }
            } else {
                variable.accept(this, UsageState.Used);
            }
            for (FirWhenBranch branch : whenExpression.getBranches()) {
                branch.getCondition().accept(this, UsageState.Used);
                branch.getResult().accept(this, data);
            }
        }

        @Override
        public void visitTryExpression(@NotNull FirTryExpression tryExpression, @NotNull UsageState data) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)tryExpression, (String)"tryExpression");
                Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
                tryExpression.getTryBlock().accept(this, data);
                for (FirCatch firCatch : tryExpression.getCatches()) {
                    firCatch.getBlock().accept(this, data);
                }
                FirBlock firBlock = tryExpression.getFinallyBlock();
                if (firBlock == null) break block1;
                firBlock.accept(this, UsageState.Unused);
            }
        }

        @Override
        public void visitBlock(@NotNull FirBlock block, @NotNull UsageState data) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
            KtSourceElement ktSourceElement = block.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind.DesugaredIncrementOrDecrement) {
                return;
            }
            if (block instanceof FirContractCallBlock) {
                return;
            }
            List<FirStatement> statements = block.getStatements();
            int lastIndex = CollectionsKt.getLastIndex(statements);
            int n2 = ((Collection)statements).size();
            for (int i2 = 0; i2 < n2; ++i2) {
                FirStatement statement = statements.get(i2);
                boolean isImplicitReturn = i2 == lastIndex && statement instanceof FirExpression && TypeUtilsKt.isSubtypeOf$default(FirTypeUtilsKt.getResolvedType((FirExpression)statement), FirTypeUtilsKt.getResolvedType(block), this.context.getSession(), false, 4, null);
                statement.accept(this, isImplicitReturn ? data : UsageState.Unused);
            }
        }

        @Override
        public void visitLoop(@NotNull FirLoop loop, @NotNull UsageState data) {
            Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
            Intrinsics.checkNotNullParameter((Object)((Object)data), (String)"data");
            loop.getCondition().accept(this, UsageState.Used);
            loop.getBlock().accept(this, UsageState.Unused);
        }
    }
}

