/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnostic;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.ConeDiagnosticToFirDiagnosticKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.ConeSyntaxDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirComponentCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirSmartCastExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedExpression;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCallCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCandidate;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeConstraintSystemHasContradiction;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeHiddenCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableCandidateError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeInapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedNameError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeVisibilityError;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J*\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002JH\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002R\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0018\u0010!\u001a\u00020\u0011*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u0004\u0018\u00010\u001b*\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkInitializer", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "initializer", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "checkComponentCall", "destructuringDeclarationType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "diagnostic", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "property", "componentCall", "Lorg/jetbrains/kotlin/fir/expressions/FirComponentCall;", "destructuringDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "reportDefaultDiagnostics", "explicitReceiverOfQualifiedAccess", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "getExplicitReceiverOfQualifiedAccess", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "unwrapped", "getUnwrapped", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "resolvedVariable", "getResolvedVariable", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirDestructuringDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirDestructuringDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,240:1\n1563#2:241\n1634#2,3:242\n*S KotlinDebug\n*F\n+ 1 FirDestructuringDeclarationChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDestructuringDeclarationChecker\n*L\n152#1:241\n152#1:242,3\n*E\n"})
public final class FirDestructuringDeclarationChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirDestructuringDeclarationChecker INSTANCE = new FirDestructuringDeclarationChecker();

    private FirDestructuringDeclarationChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirProperty declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        ConeDiagnostic diagnostic;
        FirElement firElement;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        KtSourceElement ktSourceElement = declaration2.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (Intrinsics.areEqual((Object)source.getElementType(), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION)) {
            this.checkInitializer(source, declaration2.getInitializer(), reporter, context2);
            return;
        }
        if (!Intrinsics.areEqual((Object)source.getElementType(), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY)) {
            return;
        }
        FirExpression firExpression = declaration2.getInitializer();
        FirComponentCall firComponentCall = firExpression instanceof FirComponentCall ? (FirComponentCall)firExpression : null;
        if (firComponentCall == null) {
            return;
        }
        FirComponentCall componentCall = firComponentCall;
        FirQualifiedAccessExpression firQualifiedAccessExpression = this.getExplicitReceiverOfQualifiedAccess(componentCall);
        if (firQualifiedAccessExpression == null) {
            return;
        }
        FirQualifiedAccessExpression originalExpression2 = firQualifiedAccessExpression;
        FirVariable firVariable = this.getResolvedVariable(originalExpression2);
        if (firVariable == null) {
            return;
        }
        FirVariable originalDestructuringDeclaration = firVariable;
        FirVariable firVariable2 = originalDestructuringDeclaration;
        if (firVariable2 instanceof FirProperty) {
            FirExpression firExpression2;
            Object object = ((FirProperty)originalDestructuringDeclaration).getInitializer();
            if (Intrinsics.areEqual((Object)(object != null && (object = ((FirExpression)object).getSource()) != null ? ((KtSourceElement)object).getElementType() : null), (Object)KtNodeTypes.FOR)) {
                FirQualifiedAccessExpression iterator2;
                FirExpression firExpression3 = ((FirProperty)originalDestructuringDeclaration).getInitializer();
                FirQualifiedAccessExpression firQualifiedAccessExpression2 = iterator2 = firExpression3 != null ? this.getExplicitReceiverOfQualifiedAccess(firExpression3) : null;
                FirVariable firVariable3 = firQualifiedAccessExpression2 != null ? this.getResolvedVariable(firQualifiedAccessExpression2) : null;
                FirPureAbstractElement firPureAbstractElement = firVariable3 instanceof FirProperty ? (FirProperty)firVariable3 : null;
                firExpression2 = firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getInitializer()) != null ? this.getExplicitReceiverOfQualifiedAccess((FirExpression)firPureAbstractElement) : null;
            } else {
                firExpression2 = ((FirProperty)originalDestructuringDeclaration).getInitializer();
            }
            firElement = firExpression2;
        } else {
            firElement = firVariable2 instanceof FirValueParameter ? (FirElement)originalDestructuringDeclaration : null;
        }
        if (firElement == null) {
            return;
        }
        FirElement originalDestructuringDeclarationOrInitializer = firElement;
        KtSourceElement ktSourceElement2 = originalDestructuringDeclarationOrInitializer.getSource();
        if (ktSourceElement2 == null) {
            return;
        }
        KtSourceElement originalDestructuringDeclarationOrInitializerSource = ktSourceElement2;
        FirElement firElement2 = originalDestructuringDeclarationOrInitializer;
        ConeKotlinType coneKotlinType = firElement2 instanceof FirVariable ? FirTypeUtilsKt.getConeType(((FirVariable)originalDestructuringDeclarationOrInitializer).getReturnTypeRef()) : (firElement2 instanceof FirExpression ? FirTypeUtilsKt.getResolvedType((FirExpression)originalDestructuringDeclarationOrInitializer) : null);
        if (coneKotlinType == null) {
            return;
        }
        ConeKotlinType originalDestructuringDeclarationType = coneKotlinType;
        FirNamedReference reference2 = componentCall.getCalleeReference();
        ConeDiagnostic coneDiagnostic = diagnostic = FirReferenceUtilsKt.isError(reference2) ? ((FirDiagnosticHolder)((Object)reference2)).getDiagnostic() : null;
        if (diagnostic != null) {
            this.checkComponentCall(originalDestructuringDeclarationOrInitializerSource, originalDestructuringDeclarationType, diagnostic, declaration2, componentCall, originalDestructuringDeclaration, reporter, context2);
        }
    }

    private final void checkInitializer(KtSourceElement source, FirExpression initializer, DiagnosticReporter reporter, CheckerContext context2) {
        boolean needToReport;
        FirExpression firExpression = initializer;
        boolean bl2 = firExpression == null ? true : (needToReport = firExpression instanceof FirErrorExpression ? ((FirErrorExpression)initializer).getDiagnostic() instanceof ConeSyntaxDiagnostic : false);
        if (needToReport) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getINITIALIZER_REQUIRED_FOR_DESTRUCTURING_DECLARATION(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkComponentCall(KtSourceElement source, ConeKotlinType destructuringDeclarationType, ConeDiagnostic diagnostic, FirProperty property2, FirComponentCall componentCall, FirVariable destructuringDeclaration, DiagnosticReporter reporter, CheckerContext context2) {
        ConeDiagnostic coneDiagnostic = diagnostic;
        if (coneDiagnostic instanceof ConeUnresolvedNameError) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((ConeUnresolvedNameError)diagnostic).getName(), (Object)destructuringDeclarationType, (DiagnosticContext)context2, null, 32, null);
        } else if (coneDiagnostic instanceof ConeHiddenCandidateError) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((ConeHiddenCandidateError)diagnostic).getCandidate().getCallInfo().getName(), (Object)destructuringDeclarationType, (DiagnosticContext)context2, null, 32, null);
        } else if (coneDiagnostic instanceof ConeInapplicableWrongReceiver) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((AbstractCallCandidate)CollectionsKt.first((Iterable)((ConeInapplicableWrongReceiver)diagnostic).getCandidates())).getCallInfo().getName(), (Object)destructuringDeclarationType, (DiagnosticContext)context2, null, 32, null);
        } else if (coneDiagnostic instanceof ConeAmbiguityError) {
            Collection<FirBasedSymbol<?>> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = ((ConeAmbiguityError)diagnostic).getCandidates();
            Name name2 = ((ConeAmbiguityError)diagnostic).getName();
            KtDiagnosticFactory2<Name, Collection<FirBasedSymbol<?>>> ktDiagnosticFactory2 = FirErrors.INSTANCE.getCOMPONENT_FUNCTION_AMBIGUITY();
            AbstractKtSourceElement abstractKtSourceElement = source;
            DiagnosticReporter diagnosticReporter = reporter;
            boolean $i$f$map = false;
            void var12_18 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                AbstractCandidate abstractCandidate = (AbstractCandidate)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getSymbol());
            }
            collection = (List)destination$iv$iv;
            KtDiagnosticReportHelpersKt.reportOn$default(diagnosticReporter, abstractKtSourceElement, ktDiagnosticFactory2, (Object)name2, collection, (DiagnosticContext)context2, null, 32, null);
        } else if (coneDiagnostic instanceof ConeInapplicableCandidateError) {
            if (ConeTypeUtilsKt.isMarkedNullable(TypeExpansionUtilsKt.fullyExpandedType$default(destructuringDeclarationType, context2.getSession(), null, 2, null))) {
                AbstractKtSourceElement abstractKtSourceElement = source;
                KtDiagnosticFactory1<Name> ktDiagnosticFactory1 = FirErrors.INSTANCE.getCOMPONENT_FUNCTION_ON_NULLABLE();
                FirBasedSymbol<?> firBasedSymbol = ((ConeInapplicableCandidateError)diagnostic).getCandidate().getSymbol();
                Intrinsics.checkNotNull(firBasedSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol");
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, abstractKtSourceElement, ktDiagnosticFactory1, (Object)((FirNamedFunctionSymbol)firBasedSymbol).getCallableId().getCallableName(), (DiagnosticContext)context2, null, 16, null);
            } else {
                this.reportDefaultDiagnostics(diagnostic, componentCall, reporter, context2);
            }
        } else if (coneDiagnostic instanceof ConeConstraintSystemHasContradiction) {
            ConeKotlinType componentType = FirTypeUtilsKt.getResolvedType(componentCall);
            if (componentType instanceof ConeErrorType) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_MISSING(), (Object)((AbstractCallCandidate)CollectionsKt.first((Iterable)((ConeConstraintSystemHasContradiction)diagnostic).getCandidates())).getCallInfo().getName(), (Object)destructuringDeclarationType, (DiagnosticContext)context2, null, 32, null);
                return;
            }
            ConeKotlinType expectedType = FirTypeUtilsKt.getConeType(property2.getReturnTypeRef());
            if (!AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext(context2.getSession()), (KotlinTypeMarker)componentType, (KotlinTypeMarker)expectedType, false, 8, null)) {
                KtSourceElement typeMismatchSource = destructuringDeclaration instanceof FirValueParameter ? property2.getSource() : source;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)typeMismatchSource, FirErrors.INSTANCE.getCOMPONENT_FUNCTION_RETURN_TYPE_MISMATCH(), (Object)((ConeConstraintSystemHasContradiction)diagnostic).getCandidate().getCallInfo().getName(), (Object)componentType, (Object)expectedType, (DiagnosticContext)context2, null, 64, null);
            } else {
                this.reportDefaultDiagnostics(diagnostic, componentCall, reporter, context2);
            }
        } else if (coneDiagnostic instanceof ConeVisibilityError) {
            reporter.report(ConeDiagnosticToFirDiagnosticKt.toInvisibleReferenceDiagnostic(((ConeVisibilityError)diagnostic).getSymbol(), property2.getSource(), context2.getSession()), context2);
        } else {
            this.reportDefaultDiagnostics(diagnostic, componentCall, reporter, context2);
        }
    }

    private final void reportDefaultDiagnostics(ConeDiagnostic diagnostic, FirComponentCall componentCall, DiagnosticReporter reporter, CheckerContext context2) {
        for (KtDiagnostic coneDiagnostic : ConeDiagnosticToFirDiagnosticKt.toFirDiagnostics(diagnostic, context2.getSession(), componentCall.getSource(), null)) {
            reporter.report(coneDiagnostic, context2);
        }
    }

    private final FirQualifiedAccessExpression getExplicitReceiverOfQualifiedAccess(FirExpression $this$explicitReceiverOfQualifiedAccess) {
        FirExpression firExpression = $this$explicitReceiverOfQualifiedAccess instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)$this$explicitReceiverOfQualifiedAccess : null;
        FirExpression firExpression2 = firExpression != null && (firExpression = firExpression.getExplicitReceiver()) != null ? this.getUnwrapped(firExpression) : null;
        return firExpression2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)firExpression2 : null;
    }

    private final FirExpression getUnwrapped(FirExpression $this$unwrapped) {
        FirExpression firExpression = $this$unwrapped;
        return firExpression instanceof FirSmartCastExpression ? ((FirSmartCastExpression)$this$unwrapped).getOriginalExpression() : (firExpression instanceof FirWrappedExpression ? ((FirWrappedExpression)$this$unwrapped).getExpression() : $this$unwrapped);
    }

    private final FirVariable getResolvedVariable(FirQualifiedAccessExpression $this$resolvedVariable) {
        FirVariableSymbol firVariableSymbol = FirReferenceUtilsKt.toResolvedVariableSymbol$default($this$resolvedVariable.getCalleeReference(), false, 1, null);
        if (firVariableSymbol == null) {
            return null;
        }
        FirVariableSymbol symbol = firVariableSymbol;
        FirLazyDeclarationResolverKt.lazyResolveToPhase(symbol, FirResolvePhase.BODY_RESOLVE);
        return (FirVariable)symbol.getFir();
    }
}

