/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirMissingDependencyStorage;
import org.jetbrains.kotlin.fir.types.FirMissingDependencyStorageKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a6\u0010\u0000\u001a\u00020\u00012\f\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0001\u00a8\u0006\r"}, d2={"checkMissingDependencySuperTypes", "", "classifierType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "declaration", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "isEagerCheck", "checkers"})
public final class FirMissingDependencySupertypeUtilsKt {
    public static final boolean checkMissingDependencySuperTypes(@Nullable ConeKotlinType classifierType, @Nullable KtSourceElement source, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ConeKotlinType coneKotlinType = classifierType;
        return FirMissingDependencySupertypeUtilsKt.checkMissingDependencySuperTypes((FirBasedSymbol)(coneKotlinType != null ? ToSymbolUtilsKt.toSymbol(coneKotlinType, context2.getSession()) : null), source, reporter, context2, false);
    }

    public static final boolean checkMissingDependencySuperTypes(@Nullable FirBasedSymbol<?> declaration2, @Nullable KtSourceElement source, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2, boolean isEagerCheck) {
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(declaration2 instanceof FirClassSymbol)) {
            return false;
        }
        Set<FirMissingDependencyStorage.TypeWithOrigin> missingSuperTypes = FirMissingDependencyStorageKt.getMissingDependencyStorage(context2.getSession()).getMissingSuperTypes((FirClassSymbol)declaration2);
        LanguageVersionSettings languageVersionSettings = context2.getLanguageVersionSettings();
        for (FirMissingDependencyStorage.TypeWithOrigin typeWithOrigin : missingSuperTypes) {
            ConeKotlinType superType = typeWithOrigin.component1();
            FirMissingDependencyStorage.SupertypeOrigin origin2 = typeWithOrigin.component2();
            KtDiagnosticFactory2<ConeKotlinType, ConeKotlinType> diagnostic = origin2 == FirMissingDependencyStorage.SupertypeOrigin.TYPE_ARGUMENT && !languageVersionSettings.supportsFeature(LanguageFeature.ForbidUsingSupertypesWithInaccessibleContentInTypeArguments) ? FirErrors.INSTANCE.getMISSING_DEPENDENCY_SUPERCLASS_IN_TYPE_ARGUMENT() : (isEagerCheck && !languageVersionSettings.supportsFeature(LanguageFeature.AllowEagerSupertypeAccessibilityChecks) ? FirErrors.INSTANCE.getMISSING_DEPENDENCY_SUPERCLASS_WARNING() : FirErrors.INSTANCE.getMISSING_DEPENDENCY_SUPERCLASS());
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, diagnostic, (Object)TypeUtilsKt.withNullability$default(TypeUtilsKt.withArguments(superType, new ConeTypeProjection[0]), false, TypeComponentsKt.getTypeContext(context2.getSession()), null, false, 12, null), (Object)TypeConstructionUtilsKt.constructType$default((FirClassLikeSymbol)declaration2, null, false, null, 7, null), (DiagnosticContext)context2, null, 32, null);
        }
        return !((Collection)missingSuperTypes).isEmpty();
    }
}

