/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.platform.projectStructure;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KaDanglingFileModuleImpl;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinProjectStructureProvider;
import org.jetbrains.kotlin.analysis.api.projectStructure.ContextModuleKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.DanglingFilesKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileResolutionMode;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaNotUnderContentRootModule;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H$J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KotlinProjectStructureProviderBase;", "Lorg/jetbrains/kotlin/analysis/api/platform/projectStructure/KotlinProjectStructureProvider;", "<init>", "()V", "getNotUnderContentRootModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaNotUnderContentRootModule;", "project", "Lcom/intellij/openapi/project/Project;", "computeSpecialModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "file", "Lcom/intellij/psi/PsiFile;", "computeDefaultDanglingFileResolutionMode", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileResolutionMode;", "Lorg/jetbrains/kotlin/psi/KtFile;", "computeContextModule", "analysis-api-platform-interface"})
@SourceDebugExtension(value={"SMAP\nKotlinProjectStructureProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinProjectStructureProviderBase.kt\norg/jetbrains/kotlin/analysis/api/platform/projectStructure/KotlinProjectStructureProviderBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public abstract class KotlinProjectStructureProviderBase
implements KotlinProjectStructureProvider {
    @NotNull
    protected abstract KaNotUnderContentRootModule getNotUnderContentRootModule(@NotNull Project var1);

    @Nullable
    protected final KaModule computeSpecialModule(@NotNull PsiFile file2) {
        KaModule contextModule;
        KaModule explicitModule;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (file2 instanceof KtFile && (explicitModule = DanglingFilesKt.getExplicitModule((KtFile)file2)) != null) {
            return explicitModule;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile != null && (contextModule = ContextModuleKt.getAnalysisContextModule(virtualFile)) != null) {
            return contextModule;
        }
        if (file2 instanceof KtFile && DanglingFilesKt.isDangling((KtFile)file2)) {
            contextModule = this.computeContextModule((KtFile)file2);
            KaDanglingFileResolutionMode kaDanglingFileResolutionMode = DanglingFilesKt.getDanglingFileResolutionMode((KtFile)file2);
            if (kaDanglingFileResolutionMode == null) {
                kaDanglingFileResolutionMode = this.computeDefaultDanglingFileResolutionMode((KtFile)file2);
            }
            KaDanglingFileResolutionMode resolutionMode = kaDanglingFileResolutionMode;
            return new KaDanglingFileModuleImpl(CollectionsKt.listOf((Object)file2), contextModule, resolutionMode);
        }
        return null;
    }

    private final KaDanglingFileResolutionMode computeDefaultDanglingFileResolutionMode(KtFile file2) {
        if (!(file2.isPhysical() || file2.getViewProvider().isEventSystemEnabled() || Intrinsics.areEqual((Object)file2.getOriginalFile(), (Object)file2))) {
            return KaDanglingFileResolutionMode.IGNORE_SELF;
        }
        return KaDanglingFileResolutionMode.PREFER_SELF;
    }

    private final KaModule computeContextModule(KtFile file2) {
        PsiElement contextElement;
        KaModule kaModule;
        PsiFile originalFile;
        Object object = file2.getOriginalFile();
        PsiFile it = object;
        boolean bl2 = false;
        PsiFile psiFile = originalFile = it != file2 ? object : null;
        if (originalFile != null && (object = originalFile.getVirtualFile()) != null && (kaModule = ContextModuleKt.getAnalysisContextModule((VirtualFile)object)) != null) {
            KaModule it2 = kaModule;
            boolean bl3 = false;
            return it2;
        }
        object = DanglingFilesKt.getContextModule(file2);
        if (object != null) {
            Object it3 = object;
            boolean bl4 = false;
            return it3;
        }
        PsiElement psiElement = file2.getContext();
        if (psiElement == null && (psiElement = KtPsiFactoryKt.getAnalysisContext(file2)) == null) {
            psiElement = originalFile;
        }
        if ((contextElement = psiElement) != null) {
            return this.getModule(contextElement, null);
        }
        Project project = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return this.getNotUnderContentRootModule(project);
    }
}

